/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.mktenv;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.asset.AnyAssetReference;
import fpml.consolidated.mktenv.ForwardRateCurve;
import fpml.consolidated.mktenv.TermCurve;
import fpml.consolidated.mktenv.ZeroRateCurve;
import fpml.consolidated.mktenv.meta.YieldCurveValuationMeta;
import fpml.consolidated.riskdef.PricingInputDatesModel;
import fpml.consolidated.riskdef.PricingStructureValuation;
import fpml.consolidated.riskdef.QuotedAssetSet;
import fpml.consolidated.riskdef.ValuationScenarioReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="YieldCurveValuation", builder=YieldCurveValuationBuilderImpl.class, version="1.2.2")
@RuneDataType(value="YieldCurveValuation", model="fpml", builder=YieldCurveValuationBuilderImpl.class, version="1.2.2")
public interface YieldCurveValuation
extends PricingStructureValuation {
    public static final YieldCurveValuationMeta metaData = new YieldCurveValuationMeta();

    public QuotedAssetSet getInputs();

    public ZeroRateCurve getZeroCurve();

    public List<? extends ForwardRateCurve> getForwardCurve();

    public TermCurve getDiscountFactorCurve();

    @Override
    public YieldCurveValuation build();

    @Override
    public YieldCurveValuationBuilder toBuilder();

    public static YieldCurveValuationBuilder builder() {
        return new YieldCurveValuationBuilderImpl();
    }

    default public RosettaMetaData<? extends YieldCurveValuation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends YieldCurveValuation> getType() {
        return YieldCurveValuation.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("objectReference"), processor, AnyAssetReference.class, this.getObjectReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("valuationScenarioReference"), processor, ValuationScenarioReference.class, this.getValuationScenarioReference(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("definitionRef"), String.class, (Object)this.getDefinitionRef(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("pricingInputDatesModel"), processor, PricingInputDatesModel.class, this.getPricingInputDatesModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("inputs"), processor, QuotedAssetSet.class, this.getInputs(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("zeroCurve"), processor, ZeroRateCurve.class, this.getZeroCurve(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("forwardCurve"), processor, ForwardRateCurve.class, this.getForwardCurve(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("discountFactorCurve"), processor, TermCurve.class, this.getDiscountFactorCurve(), new AttributeMeta[0]);
    }

    public static class YieldCurveValuationBuilderImpl
    extends PricingStructureValuation.PricingStructureValuationBuilderImpl
    implements YieldCurveValuationBuilder {
        protected QuotedAssetSet.QuotedAssetSetBuilder inputs;
        protected ZeroRateCurve.ZeroRateCurveBuilder zeroCurve;
        protected List<ForwardRateCurve.ForwardRateCurveBuilder> forwardCurve = new ArrayList<ForwardRateCurve.ForwardRateCurveBuilder>();
        protected TermCurve.TermCurveBuilder discountFactorCurve;

        @Override
        @RosettaAttribute(value="inputs")
        @RuneAttribute(value="inputs")
        public QuotedAssetSet.QuotedAssetSetBuilder getInputs() {
            return this.inputs;
        }

        @Override
        public QuotedAssetSet.QuotedAssetSetBuilder getOrCreateInputs() {
            QuotedAssetSet.QuotedAssetSetBuilder result = this.inputs != null ? this.inputs : (this.inputs = QuotedAssetSet.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="zeroCurve")
        @RuneAttribute(value="zeroCurve")
        public ZeroRateCurve.ZeroRateCurveBuilder getZeroCurve() {
            return this.zeroCurve;
        }

        @Override
        public ZeroRateCurve.ZeroRateCurveBuilder getOrCreateZeroCurve() {
            ZeroRateCurve.ZeroRateCurveBuilder result = this.zeroCurve != null ? this.zeroCurve : (this.zeroCurve = ZeroRateCurve.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="forwardCurve")
        @RuneAttribute(value="forwardCurve")
        public List<? extends ForwardRateCurve.ForwardRateCurveBuilder> getForwardCurve() {
            return this.forwardCurve;
        }

        @Override
        public ForwardRateCurve.ForwardRateCurveBuilder getOrCreateForwardCurve(int index) {
            if (this.forwardCurve == null) {
                this.forwardCurve = new ArrayList<ForwardRateCurve.ForwardRateCurveBuilder>();
            }
            return (ForwardRateCurve.ForwardRateCurveBuilder)this.getIndex(this.forwardCurve, index, () -> {
                ForwardRateCurve.ForwardRateCurveBuilder newForwardCurve = ForwardRateCurve.builder();
                return newForwardCurve;
            });
        }

        @Override
        @RosettaAttribute(value="discountFactorCurve")
        @RuneAttribute(value="discountFactorCurve")
        public TermCurve.TermCurveBuilder getDiscountFactorCurve() {
            return this.discountFactorCurve;
        }

        @Override
        public TermCurve.TermCurveBuilder getOrCreateDiscountFactorCurve() {
            TermCurve.TermCurveBuilder result = this.discountFactorCurve != null ? this.discountFactorCurve : (this.discountFactorCurve = TermCurve.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="objectReference")
        @RuneAttribute(value="objectReference")
        public YieldCurveValuationBuilder setObjectReference(AnyAssetReference _objectReference) {
            this.objectReference = _objectReference == null ? null : _objectReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationScenarioReference")
        @RuneAttribute(value="valuationScenarioReference")
        public YieldCurveValuationBuilder setValuationScenarioReference(ValuationScenarioReference _valuationScenarioReference) {
            this.valuationScenarioReference = _valuationScenarioReference == null ? null : _valuationScenarioReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public YieldCurveValuationBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="definitionRef")
        @RuneAttribute(value="definitionRef")
        public YieldCurveValuationBuilder setDefinitionRef(String _definitionRef) {
            this.definitionRef = _definitionRef == null ? null : _definitionRef;
            return this;
        }

        @Override
        @RosettaAttribute(value="pricingInputDatesModel", isRequired=true)
        @RuneAttribute(value="pricingInputDatesModel", isRequired=true)
        public YieldCurveValuationBuilder setPricingInputDatesModel(PricingInputDatesModel _pricingInputDatesModel) {
            this.pricingInputDatesModel = _pricingInputDatesModel == null ? null : _pricingInputDatesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="inputs")
        @RuneAttribute(value="inputs")
        public YieldCurveValuationBuilder setInputs(QuotedAssetSet _inputs) {
            this.inputs = _inputs == null ? null : _inputs.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="zeroCurve")
        @RuneAttribute(value="zeroCurve")
        public YieldCurveValuationBuilder setZeroCurve(ZeroRateCurve _zeroCurve) {
            this.zeroCurve = _zeroCurve == null ? null : _zeroCurve.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="forwardCurve")
        @RuneAttribute(value="forwardCurve")
        public YieldCurveValuationBuilder addForwardCurve(ForwardRateCurve _forwardCurve) {
            if (_forwardCurve != null) {
                this.forwardCurve.add(_forwardCurve.toBuilder());
            }
            return this;
        }

        @Override
        public YieldCurveValuationBuilder addForwardCurve(ForwardRateCurve _forwardCurve, int idx) {
            this.getIndex(this.forwardCurve, idx, () -> _forwardCurve.toBuilder());
            return this;
        }

        @Override
        public YieldCurveValuationBuilder addForwardCurve(List<? extends ForwardRateCurve> forwardCurves) {
            if (forwardCurves != null) {
                for (ForwardRateCurve forwardRateCurve : forwardCurves) {
                    this.forwardCurve.add(forwardRateCurve.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="forwardCurve")
        public YieldCurveValuationBuilder setForwardCurve(List<? extends ForwardRateCurve> forwardCurves) {
            this.forwardCurve = forwardCurves == null ? new ArrayList<ForwardRateCurve.ForwardRateCurveBuilder>() : (List)forwardCurves.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="discountFactorCurve")
        @RuneAttribute(value="discountFactorCurve")
        public YieldCurveValuationBuilder setDiscountFactorCurve(TermCurve _discountFactorCurve) {
            this.discountFactorCurve = _discountFactorCurve == null ? null : _discountFactorCurve.toBuilder();
            return this;
        }

        @Override
        public YieldCurveValuation build() {
            return new YieldCurveValuationImpl(this);
        }

        @Override
        public YieldCurveValuationBuilder toBuilder() {
            return this;
        }

        @Override
        public YieldCurveValuationBuilder prune() {
            super.prune();
            if (this.inputs != null && !this.inputs.prune().hasData()) {
                this.inputs = null;
            }
            if (this.zeroCurve != null && !this.zeroCurve.prune().hasData()) {
                this.zeroCurve = null;
            }
            this.forwardCurve = this.forwardCurve.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.discountFactorCurve != null && !this.discountFactorCurve.prune().hasData()) {
                this.discountFactorCurve = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getInputs() != null && this.getInputs().hasData()) {
                return true;
            }
            if (this.getZeroCurve() != null && this.getZeroCurve().hasData()) {
                return true;
            }
            if (this.getForwardCurve() != null && this.getForwardCurve().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getDiscountFactorCurve() != null && this.getDiscountFactorCurve().hasData();
        }

        @Override
        public YieldCurveValuationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            YieldCurveValuationBuilder o = (YieldCurveValuationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInputs(), (RosettaModelObjectBuilder)o.getInputs(), this::setInputs);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getZeroCurve(), (RosettaModelObjectBuilder)o.getZeroCurve(), this::setZeroCurve);
            merger.mergeRosetta(this.getForwardCurve(), o.getForwardCurve(), this::getOrCreateForwardCurve);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDiscountFactorCurve(), (RosettaModelObjectBuilder)o.getDiscountFactorCurve(), this::setDiscountFactorCurve);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            YieldCurveValuation _that = (YieldCurveValuation)this.getType().cast(o);
            if (!Objects.equals(this.inputs, _that.getInputs())) {
                return false;
            }
            if (!Objects.equals(this.zeroCurve, _that.getZeroCurve())) {
                return false;
            }
            if (!ListEquals.listEquals(this.forwardCurve, _that.getForwardCurve())) {
                return false;
            }
            return Objects.equals(this.discountFactorCurve, _that.getDiscountFactorCurve());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.inputs != null ? this.inputs.hashCode() : 0);
            _result = 31 * _result + (this.zeroCurve != null ? this.zeroCurve.hashCode() : 0);
            _result = 31 * _result + (this.forwardCurve != null ? this.forwardCurve.hashCode() : 0);
            _result = 31 * _result + (this.discountFactorCurve != null ? this.discountFactorCurve.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "YieldCurveValuationBuilder {inputs=" + String.valueOf(this.inputs) + ", zeroCurve=" + String.valueOf(this.zeroCurve) + ", forwardCurve=" + String.valueOf(this.forwardCurve) + ", discountFactorCurve=" + String.valueOf(this.discountFactorCurve) + "} " + super.toString();
        }
    }

    public static interface YieldCurveValuationBuilder
    extends YieldCurveValuation,
    PricingStructureValuation.PricingStructureValuationBuilder {
        public QuotedAssetSet.QuotedAssetSetBuilder getOrCreateInputs();

        @Override
        public QuotedAssetSet.QuotedAssetSetBuilder getInputs();

        public ZeroRateCurve.ZeroRateCurveBuilder getOrCreateZeroCurve();

        @Override
        public ZeroRateCurve.ZeroRateCurveBuilder getZeroCurve();

        public ForwardRateCurve.ForwardRateCurveBuilder getOrCreateForwardCurve(int var1);

        public List<? extends ForwardRateCurve.ForwardRateCurveBuilder> getForwardCurve();

        public TermCurve.TermCurveBuilder getOrCreateDiscountFactorCurve();

        @Override
        public TermCurve.TermCurveBuilder getDiscountFactorCurve();

        @Override
        public YieldCurveValuationBuilder setObjectReference(AnyAssetReference var1);

        @Override
        public YieldCurveValuationBuilder setValuationScenarioReference(ValuationScenarioReference var1);

        @Override
        public YieldCurveValuationBuilder setId(String var1);

        @Override
        public YieldCurveValuationBuilder setDefinitionRef(String var1);

        @Override
        public YieldCurveValuationBuilder setPricingInputDatesModel(PricingInputDatesModel var1);

        public YieldCurveValuationBuilder setInputs(QuotedAssetSet var1);

        public YieldCurveValuationBuilder setZeroCurve(ZeroRateCurve var1);

        public YieldCurveValuationBuilder addForwardCurve(ForwardRateCurve var1);

        public YieldCurveValuationBuilder addForwardCurve(ForwardRateCurve var1, int var2);

        public YieldCurveValuationBuilder addForwardCurve(List<? extends ForwardRateCurve> var1);

        public YieldCurveValuationBuilder setForwardCurve(List<? extends ForwardRateCurve> var1);

        public YieldCurveValuationBuilder setDiscountFactorCurve(TermCurve var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("objectReference"), processor, AnyAssetReference.AnyAssetReferenceBuilder.class, (RosettaModelObjectBuilder)this.getObjectReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("valuationScenarioReference"), processor, ValuationScenarioReference.ValuationScenarioReferenceBuilder.class, (RosettaModelObjectBuilder)this.getValuationScenarioReference(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("definitionRef"), String.class, (Object)this.getDefinitionRef(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("pricingInputDatesModel"), processor, PricingInputDatesModel.PricingInputDatesModelBuilder.class, (RosettaModelObjectBuilder)this.getPricingInputDatesModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("inputs"), processor, QuotedAssetSet.QuotedAssetSetBuilder.class, this.getInputs(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("zeroCurve"), processor, ZeroRateCurve.ZeroRateCurveBuilder.class, this.getZeroCurve(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("forwardCurve"), processor, ForwardRateCurve.ForwardRateCurveBuilder.class, this.getForwardCurve(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("discountFactorCurve"), processor, TermCurve.TermCurveBuilder.class, this.getDiscountFactorCurve(), new AttributeMeta[0]);
        }

        @Override
        public YieldCurveValuationBuilder prune();
    }

    public static class YieldCurveValuationImpl
    extends PricingStructureValuation.PricingStructureValuationImpl
    implements YieldCurveValuation {
        private final QuotedAssetSet inputs;
        private final ZeroRateCurve zeroCurve;
        private final List<? extends ForwardRateCurve> forwardCurve;
        private final TermCurve discountFactorCurve;

        protected YieldCurveValuationImpl(YieldCurveValuationBuilder builder) {
            super(builder);
            this.inputs = Optional.ofNullable(builder.getInputs()).map(f -> f.build()).orElse(null);
            this.zeroCurve = Optional.ofNullable(builder.getZeroCurve()).map(f -> f.build()).orElse(null);
            this.forwardCurve = Optional.ofNullable(builder.getForwardCurve()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.discountFactorCurve = Optional.ofNullable(builder.getDiscountFactorCurve()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="inputs")
        @RuneAttribute(value="inputs")
        public QuotedAssetSet getInputs() {
            return this.inputs;
        }

        @Override
        @RosettaAttribute(value="zeroCurve")
        @RuneAttribute(value="zeroCurve")
        public ZeroRateCurve getZeroCurve() {
            return this.zeroCurve;
        }

        @Override
        @RosettaAttribute(value="forwardCurve")
        @RuneAttribute(value="forwardCurve")
        public List<? extends ForwardRateCurve> getForwardCurve() {
            return this.forwardCurve;
        }

        @Override
        @RosettaAttribute(value="discountFactorCurve")
        @RuneAttribute(value="discountFactorCurve")
        public TermCurve getDiscountFactorCurve() {
            return this.discountFactorCurve;
        }

        @Override
        public YieldCurveValuation build() {
            return this;
        }

        @Override
        public YieldCurveValuationBuilder toBuilder() {
            YieldCurveValuationBuilder builder = YieldCurveValuation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(YieldCurveValuationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getInputs()).ifPresent(builder::setInputs);
            Optional.ofNullable(this.getZeroCurve()).ifPresent(builder::setZeroCurve);
            Optional.ofNullable(this.getForwardCurve()).ifPresent(builder::setForwardCurve);
            Optional.ofNullable(this.getDiscountFactorCurve()).ifPresent(builder::setDiscountFactorCurve);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            YieldCurveValuation _that = (YieldCurveValuation)this.getType().cast(o);
            if (!Objects.equals(this.inputs, _that.getInputs())) {
                return false;
            }
            if (!Objects.equals(this.zeroCurve, _that.getZeroCurve())) {
                return false;
            }
            if (!ListEquals.listEquals(this.forwardCurve, _that.getForwardCurve())) {
                return false;
            }
            return Objects.equals(this.discountFactorCurve, _that.getDiscountFactorCurve());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.inputs != null ? this.inputs.hashCode() : 0);
            _result = 31 * _result + (this.zeroCurve != null ? this.zeroCurve.hashCode() : 0);
            _result = 31 * _result + (this.forwardCurve != null ? this.forwardCurve.hashCode() : 0);
            _result = 31 * _result + (this.discountFactorCurve != null ? this.discountFactorCurve.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "YieldCurveValuation {inputs=" + String.valueOf(this.inputs) + ", zeroCurve=" + String.valueOf(this.zeroCurve) + ", forwardCurve=" + String.valueOf(this.forwardCurve) + ", discountFactorCurve=" + String.valueOf(this.discountFactorCurve) + "} " + super.toString();
        }
    }
}

