/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.mktenv;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.asset.AnyAssetReference;
import fpml.consolidated.mktenv.MultiDimensionalPricingData;
import fpml.consolidated.mktenv.ParametricAdjustment;
import fpml.consolidated.mktenv.meta.VolatilityMatrixMeta;
import fpml.consolidated.riskdef.PricingInputDatesModel;
import fpml.consolidated.riskdef.PricingStructureValuation;
import fpml.consolidated.riskdef.ValuationScenarioReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="VolatilityMatrix", builder=VolatilityMatrixBuilderImpl.class, version="1.2.2")
@RuneDataType(value="VolatilityMatrix", model="fpml", builder=VolatilityMatrixBuilderImpl.class, version="1.2.2")
public interface VolatilityMatrix
extends PricingStructureValuation {
    public static final VolatilityMatrixMeta metaData = new VolatilityMatrixMeta();

    public MultiDimensionalPricingData getDataPoints();

    public List<? extends ParametricAdjustment> getAdjustment();

    @Override
    public VolatilityMatrix build();

    @Override
    public VolatilityMatrixBuilder toBuilder();

    public static VolatilityMatrixBuilder builder() {
        return new VolatilityMatrixBuilderImpl();
    }

    default public RosettaMetaData<? extends VolatilityMatrix> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends VolatilityMatrix> getType() {
        return VolatilityMatrix.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("objectReference"), processor, AnyAssetReference.class, this.getObjectReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("valuationScenarioReference"), processor, ValuationScenarioReference.class, this.getValuationScenarioReference(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("definitionRef"), String.class, (Object)this.getDefinitionRef(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("pricingInputDatesModel"), processor, PricingInputDatesModel.class, this.getPricingInputDatesModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dataPoints"), processor, MultiDimensionalPricingData.class, this.getDataPoints(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("adjustment"), processor, ParametricAdjustment.class, this.getAdjustment(), new AttributeMeta[0]);
    }

    public static class VolatilityMatrixBuilderImpl
    extends PricingStructureValuation.PricingStructureValuationBuilderImpl
    implements VolatilityMatrixBuilder {
        protected MultiDimensionalPricingData.MultiDimensionalPricingDataBuilder dataPoints;
        protected List<ParametricAdjustment.ParametricAdjustmentBuilder> adjustment = new ArrayList<ParametricAdjustment.ParametricAdjustmentBuilder>();

        @Override
        @RosettaAttribute(value="dataPoints")
        @RuneAttribute(value="dataPoints")
        public MultiDimensionalPricingData.MultiDimensionalPricingDataBuilder getDataPoints() {
            return this.dataPoints;
        }

        @Override
        public MultiDimensionalPricingData.MultiDimensionalPricingDataBuilder getOrCreateDataPoints() {
            MultiDimensionalPricingData.MultiDimensionalPricingDataBuilder result = this.dataPoints != null ? this.dataPoints : (this.dataPoints = MultiDimensionalPricingData.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="adjustment")
        @RuneAttribute(value="adjustment")
        public List<? extends ParametricAdjustment.ParametricAdjustmentBuilder> getAdjustment() {
            return this.adjustment;
        }

        @Override
        public ParametricAdjustment.ParametricAdjustmentBuilder getOrCreateAdjustment(int index) {
            if (this.adjustment == null) {
                this.adjustment = new ArrayList<ParametricAdjustment.ParametricAdjustmentBuilder>();
            }
            return (ParametricAdjustment.ParametricAdjustmentBuilder)this.getIndex(this.adjustment, index, () -> {
                ParametricAdjustment.ParametricAdjustmentBuilder newAdjustment = ParametricAdjustment.builder();
                return newAdjustment;
            });
        }

        @Override
        @RosettaAttribute(value="objectReference")
        @RuneAttribute(value="objectReference")
        public VolatilityMatrixBuilder setObjectReference(AnyAssetReference _objectReference) {
            this.objectReference = _objectReference == null ? null : _objectReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationScenarioReference")
        @RuneAttribute(value="valuationScenarioReference")
        public VolatilityMatrixBuilder setValuationScenarioReference(ValuationScenarioReference _valuationScenarioReference) {
            this.valuationScenarioReference = _valuationScenarioReference == null ? null : _valuationScenarioReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public VolatilityMatrixBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="definitionRef")
        @RuneAttribute(value="definitionRef")
        public VolatilityMatrixBuilder setDefinitionRef(String _definitionRef) {
            this.definitionRef = _definitionRef == null ? null : _definitionRef;
            return this;
        }

        @Override
        @RosettaAttribute(value="pricingInputDatesModel", isRequired=true)
        @RuneAttribute(value="pricingInputDatesModel", isRequired=true)
        public VolatilityMatrixBuilder setPricingInputDatesModel(PricingInputDatesModel _pricingInputDatesModel) {
            this.pricingInputDatesModel = _pricingInputDatesModel == null ? null : _pricingInputDatesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dataPoints")
        @RuneAttribute(value="dataPoints")
        public VolatilityMatrixBuilder setDataPoints(MultiDimensionalPricingData _dataPoints) {
            this.dataPoints = _dataPoints == null ? null : _dataPoints.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="adjustment")
        @RuneAttribute(value="adjustment")
        public VolatilityMatrixBuilder addAdjustment(ParametricAdjustment _adjustment) {
            if (_adjustment != null) {
                this.adjustment.add(_adjustment.toBuilder());
            }
            return this;
        }

        @Override
        public VolatilityMatrixBuilder addAdjustment(ParametricAdjustment _adjustment, int idx) {
            this.getIndex(this.adjustment, idx, () -> _adjustment.toBuilder());
            return this;
        }

        @Override
        public VolatilityMatrixBuilder addAdjustment(List<? extends ParametricAdjustment> adjustments) {
            if (adjustments != null) {
                for (ParametricAdjustment parametricAdjustment : adjustments) {
                    this.adjustment.add(parametricAdjustment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="adjustment")
        public VolatilityMatrixBuilder setAdjustment(List<? extends ParametricAdjustment> adjustments) {
            this.adjustment = adjustments == null ? new ArrayList<ParametricAdjustment.ParametricAdjustmentBuilder>() : (List)adjustments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public VolatilityMatrix build() {
            return new VolatilityMatrixImpl(this);
        }

        @Override
        public VolatilityMatrixBuilder toBuilder() {
            return this;
        }

        @Override
        public VolatilityMatrixBuilder prune() {
            super.prune();
            if (this.dataPoints != null && !this.dataPoints.prune().hasData()) {
                this.dataPoints = null;
            }
            this.adjustment = this.adjustment.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getDataPoints() != null && this.getDataPoints().hasData()) {
                return true;
            }
            return this.getAdjustment() != null && this.getAdjustment().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public VolatilityMatrixBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            VolatilityMatrixBuilder o = (VolatilityMatrixBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDataPoints(), (RosettaModelObjectBuilder)o.getDataPoints(), this::setDataPoints);
            merger.mergeRosetta(this.getAdjustment(), o.getAdjustment(), this::getOrCreateAdjustment);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VolatilityMatrix _that = (VolatilityMatrix)this.getType().cast(o);
            if (!Objects.equals(this.dataPoints, _that.getDataPoints())) {
                return false;
            }
            return ListEquals.listEquals(this.adjustment, _that.getAdjustment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.dataPoints != null ? this.dataPoints.hashCode() : 0);
            _result = 31 * _result + (this.adjustment != null ? this.adjustment.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "VolatilityMatrixBuilder {dataPoints=" + String.valueOf(this.dataPoints) + ", adjustment=" + String.valueOf(this.adjustment) + "} " + super.toString();
        }
    }

    public static interface VolatilityMatrixBuilder
    extends VolatilityMatrix,
    PricingStructureValuation.PricingStructureValuationBuilder {
        public MultiDimensionalPricingData.MultiDimensionalPricingDataBuilder getOrCreateDataPoints();

        @Override
        public MultiDimensionalPricingData.MultiDimensionalPricingDataBuilder getDataPoints();

        public ParametricAdjustment.ParametricAdjustmentBuilder getOrCreateAdjustment(int var1);

        public List<? extends ParametricAdjustment.ParametricAdjustmentBuilder> getAdjustment();

        @Override
        public VolatilityMatrixBuilder setObjectReference(AnyAssetReference var1);

        @Override
        public VolatilityMatrixBuilder setValuationScenarioReference(ValuationScenarioReference var1);

        @Override
        public VolatilityMatrixBuilder setId(String var1);

        @Override
        public VolatilityMatrixBuilder setDefinitionRef(String var1);

        @Override
        public VolatilityMatrixBuilder setPricingInputDatesModel(PricingInputDatesModel var1);

        public VolatilityMatrixBuilder setDataPoints(MultiDimensionalPricingData var1);

        public VolatilityMatrixBuilder addAdjustment(ParametricAdjustment var1);

        public VolatilityMatrixBuilder addAdjustment(ParametricAdjustment var1, int var2);

        public VolatilityMatrixBuilder addAdjustment(List<? extends ParametricAdjustment> var1);

        public VolatilityMatrixBuilder setAdjustment(List<? extends ParametricAdjustment> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("objectReference"), processor, AnyAssetReference.AnyAssetReferenceBuilder.class, (RosettaModelObjectBuilder)this.getObjectReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("valuationScenarioReference"), processor, ValuationScenarioReference.ValuationScenarioReferenceBuilder.class, (RosettaModelObjectBuilder)this.getValuationScenarioReference(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("definitionRef"), String.class, (Object)this.getDefinitionRef(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("pricingInputDatesModel"), processor, PricingInputDatesModel.PricingInputDatesModelBuilder.class, (RosettaModelObjectBuilder)this.getPricingInputDatesModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dataPoints"), processor, MultiDimensionalPricingData.MultiDimensionalPricingDataBuilder.class, this.getDataPoints(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("adjustment"), processor, ParametricAdjustment.ParametricAdjustmentBuilder.class, this.getAdjustment(), new AttributeMeta[0]);
        }

        @Override
        public VolatilityMatrixBuilder prune();
    }

    public static class VolatilityMatrixImpl
    extends PricingStructureValuation.PricingStructureValuationImpl
    implements VolatilityMatrix {
        private final MultiDimensionalPricingData dataPoints;
        private final List<? extends ParametricAdjustment> adjustment;

        protected VolatilityMatrixImpl(VolatilityMatrixBuilder builder) {
            super(builder);
            this.dataPoints = Optional.ofNullable(builder.getDataPoints()).map(f -> f.build()).orElse(null);
            this.adjustment = Optional.ofNullable(builder.getAdjustment()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="dataPoints")
        @RuneAttribute(value="dataPoints")
        public MultiDimensionalPricingData getDataPoints() {
            return this.dataPoints;
        }

        @Override
        @RosettaAttribute(value="adjustment")
        @RuneAttribute(value="adjustment")
        public List<? extends ParametricAdjustment> getAdjustment() {
            return this.adjustment;
        }

        @Override
        public VolatilityMatrix build() {
            return this;
        }

        @Override
        public VolatilityMatrixBuilder toBuilder() {
            VolatilityMatrixBuilder builder = VolatilityMatrix.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(VolatilityMatrixBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getDataPoints()).ifPresent(builder::setDataPoints);
            Optional.ofNullable(this.getAdjustment()).ifPresent(builder::setAdjustment);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VolatilityMatrix _that = (VolatilityMatrix)this.getType().cast(o);
            if (!Objects.equals(this.dataPoints, _that.getDataPoints())) {
                return false;
            }
            return ListEquals.listEquals(this.adjustment, _that.getAdjustment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.dataPoints != null ? this.dataPoints.hashCode() : 0);
            _result = 31 * _result + (this.adjustment != null ? this.adjustment.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "VolatilityMatrix {dataPoints=" + String.valueOf(this.dataPoints) + ", adjustment=" + String.valueOf(this.adjustment) + "} " + super.toString();
        }
    }
}

