/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.loan.AbstractLoanEventSequence;
import fpml.consolidated.loan.AbstractLoanServicingEvent;
import fpml.consolidated.loan.BusinessEventPartiesModel;
import fpml.consolidated.loan.LenderAndCashDetailsModel;
import fpml.consolidated.loan.LoanContractList;
import fpml.consolidated.loan.LoanContractsReference;
import fpml.consolidated.loan.LoanLegalActionReference;
import fpml.consolidated.loan.meta.RolloverMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Rollover", builder=RolloverBuilderImpl.class, version="1.2.2")
@RuneDataType(value="Rollover", model="fpml", builder=RolloverBuilderImpl.class, version="1.2.2")
public interface Rollover
extends AbstractLoanServicingEvent {
    public static final RolloverMeta metaData = new RolloverMeta();

    public LoanContractsReference getCurrentContracts();

    public LoanContractList getNewContracts();

    @Override
    public Rollover build();

    @Override
    public RolloverBuilder toBuilder();

    public static RolloverBuilder builder() {
        return new RolloverBuilderImpl();
    }

    default public RosettaMetaData<? extends Rollover> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Rollover> getType() {
        return Rollover.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.class, this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.class, this.getLegalActionReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currentContracts"), processor, LoanContractsReference.class, this.getCurrentContracts(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("newContracts"), processor, LoanContractList.class, this.getNewContracts(), new AttributeMeta[0]);
    }

    public static class RolloverBuilderImpl
    extends AbstractLoanServicingEvent.AbstractLoanServicingEventBuilderImpl
    implements RolloverBuilder {
        protected LoanContractsReference.LoanContractsReferenceBuilder currentContracts;
        protected LoanContractList.LoanContractListBuilder newContracts;

        @Override
        @RosettaAttribute(value="currentContracts", isRequired=true)
        @RuneAttribute(value="currentContracts", isRequired=true)
        public LoanContractsReference.LoanContractsReferenceBuilder getCurrentContracts() {
            return this.currentContracts;
        }

        @Override
        public LoanContractsReference.LoanContractsReferenceBuilder getOrCreateCurrentContracts() {
            LoanContractsReference.LoanContractsReferenceBuilder result = this.currentContracts != null ? this.currentContracts : (this.currentContracts = LoanContractsReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="newContracts", isRequired=true)
        @RuneAttribute(value="newContracts", isRequired=true)
        public LoanContractList.LoanContractListBuilder getNewContracts() {
            return this.newContracts;
        }

        @Override
        public LoanContractList.LoanContractListBuilder getOrCreateNewContracts() {
            LoanContractList.LoanContractListBuilder result = this.newContracts != null ? this.newContracts : (this.newContracts = LoanContractList.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public RolloverBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public RolloverBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public RolloverBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public RolloverBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public RolloverBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public RolloverBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public RolloverBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessEventPartiesModel", isRequired=true)
        @RuneAttribute(value="businessEventPartiesModel", isRequired=true)
        public RolloverBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel _businessEventPartiesModel) {
            this.businessEventPartiesModel = _businessEventPartiesModel == null ? null : _businessEventPartiesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public RolloverBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="legalActionReference")
        @RuneAttribute(value="legalActionReference")
        public RolloverBuilder setLegalActionReference(LoanLegalActionReference _legalActionReference) {
            this.legalActionReference = _legalActionReference == null ? null : _legalActionReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="currentContracts", isRequired=true)
        @RuneAttribute(value="currentContracts", isRequired=true)
        public RolloverBuilder setCurrentContracts(LoanContractsReference _currentContracts) {
            this.currentContracts = _currentContracts == null ? null : _currentContracts.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="newContracts", isRequired=true)
        @RuneAttribute(value="newContracts", isRequired=true)
        public RolloverBuilder setNewContracts(LoanContractList _newContracts) {
            this.newContracts = _newContracts == null ? null : _newContracts.toBuilder();
            return this;
        }

        @Override
        public Rollover build() {
            return new RolloverImpl(this);
        }

        @Override
        public RolloverBuilder toBuilder() {
            return this;
        }

        @Override
        public RolloverBuilder prune() {
            super.prune();
            if (this.currentContracts != null && !this.currentContracts.prune().hasData()) {
                this.currentContracts = null;
            }
            if (this.newContracts != null && !this.newContracts.prune().hasData()) {
                this.newContracts = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCurrentContracts() != null && this.getCurrentContracts().hasData()) {
                return true;
            }
            return this.getNewContracts() != null && this.getNewContracts().hasData();
        }

        @Override
        public RolloverBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            RolloverBuilder o = (RolloverBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCurrentContracts(), (RosettaModelObjectBuilder)o.getCurrentContracts(), this::setCurrentContracts);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNewContracts(), (RosettaModelObjectBuilder)o.getNewContracts(), this::setNewContracts);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Rollover _that = (Rollover)this.getType().cast(o);
            if (!Objects.equals(this.currentContracts, _that.getCurrentContracts())) {
                return false;
            }
            return Objects.equals(this.newContracts, _that.getNewContracts());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.currentContracts != null ? this.currentContracts.hashCode() : 0);
            _result = 31 * _result + (this.newContracts != null ? this.newContracts.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RolloverBuilder {currentContracts=" + String.valueOf(this.currentContracts) + ", newContracts=" + String.valueOf(this.newContracts) + "} " + super.toString();
        }
    }

    public static interface RolloverBuilder
    extends Rollover,
    AbstractLoanServicingEvent.AbstractLoanServicingEventBuilder {
        public LoanContractsReference.LoanContractsReferenceBuilder getOrCreateCurrentContracts();

        @Override
        public LoanContractsReference.LoanContractsReferenceBuilder getCurrentContracts();

        public LoanContractList.LoanContractListBuilder getOrCreateNewContracts();

        @Override
        public LoanContractList.LoanContractListBuilder getNewContracts();

        @Override
        public RolloverBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public RolloverBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public RolloverBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public RolloverBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public RolloverBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        @Override
        public RolloverBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        @Override
        public RolloverBuilder setComment(String var1);

        @Override
        public RolloverBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel var1);

        @Override
        public RolloverBuilder setEffectiveDate(ZonedDateTime var1);

        @Override
        public RolloverBuilder setLegalActionReference(LoanLegalActionReference var1);

        public RolloverBuilder setCurrentContracts(LoanContractsReference var1);

        public RolloverBuilder setNewContracts(LoanContractList var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, (RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, (RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.BusinessEventPartiesModelBuilder.class, (RosettaModelObjectBuilder)this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.LoanLegalActionReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLegalActionReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currentContracts"), processor, LoanContractsReference.LoanContractsReferenceBuilder.class, this.getCurrentContracts(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("newContracts"), processor, LoanContractList.LoanContractListBuilder.class, this.getNewContracts(), new AttributeMeta[0]);
        }

        @Override
        public RolloverBuilder prune();
    }

    public static class RolloverImpl
    extends AbstractLoanServicingEvent.AbstractLoanServicingEventImpl
    implements Rollover {
        private final LoanContractsReference currentContracts;
        private final LoanContractList newContracts;

        protected RolloverImpl(RolloverBuilder builder) {
            super(builder);
            this.currentContracts = Optional.ofNullable(builder.getCurrentContracts()).map(f -> f.build()).orElse(null);
            this.newContracts = Optional.ofNullable(builder.getNewContracts()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="currentContracts", isRequired=true)
        @RuneAttribute(value="currentContracts", isRequired=true)
        public LoanContractsReference getCurrentContracts() {
            return this.currentContracts;
        }

        @Override
        @RosettaAttribute(value="newContracts", isRequired=true)
        @RuneAttribute(value="newContracts", isRequired=true)
        public LoanContractList getNewContracts() {
            return this.newContracts;
        }

        @Override
        public Rollover build() {
            return this;
        }

        @Override
        public RolloverBuilder toBuilder() {
            RolloverBuilder builder = Rollover.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RolloverBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCurrentContracts()).ifPresent(builder::setCurrentContracts);
            Optional.ofNullable(this.getNewContracts()).ifPresent(builder::setNewContracts);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Rollover _that = (Rollover)this.getType().cast(o);
            if (!Objects.equals(this.currentContracts, _that.getCurrentContracts())) {
                return false;
            }
            return Objects.equals(this.newContracts, _that.getNewContracts());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.currentContracts != null ? this.currentContracts.hashCode() : 0);
            _result = 31 * _result + (this.newContracts != null ? this.newContracts.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Rollover {currentContracts=" + String.valueOf(this.currentContracts) + ", newContracts=" + String.valueOf(this.newContracts) + "} " + super.toString();
        }
    }
}

