/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.loan.AbstractLoanContractEvent;
import fpml.consolidated.loan.AbstractLoanEventSequence;
import fpml.consolidated.loan.BusinessEventPartiesModel;
import fpml.consolidated.loan.LenderAndCashDetailsModel;
import fpml.consolidated.loan.LoanContractReference;
import fpml.consolidated.loan.LoanLegalActionReference;
import fpml.consolidated.loan.MoneyWithParticipantShare;
import fpml.consolidated.loan.RepaymentTypeModel;
import fpml.consolidated.loan.meta.RepaymentMeta;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Repayment", builder=RepaymentBuilderImpl.class, version="1.2.2")
@RuneDataType(value="Repayment", model="fpml", builder=RepaymentBuilderImpl.class, version="1.2.2")
public interface Repayment
extends AbstractLoanContractEvent {
    public static final RepaymentMeta metaData = new RepaymentMeta();

    public MoneyWithParticipantShare getAmount();

    public BigDecimal getPrice();

    public RepaymentTypeModel getRepaymentTypeModel();

    @Override
    public Repayment build();

    @Override
    public RepaymentBuilder toBuilder();

    public static RepaymentBuilder builder() {
        return new RepaymentBuilderImpl();
    }

    default public RosettaMetaData<? extends Repayment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Repayment> getType() {
        return Repayment.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.class, this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.class, this.getLegalActionReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.class, this.getLoanContractReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.class, this.getAmount(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("price"), BigDecimal.class, (Object)this.getPrice(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("repaymentTypeModel"), processor, RepaymentTypeModel.class, this.getRepaymentTypeModel(), new AttributeMeta[0]);
    }

    public static class RepaymentBuilderImpl
    extends AbstractLoanContractEvent.AbstractLoanContractEventBuilderImpl
    implements RepaymentBuilder {
        protected MoneyWithParticipantShare.MoneyWithParticipantShareBuilder amount;
        protected BigDecimal price;
        protected RepaymentTypeModel.RepaymentTypeModelBuilder repaymentTypeModel;

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getAmount() {
            return this.amount;
        }

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateAmount() {
            MoneyWithParticipantShare.MoneyWithParticipantShareBuilder result = this.amount != null ? this.amount : (this.amount = MoneyWithParticipantShare.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="price")
        @RuneAttribute(value="price")
        public BigDecimal getPrice() {
            return this.price;
        }

        @Override
        @RosettaAttribute(value="repaymentTypeModel", isRequired=true)
        @RuneAttribute(value="repaymentTypeModel", isRequired=true)
        public RepaymentTypeModel.RepaymentTypeModelBuilder getRepaymentTypeModel() {
            return this.repaymentTypeModel;
        }

        @Override
        public RepaymentTypeModel.RepaymentTypeModelBuilder getOrCreateRepaymentTypeModel() {
            RepaymentTypeModel.RepaymentTypeModelBuilder result = this.repaymentTypeModel != null ? this.repaymentTypeModel : (this.repaymentTypeModel = RepaymentTypeModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public RepaymentBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public RepaymentBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public RepaymentBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public RepaymentBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public RepaymentBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public RepaymentBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public RepaymentBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessEventPartiesModel", isRequired=true)
        @RuneAttribute(value="businessEventPartiesModel", isRequired=true)
        public RepaymentBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel _businessEventPartiesModel) {
            this.businessEventPartiesModel = _businessEventPartiesModel == null ? null : _businessEventPartiesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public RepaymentBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="legalActionReference")
        @RuneAttribute(value="legalActionReference")
        public RepaymentBuilder setLegalActionReference(LoanLegalActionReference _legalActionReference) {
            this.legalActionReference = _legalActionReference == null ? null : _legalActionReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loanContractReference", isRequired=true)
        @RuneAttribute(value="loanContractReference", isRequired=true)
        public RepaymentBuilder setLoanContractReference(LoanContractReference _loanContractReference) {
            this.loanContractReference = _loanContractReference == null ? null : _loanContractReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public RepaymentBuilder setAmount(MoneyWithParticipantShare _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="price")
        @RuneAttribute(value="price")
        public RepaymentBuilder setPrice(BigDecimal _price) {
            this.price = _price == null ? null : _price;
            return this;
        }

        @Override
        @RosettaAttribute(value="repaymentTypeModel", isRequired=true)
        @RuneAttribute(value="repaymentTypeModel", isRequired=true)
        public RepaymentBuilder setRepaymentTypeModel(RepaymentTypeModel _repaymentTypeModel) {
            this.repaymentTypeModel = _repaymentTypeModel == null ? null : _repaymentTypeModel.toBuilder();
            return this;
        }

        @Override
        public Repayment build() {
            return new RepaymentImpl(this);
        }

        @Override
        public RepaymentBuilder toBuilder() {
            return this;
        }

        @Override
        public RepaymentBuilder prune() {
            super.prune();
            if (this.amount != null && !this.amount.prune().hasData()) {
                this.amount = null;
            }
            if (this.repaymentTypeModel != null && !this.repaymentTypeModel.prune().hasData()) {
                this.repaymentTypeModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getAmount() != null && this.getAmount().hasData()) {
                return true;
            }
            if (this.getPrice() != null) {
                return true;
            }
            return this.getRepaymentTypeModel() != null && this.getRepaymentTypeModel().hasData();
        }

        @Override
        public RepaymentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            RepaymentBuilder o = (RepaymentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmount(), (RosettaModelObjectBuilder)o.getAmount(), this::setAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRepaymentTypeModel(), (RosettaModelObjectBuilder)o.getRepaymentTypeModel(), this::setRepaymentTypeModel);
            merger.mergeBasic((Object)this.getPrice(), (Object)o.getPrice(), this::setPrice, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Repayment _that = (Repayment)this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            if (!Objects.equals(this.price, _that.getPrice())) {
                return false;
            }
            return Objects.equals(this.repaymentTypeModel, _that.getRepaymentTypeModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.price != null ? this.price.hashCode() : 0);
            _result = 31 * _result + (this.repaymentTypeModel != null ? this.repaymentTypeModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RepaymentBuilder {amount=" + String.valueOf(this.amount) + ", price=" + String.valueOf(this.price) + ", repaymentTypeModel=" + String.valueOf(this.repaymentTypeModel) + "} " + super.toString();
        }
    }

    public static interface RepaymentBuilder
    extends Repayment,
    AbstractLoanContractEvent.AbstractLoanContractEventBuilder {
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateAmount();

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getAmount();

        public RepaymentTypeModel.RepaymentTypeModelBuilder getOrCreateRepaymentTypeModel();

        @Override
        public RepaymentTypeModel.RepaymentTypeModelBuilder getRepaymentTypeModel();

        @Override
        public RepaymentBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public RepaymentBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public RepaymentBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public RepaymentBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public RepaymentBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        @Override
        public RepaymentBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        @Override
        public RepaymentBuilder setComment(String var1);

        @Override
        public RepaymentBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel var1);

        @Override
        public RepaymentBuilder setEffectiveDate(ZonedDateTime var1);

        @Override
        public RepaymentBuilder setLegalActionReference(LoanLegalActionReference var1);

        @Override
        public RepaymentBuilder setLoanContractReference(LoanContractReference var1);

        public RepaymentBuilder setAmount(MoneyWithParticipantShare var1);

        public RepaymentBuilder setPrice(BigDecimal var1);

        public RepaymentBuilder setRepaymentTypeModel(RepaymentTypeModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, (RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, (RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.BusinessEventPartiesModelBuilder.class, (RosettaModelObjectBuilder)this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.LoanLegalActionReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLegalActionReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.LoanContractReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLoanContractReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.MoneyWithParticipantShareBuilder.class, this.getAmount(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("price"), BigDecimal.class, (Object)this.getPrice(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("repaymentTypeModel"), processor, RepaymentTypeModel.RepaymentTypeModelBuilder.class, this.getRepaymentTypeModel(), new AttributeMeta[0]);
        }

        @Override
        public RepaymentBuilder prune();
    }

    public static class RepaymentImpl
    extends AbstractLoanContractEvent.AbstractLoanContractEventImpl
    implements Repayment {
        private final MoneyWithParticipantShare amount;
        private final BigDecimal price;
        private final RepaymentTypeModel repaymentTypeModel;

        protected RepaymentImpl(RepaymentBuilder builder) {
            super(builder);
            this.amount = Optional.ofNullable(builder.getAmount()).map(f -> f.build()).orElse(null);
            this.price = builder.getPrice();
            this.repaymentTypeModel = Optional.ofNullable(builder.getRepaymentTypeModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public MoneyWithParticipantShare getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="price")
        @RuneAttribute(value="price")
        public BigDecimal getPrice() {
            return this.price;
        }

        @Override
        @RosettaAttribute(value="repaymentTypeModel", isRequired=true)
        @RuneAttribute(value="repaymentTypeModel", isRequired=true)
        public RepaymentTypeModel getRepaymentTypeModel() {
            return this.repaymentTypeModel;
        }

        @Override
        public Repayment build() {
            return this;
        }

        @Override
        public RepaymentBuilder toBuilder() {
            RepaymentBuilder builder = Repayment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RepaymentBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getPrice()).ifPresent(builder::setPrice);
            Optional.ofNullable(this.getRepaymentTypeModel()).ifPresent(builder::setRepaymentTypeModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Repayment _that = (Repayment)this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            if (!Objects.equals(this.price, _that.getPrice())) {
                return false;
            }
            return Objects.equals(this.repaymentTypeModel, _that.getRepaymentTypeModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.price != null ? this.price.hashCode() : 0);
            _result = 31 * _result + (this.repaymentTypeModel != null ? this.repaymentTypeModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Repayment {amount=" + String.valueOf(this.amount) + ", price=" + String.valueOf(this.price) + ", repaymentTypeModel=" + String.valueOf(this.repaymentTypeModel) + "} " + super.toString();
        }
    }
}

