/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.loan.AbstractLoanTradeEvent;
import fpml.consolidated.loan.AbstractLoanTradeNotification;
import fpml.consolidated.loan.DealDetailsModel;
import fpml.consolidated.loan.FacilityDetailsModel;
import fpml.consolidated.loan.LoanTradeDetailsModel;
import fpml.consolidated.loan.LoanTradePayment;
import fpml.consolidated.loan.LoanTradeSettlementTask;
import fpml.consolidated.loan.LoanTradingPartyRole;
import fpml.consolidated.loan.meta.LoanTradeNotificationMeta;
import fpml.consolidated.msg.CorrelationAndSequenceModel;
import fpml.consolidated.msg.RequestMessageHeader;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.Party;
import fpml.consolidated.shared.PartyReference;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LoanTradeNotification", builder=LoanTradeNotificationBuilderImpl.class, version="1.2.2")
@RuneDataType(value="LoanTradeNotification", model="fpml", builder=LoanTradeNotificationBuilderImpl.class, version="1.2.2")
public interface LoanTradeNotification
extends AbstractLoanTradeNotification {
    public static final LoanTradeNotificationMeta metaData = new LoanTradeNotificationMeta();

    public AbstractLoanTradeEvent getLoanTradeEventGroup();

    public LoanTradeSettlementTask getSettlementTask();

    public LoanTradeDetailsModel getLoanTradeDetailsModel();

    public DealDetailsModel getDealDetailsModel();

    public FacilityDetailsModel getFacilityDetailsModel();

    public List<? extends Party> getParty();

    @Override
    public LoanTradeNotification build();

    @Override
    public LoanTradeNotificationBuilder toBuilder();

    public static LoanTradeNotificationBuilder builder() {
        return new LoanTradeNotificationBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanTradeNotification> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanTradeNotification> getType() {
        return LoanTradeNotification.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("noticeDate"), ZonedDateTime.class, (Object)this.getNoticeDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.class, this.getPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("role"), processor, LoanTradingPartyRole.class, this.getRole(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payment"), processor, LoanTradePayment.class, this.getPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanTradeEventGroup"), processor, AbstractLoanTradeEvent.class, this.getLoanTradeEventGroup(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementTask"), processor, LoanTradeSettlementTask.class, this.getSettlementTask(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanTradeDetailsModel"), processor, LoanTradeDetailsModel.class, this.getLoanTradeDetailsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dealDetailsModel"), processor, DealDetailsModel.class, this.getDealDetailsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityDetailsModel"), processor, FacilityDetailsModel.class, this.getFacilityDetailsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("party"), processor, Party.class, this.getParty(), new AttributeMeta[0]);
    }

    public static class LoanTradeNotificationBuilderImpl
    extends AbstractLoanTradeNotification.AbstractLoanTradeNotificationBuilderImpl
    implements LoanTradeNotificationBuilder {
        protected AbstractLoanTradeEvent.AbstractLoanTradeEventBuilder loanTradeEventGroup;
        protected LoanTradeSettlementTask.LoanTradeSettlementTaskBuilder settlementTask;
        protected LoanTradeDetailsModel.LoanTradeDetailsModelBuilder loanTradeDetailsModel;
        protected DealDetailsModel.DealDetailsModelBuilder dealDetailsModel;
        protected FacilityDetailsModel.FacilityDetailsModelBuilder facilityDetailsModel;
        protected List<Party.PartyBuilder> party = new ArrayList<Party.PartyBuilder>();

        @Override
        @RosettaAttribute(value="loanTradeEventGroup")
        @RuneAttribute(value="loanTradeEventGroup")
        public AbstractLoanTradeEvent.AbstractLoanTradeEventBuilder getLoanTradeEventGroup() {
            return this.loanTradeEventGroup;
        }

        @Override
        public AbstractLoanTradeEvent.AbstractLoanTradeEventBuilder getOrCreateLoanTradeEventGroup() {
            AbstractLoanTradeEvent.AbstractLoanTradeEventBuilder result = this.loanTradeEventGroup != null ? this.loanTradeEventGroup : (this.loanTradeEventGroup = AbstractLoanTradeEvent.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementTask")
        @RuneAttribute(value="settlementTask")
        public LoanTradeSettlementTask.LoanTradeSettlementTaskBuilder getSettlementTask() {
            return this.settlementTask;
        }

        @Override
        public LoanTradeSettlementTask.LoanTradeSettlementTaskBuilder getOrCreateSettlementTask() {
            LoanTradeSettlementTask.LoanTradeSettlementTaskBuilder result = this.settlementTask != null ? this.settlementTask : (this.settlementTask = LoanTradeSettlementTask.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="loanTradeDetailsModel", isRequired=true)
        @RuneAttribute(value="loanTradeDetailsModel", isRequired=true)
        public LoanTradeDetailsModel.LoanTradeDetailsModelBuilder getLoanTradeDetailsModel() {
            return this.loanTradeDetailsModel;
        }

        @Override
        public LoanTradeDetailsModel.LoanTradeDetailsModelBuilder getOrCreateLoanTradeDetailsModel() {
            LoanTradeDetailsModel.LoanTradeDetailsModelBuilder result = this.loanTradeDetailsModel != null ? this.loanTradeDetailsModel : (this.loanTradeDetailsModel = LoanTradeDetailsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dealDetailsModel")
        @RuneAttribute(value="dealDetailsModel")
        public DealDetailsModel.DealDetailsModelBuilder getDealDetailsModel() {
            return this.dealDetailsModel;
        }

        @Override
        public DealDetailsModel.DealDetailsModelBuilder getOrCreateDealDetailsModel() {
            DealDetailsModel.DealDetailsModelBuilder result = this.dealDetailsModel != null ? this.dealDetailsModel : (this.dealDetailsModel = DealDetailsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="facilityDetailsModel", isRequired=true)
        @RuneAttribute(value="facilityDetailsModel", isRequired=true)
        public FacilityDetailsModel.FacilityDetailsModelBuilder getFacilityDetailsModel() {
            return this.facilityDetailsModel;
        }

        @Override
        public FacilityDetailsModel.FacilityDetailsModelBuilder getOrCreateFacilityDetailsModel() {
            FacilityDetailsModel.FacilityDetailsModelBuilder result = this.facilityDetailsModel != null ? this.facilityDetailsModel : (this.facilityDetailsModel = FacilityDetailsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public List<? extends Party.PartyBuilder> getParty() {
            return this.party;
        }

        @Override
        public Party.PartyBuilder getOrCreateParty(int index) {
            if (this.party == null) {
                this.party = new ArrayList<Party.PartyBuilder>();
            }
            return (Party.PartyBuilder)this.getIndex(this.party, index, () -> {
                Party.PartyBuilder newParty = Party.builder();
                return newParty;
            });
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public LoanTradeNotificationBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public LoanTradeNotificationBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public LoanTradeNotificationBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public LoanTradeNotificationBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public LoanTradeNotificationBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="isCorrection")
        @RuneAttribute(value="isCorrection")
        public LoanTradeNotificationBuilder setIsCorrection(Boolean _isCorrection) {
            this.isCorrection = _isCorrection == null ? null : _isCorrection;
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public LoanTradeNotificationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public LoanTradeNotificationBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="noticeDate", isRequired=true)
        @RuneAttribute(value="noticeDate", isRequired=true)
        public LoanTradeNotificationBuilder setNoticeDate(ZonedDateTime _noticeDate) {
            this.noticeDate = _noticeDate == null ? null : _noticeDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public LoanTradeNotificationBuilder setPartyReference(PartyReference _partyReference) {
            this.partyReference = _partyReference == null ? null : _partyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="role", isRequired=true)
        @RuneAttribute(value="role", isRequired=true)
        public LoanTradeNotificationBuilder setRole(LoanTradingPartyRole _role) {
            this.role = _role == null ? null : _role.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="payment")
        @RuneAttribute(value="payment")
        public LoanTradeNotificationBuilder addPayment(LoanTradePayment _payment) {
            if (_payment != null) {
                this.payment.add(_payment.toBuilder());
            }
            return this;
        }

        @Override
        public LoanTradeNotificationBuilder addPayment(LoanTradePayment _payment, int idx) {
            this.getIndex(this.payment, idx, () -> _payment.toBuilder());
            return this;
        }

        @Override
        public LoanTradeNotificationBuilder addPayment(List<? extends LoanTradePayment> payments) {
            if (payments != null) {
                for (LoanTradePayment loanTradePayment : payments) {
                    this.payment.add(loanTradePayment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="payment")
        public LoanTradeNotificationBuilder setPayment(List<? extends LoanTradePayment> payments) {
            this.payment = payments == null ? new ArrayList() : (List)payments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="loanTradeEventGroup")
        @RuneAttribute(value="loanTradeEventGroup")
        public LoanTradeNotificationBuilder setLoanTradeEventGroup(AbstractLoanTradeEvent _loanTradeEventGroup) {
            this.loanTradeEventGroup = _loanTradeEventGroup == null ? null : _loanTradeEventGroup.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementTask")
        @RuneAttribute(value="settlementTask")
        public LoanTradeNotificationBuilder setSettlementTask(LoanTradeSettlementTask _settlementTask) {
            this.settlementTask = _settlementTask == null ? null : _settlementTask.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loanTradeDetailsModel", isRequired=true)
        @RuneAttribute(value="loanTradeDetailsModel", isRequired=true)
        public LoanTradeNotificationBuilder setLoanTradeDetailsModel(LoanTradeDetailsModel _loanTradeDetailsModel) {
            this.loanTradeDetailsModel = _loanTradeDetailsModel == null ? null : _loanTradeDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dealDetailsModel")
        @RuneAttribute(value="dealDetailsModel")
        public LoanTradeNotificationBuilder setDealDetailsModel(DealDetailsModel _dealDetailsModel) {
            this.dealDetailsModel = _dealDetailsModel == null ? null : _dealDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityDetailsModel", isRequired=true)
        @RuneAttribute(value="facilityDetailsModel", isRequired=true)
        public LoanTradeNotificationBuilder setFacilityDetailsModel(FacilityDetailsModel _facilityDetailsModel) {
            this.facilityDetailsModel = _facilityDetailsModel == null ? null : _facilityDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public LoanTradeNotificationBuilder addParty(Party _party) {
            if (_party != null) {
                this.party.add(_party.toBuilder());
            }
            return this;
        }

        @Override
        public LoanTradeNotificationBuilder addParty(Party _party, int idx) {
            this.getIndex(this.party, idx, () -> _party.toBuilder());
            return this;
        }

        @Override
        public LoanTradeNotificationBuilder addParty(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.party.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="party")
        public LoanTradeNotificationBuilder setParty(List<? extends Party> partys) {
            this.party = partys == null ? new ArrayList<Party.PartyBuilder>() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LoanTradeNotification build() {
            return new LoanTradeNotificationImpl(this);
        }

        @Override
        public LoanTradeNotificationBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanTradeNotificationBuilder prune() {
            super.prune();
            if (this.loanTradeEventGroup != null && !this.loanTradeEventGroup.prune().hasData()) {
                this.loanTradeEventGroup = null;
            }
            if (this.settlementTask != null && !this.settlementTask.prune().hasData()) {
                this.settlementTask = null;
            }
            if (this.loanTradeDetailsModel != null && !this.loanTradeDetailsModel.prune().hasData()) {
                this.loanTradeDetailsModel = null;
            }
            if (this.dealDetailsModel != null && !this.dealDetailsModel.prune().hasData()) {
                this.dealDetailsModel = null;
            }
            if (this.facilityDetailsModel != null && !this.facilityDetailsModel.prune().hasData()) {
                this.facilityDetailsModel = null;
            }
            this.party = this.party.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getLoanTradeEventGroup() != null && this.getLoanTradeEventGroup().hasData()) {
                return true;
            }
            if (this.getSettlementTask() != null && this.getSettlementTask().hasData()) {
                return true;
            }
            if (this.getLoanTradeDetailsModel() != null && this.getLoanTradeDetailsModel().hasData()) {
                return true;
            }
            if (this.getDealDetailsModel() != null && this.getDealDetailsModel().hasData()) {
                return true;
            }
            if (this.getFacilityDetailsModel() != null && this.getFacilityDetailsModel().hasData()) {
                return true;
            }
            return this.getParty() != null && this.getParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public LoanTradeNotificationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanTradeNotificationBuilder o = (LoanTradeNotificationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLoanTradeEventGroup(), (RosettaModelObjectBuilder)o.getLoanTradeEventGroup(), this::setLoanTradeEventGroup);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementTask(), (RosettaModelObjectBuilder)o.getSettlementTask(), this::setSettlementTask);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLoanTradeDetailsModel(), (RosettaModelObjectBuilder)o.getLoanTradeDetailsModel(), this::setLoanTradeDetailsModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDealDetailsModel(), (RosettaModelObjectBuilder)o.getDealDetailsModel(), this::setDealDetailsModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFacilityDetailsModel(), (RosettaModelObjectBuilder)o.getFacilityDetailsModel(), this::setFacilityDetailsModel);
            merger.mergeRosetta(this.getParty(), o.getParty(), this::getOrCreateParty);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanTradeNotification _that = (LoanTradeNotification)this.getType().cast(o);
            if (!Objects.equals(this.loanTradeEventGroup, _that.getLoanTradeEventGroup())) {
                return false;
            }
            if (!Objects.equals(this.settlementTask, _that.getSettlementTask())) {
                return false;
            }
            if (!Objects.equals(this.loanTradeDetailsModel, _that.getLoanTradeDetailsModel())) {
                return false;
            }
            if (!Objects.equals(this.dealDetailsModel, _that.getDealDetailsModel())) {
                return false;
            }
            if (!Objects.equals(this.facilityDetailsModel, _that.getFacilityDetailsModel())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.loanTradeEventGroup != null ? this.loanTradeEventGroup.hashCode() : 0);
            _result = 31 * _result + (this.settlementTask != null ? this.settlementTask.hashCode() : 0);
            _result = 31 * _result + (this.loanTradeDetailsModel != null ? this.loanTradeDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.dealDetailsModel != null ? this.dealDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.facilityDetailsModel != null ? this.facilityDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanTradeNotificationBuilder {loanTradeEventGroup=" + String.valueOf(this.loanTradeEventGroup) + ", settlementTask=" + String.valueOf(this.settlementTask) + ", loanTradeDetailsModel=" + String.valueOf(this.loanTradeDetailsModel) + ", dealDetailsModel=" + String.valueOf(this.dealDetailsModel) + ", facilityDetailsModel=" + String.valueOf(this.facilityDetailsModel) + ", party=" + String.valueOf(this.party) + "} " + super.toString();
        }
    }

    public static interface LoanTradeNotificationBuilder
    extends LoanTradeNotification,
    AbstractLoanTradeNotification.AbstractLoanTradeNotificationBuilder {
        public AbstractLoanTradeEvent.AbstractLoanTradeEventBuilder getOrCreateLoanTradeEventGroup();

        @Override
        public AbstractLoanTradeEvent.AbstractLoanTradeEventBuilder getLoanTradeEventGroup();

        public LoanTradeSettlementTask.LoanTradeSettlementTaskBuilder getOrCreateSettlementTask();

        @Override
        public LoanTradeSettlementTask.LoanTradeSettlementTaskBuilder getSettlementTask();

        public LoanTradeDetailsModel.LoanTradeDetailsModelBuilder getOrCreateLoanTradeDetailsModel();

        @Override
        public LoanTradeDetailsModel.LoanTradeDetailsModelBuilder getLoanTradeDetailsModel();

        public DealDetailsModel.DealDetailsModelBuilder getOrCreateDealDetailsModel();

        @Override
        public DealDetailsModel.DealDetailsModelBuilder getDealDetailsModel();

        public FacilityDetailsModel.FacilityDetailsModelBuilder getOrCreateFacilityDetailsModel();

        @Override
        public FacilityDetailsModel.FacilityDetailsModelBuilder getFacilityDetailsModel();

        public Party.PartyBuilder getOrCreateParty(int var1);

        public List<? extends Party.PartyBuilder> getParty();

        @Override
        public LoanTradeNotificationBuilder setFpmlVersion(String var1);

        @Override
        public LoanTradeNotificationBuilder setExpectedBuild(Integer var1);

        @Override
        public LoanTradeNotificationBuilder setActualBuild(Integer var1);

        @Override
        public LoanTradeNotificationBuilder setHeader(RequestMessageHeader var1);

        @Override
        public LoanTradeNotificationBuilder setValidationModel(ValidationModel var1);

        @Override
        public LoanTradeNotificationBuilder setIsCorrection(Boolean var1);

        @Override
        public LoanTradeNotificationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public LoanTradeNotificationBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        @Override
        public LoanTradeNotificationBuilder setNoticeDate(ZonedDateTime var1);

        @Override
        public LoanTradeNotificationBuilder setPartyReference(PartyReference var1);

        @Override
        public LoanTradeNotificationBuilder setRole(LoanTradingPartyRole var1);

        @Override
        public LoanTradeNotificationBuilder addPayment(LoanTradePayment var1);

        @Override
        public LoanTradeNotificationBuilder addPayment(LoanTradePayment var1, int var2);

        @Override
        public LoanTradeNotificationBuilder addPayment(List<? extends LoanTradePayment> var1);

        @Override
        public LoanTradeNotificationBuilder setPayment(List<? extends LoanTradePayment> var1);

        public LoanTradeNotificationBuilder setLoanTradeEventGroup(AbstractLoanTradeEvent var1);

        public LoanTradeNotificationBuilder setSettlementTask(LoanTradeSettlementTask var1);

        public LoanTradeNotificationBuilder setLoanTradeDetailsModel(LoanTradeDetailsModel var1);

        public LoanTradeNotificationBuilder setDealDetailsModel(DealDetailsModel var1);

        public LoanTradeNotificationBuilder setFacilityDetailsModel(FacilityDetailsModel var1);

        public LoanTradeNotificationBuilder addParty(Party var1);

        public LoanTradeNotificationBuilder addParty(Party var1, int var2);

        public LoanTradeNotificationBuilder addParty(List<? extends Party> var1);

        public LoanTradeNotificationBuilder setParty(List<? extends Party> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("noticeDate"), ZonedDateTime.class, (Object)this.getNoticeDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.PartyReferenceBuilder.class, (RosettaModelObjectBuilder)this.getPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("role"), processor, LoanTradingPartyRole.LoanTradingPartyRoleBuilder.class, (RosettaModelObjectBuilder)this.getRole(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payment"), processor, LoanTradePayment.LoanTradePaymentBuilder.class, this.getPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanTradeEventGroup"), processor, AbstractLoanTradeEvent.AbstractLoanTradeEventBuilder.class, this.getLoanTradeEventGroup(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementTask"), processor, LoanTradeSettlementTask.LoanTradeSettlementTaskBuilder.class, this.getSettlementTask(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanTradeDetailsModel"), processor, LoanTradeDetailsModel.LoanTradeDetailsModelBuilder.class, this.getLoanTradeDetailsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dealDetailsModel"), processor, DealDetailsModel.DealDetailsModelBuilder.class, this.getDealDetailsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityDetailsModel"), processor, FacilityDetailsModel.FacilityDetailsModelBuilder.class, this.getFacilityDetailsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("party"), processor, Party.PartyBuilder.class, this.getParty(), new AttributeMeta[0]);
        }

        @Override
        public LoanTradeNotificationBuilder prune();
    }

    public static class LoanTradeNotificationImpl
    extends AbstractLoanTradeNotification.AbstractLoanTradeNotificationImpl
    implements LoanTradeNotification {
        private final AbstractLoanTradeEvent loanTradeEventGroup;
        private final LoanTradeSettlementTask settlementTask;
        private final LoanTradeDetailsModel loanTradeDetailsModel;
        private final DealDetailsModel dealDetailsModel;
        private final FacilityDetailsModel facilityDetailsModel;
        private final List<? extends Party> party;

        protected LoanTradeNotificationImpl(LoanTradeNotificationBuilder builder) {
            super(builder);
            this.loanTradeEventGroup = Optional.ofNullable(builder.getLoanTradeEventGroup()).map(f -> f.build()).orElse(null);
            this.settlementTask = Optional.ofNullable(builder.getSettlementTask()).map(f -> f.build()).orElse(null);
            this.loanTradeDetailsModel = Optional.ofNullable(builder.getLoanTradeDetailsModel()).map(f -> f.build()).orElse(null);
            this.dealDetailsModel = Optional.ofNullable(builder.getDealDetailsModel()).map(f -> f.build()).orElse(null);
            this.facilityDetailsModel = Optional.ofNullable(builder.getFacilityDetailsModel()).map(f -> f.build()).orElse(null);
            this.party = Optional.ofNullable(builder.getParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="loanTradeEventGroup")
        @RuneAttribute(value="loanTradeEventGroup")
        public AbstractLoanTradeEvent getLoanTradeEventGroup() {
            return this.loanTradeEventGroup;
        }

        @Override
        @RosettaAttribute(value="settlementTask")
        @RuneAttribute(value="settlementTask")
        public LoanTradeSettlementTask getSettlementTask() {
            return this.settlementTask;
        }

        @Override
        @RosettaAttribute(value="loanTradeDetailsModel", isRequired=true)
        @RuneAttribute(value="loanTradeDetailsModel", isRequired=true)
        public LoanTradeDetailsModel getLoanTradeDetailsModel() {
            return this.loanTradeDetailsModel;
        }

        @Override
        @RosettaAttribute(value="dealDetailsModel")
        @RuneAttribute(value="dealDetailsModel")
        public DealDetailsModel getDealDetailsModel() {
            return this.dealDetailsModel;
        }

        @Override
        @RosettaAttribute(value="facilityDetailsModel", isRequired=true)
        @RuneAttribute(value="facilityDetailsModel", isRequired=true)
        public FacilityDetailsModel getFacilityDetailsModel() {
            return this.facilityDetailsModel;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public List<? extends Party> getParty() {
            return this.party;
        }

        @Override
        public LoanTradeNotification build() {
            return this;
        }

        @Override
        public LoanTradeNotificationBuilder toBuilder() {
            LoanTradeNotificationBuilder builder = LoanTradeNotification.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanTradeNotificationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getLoanTradeEventGroup()).ifPresent(builder::setLoanTradeEventGroup);
            Optional.ofNullable(this.getSettlementTask()).ifPresent(builder::setSettlementTask);
            Optional.ofNullable(this.getLoanTradeDetailsModel()).ifPresent(builder::setLoanTradeDetailsModel);
            Optional.ofNullable(this.getDealDetailsModel()).ifPresent(builder::setDealDetailsModel);
            Optional.ofNullable(this.getFacilityDetailsModel()).ifPresent(builder::setFacilityDetailsModel);
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanTradeNotification _that = (LoanTradeNotification)this.getType().cast(o);
            if (!Objects.equals(this.loanTradeEventGroup, _that.getLoanTradeEventGroup())) {
                return false;
            }
            if (!Objects.equals(this.settlementTask, _that.getSettlementTask())) {
                return false;
            }
            if (!Objects.equals(this.loanTradeDetailsModel, _that.getLoanTradeDetailsModel())) {
                return false;
            }
            if (!Objects.equals(this.dealDetailsModel, _that.getDealDetailsModel())) {
                return false;
            }
            if (!Objects.equals(this.facilityDetailsModel, _that.getFacilityDetailsModel())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.loanTradeEventGroup != null ? this.loanTradeEventGroup.hashCode() : 0);
            _result = 31 * _result + (this.settlementTask != null ? this.settlementTask.hashCode() : 0);
            _result = 31 * _result + (this.loanTradeDetailsModel != null ? this.loanTradeDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.dealDetailsModel != null ? this.dealDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.facilityDetailsModel != null ? this.facilityDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanTradeNotification {loanTradeEventGroup=" + String.valueOf(this.loanTradeEventGroup) + ", settlementTask=" + String.valueOf(this.settlementTask) + ", loanTradeDetailsModel=" + String.valueOf(this.loanTradeDetailsModel) + ", dealDetailsModel=" + String.valueOf(this.dealDetailsModel) + ", facilityDetailsModel=" + String.valueOf(this.facilityDetailsModel) + ", party=" + String.valueOf(this.party) + "} " + super.toString();
        }
    }
}

