/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.fpmlenum.InterestCalculationMethodEnum;
import fpml.consolidated.loan.AbstractLoanContractEvent;
import fpml.consolidated.loan.AbstractLoanEventSequence;
import fpml.consolidated.loan.BusinessEventPartiesModel;
import fpml.consolidated.loan.LenderAndCashDetailsModel;
import fpml.consolidated.loan.LoanContractReference;
import fpml.consolidated.loan.LoanInterestPaymentSequence;
import fpml.consolidated.loan.LoanLegalActionReference;
import fpml.consolidated.loan.MoneyWithParticipantShare;
import fpml.consolidated.loan.meta.LoanInterestPaymentMeta;
import fpml.consolidated.shared.PeriodModel;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LoanInterestPayment", builder=LoanInterestPaymentBuilderImpl.class, version="1.2.2")
@RuneDataType(value="LoanInterestPayment", model="fpml", builder=LoanInterestPaymentBuilderImpl.class, version="1.2.2")
public interface LoanInterestPayment
extends AbstractLoanContractEvent {
    public static final LoanInterestPaymentMeta metaData = new LoanInterestPaymentMeta();

    public PeriodModel getPeriodModel();

    public InterestCalculationMethodEnum getLenderShareCalculationMethod();

    public MoneyWithParticipantShare getAmount();

    public LoanInterestPaymentSequence getLoanInterestPaymentSequence();

    @Override
    public LoanInterestPayment build();

    @Override
    public LoanInterestPaymentBuilder toBuilder();

    public static LoanInterestPaymentBuilder builder() {
        return new LoanInterestPaymentBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanInterestPayment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanInterestPayment> getType() {
        return LoanInterestPayment.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.class, this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.class, this.getLegalActionReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.class, this.getLoanContractReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("periodModel"), processor, PeriodModel.class, this.getPeriodModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("lenderShareCalculationMethod"), InterestCalculationMethodEnum.class, (Object)this.getLenderShareCalculationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.class, this.getAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanInterestPaymentSequence"), processor, LoanInterestPaymentSequence.class, this.getLoanInterestPaymentSequence(), new AttributeMeta[0]);
    }

    public static class LoanInterestPaymentBuilderImpl
    extends AbstractLoanContractEvent.AbstractLoanContractEventBuilderImpl
    implements LoanInterestPaymentBuilder {
        protected PeriodModel.PeriodModelBuilder periodModel;
        protected InterestCalculationMethodEnum lenderShareCalculationMethod;
        protected MoneyWithParticipantShare.MoneyWithParticipantShareBuilder amount;
        protected LoanInterestPaymentSequence.LoanInterestPaymentSequenceBuilder loanInterestPaymentSequence;

        @Override
        @RosettaAttribute(value="periodModel", isRequired=true)
        @RuneAttribute(value="periodModel", isRequired=true)
        public PeriodModel.PeriodModelBuilder getPeriodModel() {
            return this.periodModel;
        }

        @Override
        public PeriodModel.PeriodModelBuilder getOrCreatePeriodModel() {
            PeriodModel.PeriodModelBuilder result = this.periodModel != null ? this.periodModel : (this.periodModel = PeriodModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="lenderShareCalculationMethod", isRequired=true)
        @RuneAttribute(value="lenderShareCalculationMethod", isRequired=true)
        public InterestCalculationMethodEnum getLenderShareCalculationMethod() {
            return this.lenderShareCalculationMethod;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getAmount() {
            return this.amount;
        }

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateAmount() {
            MoneyWithParticipantShare.MoneyWithParticipantShareBuilder result = this.amount != null ? this.amount : (this.amount = MoneyWithParticipantShare.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="loanInterestPaymentSequence")
        @RuneAttribute(value="loanInterestPaymentSequence")
        public LoanInterestPaymentSequence.LoanInterestPaymentSequenceBuilder getLoanInterestPaymentSequence() {
            return this.loanInterestPaymentSequence;
        }

        @Override
        public LoanInterestPaymentSequence.LoanInterestPaymentSequenceBuilder getOrCreateLoanInterestPaymentSequence() {
            LoanInterestPaymentSequence.LoanInterestPaymentSequenceBuilder result = this.loanInterestPaymentSequence != null ? this.loanInterestPaymentSequence : (this.loanInterestPaymentSequence = LoanInterestPaymentSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public LoanInterestPaymentBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public LoanInterestPaymentBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public LoanInterestPaymentBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public LoanInterestPaymentBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public LoanInterestPaymentBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public LoanInterestPaymentBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public LoanInterestPaymentBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessEventPartiesModel", isRequired=true)
        @RuneAttribute(value="businessEventPartiesModel", isRequired=true)
        public LoanInterestPaymentBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel _businessEventPartiesModel) {
            this.businessEventPartiesModel = _businessEventPartiesModel == null ? null : _businessEventPartiesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public LoanInterestPaymentBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="legalActionReference")
        @RuneAttribute(value="legalActionReference")
        public LoanInterestPaymentBuilder setLegalActionReference(LoanLegalActionReference _legalActionReference) {
            this.legalActionReference = _legalActionReference == null ? null : _legalActionReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loanContractReference", isRequired=true)
        @RuneAttribute(value="loanContractReference", isRequired=true)
        public LoanInterestPaymentBuilder setLoanContractReference(LoanContractReference _loanContractReference) {
            this.loanContractReference = _loanContractReference == null ? null : _loanContractReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="periodModel", isRequired=true)
        @RuneAttribute(value="periodModel", isRequired=true)
        public LoanInterestPaymentBuilder setPeriodModel(PeriodModel _periodModel) {
            this.periodModel = _periodModel == null ? null : _periodModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderShareCalculationMethod", isRequired=true)
        @RuneAttribute(value="lenderShareCalculationMethod", isRequired=true)
        public LoanInterestPaymentBuilder setLenderShareCalculationMethod(InterestCalculationMethodEnum _lenderShareCalculationMethod) {
            this.lenderShareCalculationMethod = _lenderShareCalculationMethod == null ? null : _lenderShareCalculationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public LoanInterestPaymentBuilder setAmount(MoneyWithParticipantShare _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loanInterestPaymentSequence")
        @RuneAttribute(value="loanInterestPaymentSequence")
        public LoanInterestPaymentBuilder setLoanInterestPaymentSequence(LoanInterestPaymentSequence _loanInterestPaymentSequence) {
            this.loanInterestPaymentSequence = _loanInterestPaymentSequence == null ? null : _loanInterestPaymentSequence.toBuilder();
            return this;
        }

        @Override
        public LoanInterestPayment build() {
            return new LoanInterestPaymentImpl(this);
        }

        @Override
        public LoanInterestPaymentBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanInterestPaymentBuilder prune() {
            super.prune();
            if (this.periodModel != null && !this.periodModel.prune().hasData()) {
                this.periodModel = null;
            }
            if (this.amount != null && !this.amount.prune().hasData()) {
                this.amount = null;
            }
            if (this.loanInterestPaymentSequence != null && !this.loanInterestPaymentSequence.prune().hasData()) {
                this.loanInterestPaymentSequence = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPeriodModel() != null && this.getPeriodModel().hasData()) {
                return true;
            }
            if (this.getLenderShareCalculationMethod() != null) {
                return true;
            }
            if (this.getAmount() != null && this.getAmount().hasData()) {
                return true;
            }
            return this.getLoanInterestPaymentSequence() != null && this.getLoanInterestPaymentSequence().hasData();
        }

        @Override
        public LoanInterestPaymentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanInterestPaymentBuilder o = (LoanInterestPaymentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPeriodModel(), (RosettaModelObjectBuilder)o.getPeriodModel(), this::setPeriodModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmount(), (RosettaModelObjectBuilder)o.getAmount(), this::setAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLoanInterestPaymentSequence(), (RosettaModelObjectBuilder)o.getLoanInterestPaymentSequence(), this::setLoanInterestPaymentSequence);
            merger.mergeBasic((Object)this.getLenderShareCalculationMethod(), (Object)o.getLenderShareCalculationMethod(), this::setLenderShareCalculationMethod, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanInterestPayment _that = (LoanInterestPayment)this.getType().cast(o);
            if (!Objects.equals(this.periodModel, _that.getPeriodModel())) {
                return false;
            }
            if (!Objects.equals((Object)this.lenderShareCalculationMethod, (Object)_that.getLenderShareCalculationMethod())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return Objects.equals(this.loanInterestPaymentSequence, _that.getLoanInterestPaymentSequence());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.periodModel != null ? this.periodModel.hashCode() : 0);
            _result = 31 * _result + (this.lenderShareCalculationMethod != null ? ((Object)((Object)this.lenderShareCalculationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.loanInterestPaymentSequence != null ? this.loanInterestPaymentSequence.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanInterestPaymentBuilder {periodModel=" + String.valueOf(this.periodModel) + ", lenderShareCalculationMethod=" + String.valueOf((Object)this.lenderShareCalculationMethod) + ", amount=" + String.valueOf(this.amount) + ", loanInterestPaymentSequence=" + String.valueOf(this.loanInterestPaymentSequence) + "} " + super.toString();
        }
    }

    public static interface LoanInterestPaymentBuilder
    extends LoanInterestPayment,
    AbstractLoanContractEvent.AbstractLoanContractEventBuilder {
        public PeriodModel.PeriodModelBuilder getOrCreatePeriodModel();

        @Override
        public PeriodModel.PeriodModelBuilder getPeriodModel();

        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateAmount();

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getAmount();

        public LoanInterestPaymentSequence.LoanInterestPaymentSequenceBuilder getOrCreateLoanInterestPaymentSequence();

        @Override
        public LoanInterestPaymentSequence.LoanInterestPaymentSequenceBuilder getLoanInterestPaymentSequence();

        @Override
        public LoanInterestPaymentBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public LoanInterestPaymentBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public LoanInterestPaymentBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public LoanInterestPaymentBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public LoanInterestPaymentBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        @Override
        public LoanInterestPaymentBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        @Override
        public LoanInterestPaymentBuilder setComment(String var1);

        @Override
        public LoanInterestPaymentBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel var1);

        @Override
        public LoanInterestPaymentBuilder setEffectiveDate(ZonedDateTime var1);

        @Override
        public LoanInterestPaymentBuilder setLegalActionReference(LoanLegalActionReference var1);

        @Override
        public LoanInterestPaymentBuilder setLoanContractReference(LoanContractReference var1);

        public LoanInterestPaymentBuilder setPeriodModel(PeriodModel var1);

        public LoanInterestPaymentBuilder setLenderShareCalculationMethod(InterestCalculationMethodEnum var1);

        public LoanInterestPaymentBuilder setAmount(MoneyWithParticipantShare var1);

        public LoanInterestPaymentBuilder setLoanInterestPaymentSequence(LoanInterestPaymentSequence var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, (RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, (RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.BusinessEventPartiesModelBuilder.class, (RosettaModelObjectBuilder)this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.LoanLegalActionReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLegalActionReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.LoanContractReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLoanContractReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("periodModel"), processor, PeriodModel.PeriodModelBuilder.class, this.getPeriodModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("lenderShareCalculationMethod"), InterestCalculationMethodEnum.class, (Object)this.getLenderShareCalculationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.MoneyWithParticipantShareBuilder.class, this.getAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanInterestPaymentSequence"), processor, LoanInterestPaymentSequence.LoanInterestPaymentSequenceBuilder.class, this.getLoanInterestPaymentSequence(), new AttributeMeta[0]);
        }

        @Override
        public LoanInterestPaymentBuilder prune();
    }

    public static class LoanInterestPaymentImpl
    extends AbstractLoanContractEvent.AbstractLoanContractEventImpl
    implements LoanInterestPayment {
        private final PeriodModel periodModel;
        private final InterestCalculationMethodEnum lenderShareCalculationMethod;
        private final MoneyWithParticipantShare amount;
        private final LoanInterestPaymentSequence loanInterestPaymentSequence;

        protected LoanInterestPaymentImpl(LoanInterestPaymentBuilder builder) {
            super(builder);
            this.periodModel = Optional.ofNullable(builder.getPeriodModel()).map(f -> f.build()).orElse(null);
            this.lenderShareCalculationMethod = builder.getLenderShareCalculationMethod();
            this.amount = Optional.ofNullable(builder.getAmount()).map(f -> f.build()).orElse(null);
            this.loanInterestPaymentSequence = Optional.ofNullable(builder.getLoanInterestPaymentSequence()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="periodModel", isRequired=true)
        @RuneAttribute(value="periodModel", isRequired=true)
        public PeriodModel getPeriodModel() {
            return this.periodModel;
        }

        @Override
        @RosettaAttribute(value="lenderShareCalculationMethod", isRequired=true)
        @RuneAttribute(value="lenderShareCalculationMethod", isRequired=true)
        public InterestCalculationMethodEnum getLenderShareCalculationMethod() {
            return this.lenderShareCalculationMethod;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public MoneyWithParticipantShare getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="loanInterestPaymentSequence")
        @RuneAttribute(value="loanInterestPaymentSequence")
        public LoanInterestPaymentSequence getLoanInterestPaymentSequence() {
            return this.loanInterestPaymentSequence;
        }

        @Override
        public LoanInterestPayment build() {
            return this;
        }

        @Override
        public LoanInterestPaymentBuilder toBuilder() {
            LoanInterestPaymentBuilder builder = LoanInterestPayment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanInterestPaymentBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPeriodModel()).ifPresent(builder::setPeriodModel);
            Optional.ofNullable(this.getLenderShareCalculationMethod()).ifPresent(builder::setLenderShareCalculationMethod);
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getLoanInterestPaymentSequence()).ifPresent(builder::setLoanInterestPaymentSequence);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanInterestPayment _that = (LoanInterestPayment)this.getType().cast(o);
            if (!Objects.equals(this.periodModel, _that.getPeriodModel())) {
                return false;
            }
            if (!Objects.equals((Object)this.lenderShareCalculationMethod, (Object)_that.getLenderShareCalculationMethod())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return Objects.equals(this.loanInterestPaymentSequence, _that.getLoanInterestPaymentSequence());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.periodModel != null ? this.periodModel.hashCode() : 0);
            _result = 31 * _result + (this.lenderShareCalculationMethod != null ? ((Object)((Object)this.lenderShareCalculationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.loanInterestPaymentSequence != null ? this.loanInterestPaymentSequence.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanInterestPayment {periodModel=" + String.valueOf(this.periodModel) + ", lenderShareCalculationMethod=" + String.valueOf((Object)this.lenderShareCalculationMethod) + ", amount=" + String.valueOf(this.amount) + ", loanInterestPaymentSequence=" + String.valueOf(this.loanInterestPaymentSequence) + "} " + super.toString();
        }
    }
}

