/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.loan.CovenantObligationId;
import fpml.consolidated.loan.CovenantObligationSummary;
import fpml.consolidated.loan.DealReference;
import fpml.consolidated.loan.FacilityReference;
import fpml.consolidated.loan.VersionedCovenantObligationId;
import fpml.consolidated.loan.meta.LoanCovenantObligationSummaryMeta;
import fpml.consolidated.shared.PartyReference;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LoanCovenantObligationSummary", builder=LoanCovenantObligationSummaryBuilderImpl.class, version="1.2.2")
@RuneDataType(value="LoanCovenantObligationSummary", model="fpml", builder=LoanCovenantObligationSummaryBuilderImpl.class, version="1.2.2")
public interface LoanCovenantObligationSummary
extends CovenantObligationSummary {
    public static final LoanCovenantObligationSummaryMeta metaData = new LoanCovenantObligationSummaryMeta();

    public DealReference getDealReference();

    public List<? extends FacilityReference> getFacilityReference();

    @Override
    public LoanCovenantObligationSummary build();

    @Override
    public LoanCovenantObligationSummaryBuilder toBuilder();

    public static LoanCovenantObligationSummaryBuilder builder() {
        return new LoanCovenantObligationSummaryBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanCovenantObligationSummary> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanCovenantObligationSummary> getType() {
        return LoanCovenantObligationSummary.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.class, this.getPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("covenantObligationId"), processor, CovenantObligationId.class, this.getCovenantObligationId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("versionedCovenantObligationId"), processor, VersionedCovenantObligationId.class, this.getVersionedCovenantObligationId(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("obligatedParty"), processor, PartyReference.class, this.getObligatedParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dealReference"), processor, DealReference.class, this.getDealReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.class, this.getFacilityReference(), new AttributeMeta[0]);
    }

    public static class LoanCovenantObligationSummaryBuilderImpl
    extends CovenantObligationSummary.CovenantObligationSummaryBuilderImpl
    implements LoanCovenantObligationSummaryBuilder {
        protected DealReference.DealReferenceBuilder dealReference;
        protected List<FacilityReference.FacilityReferenceBuilder> facilityReference = new ArrayList<FacilityReference.FacilityReferenceBuilder>();

        @Override
        @RosettaAttribute(value="dealReference")
        @RuneAttribute(value="dealReference")
        public DealReference.DealReferenceBuilder getDealReference() {
            return this.dealReference;
        }

        @Override
        public DealReference.DealReferenceBuilder getOrCreateDealReference() {
            DealReference.DealReferenceBuilder result = this.dealReference != null ? this.dealReference : (this.dealReference = DealReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="facilityReference")
        @RuneAttribute(value="facilityReference")
        public List<? extends FacilityReference.FacilityReferenceBuilder> getFacilityReference() {
            return this.facilityReference;
        }

        @Override
        public FacilityReference.FacilityReferenceBuilder getOrCreateFacilityReference(int index) {
            if (this.facilityReference == null) {
                this.facilityReference = new ArrayList<FacilityReference.FacilityReferenceBuilder>();
            }
            return (FacilityReference.FacilityReferenceBuilder)this.getIndex(this.facilityReference, index, () -> {
                FacilityReference.FacilityReferenceBuilder newFacilityReference = FacilityReference.builder();
                return newFacilityReference;
            });
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public LoanCovenantObligationSummaryBuilder setName(String _name) {
            this.name = _name == null ? null : _name;
            return this;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public LoanCovenantObligationSummaryBuilder setPartyReference(PartyReference _partyReference) {
            this.partyReference = _partyReference == null ? null : _partyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="covenantObligationId")
        @RuneAttribute(value="covenantObligationId")
        public LoanCovenantObligationSummaryBuilder addCovenantObligationId(CovenantObligationId _covenantObligationId) {
            if (_covenantObligationId != null) {
                this.covenantObligationId.add(_covenantObligationId.toBuilder());
            }
            return this;
        }

        @Override
        public LoanCovenantObligationSummaryBuilder addCovenantObligationId(CovenantObligationId _covenantObligationId, int idx) {
            this.getIndex(this.covenantObligationId, idx, () -> _covenantObligationId.toBuilder());
            return this;
        }

        @Override
        public LoanCovenantObligationSummaryBuilder addCovenantObligationId(List<? extends CovenantObligationId> covenantObligationIds) {
            if (covenantObligationIds != null) {
                for (CovenantObligationId covenantObligationId : covenantObligationIds) {
                    this.covenantObligationId.add(covenantObligationId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="covenantObligationId")
        public LoanCovenantObligationSummaryBuilder setCovenantObligationId(List<? extends CovenantObligationId> covenantObligationIds) {
            this.covenantObligationId = covenantObligationIds == null ? new ArrayList() : (List)covenantObligationIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="versionedCovenantObligationId")
        @RuneAttribute(value="versionedCovenantObligationId")
        public LoanCovenantObligationSummaryBuilder addVersionedCovenantObligationId(VersionedCovenantObligationId _versionedCovenantObligationId) {
            if (_versionedCovenantObligationId != null) {
                this.versionedCovenantObligationId.add(_versionedCovenantObligationId.toBuilder());
            }
            return this;
        }

        @Override
        public LoanCovenantObligationSummaryBuilder addVersionedCovenantObligationId(VersionedCovenantObligationId _versionedCovenantObligationId, int idx) {
            this.getIndex(this.versionedCovenantObligationId, idx, () -> _versionedCovenantObligationId.toBuilder());
            return this;
        }

        @Override
        public LoanCovenantObligationSummaryBuilder addVersionedCovenantObligationId(List<? extends VersionedCovenantObligationId> versionedCovenantObligationIds) {
            if (versionedCovenantObligationIds != null) {
                for (VersionedCovenantObligationId versionedCovenantObligationId : versionedCovenantObligationIds) {
                    this.versionedCovenantObligationId.add(versionedCovenantObligationId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="versionedCovenantObligationId")
        public LoanCovenantObligationSummaryBuilder setVersionedCovenantObligationId(List<? extends VersionedCovenantObligationId> versionedCovenantObligationIds) {
            this.versionedCovenantObligationId = versionedCovenantObligationIds == null ? new ArrayList() : (List)versionedCovenantObligationIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public LoanCovenantObligationSummaryBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public LoanCovenantObligationSummaryBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="obligatedParty", isRequired=true)
        @RuneAttribute(value="obligatedParty", isRequired=true)
        public LoanCovenantObligationSummaryBuilder setObligatedParty(PartyReference _obligatedParty) {
            this.obligatedParty = _obligatedParty == null ? null : _obligatedParty.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dealReference")
        @RuneAttribute(value="dealReference")
        public LoanCovenantObligationSummaryBuilder setDealReference(DealReference _dealReference) {
            this.dealReference = _dealReference == null ? null : _dealReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityReference")
        @RuneAttribute(value="facilityReference")
        public LoanCovenantObligationSummaryBuilder addFacilityReference(FacilityReference _facilityReference) {
            if (_facilityReference != null) {
                this.facilityReference.add(_facilityReference.toBuilder());
            }
            return this;
        }

        @Override
        public LoanCovenantObligationSummaryBuilder addFacilityReference(FacilityReference _facilityReference, int idx) {
            this.getIndex(this.facilityReference, idx, () -> _facilityReference.toBuilder());
            return this;
        }

        @Override
        public LoanCovenantObligationSummaryBuilder addFacilityReference(List<? extends FacilityReference> facilityReferences) {
            if (facilityReferences != null) {
                for (FacilityReference facilityReference : facilityReferences) {
                    this.facilityReference.add(facilityReference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="facilityReference")
        public LoanCovenantObligationSummaryBuilder setFacilityReference(List<? extends FacilityReference> facilityReferences) {
            this.facilityReference = facilityReferences == null ? new ArrayList<FacilityReference.FacilityReferenceBuilder>() : (List)facilityReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LoanCovenantObligationSummary build() {
            return new LoanCovenantObligationSummaryImpl(this);
        }

        @Override
        public LoanCovenantObligationSummaryBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanCovenantObligationSummaryBuilder prune() {
            super.prune();
            if (this.dealReference != null && !this.dealReference.prune().hasData()) {
                this.dealReference = null;
            }
            this.facilityReference = this.facilityReference.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getDealReference() != null && this.getDealReference().hasData()) {
                return true;
            }
            return this.getFacilityReference() != null && this.getFacilityReference().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public LoanCovenantObligationSummaryBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanCovenantObligationSummaryBuilder o = (LoanCovenantObligationSummaryBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDealReference(), (RosettaModelObjectBuilder)o.getDealReference(), this::setDealReference);
            merger.mergeRosetta(this.getFacilityReference(), o.getFacilityReference(), this::getOrCreateFacilityReference);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanCovenantObligationSummary _that = (LoanCovenantObligationSummary)this.getType().cast(o);
            if (!Objects.equals(this.dealReference, _that.getDealReference())) {
                return false;
            }
            return ListEquals.listEquals(this.facilityReference, _that.getFacilityReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.dealReference != null ? this.dealReference.hashCode() : 0);
            _result = 31 * _result + (this.facilityReference != null ? this.facilityReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanCovenantObligationSummaryBuilder {dealReference=" + String.valueOf(this.dealReference) + ", facilityReference=" + String.valueOf(this.facilityReference) + "} " + super.toString();
        }
    }

    public static interface LoanCovenantObligationSummaryBuilder
    extends LoanCovenantObligationSummary,
    CovenantObligationSummary.CovenantObligationSummaryBuilder {
        public DealReference.DealReferenceBuilder getOrCreateDealReference();

        @Override
        public DealReference.DealReferenceBuilder getDealReference();

        public FacilityReference.FacilityReferenceBuilder getOrCreateFacilityReference(int var1);

        public List<? extends FacilityReference.FacilityReferenceBuilder> getFacilityReference();

        @Override
        public LoanCovenantObligationSummaryBuilder setName(String var1);

        @Override
        public LoanCovenantObligationSummaryBuilder setPartyReference(PartyReference var1);

        @Override
        public LoanCovenantObligationSummaryBuilder addCovenantObligationId(CovenantObligationId var1);

        @Override
        public LoanCovenantObligationSummaryBuilder addCovenantObligationId(CovenantObligationId var1, int var2);

        @Override
        public LoanCovenantObligationSummaryBuilder addCovenantObligationId(List<? extends CovenantObligationId> var1);

        @Override
        public LoanCovenantObligationSummaryBuilder setCovenantObligationId(List<? extends CovenantObligationId> var1);

        @Override
        public LoanCovenantObligationSummaryBuilder addVersionedCovenantObligationId(VersionedCovenantObligationId var1);

        @Override
        public LoanCovenantObligationSummaryBuilder addVersionedCovenantObligationId(VersionedCovenantObligationId var1, int var2);

        @Override
        public LoanCovenantObligationSummaryBuilder addVersionedCovenantObligationId(List<? extends VersionedCovenantObligationId> var1);

        @Override
        public LoanCovenantObligationSummaryBuilder setVersionedCovenantObligationId(List<? extends VersionedCovenantObligationId> var1);

        @Override
        public LoanCovenantObligationSummaryBuilder setId(String var1);

        @Override
        public LoanCovenantObligationSummaryBuilder setEffectiveDate(ZonedDateTime var1);

        @Override
        public LoanCovenantObligationSummaryBuilder setObligatedParty(PartyReference var1);

        public LoanCovenantObligationSummaryBuilder setDealReference(DealReference var1);

        public LoanCovenantObligationSummaryBuilder addFacilityReference(FacilityReference var1);

        public LoanCovenantObligationSummaryBuilder addFacilityReference(FacilityReference var1, int var2);

        public LoanCovenantObligationSummaryBuilder addFacilityReference(List<? extends FacilityReference> var1);

        public LoanCovenantObligationSummaryBuilder setFacilityReference(List<? extends FacilityReference> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.PartyReferenceBuilder.class, (RosettaModelObjectBuilder)this.getPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("covenantObligationId"), processor, CovenantObligationId.CovenantObligationIdBuilder.class, this.getCovenantObligationId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("versionedCovenantObligationId"), processor, VersionedCovenantObligationId.VersionedCovenantObligationIdBuilder.class, this.getVersionedCovenantObligationId(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("obligatedParty"), processor, PartyReference.PartyReferenceBuilder.class, (RosettaModelObjectBuilder)this.getObligatedParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dealReference"), processor, DealReference.DealReferenceBuilder.class, this.getDealReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.FacilityReferenceBuilder.class, this.getFacilityReference(), new AttributeMeta[0]);
        }

        @Override
        public LoanCovenantObligationSummaryBuilder prune();
    }

    public static class LoanCovenantObligationSummaryImpl
    extends CovenantObligationSummary.CovenantObligationSummaryImpl
    implements LoanCovenantObligationSummary {
        private final DealReference dealReference;
        private final List<? extends FacilityReference> facilityReference;

        protected LoanCovenantObligationSummaryImpl(LoanCovenantObligationSummaryBuilder builder) {
            super(builder);
            this.dealReference = Optional.ofNullable(builder.getDealReference()).map(f -> f.build()).orElse(null);
            this.facilityReference = Optional.ofNullable(builder.getFacilityReference()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="dealReference")
        @RuneAttribute(value="dealReference")
        public DealReference getDealReference() {
            return this.dealReference;
        }

        @Override
        @RosettaAttribute(value="facilityReference")
        @RuneAttribute(value="facilityReference")
        public List<? extends FacilityReference> getFacilityReference() {
            return this.facilityReference;
        }

        @Override
        public LoanCovenantObligationSummary build() {
            return this;
        }

        @Override
        public LoanCovenantObligationSummaryBuilder toBuilder() {
            LoanCovenantObligationSummaryBuilder builder = LoanCovenantObligationSummary.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanCovenantObligationSummaryBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getDealReference()).ifPresent(builder::setDealReference);
            Optional.ofNullable(this.getFacilityReference()).ifPresent(builder::setFacilityReference);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanCovenantObligationSummary _that = (LoanCovenantObligationSummary)this.getType().cast(o);
            if (!Objects.equals(this.dealReference, _that.getDealReference())) {
                return false;
            }
            return ListEquals.listEquals(this.facilityReference, _that.getFacilityReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.dealReference != null ? this.dealReference.hashCode() : 0);
            _result = 31 * _result + (this.facilityReference != null ? this.facilityReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanCovenantObligationSummary {dealReference=" + String.valueOf(this.dealReference) + ", facilityReference=" + String.valueOf(this.facilityReference) + "} " + super.toString();
        }
    }
}

