/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.loan.AbstractLoanAllocationEvent;
import fpml.consolidated.loan.AbstractLoanEventSequence;
import fpml.consolidated.loan.LenderAndCashDetailsModel;
import fpml.consolidated.loan.LoanAllocationReference;
import fpml.consolidated.loan.meta.LoanAllocationTransferFeeDueMeta;
import fpml.consolidated.shared.NonNegativeMoney;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LoanAllocationTransferFeeDue", builder=LoanAllocationTransferFeeDueBuilderImpl.class, version="1.2.2")
@RuneDataType(value="LoanAllocationTransferFeeDue", model="fpml", builder=LoanAllocationTransferFeeDueBuilderImpl.class, version="1.2.2")
public interface LoanAllocationTransferFeeDue
extends AbstractLoanAllocationEvent {
    public static final LoanAllocationTransferFeeDueMeta metaData = new LoanAllocationTransferFeeDueMeta();

    public NonNegativeMoney getAmount();

    public ZonedDateTime getDueDate();

    @Override
    public LoanAllocationTransferFeeDue build();

    @Override
    public LoanAllocationTransferFeeDueBuilder toBuilder();

    public static LoanAllocationTransferFeeDueBuilder builder() {
        return new LoanAllocationTransferFeeDueBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanAllocationTransferFeeDue> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanAllocationTransferFeeDue> getType() {
        return LoanAllocationTransferFeeDue.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("allocationReference"), processor, LoanAllocationReference.class, this.getAllocationReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amount"), processor, NonNegativeMoney.class, this.getAmount(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("dueDate"), ZonedDateTime.class, (Object)this.getDueDate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class LoanAllocationTransferFeeDueBuilderImpl
    extends AbstractLoanAllocationEvent.AbstractLoanAllocationEventBuilderImpl
    implements LoanAllocationTransferFeeDueBuilder {
        protected NonNegativeMoney.NonNegativeMoneyBuilder amount;
        protected ZonedDateTime dueDate;

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public NonNegativeMoney.NonNegativeMoneyBuilder getAmount() {
            return this.amount;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateAmount() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.amount != null ? this.amount : (this.amount = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dueDate", isRequired=true)
        @RuneAttribute(value="dueDate", isRequired=true)
        public ZonedDateTime getDueDate() {
            return this.dueDate;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public LoanAllocationTransferFeeDueBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public LoanAllocationTransferFeeDueBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public LoanAllocationTransferFeeDueBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public LoanAllocationTransferFeeDueBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public LoanAllocationTransferFeeDueBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public LoanAllocationTransferFeeDueBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public LoanAllocationTransferFeeDueBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="allocationReference", isRequired=true)
        @RuneAttribute(value="allocationReference", isRequired=true)
        public LoanAllocationTransferFeeDueBuilder setAllocationReference(LoanAllocationReference _allocationReference) {
            this.allocationReference = _allocationReference == null ? null : _allocationReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public LoanAllocationTransferFeeDueBuilder setAmount(NonNegativeMoney _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dueDate", isRequired=true)
        @RuneAttribute(value="dueDate", isRequired=true)
        public LoanAllocationTransferFeeDueBuilder setDueDate(ZonedDateTime _dueDate) {
            this.dueDate = _dueDate == null ? null : _dueDate;
            return this;
        }

        @Override
        public LoanAllocationTransferFeeDue build() {
            return new LoanAllocationTransferFeeDueImpl(this);
        }

        @Override
        public LoanAllocationTransferFeeDueBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanAllocationTransferFeeDueBuilder prune() {
            super.prune();
            if (this.amount != null && !this.amount.prune().hasData()) {
                this.amount = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getAmount() != null && this.getAmount().hasData()) {
                return true;
            }
            return this.getDueDate() != null;
        }

        @Override
        public LoanAllocationTransferFeeDueBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanAllocationTransferFeeDueBuilder o = (LoanAllocationTransferFeeDueBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmount(), (RosettaModelObjectBuilder)o.getAmount(), this::setAmount);
            merger.mergeBasic((Object)this.getDueDate(), (Object)o.getDueDate(), this::setDueDate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanAllocationTransferFeeDue _that = (LoanAllocationTransferFeeDue)this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return Objects.equals(this.dueDate, _that.getDueDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.dueDate != null ? this.dueDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanAllocationTransferFeeDueBuilder {amount=" + String.valueOf(this.amount) + ", dueDate=" + String.valueOf(this.dueDate) + "} " + super.toString();
        }
    }

    public static interface LoanAllocationTransferFeeDueBuilder
    extends LoanAllocationTransferFeeDue,
    AbstractLoanAllocationEvent.AbstractLoanAllocationEventBuilder {
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateAmount();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getAmount();

        @Override
        public LoanAllocationTransferFeeDueBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public LoanAllocationTransferFeeDueBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public LoanAllocationTransferFeeDueBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public LoanAllocationTransferFeeDueBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public LoanAllocationTransferFeeDueBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        @Override
        public LoanAllocationTransferFeeDueBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        @Override
        public LoanAllocationTransferFeeDueBuilder setComment(String var1);

        @Override
        public LoanAllocationTransferFeeDueBuilder setAllocationReference(LoanAllocationReference var1);

        public LoanAllocationTransferFeeDueBuilder setAmount(NonNegativeMoney var1);

        public LoanAllocationTransferFeeDueBuilder setDueDate(ZonedDateTime var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, (RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, (RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("allocationReference"), processor, LoanAllocationReference.LoanAllocationReferenceBuilder.class, (RosettaModelObjectBuilder)this.getAllocationReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getAmount(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("dueDate"), ZonedDateTime.class, (Object)this.getDueDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public LoanAllocationTransferFeeDueBuilder prune();
    }

    public static class LoanAllocationTransferFeeDueImpl
    extends AbstractLoanAllocationEvent.AbstractLoanAllocationEventImpl
    implements LoanAllocationTransferFeeDue {
        private final NonNegativeMoney amount;
        private final ZonedDateTime dueDate;

        protected LoanAllocationTransferFeeDueImpl(LoanAllocationTransferFeeDueBuilder builder) {
            super(builder);
            this.amount = Optional.ofNullable(builder.getAmount()).map(f -> f.build()).orElse(null);
            this.dueDate = builder.getDueDate();
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public NonNegativeMoney getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="dueDate", isRequired=true)
        @RuneAttribute(value="dueDate", isRequired=true)
        public ZonedDateTime getDueDate() {
            return this.dueDate;
        }

        @Override
        public LoanAllocationTransferFeeDue build() {
            return this;
        }

        @Override
        public LoanAllocationTransferFeeDueBuilder toBuilder() {
            LoanAllocationTransferFeeDueBuilder builder = LoanAllocationTransferFeeDue.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanAllocationTransferFeeDueBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getDueDate()).ifPresent(builder::setDueDate);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanAllocationTransferFeeDue _that = (LoanAllocationTransferFeeDue)this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return Objects.equals(this.dueDate, _that.getDueDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.dueDate != null ? this.dueDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanAllocationTransferFeeDue {amount=" + String.valueOf(this.amount) + ", dueDate=" + String.valueOf(this.dueDate) + "} " + super.toString();
        }
    }
}

