/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.loan.AbstractFacilityEvent;
import fpml.consolidated.loan.AbstractLoanEventSequence;
import fpml.consolidated.loan.Adjustment;
import fpml.consolidated.loan.BusinessEventPartiesModel;
import fpml.consolidated.loan.CommitmentSchedule;
import fpml.consolidated.loan.FacilityCommitment;
import fpml.consolidated.loan.FacilityReference;
import fpml.consolidated.loan.LenderAndCashDetailsModel;
import fpml.consolidated.loan.LoanLegalActionReference;
import fpml.consolidated.loan.meta.CommitmentAdjustmentMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CommitmentAdjustment", builder=CommitmentAdjustmentBuilderImpl.class, version="1.2.2")
@RuneDataType(value="CommitmentAdjustment", model="fpml", builder=CommitmentAdjustmentBuilderImpl.class, version="1.2.2")
public interface CommitmentAdjustment
extends AbstractFacilityEvent {
    public static final CommitmentAdjustmentMeta metaData = new CommitmentAdjustmentMeta();

    public Boolean getRefusalAllowed();

    public Boolean getScheduled();

    public Boolean getPik();

    public FacilityCommitment getFacilityCommitment();

    public Adjustment getAdjustment();

    public CommitmentSchedule getCommitmentSchedule();

    @Override
    public CommitmentAdjustment build();

    @Override
    public CommitmentAdjustmentBuilder toBuilder();

    public static CommitmentAdjustmentBuilder builder() {
        return new CommitmentAdjustmentBuilderImpl();
    }

    default public RosettaMetaData<? extends CommitmentAdjustment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommitmentAdjustment> getType() {
        return CommitmentAdjustment.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.class, this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.class, this.getLegalActionReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.class, this.getFacilityReference(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("refusalAllowed"), Boolean.class, (Object)this.getRefusalAllowed(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("scheduled"), Boolean.class, (Object)this.getScheduled(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("pik"), Boolean.class, (Object)this.getPik(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityCommitment"), processor, FacilityCommitment.class, this.getFacilityCommitment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("adjustment"), processor, Adjustment.class, this.getAdjustment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commitmentSchedule"), processor, CommitmentSchedule.class, this.getCommitmentSchedule(), new AttributeMeta[0]);
    }

    public static class CommitmentAdjustmentBuilderImpl
    extends AbstractFacilityEvent.AbstractFacilityEventBuilderImpl
    implements CommitmentAdjustmentBuilder {
        protected Boolean refusalAllowed;
        protected Boolean scheduled;
        protected Boolean pik;
        protected FacilityCommitment.FacilityCommitmentBuilder facilityCommitment;
        protected Adjustment.AdjustmentBuilder adjustment;
        protected CommitmentSchedule.CommitmentScheduleBuilder commitmentSchedule;

        @Override
        @RosettaAttribute(value="refusalAllowed", isRequired=true)
        @RuneAttribute(value="refusalAllowed", isRequired=true)
        public Boolean getRefusalAllowed() {
            return this.refusalAllowed;
        }

        @Override
        @RosettaAttribute(value="scheduled", isRequired=true)
        @RuneAttribute(value="scheduled", isRequired=true)
        public Boolean getScheduled() {
            return this.scheduled;
        }

        @Override
        @RosettaAttribute(value="pik", isRequired=true)
        @RuneAttribute(value="pik", isRequired=true)
        public Boolean getPik() {
            return this.pik;
        }

        @Override
        @RosettaAttribute(value="facilityCommitment", isRequired=true)
        @RuneAttribute(value="facilityCommitment", isRequired=true)
        public FacilityCommitment.FacilityCommitmentBuilder getFacilityCommitment() {
            return this.facilityCommitment;
        }

        @Override
        public FacilityCommitment.FacilityCommitmentBuilder getOrCreateFacilityCommitment() {
            FacilityCommitment.FacilityCommitmentBuilder result = this.facilityCommitment != null ? this.facilityCommitment : (this.facilityCommitment = FacilityCommitment.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="adjustment", isRequired=true)
        @RuneAttribute(value="adjustment", isRequired=true)
        public Adjustment.AdjustmentBuilder getAdjustment() {
            return this.adjustment;
        }

        @Override
        public Adjustment.AdjustmentBuilder getOrCreateAdjustment() {
            Adjustment.AdjustmentBuilder result = this.adjustment != null ? this.adjustment : (this.adjustment = Adjustment.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="commitmentSchedule")
        @RuneAttribute(value="commitmentSchedule")
        public CommitmentSchedule.CommitmentScheduleBuilder getCommitmentSchedule() {
            return this.commitmentSchedule;
        }

        @Override
        public CommitmentSchedule.CommitmentScheduleBuilder getOrCreateCommitmentSchedule() {
            CommitmentSchedule.CommitmentScheduleBuilder result = this.commitmentSchedule != null ? this.commitmentSchedule : (this.commitmentSchedule = CommitmentSchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public CommitmentAdjustmentBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public CommitmentAdjustmentBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public CommitmentAdjustmentBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public CommitmentAdjustmentBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public CommitmentAdjustmentBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public CommitmentAdjustmentBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public CommitmentAdjustmentBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessEventPartiesModel", isRequired=true)
        @RuneAttribute(value="businessEventPartiesModel", isRequired=true)
        public CommitmentAdjustmentBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel _businessEventPartiesModel) {
            this.businessEventPartiesModel = _businessEventPartiesModel == null ? null : _businessEventPartiesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public CommitmentAdjustmentBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="legalActionReference")
        @RuneAttribute(value="legalActionReference")
        public CommitmentAdjustmentBuilder setLegalActionReference(LoanLegalActionReference _legalActionReference) {
            this.legalActionReference = _legalActionReference == null ? null : _legalActionReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityReference", isRequired=true)
        @RuneAttribute(value="facilityReference", isRequired=true)
        public CommitmentAdjustmentBuilder setFacilityReference(FacilityReference _facilityReference) {
            this.facilityReference = _facilityReference == null ? null : _facilityReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="refusalAllowed", isRequired=true)
        @RuneAttribute(value="refusalAllowed", isRequired=true)
        public CommitmentAdjustmentBuilder setRefusalAllowed(Boolean _refusalAllowed) {
            this.refusalAllowed = _refusalAllowed == null ? null : _refusalAllowed;
            return this;
        }

        @Override
        @RosettaAttribute(value="scheduled", isRequired=true)
        @RuneAttribute(value="scheduled", isRequired=true)
        public CommitmentAdjustmentBuilder setScheduled(Boolean _scheduled) {
            this.scheduled = _scheduled == null ? null : _scheduled;
            return this;
        }

        @Override
        @RosettaAttribute(value="pik", isRequired=true)
        @RuneAttribute(value="pik", isRequired=true)
        public CommitmentAdjustmentBuilder setPik(Boolean _pik) {
            this.pik = _pik == null ? null : _pik;
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityCommitment", isRequired=true)
        @RuneAttribute(value="facilityCommitment", isRequired=true)
        public CommitmentAdjustmentBuilder setFacilityCommitment(FacilityCommitment _facilityCommitment) {
            this.facilityCommitment = _facilityCommitment == null ? null : _facilityCommitment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="adjustment", isRequired=true)
        @RuneAttribute(value="adjustment", isRequired=true)
        public CommitmentAdjustmentBuilder setAdjustment(Adjustment _adjustment) {
            this.adjustment = _adjustment == null ? null : _adjustment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="commitmentSchedule")
        @RuneAttribute(value="commitmentSchedule")
        public CommitmentAdjustmentBuilder setCommitmentSchedule(CommitmentSchedule _commitmentSchedule) {
            this.commitmentSchedule = _commitmentSchedule == null ? null : _commitmentSchedule.toBuilder();
            return this;
        }

        @Override
        public CommitmentAdjustment build() {
            return new CommitmentAdjustmentImpl(this);
        }

        @Override
        public CommitmentAdjustmentBuilder toBuilder() {
            return this;
        }

        @Override
        public CommitmentAdjustmentBuilder prune() {
            super.prune();
            if (this.facilityCommitment != null && !this.facilityCommitment.prune().hasData()) {
                this.facilityCommitment = null;
            }
            if (this.adjustment != null && !this.adjustment.prune().hasData()) {
                this.adjustment = null;
            }
            if (this.commitmentSchedule != null && !this.commitmentSchedule.prune().hasData()) {
                this.commitmentSchedule = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getRefusalAllowed() != null) {
                return true;
            }
            if (this.getScheduled() != null) {
                return true;
            }
            if (this.getPik() != null) {
                return true;
            }
            if (this.getFacilityCommitment() != null && this.getFacilityCommitment().hasData()) {
                return true;
            }
            if (this.getAdjustment() != null && this.getAdjustment().hasData()) {
                return true;
            }
            return this.getCommitmentSchedule() != null && this.getCommitmentSchedule().hasData();
        }

        @Override
        public CommitmentAdjustmentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CommitmentAdjustmentBuilder o = (CommitmentAdjustmentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFacilityCommitment(), (RosettaModelObjectBuilder)o.getFacilityCommitment(), this::setFacilityCommitment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAdjustment(), (RosettaModelObjectBuilder)o.getAdjustment(), this::setAdjustment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommitmentSchedule(), (RosettaModelObjectBuilder)o.getCommitmentSchedule(), this::setCommitmentSchedule);
            merger.mergeBasic((Object)this.getRefusalAllowed(), (Object)o.getRefusalAllowed(), this::setRefusalAllowed, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getScheduled(), (Object)o.getScheduled(), this::setScheduled, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPik(), (Object)o.getPik(), this::setPik, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommitmentAdjustment _that = (CommitmentAdjustment)this.getType().cast(o);
            if (!Objects.equals(this.refusalAllowed, _that.getRefusalAllowed())) {
                return false;
            }
            if (!Objects.equals(this.scheduled, _that.getScheduled())) {
                return false;
            }
            if (!Objects.equals(this.pik, _that.getPik())) {
                return false;
            }
            if (!Objects.equals(this.facilityCommitment, _that.getFacilityCommitment())) {
                return false;
            }
            if (!Objects.equals(this.adjustment, _that.getAdjustment())) {
                return false;
            }
            return Objects.equals(this.commitmentSchedule, _that.getCommitmentSchedule());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.refusalAllowed != null ? this.refusalAllowed.hashCode() : 0);
            _result = 31 * _result + (this.scheduled != null ? this.scheduled.hashCode() : 0);
            _result = 31 * _result + (this.pik != null ? this.pik.hashCode() : 0);
            _result = 31 * _result + (this.facilityCommitment != null ? this.facilityCommitment.hashCode() : 0);
            _result = 31 * _result + (this.adjustment != null ? this.adjustment.hashCode() : 0);
            _result = 31 * _result + (this.commitmentSchedule != null ? this.commitmentSchedule.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommitmentAdjustmentBuilder {refusalAllowed=" + this.refusalAllowed + ", scheduled=" + this.scheduled + ", pik=" + this.pik + ", facilityCommitment=" + String.valueOf(this.facilityCommitment) + ", adjustment=" + String.valueOf(this.adjustment) + ", commitmentSchedule=" + String.valueOf(this.commitmentSchedule) + "} " + super.toString();
        }
    }

    public static interface CommitmentAdjustmentBuilder
    extends CommitmentAdjustment,
    AbstractFacilityEvent.AbstractFacilityEventBuilder {
        public FacilityCommitment.FacilityCommitmentBuilder getOrCreateFacilityCommitment();

        @Override
        public FacilityCommitment.FacilityCommitmentBuilder getFacilityCommitment();

        public Adjustment.AdjustmentBuilder getOrCreateAdjustment();

        @Override
        public Adjustment.AdjustmentBuilder getAdjustment();

        public CommitmentSchedule.CommitmentScheduleBuilder getOrCreateCommitmentSchedule();

        @Override
        public CommitmentSchedule.CommitmentScheduleBuilder getCommitmentSchedule();

        @Override
        public CommitmentAdjustmentBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public CommitmentAdjustmentBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public CommitmentAdjustmentBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public CommitmentAdjustmentBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public CommitmentAdjustmentBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        @Override
        public CommitmentAdjustmentBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        @Override
        public CommitmentAdjustmentBuilder setComment(String var1);

        @Override
        public CommitmentAdjustmentBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel var1);

        @Override
        public CommitmentAdjustmentBuilder setEffectiveDate(ZonedDateTime var1);

        @Override
        public CommitmentAdjustmentBuilder setLegalActionReference(LoanLegalActionReference var1);

        @Override
        public CommitmentAdjustmentBuilder setFacilityReference(FacilityReference var1);

        public CommitmentAdjustmentBuilder setRefusalAllowed(Boolean var1);

        public CommitmentAdjustmentBuilder setScheduled(Boolean var1);

        public CommitmentAdjustmentBuilder setPik(Boolean var1);

        public CommitmentAdjustmentBuilder setFacilityCommitment(FacilityCommitment var1);

        public CommitmentAdjustmentBuilder setAdjustment(Adjustment var1);

        public CommitmentAdjustmentBuilder setCommitmentSchedule(CommitmentSchedule var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, (RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, (RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.BusinessEventPartiesModelBuilder.class, (RosettaModelObjectBuilder)this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.LoanLegalActionReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLegalActionReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.FacilityReferenceBuilder.class, (RosettaModelObjectBuilder)this.getFacilityReference(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("refusalAllowed"), Boolean.class, (Object)this.getRefusalAllowed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("scheduled"), Boolean.class, (Object)this.getScheduled(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("pik"), Boolean.class, (Object)this.getPik(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityCommitment"), processor, FacilityCommitment.FacilityCommitmentBuilder.class, this.getFacilityCommitment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("adjustment"), processor, Adjustment.AdjustmentBuilder.class, this.getAdjustment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commitmentSchedule"), processor, CommitmentSchedule.CommitmentScheduleBuilder.class, this.getCommitmentSchedule(), new AttributeMeta[0]);
        }

        @Override
        public CommitmentAdjustmentBuilder prune();
    }

    public static class CommitmentAdjustmentImpl
    extends AbstractFacilityEvent.AbstractFacilityEventImpl
    implements CommitmentAdjustment {
        private final Boolean refusalAllowed;
        private final Boolean scheduled;
        private final Boolean pik;
        private final FacilityCommitment facilityCommitment;
        private final Adjustment adjustment;
        private final CommitmentSchedule commitmentSchedule;

        protected CommitmentAdjustmentImpl(CommitmentAdjustmentBuilder builder) {
            super(builder);
            this.refusalAllowed = builder.getRefusalAllowed();
            this.scheduled = builder.getScheduled();
            this.pik = builder.getPik();
            this.facilityCommitment = Optional.ofNullable(builder.getFacilityCommitment()).map(f -> f.build()).orElse(null);
            this.adjustment = Optional.ofNullable(builder.getAdjustment()).map(f -> f.build()).orElse(null);
            this.commitmentSchedule = Optional.ofNullable(builder.getCommitmentSchedule()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="refusalAllowed", isRequired=true)
        @RuneAttribute(value="refusalAllowed", isRequired=true)
        public Boolean getRefusalAllowed() {
            return this.refusalAllowed;
        }

        @Override
        @RosettaAttribute(value="scheduled", isRequired=true)
        @RuneAttribute(value="scheduled", isRequired=true)
        public Boolean getScheduled() {
            return this.scheduled;
        }

        @Override
        @RosettaAttribute(value="pik", isRequired=true)
        @RuneAttribute(value="pik", isRequired=true)
        public Boolean getPik() {
            return this.pik;
        }

        @Override
        @RosettaAttribute(value="facilityCommitment", isRequired=true)
        @RuneAttribute(value="facilityCommitment", isRequired=true)
        public FacilityCommitment getFacilityCommitment() {
            return this.facilityCommitment;
        }

        @Override
        @RosettaAttribute(value="adjustment", isRequired=true)
        @RuneAttribute(value="adjustment", isRequired=true)
        public Adjustment getAdjustment() {
            return this.adjustment;
        }

        @Override
        @RosettaAttribute(value="commitmentSchedule")
        @RuneAttribute(value="commitmentSchedule")
        public CommitmentSchedule getCommitmentSchedule() {
            return this.commitmentSchedule;
        }

        @Override
        public CommitmentAdjustment build() {
            return this;
        }

        @Override
        public CommitmentAdjustmentBuilder toBuilder() {
            CommitmentAdjustmentBuilder builder = CommitmentAdjustment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommitmentAdjustmentBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getRefusalAllowed()).ifPresent(builder::setRefusalAllowed);
            Optional.ofNullable(this.getScheduled()).ifPresent(builder::setScheduled);
            Optional.ofNullable(this.getPik()).ifPresent(builder::setPik);
            Optional.ofNullable(this.getFacilityCommitment()).ifPresent(builder::setFacilityCommitment);
            Optional.ofNullable(this.getAdjustment()).ifPresent(builder::setAdjustment);
            Optional.ofNullable(this.getCommitmentSchedule()).ifPresent(builder::setCommitmentSchedule);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommitmentAdjustment _that = (CommitmentAdjustment)this.getType().cast(o);
            if (!Objects.equals(this.refusalAllowed, _that.getRefusalAllowed())) {
                return false;
            }
            if (!Objects.equals(this.scheduled, _that.getScheduled())) {
                return false;
            }
            if (!Objects.equals(this.pik, _that.getPik())) {
                return false;
            }
            if (!Objects.equals(this.facilityCommitment, _that.getFacilityCommitment())) {
                return false;
            }
            if (!Objects.equals(this.adjustment, _that.getAdjustment())) {
                return false;
            }
            return Objects.equals(this.commitmentSchedule, _that.getCommitmentSchedule());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.refusalAllowed != null ? this.refusalAllowed.hashCode() : 0);
            _result = 31 * _result + (this.scheduled != null ? this.scheduled.hashCode() : 0);
            _result = 31 * _result + (this.pik != null ? this.pik.hashCode() : 0);
            _result = 31 * _result + (this.facilityCommitment != null ? this.facilityCommitment.hashCode() : 0);
            _result = 31 * _result + (this.adjustment != null ? this.adjustment.hashCode() : 0);
            _result = 31 * _result + (this.commitmentSchedule != null ? this.commitmentSchedule.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommitmentAdjustment {refusalAllowed=" + this.refusalAllowed + ", scheduled=" + this.scheduled + ", pik=" + this.pik + ", facilityCommitment=" + String.valueOf(this.facilityCommitment) + ", adjustment=" + String.valueOf(this.adjustment) + ", commitmentSchedule=" + String.valueOf(this.commitmentSchedule) + "} " + super.toString();
        }
    }
}

