/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.loan.SimplePayerReceiverModel;
import fpml.consolidated.loan.TaxWithholding;
import fpml.consolidated.loan.meta.CashPayableMeta;
import fpml.consolidated.shared.NonNegativeMoney;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CashPayable", builder=CashPayableBuilderImpl.class, version="1.2.2")
@RuneDataType(value="CashPayable", model="fpml", builder=CashPayableBuilderImpl.class, version="1.2.2")
public interface CashPayable
extends RosettaModelObject {
    public static final CashPayableMeta metaData = new CashPayableMeta();

    public SimplePayerReceiverModel getSimplePayerReceiverModel();

    public NonNegativeMoney getNetAmount();

    public List<? extends TaxWithholding> getTaxWithholding();

    public CashPayable build();

    public CashPayableBuilder toBuilder();

    public static CashPayableBuilder builder() {
        return new CashPayableBuilderImpl();
    }

    default public RosettaMetaData<? extends CashPayable> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CashPayable> getType() {
        return CashPayable.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("simplePayerReceiverModel"), processor, SimplePayerReceiverModel.class, this.getSimplePayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("netAmount"), processor, NonNegativeMoney.class, this.getNetAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("taxWithholding"), processor, TaxWithholding.class, this.getTaxWithholding(), new AttributeMeta[0]);
    }

    public static class CashPayableBuilderImpl
    implements CashPayableBuilder {
        protected SimplePayerReceiverModel.SimplePayerReceiverModelBuilder simplePayerReceiverModel;
        protected NonNegativeMoney.NonNegativeMoneyBuilder netAmount;
        protected List<TaxWithholding.TaxWithholdingBuilder> taxWithholding = new ArrayList<TaxWithholding.TaxWithholdingBuilder>();

        @Override
        @RosettaAttribute(value="simplePayerReceiverModel", isRequired=true)
        @RuneAttribute(value="simplePayerReceiverModel", isRequired=true)
        public SimplePayerReceiverModel.SimplePayerReceiverModelBuilder getSimplePayerReceiverModel() {
            return this.simplePayerReceiverModel;
        }

        @Override
        public SimplePayerReceiverModel.SimplePayerReceiverModelBuilder getOrCreateSimplePayerReceiverModel() {
            SimplePayerReceiverModel.SimplePayerReceiverModelBuilder result = this.simplePayerReceiverModel != null ? this.simplePayerReceiverModel : (this.simplePayerReceiverModel = SimplePayerReceiverModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="netAmount", isRequired=true)
        @RuneAttribute(value="netAmount", isRequired=true)
        public NonNegativeMoney.NonNegativeMoneyBuilder getNetAmount() {
            return this.netAmount;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateNetAmount() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.netAmount != null ? this.netAmount : (this.netAmount = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="taxWithholding")
        @RuneAttribute(value="taxWithholding")
        public List<? extends TaxWithholding.TaxWithholdingBuilder> getTaxWithholding() {
            return this.taxWithholding;
        }

        @Override
        public TaxWithholding.TaxWithholdingBuilder getOrCreateTaxWithholding(int index) {
            if (this.taxWithholding == null) {
                this.taxWithholding = new ArrayList<TaxWithholding.TaxWithholdingBuilder>();
            }
            return (TaxWithholding.TaxWithholdingBuilder)this.getIndex(this.taxWithholding, index, () -> {
                TaxWithholding.TaxWithholdingBuilder newTaxWithholding = TaxWithholding.builder();
                return newTaxWithholding;
            });
        }

        @Override
        @RosettaAttribute(value="simplePayerReceiverModel", isRequired=true)
        @RuneAttribute(value="simplePayerReceiverModel", isRequired=true)
        public CashPayableBuilder setSimplePayerReceiverModel(SimplePayerReceiverModel _simplePayerReceiverModel) {
            this.simplePayerReceiverModel = _simplePayerReceiverModel == null ? null : _simplePayerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="netAmount", isRequired=true)
        @RuneAttribute(value="netAmount", isRequired=true)
        public CashPayableBuilder setNetAmount(NonNegativeMoney _netAmount) {
            this.netAmount = _netAmount == null ? null : _netAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="taxWithholding")
        @RuneAttribute(value="taxWithholding")
        public CashPayableBuilder addTaxWithholding(TaxWithholding _taxWithholding) {
            if (_taxWithholding != null) {
                this.taxWithholding.add(_taxWithholding.toBuilder());
            }
            return this;
        }

        @Override
        public CashPayableBuilder addTaxWithholding(TaxWithholding _taxWithholding, int idx) {
            this.getIndex(this.taxWithholding, idx, () -> _taxWithholding.toBuilder());
            return this;
        }

        @Override
        public CashPayableBuilder addTaxWithholding(List<? extends TaxWithholding> taxWithholdings) {
            if (taxWithholdings != null) {
                for (TaxWithholding taxWithholding : taxWithholdings) {
                    this.taxWithholding.add(taxWithholding.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="taxWithholding")
        public CashPayableBuilder setTaxWithholding(List<? extends TaxWithholding> taxWithholdings) {
            this.taxWithholding = taxWithholdings == null ? new ArrayList<TaxWithholding.TaxWithholdingBuilder>() : (List)taxWithholdings.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CashPayable build() {
            return new CashPayableImpl(this);
        }

        @Override
        public CashPayableBuilder toBuilder() {
            return this;
        }

        @Override
        public CashPayableBuilder prune() {
            if (this.simplePayerReceiverModel != null && !this.simplePayerReceiverModel.prune().hasData()) {
                this.simplePayerReceiverModel = null;
            }
            if (this.netAmount != null && !this.netAmount.prune().hasData()) {
                this.netAmount = null;
            }
            this.taxWithholding = this.taxWithholding.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getSimplePayerReceiverModel() != null && this.getSimplePayerReceiverModel().hasData()) {
                return true;
            }
            if (this.getNetAmount() != null && this.getNetAmount().hasData()) {
                return true;
            }
            return this.getTaxWithholding() != null && this.getTaxWithholding().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public CashPayableBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CashPayableBuilder o = (CashPayableBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSimplePayerReceiverModel(), (RosettaModelObjectBuilder)o.getSimplePayerReceiverModel(), this::setSimplePayerReceiverModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNetAmount(), (RosettaModelObjectBuilder)o.getNetAmount(), this::setNetAmount);
            merger.mergeRosetta(this.getTaxWithholding(), o.getTaxWithholding(), this::getOrCreateTaxWithholding);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CashPayable _that = this.getType().cast(o);
            if (!Objects.equals(this.simplePayerReceiverModel, _that.getSimplePayerReceiverModel())) {
                return false;
            }
            if (!Objects.equals(this.netAmount, _that.getNetAmount())) {
                return false;
            }
            return ListEquals.listEquals(this.taxWithholding, _that.getTaxWithholding());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.simplePayerReceiverModel != null ? this.simplePayerReceiverModel.hashCode() : 0);
            _result = 31 * _result + (this.netAmount != null ? this.netAmount.hashCode() : 0);
            _result = 31 * _result + (this.taxWithholding != null ? this.taxWithholding.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CashPayableBuilder {simplePayerReceiverModel=" + String.valueOf(this.simplePayerReceiverModel) + ", netAmount=" + String.valueOf(this.netAmount) + ", taxWithholding=" + String.valueOf(this.taxWithholding) + "}";
        }
    }

    public static interface CashPayableBuilder
    extends CashPayable,
    RosettaModelObjectBuilder {
        public SimplePayerReceiverModel.SimplePayerReceiverModelBuilder getOrCreateSimplePayerReceiverModel();

        @Override
        public SimplePayerReceiverModel.SimplePayerReceiverModelBuilder getSimplePayerReceiverModel();

        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateNetAmount();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getNetAmount();

        public TaxWithholding.TaxWithholdingBuilder getOrCreateTaxWithholding(int var1);

        public List<? extends TaxWithholding.TaxWithholdingBuilder> getTaxWithholding();

        public CashPayableBuilder setSimplePayerReceiverModel(SimplePayerReceiverModel var1);

        public CashPayableBuilder setNetAmount(NonNegativeMoney var1);

        public CashPayableBuilder addTaxWithholding(TaxWithholding var1);

        public CashPayableBuilder addTaxWithholding(TaxWithholding var1, int var2);

        public CashPayableBuilder addTaxWithholding(List<? extends TaxWithholding> var1);

        public CashPayableBuilder setTaxWithholding(List<? extends TaxWithholding> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("simplePayerReceiverModel"), processor, SimplePayerReceiverModel.SimplePayerReceiverModelBuilder.class, this.getSimplePayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("netAmount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getNetAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("taxWithholding"), processor, TaxWithholding.TaxWithholdingBuilder.class, this.getTaxWithholding(), new AttributeMeta[0]);
        }

        public CashPayableBuilder prune();
    }

    public static class CashPayableImpl
    implements CashPayable {
        private final SimplePayerReceiverModel simplePayerReceiverModel;
        private final NonNegativeMoney netAmount;
        private final List<? extends TaxWithholding> taxWithholding;

        protected CashPayableImpl(CashPayableBuilder builder) {
            this.simplePayerReceiverModel = Optional.ofNullable(builder.getSimplePayerReceiverModel()).map(f -> f.build()).orElse(null);
            this.netAmount = Optional.ofNullable(builder.getNetAmount()).map(f -> f.build()).orElse(null);
            this.taxWithholding = Optional.ofNullable(builder.getTaxWithholding()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="simplePayerReceiverModel", isRequired=true)
        @RuneAttribute(value="simplePayerReceiverModel", isRequired=true)
        public SimplePayerReceiverModel getSimplePayerReceiverModel() {
            return this.simplePayerReceiverModel;
        }

        @Override
        @RosettaAttribute(value="netAmount", isRequired=true)
        @RuneAttribute(value="netAmount", isRequired=true)
        public NonNegativeMoney getNetAmount() {
            return this.netAmount;
        }

        @Override
        @RosettaAttribute(value="taxWithholding")
        @RuneAttribute(value="taxWithholding")
        public List<? extends TaxWithholding> getTaxWithholding() {
            return this.taxWithholding;
        }

        @Override
        public CashPayable build() {
            return this;
        }

        @Override
        public CashPayableBuilder toBuilder() {
            CashPayableBuilder builder = CashPayable.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CashPayableBuilder builder) {
            Optional.ofNullable(this.getSimplePayerReceiverModel()).ifPresent(builder::setSimplePayerReceiverModel);
            Optional.ofNullable(this.getNetAmount()).ifPresent(builder::setNetAmount);
            Optional.ofNullable(this.getTaxWithholding()).ifPresent(builder::setTaxWithholding);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CashPayable _that = this.getType().cast(o);
            if (!Objects.equals(this.simplePayerReceiverModel, _that.getSimplePayerReceiverModel())) {
                return false;
            }
            if (!Objects.equals(this.netAmount, _that.getNetAmount())) {
                return false;
            }
            return ListEquals.listEquals(this.taxWithholding, _that.getTaxWithholding());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.simplePayerReceiverModel != null ? this.simplePayerReceiverModel.hashCode() : 0);
            _result = 31 * _result + (this.netAmount != null ? this.netAmount.hashCode() : 0);
            _result = 31 * _result + (this.taxWithholding != null ? this.taxWithholding.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CashPayable {simplePayerReceiverModel=" + String.valueOf(this.simplePayerReceiverModel) + ", netAmount=" + String.valueOf(this.netAmount) + ", taxWithholding=" + String.valueOf(this.taxWithholding) + "}";
        }
    }
}

