/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.loan.AbstractLoanEventSequence;
import fpml.consolidated.loan.AbstractLoanServicingEvent;
import fpml.consolidated.loan.BusinessEventPartiesModel;
import fpml.consolidated.loan.FacilityReference;
import fpml.consolidated.loan.LenderAndCashDetailsModel;
import fpml.consolidated.loan.LoanLegalActionReference;
import fpml.consolidated.loan.meta.AbstractFacilityEventMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AbstractFacilityEvent", builder=AbstractFacilityEventBuilderImpl.class, version="1.2.2")
@RuneDataType(value="AbstractFacilityEvent", model="fpml", builder=AbstractFacilityEventBuilderImpl.class, version="1.2.2")
public interface AbstractFacilityEvent
extends AbstractLoanServicingEvent {
    public static final AbstractFacilityEventMeta metaData = new AbstractFacilityEventMeta();

    public FacilityReference getFacilityReference();

    @Override
    public AbstractFacilityEvent build();

    @Override
    public AbstractFacilityEventBuilder toBuilder();

    public static AbstractFacilityEventBuilder builder() {
        return new AbstractFacilityEventBuilderImpl();
    }

    default public RosettaMetaData<? extends AbstractFacilityEvent> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AbstractFacilityEvent> getType() {
        return AbstractFacilityEvent.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.class, this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.class, this.getLegalActionReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.class, this.getFacilityReference(), new AttributeMeta[0]);
    }

    public static class AbstractFacilityEventBuilderImpl
    extends AbstractLoanServicingEvent.AbstractLoanServicingEventBuilderImpl
    implements AbstractFacilityEventBuilder {
        protected FacilityReference.FacilityReferenceBuilder facilityReference;

        @Override
        @RosettaAttribute(value="facilityReference", isRequired=true)
        @RuneAttribute(value="facilityReference", isRequired=true)
        public FacilityReference.FacilityReferenceBuilder getFacilityReference() {
            return this.facilityReference;
        }

        @Override
        public FacilityReference.FacilityReferenceBuilder getOrCreateFacilityReference() {
            FacilityReference.FacilityReferenceBuilder result = this.facilityReference != null ? this.facilityReference : (this.facilityReference = FacilityReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public AbstractFacilityEventBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public AbstractFacilityEventBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public AbstractFacilityEventBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public AbstractFacilityEventBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public AbstractFacilityEventBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public AbstractFacilityEventBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public AbstractFacilityEventBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessEventPartiesModel", isRequired=true)
        @RuneAttribute(value="businessEventPartiesModel", isRequired=true)
        public AbstractFacilityEventBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel _businessEventPartiesModel) {
            this.businessEventPartiesModel = _businessEventPartiesModel == null ? null : _businessEventPartiesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public AbstractFacilityEventBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="legalActionReference")
        @RuneAttribute(value="legalActionReference")
        public AbstractFacilityEventBuilder setLegalActionReference(LoanLegalActionReference _legalActionReference) {
            this.legalActionReference = _legalActionReference == null ? null : _legalActionReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityReference", isRequired=true)
        @RuneAttribute(value="facilityReference", isRequired=true)
        public AbstractFacilityEventBuilder setFacilityReference(FacilityReference _facilityReference) {
            this.facilityReference = _facilityReference == null ? null : _facilityReference.toBuilder();
            return this;
        }

        @Override
        public AbstractFacilityEvent build() {
            return new AbstractFacilityEventImpl(this);
        }

        @Override
        public AbstractFacilityEventBuilder toBuilder() {
            return this;
        }

        @Override
        public AbstractFacilityEventBuilder prune() {
            super.prune();
            if (this.facilityReference != null && !this.facilityReference.prune().hasData()) {
                this.facilityReference = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getFacilityReference() != null && this.getFacilityReference().hasData();
        }

        @Override
        public AbstractFacilityEventBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            AbstractFacilityEventBuilder o = (AbstractFacilityEventBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFacilityReference(), (RosettaModelObjectBuilder)o.getFacilityReference(), this::setFacilityReference);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractFacilityEvent _that = (AbstractFacilityEvent)this.getType().cast(o);
            return Objects.equals(this.facilityReference, _that.getFacilityReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.facilityReference != null ? this.facilityReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractFacilityEventBuilder {facilityReference=" + String.valueOf(this.facilityReference) + "} " + super.toString();
        }
    }

    public static interface AbstractFacilityEventBuilder
    extends AbstractFacilityEvent,
    AbstractLoanServicingEvent.AbstractLoanServicingEventBuilder {
        public FacilityReference.FacilityReferenceBuilder getOrCreateFacilityReference();

        @Override
        public FacilityReference.FacilityReferenceBuilder getFacilityReference();

        @Override
        public AbstractFacilityEventBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public AbstractFacilityEventBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public AbstractFacilityEventBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public AbstractFacilityEventBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public AbstractFacilityEventBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        @Override
        public AbstractFacilityEventBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        @Override
        public AbstractFacilityEventBuilder setComment(String var1);

        @Override
        public AbstractFacilityEventBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel var1);

        @Override
        public AbstractFacilityEventBuilder setEffectiveDate(ZonedDateTime var1);

        @Override
        public AbstractFacilityEventBuilder setLegalActionReference(LoanLegalActionReference var1);

        public AbstractFacilityEventBuilder setFacilityReference(FacilityReference var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, (RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, (RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.BusinessEventPartiesModelBuilder.class, (RosettaModelObjectBuilder)this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.LoanLegalActionReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLegalActionReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.FacilityReferenceBuilder.class, this.getFacilityReference(), new AttributeMeta[0]);
        }

        @Override
        public AbstractFacilityEventBuilder prune();
    }

    public static class AbstractFacilityEventImpl
    extends AbstractLoanServicingEvent.AbstractLoanServicingEventImpl
    implements AbstractFacilityEvent {
        private final FacilityReference facilityReference;

        protected AbstractFacilityEventImpl(AbstractFacilityEventBuilder builder) {
            super(builder);
            this.facilityReference = Optional.ofNullable(builder.getFacilityReference()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="facilityReference", isRequired=true)
        @RuneAttribute(value="facilityReference", isRequired=true)
        public FacilityReference getFacilityReference() {
            return this.facilityReference;
        }

        @Override
        public AbstractFacilityEvent build() {
            return this;
        }

        @Override
        public AbstractFacilityEventBuilder toBuilder() {
            AbstractFacilityEventBuilder builder = AbstractFacilityEvent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AbstractFacilityEventBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getFacilityReference()).ifPresent(builder::setFacilityReference);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractFacilityEvent _that = (AbstractFacilityEvent)this.getType().cast(o);
            return Objects.equals(this.facilityReference, _that.getFacilityReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.facilityReference != null ? this.facilityReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractFacilityEvent {facilityReference=" + String.valueOf(this.facilityReference) + "} " + super.toString();
        }
    }
}

