/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.loan.DealReference;
import fpml.consolidated.loan.FacilityCommitmentModel;
import fpml.consolidated.loan.FacilityDatesModel;
import fpml.consolidated.loan.FacilityFeaturesModel;
import fpml.consolidated.loan.FacilityOptionsFeesAndRatesModel;
import fpml.consolidated.loan.FacilityRolesModel;
import fpml.consolidated.loan.FacilitySummary;
import fpml.consolidated.loan.MultiCurrency;
import fpml.consolidated.loan.meta.AbstractFacilityMeta;
import fpml.consolidated.shared.GoverningLaw;
import fpml.consolidated.shared.InstrumentId;
import fpml.consolidated.shared.PartyReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AbstractFacility", builder=AbstractFacilityBuilderImpl.class, version="1.2.2")
@RuneDataType(value="AbstractFacility", model="fpml", builder=AbstractFacilityBuilderImpl.class, version="1.2.2")
public interface AbstractFacility
extends FacilitySummary {
    public static final AbstractFacilityMeta metaData = new AbstractFacilityMeta();

    public GoverningLaw getGoverningLaw();

    public FacilityFeaturesModel getFacilityFeaturesModel();

    public FacilityOptionsFeesAndRatesModel getFacilityOptionsFeesAndRatesModel();

    public MultiCurrency getMultiCurrency();

    @Override
    public AbstractFacility build();

    @Override
    public AbstractFacilityBuilder toBuilder();

    public static AbstractFacilityBuilder builder() {
        return new AbstractFacilityBuilderImpl();
    }

    default public RosettaMetaData<? extends AbstractFacility> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AbstractFacility> getType() {
        return AbstractFacility.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.class, this.getPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dealReference"), processor, DealReference.class, this.getDealReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityRolesModel"), processor, FacilityRolesModel.class, this.getFacilityRolesModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityDatesModel"), processor, FacilityDatesModel.class, this.getFacilityDatesModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityCommitmentModel"), processor, FacilityCommitmentModel.class, this.getFacilityCommitmentModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("governingLaw"), processor, GoverningLaw.class, this.getGoverningLaw(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityFeaturesModel"), processor, FacilityFeaturesModel.class, this.getFacilityFeaturesModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityOptionsFeesAndRatesModel"), processor, FacilityOptionsFeesAndRatesModel.class, this.getFacilityOptionsFeesAndRatesModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("multiCurrency"), processor, MultiCurrency.class, this.getMultiCurrency(), new AttributeMeta[0]);
    }

    public static class AbstractFacilityBuilderImpl
    extends FacilitySummary.FacilitySummaryBuilderImpl
    implements AbstractFacilityBuilder {
        protected GoverningLaw.GoverningLawBuilder governingLaw;
        protected FacilityFeaturesModel.FacilityFeaturesModelBuilder facilityFeaturesModel;
        protected FacilityOptionsFeesAndRatesModel.FacilityOptionsFeesAndRatesModelBuilder facilityOptionsFeesAndRatesModel;
        protected MultiCurrency.MultiCurrencyBuilder multiCurrency;

        @Override
        @RosettaAttribute(value="governingLaw")
        @RuneAttribute(value="governingLaw")
        public GoverningLaw.GoverningLawBuilder getGoverningLaw() {
            return this.governingLaw;
        }

        @Override
        public GoverningLaw.GoverningLawBuilder getOrCreateGoverningLaw() {
            GoverningLaw.GoverningLawBuilder result = this.governingLaw != null ? this.governingLaw : (this.governingLaw = GoverningLaw.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="facilityFeaturesModel", isRequired=true)
        @RuneAttribute(value="facilityFeaturesModel", isRequired=true)
        public FacilityFeaturesModel.FacilityFeaturesModelBuilder getFacilityFeaturesModel() {
            return this.facilityFeaturesModel;
        }

        @Override
        public FacilityFeaturesModel.FacilityFeaturesModelBuilder getOrCreateFacilityFeaturesModel() {
            FacilityFeaturesModel.FacilityFeaturesModelBuilder result = this.facilityFeaturesModel != null ? this.facilityFeaturesModel : (this.facilityFeaturesModel = FacilityFeaturesModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="facilityOptionsFeesAndRatesModel", isRequired=true)
        @RuneAttribute(value="facilityOptionsFeesAndRatesModel", isRequired=true)
        public FacilityOptionsFeesAndRatesModel.FacilityOptionsFeesAndRatesModelBuilder getFacilityOptionsFeesAndRatesModel() {
            return this.facilityOptionsFeesAndRatesModel;
        }

        @Override
        public FacilityOptionsFeesAndRatesModel.FacilityOptionsFeesAndRatesModelBuilder getOrCreateFacilityOptionsFeesAndRatesModel() {
            FacilityOptionsFeesAndRatesModel.FacilityOptionsFeesAndRatesModelBuilder result = this.facilityOptionsFeesAndRatesModel != null ? this.facilityOptionsFeesAndRatesModel : (this.facilityOptionsFeesAndRatesModel = FacilityOptionsFeesAndRatesModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="multiCurrency")
        @RuneAttribute(value="multiCurrency")
        public MultiCurrency.MultiCurrencyBuilder getMultiCurrency() {
            return this.multiCurrency;
        }

        @Override
        public MultiCurrency.MultiCurrencyBuilder getOrCreateMultiCurrency() {
            MultiCurrency.MultiCurrencyBuilder result = this.multiCurrency != null ? this.multiCurrency : (this.multiCurrency = MultiCurrency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public AbstractFacilityBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public AbstractFacilityBuilder setPartyReference(PartyReference _partyReference) {
            this.partyReference = _partyReference == null ? null : _partyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public AbstractFacilityBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public AbstractFacilityBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public AbstractFacilityBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public AbstractFacilityBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public AbstractFacilityBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        @RosettaAttribute(value="dealReference")
        @RuneAttribute(value="dealReference")
        public AbstractFacilityBuilder setDealReference(DealReference _dealReference) {
            this.dealReference = _dealReference == null ? null : _dealReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityRolesModel", isRequired=true)
        @RuneAttribute(value="facilityRolesModel", isRequired=true)
        public AbstractFacilityBuilder setFacilityRolesModel(FacilityRolesModel _facilityRolesModel) {
            this.facilityRolesModel = _facilityRolesModel == null ? null : _facilityRolesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityDatesModel", isRequired=true)
        @RuneAttribute(value="facilityDatesModel", isRequired=true)
        public AbstractFacilityBuilder setFacilityDatesModel(FacilityDatesModel _facilityDatesModel) {
            this.facilityDatesModel = _facilityDatesModel == null ? null : _facilityDatesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityCommitmentModel", isRequired=true)
        @RuneAttribute(value="facilityCommitmentModel", isRequired=true)
        public AbstractFacilityBuilder setFacilityCommitmentModel(FacilityCommitmentModel _facilityCommitmentModel) {
            this.facilityCommitmentModel = _facilityCommitmentModel == null ? null : _facilityCommitmentModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="governingLaw")
        @RuneAttribute(value="governingLaw")
        public AbstractFacilityBuilder setGoverningLaw(GoverningLaw _governingLaw) {
            this.governingLaw = _governingLaw == null ? null : _governingLaw.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityFeaturesModel", isRequired=true)
        @RuneAttribute(value="facilityFeaturesModel", isRequired=true)
        public AbstractFacilityBuilder setFacilityFeaturesModel(FacilityFeaturesModel _facilityFeaturesModel) {
            this.facilityFeaturesModel = _facilityFeaturesModel == null ? null : _facilityFeaturesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityOptionsFeesAndRatesModel", isRequired=true)
        @RuneAttribute(value="facilityOptionsFeesAndRatesModel", isRequired=true)
        public AbstractFacilityBuilder setFacilityOptionsFeesAndRatesModel(FacilityOptionsFeesAndRatesModel _facilityOptionsFeesAndRatesModel) {
            this.facilityOptionsFeesAndRatesModel = _facilityOptionsFeesAndRatesModel == null ? null : _facilityOptionsFeesAndRatesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="multiCurrency")
        @RuneAttribute(value="multiCurrency")
        public AbstractFacilityBuilder setMultiCurrency(MultiCurrency _multiCurrency) {
            this.multiCurrency = _multiCurrency == null ? null : _multiCurrency.toBuilder();
            return this;
        }

        @Override
        public AbstractFacility build() {
            return new AbstractFacilityImpl(this);
        }

        @Override
        public AbstractFacilityBuilder toBuilder() {
            return this;
        }

        @Override
        public AbstractFacilityBuilder prune() {
            super.prune();
            if (this.governingLaw != null && !this.governingLaw.prune().hasData()) {
                this.governingLaw = null;
            }
            if (this.facilityFeaturesModel != null && !this.facilityFeaturesModel.prune().hasData()) {
                this.facilityFeaturesModel = null;
            }
            if (this.facilityOptionsFeesAndRatesModel != null && !this.facilityOptionsFeesAndRatesModel.prune().hasData()) {
                this.facilityOptionsFeesAndRatesModel = null;
            }
            if (this.multiCurrency != null && !this.multiCurrency.prune().hasData()) {
                this.multiCurrency = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getGoverningLaw() != null && this.getGoverningLaw().hasData()) {
                return true;
            }
            if (this.getFacilityFeaturesModel() != null && this.getFacilityFeaturesModel().hasData()) {
                return true;
            }
            if (this.getFacilityOptionsFeesAndRatesModel() != null && this.getFacilityOptionsFeesAndRatesModel().hasData()) {
                return true;
            }
            return this.getMultiCurrency() != null && this.getMultiCurrency().hasData();
        }

        @Override
        public AbstractFacilityBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            AbstractFacilityBuilder o = (AbstractFacilityBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getGoverningLaw(), (RosettaModelObjectBuilder)o.getGoverningLaw(), this::setGoverningLaw);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFacilityFeaturesModel(), (RosettaModelObjectBuilder)o.getFacilityFeaturesModel(), this::setFacilityFeaturesModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFacilityOptionsFeesAndRatesModel(), (RosettaModelObjectBuilder)o.getFacilityOptionsFeesAndRatesModel(), this::setFacilityOptionsFeesAndRatesModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMultiCurrency(), (RosettaModelObjectBuilder)o.getMultiCurrency(), this::setMultiCurrency);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractFacility _that = (AbstractFacility)this.getType().cast(o);
            if (!Objects.equals(this.governingLaw, _that.getGoverningLaw())) {
                return false;
            }
            if (!Objects.equals(this.facilityFeaturesModel, _that.getFacilityFeaturesModel())) {
                return false;
            }
            if (!Objects.equals(this.facilityOptionsFeesAndRatesModel, _that.getFacilityOptionsFeesAndRatesModel())) {
                return false;
            }
            return Objects.equals(this.multiCurrency, _that.getMultiCurrency());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.governingLaw != null ? this.governingLaw.hashCode() : 0);
            _result = 31 * _result + (this.facilityFeaturesModel != null ? this.facilityFeaturesModel.hashCode() : 0);
            _result = 31 * _result + (this.facilityOptionsFeesAndRatesModel != null ? this.facilityOptionsFeesAndRatesModel.hashCode() : 0);
            _result = 31 * _result + (this.multiCurrency != null ? this.multiCurrency.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractFacilityBuilder {governingLaw=" + String.valueOf(this.governingLaw) + ", facilityFeaturesModel=" + String.valueOf(this.facilityFeaturesModel) + ", facilityOptionsFeesAndRatesModel=" + String.valueOf(this.facilityOptionsFeesAndRatesModel) + ", multiCurrency=" + String.valueOf(this.multiCurrency) + "} " + super.toString();
        }
    }

    public static interface AbstractFacilityBuilder
    extends AbstractFacility,
    FacilitySummary.FacilitySummaryBuilder {
        public GoverningLaw.GoverningLawBuilder getOrCreateGoverningLaw();

        @Override
        public GoverningLaw.GoverningLawBuilder getGoverningLaw();

        public FacilityFeaturesModel.FacilityFeaturesModelBuilder getOrCreateFacilityFeaturesModel();

        @Override
        public FacilityFeaturesModel.FacilityFeaturesModelBuilder getFacilityFeaturesModel();

        public FacilityOptionsFeesAndRatesModel.FacilityOptionsFeesAndRatesModelBuilder getOrCreateFacilityOptionsFeesAndRatesModel();

        @Override
        public FacilityOptionsFeesAndRatesModel.FacilityOptionsFeesAndRatesModelBuilder getFacilityOptionsFeesAndRatesModel();

        public MultiCurrency.MultiCurrencyBuilder getOrCreateMultiCurrency();

        @Override
        public MultiCurrency.MultiCurrencyBuilder getMultiCurrency();

        @Override
        public AbstractFacilityBuilder setId(String var1);

        @Override
        public AbstractFacilityBuilder setPartyReference(PartyReference var1);

        @Override
        public AbstractFacilityBuilder addInstrumentId(InstrumentId var1);

        @Override
        public AbstractFacilityBuilder addInstrumentId(InstrumentId var1, int var2);

        @Override
        public AbstractFacilityBuilder addInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public AbstractFacilityBuilder setInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public AbstractFacilityBuilder setDescription(String var1);

        @Override
        public AbstractFacilityBuilder setDealReference(DealReference var1);

        @Override
        public AbstractFacilityBuilder setFacilityRolesModel(FacilityRolesModel var1);

        @Override
        public AbstractFacilityBuilder setFacilityDatesModel(FacilityDatesModel var1);

        @Override
        public AbstractFacilityBuilder setFacilityCommitmentModel(FacilityCommitmentModel var1);

        public AbstractFacilityBuilder setGoverningLaw(GoverningLaw var1);

        public AbstractFacilityBuilder setFacilityFeaturesModel(FacilityFeaturesModel var1);

        public AbstractFacilityBuilder setFacilityOptionsFeesAndRatesModel(FacilityOptionsFeesAndRatesModel var1);

        public AbstractFacilityBuilder setMultiCurrency(MultiCurrency var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.PartyReferenceBuilder.class, (RosettaModelObjectBuilder)this.getPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dealReference"), processor, DealReference.DealReferenceBuilder.class, (RosettaModelObjectBuilder)this.getDealReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityRolesModel"), processor, FacilityRolesModel.FacilityRolesModelBuilder.class, (RosettaModelObjectBuilder)this.getFacilityRolesModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityDatesModel"), processor, FacilityDatesModel.FacilityDatesModelBuilder.class, (RosettaModelObjectBuilder)this.getFacilityDatesModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityCommitmentModel"), processor, FacilityCommitmentModel.FacilityCommitmentModelBuilder.class, (RosettaModelObjectBuilder)this.getFacilityCommitmentModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("governingLaw"), processor, GoverningLaw.GoverningLawBuilder.class, this.getGoverningLaw(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityFeaturesModel"), processor, FacilityFeaturesModel.FacilityFeaturesModelBuilder.class, this.getFacilityFeaturesModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityOptionsFeesAndRatesModel"), processor, FacilityOptionsFeesAndRatesModel.FacilityOptionsFeesAndRatesModelBuilder.class, this.getFacilityOptionsFeesAndRatesModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("multiCurrency"), processor, MultiCurrency.MultiCurrencyBuilder.class, this.getMultiCurrency(), new AttributeMeta[0]);
        }

        @Override
        public AbstractFacilityBuilder prune();
    }

    public static class AbstractFacilityImpl
    extends FacilitySummary.FacilitySummaryImpl
    implements AbstractFacility {
        private final GoverningLaw governingLaw;
        private final FacilityFeaturesModel facilityFeaturesModel;
        private final FacilityOptionsFeesAndRatesModel facilityOptionsFeesAndRatesModel;
        private final MultiCurrency multiCurrency;

        protected AbstractFacilityImpl(AbstractFacilityBuilder builder) {
            super(builder);
            this.governingLaw = Optional.ofNullable(builder.getGoverningLaw()).map(f -> f.build()).orElse(null);
            this.facilityFeaturesModel = Optional.ofNullable(builder.getFacilityFeaturesModel()).map(f -> f.build()).orElse(null);
            this.facilityOptionsFeesAndRatesModel = Optional.ofNullable(builder.getFacilityOptionsFeesAndRatesModel()).map(f -> f.build()).orElse(null);
            this.multiCurrency = Optional.ofNullable(builder.getMultiCurrency()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="governingLaw")
        @RuneAttribute(value="governingLaw")
        public GoverningLaw getGoverningLaw() {
            return this.governingLaw;
        }

        @Override
        @RosettaAttribute(value="facilityFeaturesModel", isRequired=true)
        @RuneAttribute(value="facilityFeaturesModel", isRequired=true)
        public FacilityFeaturesModel getFacilityFeaturesModel() {
            return this.facilityFeaturesModel;
        }

        @Override
        @RosettaAttribute(value="facilityOptionsFeesAndRatesModel", isRequired=true)
        @RuneAttribute(value="facilityOptionsFeesAndRatesModel", isRequired=true)
        public FacilityOptionsFeesAndRatesModel getFacilityOptionsFeesAndRatesModel() {
            return this.facilityOptionsFeesAndRatesModel;
        }

        @Override
        @RosettaAttribute(value="multiCurrency")
        @RuneAttribute(value="multiCurrency")
        public MultiCurrency getMultiCurrency() {
            return this.multiCurrency;
        }

        @Override
        public AbstractFacility build() {
            return this;
        }

        @Override
        public AbstractFacilityBuilder toBuilder() {
            AbstractFacilityBuilder builder = AbstractFacility.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AbstractFacilityBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getGoverningLaw()).ifPresent(builder::setGoverningLaw);
            Optional.ofNullable(this.getFacilityFeaturesModel()).ifPresent(builder::setFacilityFeaturesModel);
            Optional.ofNullable(this.getFacilityOptionsFeesAndRatesModel()).ifPresent(builder::setFacilityOptionsFeesAndRatesModel);
            Optional.ofNullable(this.getMultiCurrency()).ifPresent(builder::setMultiCurrency);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractFacility _that = (AbstractFacility)this.getType().cast(o);
            if (!Objects.equals(this.governingLaw, _that.getGoverningLaw())) {
                return false;
            }
            if (!Objects.equals(this.facilityFeaturesModel, _that.getFacilityFeaturesModel())) {
                return false;
            }
            if (!Objects.equals(this.facilityOptionsFeesAndRatesModel, _that.getFacilityOptionsFeesAndRatesModel())) {
                return false;
            }
            return Objects.equals(this.multiCurrency, _that.getMultiCurrency());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.governingLaw != null ? this.governingLaw.hashCode() : 0);
            _result = 31 * _result + (this.facilityFeaturesModel != null ? this.facilityFeaturesModel.hashCode() : 0);
            _result = 31 * _result + (this.facilityOptionsFeesAndRatesModel != null ? this.facilityOptionsFeesAndRatesModel.hashCode() : 0);
            _result = 31 * _result + (this.multiCurrency != null ? this.multiCurrency.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractFacility {governingLaw=" + String.valueOf(this.governingLaw) + ", facilityFeaturesModel=" + String.valueOf(this.facilityFeaturesModel) + ", facilityOptionsFeesAndRatesModel=" + String.valueOf(this.facilityOptionsFeesAndRatesModel) + ", multiCurrency=" + String.valueOf(this.multiCurrency) + "} " + super.toString();
        }
    }
}

