/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.ird;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.ird.meta.ExercisePeriodMeta;
import fpml.consolidated.shared.Period;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ExercisePeriod", builder=ExercisePeriodBuilderImpl.class, version="1.2.2")
@RuneDataType(value="ExercisePeriod", model="fpml", builder=ExercisePeriodBuilderImpl.class, version="1.2.2")
public interface ExercisePeriod
extends RosettaModelObject {
    public static final ExercisePeriodMeta metaData = new ExercisePeriodMeta();

    public Period getEarliestExerciseDateTenor();

    public Period getExerciseFrequency();

    public String getId();

    public ExercisePeriod build();

    public ExercisePeriodBuilder toBuilder();

    public static ExercisePeriodBuilder builder() {
        return new ExercisePeriodBuilderImpl();
    }

    default public RosettaMetaData<? extends ExercisePeriod> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ExercisePeriod> getType() {
        return ExercisePeriod.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("earliestExerciseDateTenor"), processor, Period.class, this.getEarliestExerciseDateTenor(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exerciseFrequency"), processor, Period.class, this.getExerciseFrequency(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ExercisePeriodBuilderImpl
    implements ExercisePeriodBuilder {
        protected Period.PeriodBuilder earliestExerciseDateTenor;
        protected Period.PeriodBuilder exerciseFrequency;
        protected String id;

        @Override
        @RosettaAttribute(value="earliestExerciseDateTenor")
        @RuneAttribute(value="earliestExerciseDateTenor")
        public Period.PeriodBuilder getEarliestExerciseDateTenor() {
            return this.earliestExerciseDateTenor;
        }

        @Override
        public Period.PeriodBuilder getOrCreateEarliestExerciseDateTenor() {
            Period.PeriodBuilder result = this.earliestExerciseDateTenor != null ? this.earliestExerciseDateTenor : (this.earliestExerciseDateTenor = Period.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exerciseFrequency")
        @RuneAttribute(value="exerciseFrequency")
        public Period.PeriodBuilder getExerciseFrequency() {
            return this.exerciseFrequency;
        }

        @Override
        public Period.PeriodBuilder getOrCreateExerciseFrequency() {
            Period.PeriodBuilder result = this.exerciseFrequency != null ? this.exerciseFrequency : (this.exerciseFrequency = Period.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="earliestExerciseDateTenor")
        @RuneAttribute(value="earliestExerciseDateTenor")
        public ExercisePeriodBuilder setEarliestExerciseDateTenor(Period _earliestExerciseDateTenor) {
            this.earliestExerciseDateTenor = _earliestExerciseDateTenor == null ? null : _earliestExerciseDateTenor.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseFrequency")
        @RuneAttribute(value="exerciseFrequency")
        public ExercisePeriodBuilder setExerciseFrequency(Period _exerciseFrequency) {
            this.exerciseFrequency = _exerciseFrequency == null ? null : _exerciseFrequency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public ExercisePeriodBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public ExercisePeriod build() {
            return new ExercisePeriodImpl(this);
        }

        @Override
        public ExercisePeriodBuilder toBuilder() {
            return this;
        }

        @Override
        public ExercisePeriodBuilder prune() {
            if (this.earliestExerciseDateTenor != null && !this.earliestExerciseDateTenor.prune().hasData()) {
                this.earliestExerciseDateTenor = null;
            }
            if (this.exerciseFrequency != null && !this.exerciseFrequency.prune().hasData()) {
                this.exerciseFrequency = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getEarliestExerciseDateTenor() != null && this.getEarliestExerciseDateTenor().hasData()) {
                return true;
            }
            if (this.getExerciseFrequency() != null && this.getExerciseFrequency().hasData()) {
                return true;
            }
            return this.getId() != null;
        }

        public ExercisePeriodBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ExercisePeriodBuilder o = (ExercisePeriodBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEarliestExerciseDateTenor(), (RosettaModelObjectBuilder)o.getEarliestExerciseDateTenor(), this::setEarliestExerciseDateTenor);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExerciseFrequency(), (RosettaModelObjectBuilder)o.getExerciseFrequency(), this::setExerciseFrequency);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ExercisePeriod _that = this.getType().cast(o);
            if (!Objects.equals(this.earliestExerciseDateTenor, _that.getEarliestExerciseDateTenor())) {
                return false;
            }
            if (!Objects.equals(this.exerciseFrequency, _that.getExerciseFrequency())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.earliestExerciseDateTenor != null ? this.earliestExerciseDateTenor.hashCode() : 0);
            _result = 31 * _result + (this.exerciseFrequency != null ? this.exerciseFrequency.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExercisePeriodBuilder {earliestExerciseDateTenor=" + String.valueOf(this.earliestExerciseDateTenor) + ", exerciseFrequency=" + String.valueOf(this.exerciseFrequency) + ", id=" + this.id + "}";
        }
    }

    public static interface ExercisePeriodBuilder
    extends ExercisePeriod,
    RosettaModelObjectBuilder {
        public Period.PeriodBuilder getOrCreateEarliestExerciseDateTenor();

        @Override
        public Period.PeriodBuilder getEarliestExerciseDateTenor();

        public Period.PeriodBuilder getOrCreateExerciseFrequency();

        @Override
        public Period.PeriodBuilder getExerciseFrequency();

        public ExercisePeriodBuilder setEarliestExerciseDateTenor(Period var1);

        public ExercisePeriodBuilder setExerciseFrequency(Period var1);

        public ExercisePeriodBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("earliestExerciseDateTenor"), processor, Period.PeriodBuilder.class, this.getEarliestExerciseDateTenor(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exerciseFrequency"), processor, Period.PeriodBuilder.class, this.getExerciseFrequency(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public ExercisePeriodBuilder prune();
    }

    public static class ExercisePeriodImpl
    implements ExercisePeriod {
        private final Period earliestExerciseDateTenor;
        private final Period exerciseFrequency;
        private final String id;

        protected ExercisePeriodImpl(ExercisePeriodBuilder builder) {
            this.earliestExerciseDateTenor = Optional.ofNullable(builder.getEarliestExerciseDateTenor()).map(f -> f.build()).orElse(null);
            this.exerciseFrequency = Optional.ofNullable(builder.getExerciseFrequency()).map(f -> f.build()).orElse(null);
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="earliestExerciseDateTenor")
        @RuneAttribute(value="earliestExerciseDateTenor")
        public Period getEarliestExerciseDateTenor() {
            return this.earliestExerciseDateTenor;
        }

        @Override
        @RosettaAttribute(value="exerciseFrequency")
        @RuneAttribute(value="exerciseFrequency")
        public Period getExerciseFrequency() {
            return this.exerciseFrequency;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public ExercisePeriod build() {
            return this;
        }

        @Override
        public ExercisePeriodBuilder toBuilder() {
            ExercisePeriodBuilder builder = ExercisePeriod.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ExercisePeriodBuilder builder) {
            Optional.ofNullable(this.getEarliestExerciseDateTenor()).ifPresent(builder::setEarliestExerciseDateTenor);
            Optional.ofNullable(this.getExerciseFrequency()).ifPresent(builder::setExerciseFrequency);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ExercisePeriod _that = this.getType().cast(o);
            if (!Objects.equals(this.earliestExerciseDateTenor, _that.getEarliestExerciseDateTenor())) {
                return false;
            }
            if (!Objects.equals(this.exerciseFrequency, _that.getExerciseFrequency())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.earliestExerciseDateTenor != null ? this.earliestExerciseDateTenor.hashCode() : 0);
            _result = 31 * _result + (this.exerciseFrequency != null ? this.exerciseFrequency.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExercisePeriod {earliestExerciseDateTenor=" + String.valueOf(this.earliestExerciseDateTenor) + ", exerciseFrequency=" + String.valueOf(this.exerciseFrequency) + ", id=" + this.id + "}";
        }
    }
}

