/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx.targets;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.fpmlenum.ConditionEnum;
import fpml.consolidated.fpmlenum.FxSettlementAdjustmentMethodEnum;
import fpml.consolidated.fx.targets.meta.FxPayoffCapMeta;
import fpml.consolidated.shared.Schedule;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="FxPayoffCap", builder=FxPayoffCapBuilderImpl.class, version="1.2.2")
@RuneDataType(value="FxPayoffCap", model="fpml", builder=FxPayoffCapBuilderImpl.class, version="1.2.2")
public interface FxPayoffCap
extends RosettaModelObject {
    public static final FxPayoffCapMeta metaData = new FxPayoffCapMeta();

    public ConditionEnum getCondition();

    public Schedule getRate();

    public FxSettlementAdjustmentMethodEnum getSettlementAdjustmentStyle();

    public FxPayoffCap build();

    public FxPayoffCapBuilder toBuilder();

    public static FxPayoffCapBuilder builder() {
        return new FxPayoffCapBuilderImpl();
    }

    default public RosettaMetaData<? extends FxPayoffCap> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxPayoffCap> getType() {
        return FxPayoffCap.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("condition"), ConditionEnum.class, (Object)this.getCondition(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rate"), processor, Schedule.class, this.getRate(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementAdjustmentStyle"), FxSettlementAdjustmentMethodEnum.class, (Object)this.getSettlementAdjustmentStyle(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class FxPayoffCapBuilderImpl
    implements FxPayoffCapBuilder {
        protected ConditionEnum condition;
        protected Schedule.ScheduleBuilder rate;
        protected FxSettlementAdjustmentMethodEnum settlementAdjustmentStyle;

        @Override
        @RosettaAttribute(value="condition", isRequired=true)
        @RuneAttribute(value="condition", isRequired=true)
        public ConditionEnum getCondition() {
            return this.condition;
        }

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public Schedule.ScheduleBuilder getRate() {
            return this.rate;
        }

        @Override
        public Schedule.ScheduleBuilder getOrCreateRate() {
            Schedule.ScheduleBuilder result = this.rate != null ? this.rate : (this.rate = Schedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementAdjustmentStyle", isRequired=true)
        @RuneAttribute(value="settlementAdjustmentStyle", isRequired=true)
        public FxSettlementAdjustmentMethodEnum getSettlementAdjustmentStyle() {
            return this.settlementAdjustmentStyle;
        }

        @Override
        @RosettaAttribute(value="condition", isRequired=true)
        @RuneAttribute(value="condition", isRequired=true)
        public FxPayoffCapBuilder setCondition(ConditionEnum _condition) {
            this.condition = _condition == null ? null : _condition;
            return this;
        }

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public FxPayoffCapBuilder setRate(Schedule _rate) {
            this.rate = _rate == null ? null : _rate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementAdjustmentStyle", isRequired=true)
        @RuneAttribute(value="settlementAdjustmentStyle", isRequired=true)
        public FxPayoffCapBuilder setSettlementAdjustmentStyle(FxSettlementAdjustmentMethodEnum _settlementAdjustmentStyle) {
            this.settlementAdjustmentStyle = _settlementAdjustmentStyle == null ? null : _settlementAdjustmentStyle;
            return this;
        }

        @Override
        public FxPayoffCap build() {
            return new FxPayoffCapImpl(this);
        }

        @Override
        public FxPayoffCapBuilder toBuilder() {
            return this;
        }

        @Override
        public FxPayoffCapBuilder prune() {
            if (this.rate != null && !this.rate.prune().hasData()) {
                this.rate = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCondition() != null) {
                return true;
            }
            if (this.getRate() != null && this.getRate().hasData()) {
                return true;
            }
            return this.getSettlementAdjustmentStyle() != null;
        }

        public FxPayoffCapBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FxPayoffCapBuilder o = (FxPayoffCapBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRate(), (RosettaModelObjectBuilder)o.getRate(), this::setRate);
            merger.mergeBasic((Object)this.getCondition(), (Object)o.getCondition(), this::setCondition, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSettlementAdjustmentStyle(), (Object)o.getSettlementAdjustmentStyle(), this::setSettlementAdjustmentStyle, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxPayoffCap _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.condition, (Object)_that.getCondition())) {
                return false;
            }
            if (!Objects.equals(this.rate, _that.getRate())) {
                return false;
            }
            return Objects.equals((Object)this.settlementAdjustmentStyle, (Object)_that.getSettlementAdjustmentStyle());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.condition != null ? ((Object)((Object)this.condition)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.rate != null ? this.rate.hashCode() : 0);
            _result = 31 * _result + (this.settlementAdjustmentStyle != null ? ((Object)((Object)this.settlementAdjustmentStyle)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxPayoffCapBuilder {condition=" + String.valueOf((Object)this.condition) + ", rate=" + String.valueOf(this.rate) + ", settlementAdjustmentStyle=" + String.valueOf((Object)this.settlementAdjustmentStyle) + "}";
        }
    }

    public static interface FxPayoffCapBuilder
    extends FxPayoffCap,
    RosettaModelObjectBuilder {
        public Schedule.ScheduleBuilder getOrCreateRate();

        @Override
        public Schedule.ScheduleBuilder getRate();

        public FxPayoffCapBuilder setCondition(ConditionEnum var1);

        public FxPayoffCapBuilder setRate(Schedule var1);

        public FxPayoffCapBuilder setSettlementAdjustmentStyle(FxSettlementAdjustmentMethodEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("condition"), ConditionEnum.class, (Object)this.getCondition(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rate"), processor, Schedule.ScheduleBuilder.class, this.getRate(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementAdjustmentStyle"), FxSettlementAdjustmentMethodEnum.class, (Object)this.getSettlementAdjustmentStyle(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public FxPayoffCapBuilder prune();
    }

    public static class FxPayoffCapImpl
    implements FxPayoffCap {
        private final ConditionEnum condition;
        private final Schedule rate;
        private final FxSettlementAdjustmentMethodEnum settlementAdjustmentStyle;

        protected FxPayoffCapImpl(FxPayoffCapBuilder builder) {
            this.condition = builder.getCondition();
            this.rate = Optional.ofNullable(builder.getRate()).map(f -> f.build()).orElse(null);
            this.settlementAdjustmentStyle = builder.getSettlementAdjustmentStyle();
        }

        @Override
        @RosettaAttribute(value="condition", isRequired=true)
        @RuneAttribute(value="condition", isRequired=true)
        public ConditionEnum getCondition() {
            return this.condition;
        }

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public Schedule getRate() {
            return this.rate;
        }

        @Override
        @RosettaAttribute(value="settlementAdjustmentStyle", isRequired=true)
        @RuneAttribute(value="settlementAdjustmentStyle", isRequired=true)
        public FxSettlementAdjustmentMethodEnum getSettlementAdjustmentStyle() {
            return this.settlementAdjustmentStyle;
        }

        @Override
        public FxPayoffCap build() {
            return this;
        }

        @Override
        public FxPayoffCapBuilder toBuilder() {
            FxPayoffCapBuilder builder = FxPayoffCap.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxPayoffCapBuilder builder) {
            Optional.ofNullable(this.getCondition()).ifPresent(builder::setCondition);
            Optional.ofNullable(this.getRate()).ifPresent(builder::setRate);
            Optional.ofNullable(this.getSettlementAdjustmentStyle()).ifPresent(builder::setSettlementAdjustmentStyle);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxPayoffCap _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.condition, (Object)_that.getCondition())) {
                return false;
            }
            if (!Objects.equals(this.rate, _that.getRate())) {
                return false;
            }
            return Objects.equals((Object)this.settlementAdjustmentStyle, (Object)_that.getSettlementAdjustmentStyle());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.condition != null ? ((Object)((Object)this.condition)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.rate != null ? this.rate.hashCode() : 0);
            _result = 31 * _result + (this.settlementAdjustmentStyle != null ? ((Object)((Object)this.settlementAdjustmentStyle)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxPayoffCap {condition=" + String.valueOf((Object)this.condition) + ", rate=" + String.valueOf(this.rate) + ", settlementAdjustmentStyle=" + String.valueOf((Object)this.settlementAdjustmentStyle) + "}";
        }
    }
}

