/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx.accruals;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.fx.accruals.meta.FxFixingScheduleSequence0Meta;
import fpml.consolidated.shared.BusinessDayAdjustments;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FxFixingScheduleSequence0", builder=FxFixingScheduleSequence0BuilderImpl.class, version="1.2.2")
@RuneDataType(value="FxFixingScheduleSequence0", model="fpml", builder=FxFixingScheduleSequence0BuilderImpl.class, version="1.2.2")
public interface FxFixingScheduleSequence0
extends RosettaModelObject {
    public static final FxFixingScheduleSequence0Meta metaData = new FxFixingScheduleSequence0Meta();

    public BusinessDayAdjustments getDateAdjustments();

    public List<ZonedDateTime> getFixingDate();

    public FxFixingScheduleSequence0 build();

    public FxFixingScheduleSequence0Builder toBuilder();

    public static FxFixingScheduleSequence0Builder builder() {
        return new FxFixingScheduleSequence0BuilderImpl();
    }

    default public RosettaMetaData<? extends FxFixingScheduleSequence0> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxFixingScheduleSequence0> getType() {
        return FxFixingScheduleSequence0.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("dateAdjustments"), processor, BusinessDayAdjustments.class, this.getDateAdjustments(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixingDate"), ZonedDateTime.class, this.getFixingDate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class FxFixingScheduleSequence0BuilderImpl
    implements FxFixingScheduleSequence0Builder {
        protected BusinessDayAdjustments.BusinessDayAdjustmentsBuilder dateAdjustments;
        protected List<ZonedDateTime> fixingDate = new ArrayList<ZonedDateTime>();

        @Override
        @RosettaAttribute(value="dateAdjustments")
        @RuneAttribute(value="dateAdjustments")
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getDateAdjustments() {
            return this.dateAdjustments;
        }

        @Override
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getOrCreateDateAdjustments() {
            BusinessDayAdjustments.BusinessDayAdjustmentsBuilder result = this.dateAdjustments != null ? this.dateAdjustments : (this.dateAdjustments = BusinessDayAdjustments.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fixingDate")
        @RuneAttribute(value="fixingDate")
        public List<ZonedDateTime> getFixingDate() {
            return this.fixingDate;
        }

        @Override
        @RosettaAttribute(value="dateAdjustments")
        @RuneAttribute(value="dateAdjustments")
        public FxFixingScheduleSequence0Builder setDateAdjustments(BusinessDayAdjustments _dateAdjustments) {
            this.dateAdjustments = _dateAdjustments == null ? null : _dateAdjustments.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixingDate")
        @RuneAttribute(value="fixingDate")
        public FxFixingScheduleSequence0Builder addFixingDate(ZonedDateTime _fixingDate) {
            if (_fixingDate != null) {
                this.fixingDate.add(_fixingDate);
            }
            return this;
        }

        @Override
        public FxFixingScheduleSequence0Builder addFixingDate(ZonedDateTime _fixingDate, int idx) {
            this.getIndex(this.fixingDate, idx, () -> _fixingDate);
            return this;
        }

        @Override
        public FxFixingScheduleSequence0Builder addFixingDate(List<ZonedDateTime> fixingDates) {
            if (fixingDates != null) {
                for (ZonedDateTime toAdd : fixingDates) {
                    this.fixingDate.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="fixingDate")
        public FxFixingScheduleSequence0Builder setFixingDate(List<ZonedDateTime> fixingDates) {
            this.fixingDate = fixingDates == null ? new ArrayList<ZonedDateTime>() : (List)fixingDates.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public FxFixingScheduleSequence0 build() {
            return new FxFixingScheduleSequence0Impl(this);
        }

        @Override
        public FxFixingScheduleSequence0Builder toBuilder() {
            return this;
        }

        @Override
        public FxFixingScheduleSequence0Builder prune() {
            if (this.dateAdjustments != null && !this.dateAdjustments.prune().hasData()) {
                this.dateAdjustments = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getDateAdjustments() != null && this.getDateAdjustments().hasData()) {
                return true;
            }
            return this.getFixingDate() != null && !this.getFixingDate().isEmpty();
        }

        public FxFixingScheduleSequence0Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FxFixingScheduleSequence0Builder o = (FxFixingScheduleSequence0Builder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDateAdjustments(), (RosettaModelObjectBuilder)o.getDateAdjustments(), this::setDateAdjustments);
            merger.mergeBasic(this.getFixingDate(), o.getFixingDate(), this::addFixingDate);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxFixingScheduleSequence0 _that = this.getType().cast(o);
            if (!Objects.equals(this.dateAdjustments, _that.getDateAdjustments())) {
                return false;
            }
            return ListEquals.listEquals(this.fixingDate, _that.getFixingDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dateAdjustments != null ? this.dateAdjustments.hashCode() : 0);
            _result = 31 * _result + (this.fixingDate != null ? this.fixingDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxFixingScheduleSequence0Builder {dateAdjustments=" + String.valueOf(this.dateAdjustments) + ", fixingDate=" + String.valueOf(this.fixingDate) + "}";
        }
    }

    public static interface FxFixingScheduleSequence0Builder
    extends FxFixingScheduleSequence0,
    RosettaModelObjectBuilder {
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getOrCreateDateAdjustments();

        @Override
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getDateAdjustments();

        public FxFixingScheduleSequence0Builder setDateAdjustments(BusinessDayAdjustments var1);

        public FxFixingScheduleSequence0Builder addFixingDate(ZonedDateTime var1);

        public FxFixingScheduleSequence0Builder addFixingDate(ZonedDateTime var1, int var2);

        public FxFixingScheduleSequence0Builder addFixingDate(List<ZonedDateTime> var1);

        public FxFixingScheduleSequence0Builder setFixingDate(List<ZonedDateTime> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("dateAdjustments"), processor, BusinessDayAdjustments.BusinessDayAdjustmentsBuilder.class, this.getDateAdjustments(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixingDate"), ZonedDateTime.class, this.getFixingDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public FxFixingScheduleSequence0Builder prune();
    }

    public static class FxFixingScheduleSequence0Impl
    implements FxFixingScheduleSequence0 {
        private final BusinessDayAdjustments dateAdjustments;
        private final List<ZonedDateTime> fixingDate;

        protected FxFixingScheduleSequence0Impl(FxFixingScheduleSequence0Builder builder) {
            this.dateAdjustments = Optional.ofNullable(builder.getDateAdjustments()).map(f -> f.build()).orElse(null);
            this.fixingDate = Optional.ofNullable(builder.getFixingDate()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
        }

        @Override
        @RosettaAttribute(value="dateAdjustments")
        @RuneAttribute(value="dateAdjustments")
        public BusinessDayAdjustments getDateAdjustments() {
            return this.dateAdjustments;
        }

        @Override
        @RosettaAttribute(value="fixingDate")
        @RuneAttribute(value="fixingDate")
        public List<ZonedDateTime> getFixingDate() {
            return this.fixingDate;
        }

        @Override
        public FxFixingScheduleSequence0 build() {
            return this;
        }

        @Override
        public FxFixingScheduleSequence0Builder toBuilder() {
            FxFixingScheduleSequence0Builder builder = FxFixingScheduleSequence0.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxFixingScheduleSequence0Builder builder) {
            Optional.ofNullable(this.getDateAdjustments()).ifPresent(builder::setDateAdjustments);
            Optional.ofNullable(this.getFixingDate()).ifPresent(builder::setFixingDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxFixingScheduleSequence0 _that = this.getType().cast(o);
            if (!Objects.equals(this.dateAdjustments, _that.getDateAdjustments())) {
                return false;
            }
            return ListEquals.listEquals(this.fixingDate, _that.getFixingDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dateAdjustments != null ? this.dateAdjustments.hashCode() : 0);
            _result = 31 * _result + (this.fixingDate != null ? this.fixingDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxFixingScheduleSequence0 {dateAdjustments=" + String.valueOf(this.dateAdjustments) + ", fixingDate=" + String.valueOf(this.fixingDate) + "}";
        }
    }
}

