/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.fpmlenum.FxBarrierDirectionEnum;
import fpml.consolidated.fpmlenum.FxBarrierTypeEnum;
import fpml.consolidated.fx.FxBarrierFeatureSequence;
import fpml.consolidated.fx.FxBusinessCenterDateTime;
import fpml.consolidated.fx.meta.FxBarrierFeatureMeta;
import fpml.consolidated.shared.InformationSource;
import fpml.consolidated.shared.QuotedCurrencyPair;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FxBarrierFeature", builder=FxBarrierFeatureBuilderImpl.class, version="1.2.2")
@RuneDataType(value="FxBarrierFeature", model="fpml", builder=FxBarrierFeatureBuilderImpl.class, version="1.2.2")
public interface FxBarrierFeature
extends RosettaModelObject {
    public static final FxBarrierFeatureMeta metaData = new FxBarrierFeatureMeta();

    public FxBarrierTypeEnum getBarrierType();

    public FxBarrierDirectionEnum getDirection();

    public QuotedCurrencyPair getQuotedCurrencyPair();

    public BigDecimal getTriggerRate();

    public List<? extends InformationSource> getInformationSource();

    public FxBarrierFeatureSequence getFxBarrierFeatureSequence();

    public List<? extends FxBusinessCenterDateTime> getObservationPoint();

    public FxBarrierFeature build();

    public FxBarrierFeatureBuilder toBuilder();

    public static FxBarrierFeatureBuilder builder() {
        return new FxBarrierFeatureBuilderImpl();
    }

    default public RosettaMetaData<? extends FxBarrierFeature> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxBarrierFeature> getType() {
        return FxBarrierFeature.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("barrierType"), FxBarrierTypeEnum.class, (Object)this.getBarrierType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("direction"), FxBarrierDirectionEnum.class, (Object)this.getDirection(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.class, this.getQuotedCurrencyPair(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("triggerRate"), BigDecimal.class, (Object)this.getTriggerRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("informationSource"), processor, InformationSource.class, this.getInformationSource(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxBarrierFeatureSequence"), processor, FxBarrierFeatureSequence.class, this.getFxBarrierFeatureSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("observationPoint"), processor, FxBusinessCenterDateTime.class, this.getObservationPoint(), new AttributeMeta[0]);
    }

    public static class FxBarrierFeatureBuilderImpl
    implements FxBarrierFeatureBuilder {
        protected FxBarrierTypeEnum barrierType;
        protected FxBarrierDirectionEnum direction;
        protected QuotedCurrencyPair.QuotedCurrencyPairBuilder quotedCurrencyPair;
        protected BigDecimal triggerRate;
        protected List<InformationSource.InformationSourceBuilder> informationSource = new ArrayList<InformationSource.InformationSourceBuilder>();
        protected FxBarrierFeatureSequence.FxBarrierFeatureSequenceBuilder fxBarrierFeatureSequence;
        protected List<FxBusinessCenterDateTime.FxBusinessCenterDateTimeBuilder> observationPoint = new ArrayList<FxBusinessCenterDateTime.FxBusinessCenterDateTimeBuilder>();

        @Override
        @RosettaAttribute(value="barrierType")
        @RuneAttribute(value="barrierType")
        public FxBarrierTypeEnum getBarrierType() {
            return this.barrierType;
        }

        @Override
        @RosettaAttribute(value="direction")
        @RuneAttribute(value="direction")
        public FxBarrierDirectionEnum getDirection() {
            return this.direction;
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair")
        @RuneAttribute(value="quotedCurrencyPair")
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getQuotedCurrencyPair() {
            return this.quotedCurrencyPair;
        }

        @Override
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getOrCreateQuotedCurrencyPair() {
            QuotedCurrencyPair.QuotedCurrencyPairBuilder result = this.quotedCurrencyPair != null ? this.quotedCurrencyPair : (this.quotedCurrencyPair = QuotedCurrencyPair.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="triggerRate")
        @RuneAttribute(value="triggerRate")
        public BigDecimal getTriggerRate() {
            return this.triggerRate;
        }

        @Override
        @RosettaAttribute(value="informationSource")
        @RuneAttribute(value="informationSource")
        public List<? extends InformationSource.InformationSourceBuilder> getInformationSource() {
            return this.informationSource;
        }

        @Override
        public InformationSource.InformationSourceBuilder getOrCreateInformationSource(int index) {
            if (this.informationSource == null) {
                this.informationSource = new ArrayList<InformationSource.InformationSourceBuilder>();
            }
            return (InformationSource.InformationSourceBuilder)this.getIndex(this.informationSource, index, () -> {
                InformationSource.InformationSourceBuilder newInformationSource = InformationSource.builder();
                return newInformationSource;
            });
        }

        @Override
        @RosettaAttribute(value="fxBarrierFeatureSequence")
        @RuneAttribute(value="fxBarrierFeatureSequence")
        public FxBarrierFeatureSequence.FxBarrierFeatureSequenceBuilder getFxBarrierFeatureSequence() {
            return this.fxBarrierFeatureSequence;
        }

        @Override
        public FxBarrierFeatureSequence.FxBarrierFeatureSequenceBuilder getOrCreateFxBarrierFeatureSequence() {
            FxBarrierFeatureSequence.FxBarrierFeatureSequenceBuilder result = this.fxBarrierFeatureSequence != null ? this.fxBarrierFeatureSequence : (this.fxBarrierFeatureSequence = FxBarrierFeatureSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="observationPoint")
        @RuneAttribute(value="observationPoint")
        public List<? extends FxBusinessCenterDateTime.FxBusinessCenterDateTimeBuilder> getObservationPoint() {
            return this.observationPoint;
        }

        @Override
        public FxBusinessCenterDateTime.FxBusinessCenterDateTimeBuilder getOrCreateObservationPoint(int index) {
            if (this.observationPoint == null) {
                this.observationPoint = new ArrayList<FxBusinessCenterDateTime.FxBusinessCenterDateTimeBuilder>();
            }
            return (FxBusinessCenterDateTime.FxBusinessCenterDateTimeBuilder)this.getIndex(this.observationPoint, index, () -> {
                FxBusinessCenterDateTime.FxBusinessCenterDateTimeBuilder newObservationPoint = FxBusinessCenterDateTime.builder();
                return newObservationPoint;
            });
        }

        @Override
        @RosettaAttribute(value="barrierType")
        @RuneAttribute(value="barrierType")
        public FxBarrierFeatureBuilder setBarrierType(FxBarrierTypeEnum _barrierType) {
            this.barrierType = _barrierType == null ? null : _barrierType;
            return this;
        }

        @Override
        @RosettaAttribute(value="direction")
        @RuneAttribute(value="direction")
        public FxBarrierFeatureBuilder setDirection(FxBarrierDirectionEnum _direction) {
            this.direction = _direction == null ? null : _direction;
            return this;
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair")
        @RuneAttribute(value="quotedCurrencyPair")
        public FxBarrierFeatureBuilder setQuotedCurrencyPair(QuotedCurrencyPair _quotedCurrencyPair) {
            this.quotedCurrencyPair = _quotedCurrencyPair == null ? null : _quotedCurrencyPair.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="triggerRate")
        @RuneAttribute(value="triggerRate")
        public FxBarrierFeatureBuilder setTriggerRate(BigDecimal _triggerRate) {
            this.triggerRate = _triggerRate == null ? null : _triggerRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="informationSource")
        @RuneAttribute(value="informationSource")
        public FxBarrierFeatureBuilder addInformationSource(InformationSource _informationSource) {
            if (_informationSource != null) {
                this.informationSource.add(_informationSource.toBuilder());
            }
            return this;
        }

        @Override
        public FxBarrierFeatureBuilder addInformationSource(InformationSource _informationSource, int idx) {
            this.getIndex(this.informationSource, idx, () -> _informationSource.toBuilder());
            return this;
        }

        @Override
        public FxBarrierFeatureBuilder addInformationSource(List<? extends InformationSource> informationSources) {
            if (informationSources != null) {
                for (InformationSource informationSource : informationSources) {
                    this.informationSource.add(informationSource.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="informationSource")
        public FxBarrierFeatureBuilder setInformationSource(List<? extends InformationSource> informationSources) {
            this.informationSource = informationSources == null ? new ArrayList<InformationSource.InformationSourceBuilder>() : (List)informationSources.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="fxBarrierFeatureSequence")
        @RuneAttribute(value="fxBarrierFeatureSequence")
        public FxBarrierFeatureBuilder setFxBarrierFeatureSequence(FxBarrierFeatureSequence _fxBarrierFeatureSequence) {
            this.fxBarrierFeatureSequence = _fxBarrierFeatureSequence == null ? null : _fxBarrierFeatureSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="observationPoint")
        @RuneAttribute(value="observationPoint")
        public FxBarrierFeatureBuilder addObservationPoint(FxBusinessCenterDateTime _observationPoint) {
            if (_observationPoint != null) {
                this.observationPoint.add(_observationPoint.toBuilder());
            }
            return this;
        }

        @Override
        public FxBarrierFeatureBuilder addObservationPoint(FxBusinessCenterDateTime _observationPoint, int idx) {
            this.getIndex(this.observationPoint, idx, () -> _observationPoint.toBuilder());
            return this;
        }

        @Override
        public FxBarrierFeatureBuilder addObservationPoint(List<? extends FxBusinessCenterDateTime> observationPoints) {
            if (observationPoints != null) {
                for (FxBusinessCenterDateTime fxBusinessCenterDateTime : observationPoints) {
                    this.observationPoint.add(fxBusinessCenterDateTime.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="observationPoint")
        public FxBarrierFeatureBuilder setObservationPoint(List<? extends FxBusinessCenterDateTime> observationPoints) {
            this.observationPoint = observationPoints == null ? new ArrayList<FxBusinessCenterDateTime.FxBusinessCenterDateTimeBuilder>() : (List)observationPoints.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public FxBarrierFeature build() {
            return new FxBarrierFeatureImpl(this);
        }

        @Override
        public FxBarrierFeatureBuilder toBuilder() {
            return this;
        }

        @Override
        public FxBarrierFeatureBuilder prune() {
            if (this.quotedCurrencyPair != null && !this.quotedCurrencyPair.prune().hasData()) {
                this.quotedCurrencyPair = null;
            }
            this.informationSource = this.informationSource.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.fxBarrierFeatureSequence != null && !this.fxBarrierFeatureSequence.prune().hasData()) {
                this.fxBarrierFeatureSequence = null;
            }
            this.observationPoint = this.observationPoint.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getBarrierType() != null) {
                return true;
            }
            if (this.getDirection() != null) {
                return true;
            }
            if (this.getQuotedCurrencyPair() != null && this.getQuotedCurrencyPair().hasData()) {
                return true;
            }
            if (this.getTriggerRate() != null) {
                return true;
            }
            if (this.getInformationSource() != null && this.getInformationSource().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getFxBarrierFeatureSequence() != null && this.getFxBarrierFeatureSequence().hasData()) {
                return true;
            }
            return this.getObservationPoint() != null && this.getObservationPoint().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public FxBarrierFeatureBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FxBarrierFeatureBuilder o = (FxBarrierFeatureBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getQuotedCurrencyPair(), (RosettaModelObjectBuilder)o.getQuotedCurrencyPair(), this::setQuotedCurrencyPair);
            merger.mergeRosetta(this.getInformationSource(), o.getInformationSource(), this::getOrCreateInformationSource);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxBarrierFeatureSequence(), (RosettaModelObjectBuilder)o.getFxBarrierFeatureSequence(), this::setFxBarrierFeatureSequence);
            merger.mergeRosetta(this.getObservationPoint(), o.getObservationPoint(), this::getOrCreateObservationPoint);
            merger.mergeBasic((Object)this.getBarrierType(), (Object)o.getBarrierType(), this::setBarrierType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDirection(), (Object)o.getDirection(), this::setDirection, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTriggerRate(), (Object)o.getTriggerRate(), this::setTriggerRate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxBarrierFeature _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.barrierType, (Object)_that.getBarrierType())) {
                return false;
            }
            if (!Objects.equals((Object)this.direction, (Object)_that.getDirection())) {
                return false;
            }
            if (!Objects.equals(this.quotedCurrencyPair, _that.getQuotedCurrencyPair())) {
                return false;
            }
            if (!Objects.equals(this.triggerRate, _that.getTriggerRate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.informationSource, _that.getInformationSource())) {
                return false;
            }
            if (!Objects.equals(this.fxBarrierFeatureSequence, _that.getFxBarrierFeatureSequence())) {
                return false;
            }
            return ListEquals.listEquals(this.observationPoint, _that.getObservationPoint());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.barrierType != null ? ((Object)((Object)this.barrierType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.direction != null ? ((Object)((Object)this.direction)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.quotedCurrencyPair != null ? this.quotedCurrencyPair.hashCode() : 0);
            _result = 31 * _result + (this.triggerRate != null ? this.triggerRate.hashCode() : 0);
            _result = 31 * _result + (this.informationSource != null ? this.informationSource.hashCode() : 0);
            _result = 31 * _result + (this.fxBarrierFeatureSequence != null ? this.fxBarrierFeatureSequence.hashCode() : 0);
            _result = 31 * _result + (this.observationPoint != null ? this.observationPoint.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxBarrierFeatureBuilder {barrierType=" + String.valueOf((Object)this.barrierType) + ", direction=" + String.valueOf((Object)this.direction) + ", quotedCurrencyPair=" + String.valueOf(this.quotedCurrencyPair) + ", triggerRate=" + String.valueOf(this.triggerRate) + ", informationSource=" + String.valueOf(this.informationSource) + ", fxBarrierFeatureSequence=" + String.valueOf(this.fxBarrierFeatureSequence) + ", observationPoint=" + String.valueOf(this.observationPoint) + "}";
        }
    }

    public static interface FxBarrierFeatureBuilder
    extends FxBarrierFeature,
    RosettaModelObjectBuilder {
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getOrCreateQuotedCurrencyPair();

        @Override
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getQuotedCurrencyPair();

        public InformationSource.InformationSourceBuilder getOrCreateInformationSource(int var1);

        public List<? extends InformationSource.InformationSourceBuilder> getInformationSource();

        public FxBarrierFeatureSequence.FxBarrierFeatureSequenceBuilder getOrCreateFxBarrierFeatureSequence();

        @Override
        public FxBarrierFeatureSequence.FxBarrierFeatureSequenceBuilder getFxBarrierFeatureSequence();

        public FxBusinessCenterDateTime.FxBusinessCenterDateTimeBuilder getOrCreateObservationPoint(int var1);

        public List<? extends FxBusinessCenterDateTime.FxBusinessCenterDateTimeBuilder> getObservationPoint();

        public FxBarrierFeatureBuilder setBarrierType(FxBarrierTypeEnum var1);

        public FxBarrierFeatureBuilder setDirection(FxBarrierDirectionEnum var1);

        public FxBarrierFeatureBuilder setQuotedCurrencyPair(QuotedCurrencyPair var1);

        public FxBarrierFeatureBuilder setTriggerRate(BigDecimal var1);

        public FxBarrierFeatureBuilder addInformationSource(InformationSource var1);

        public FxBarrierFeatureBuilder addInformationSource(InformationSource var1, int var2);

        public FxBarrierFeatureBuilder addInformationSource(List<? extends InformationSource> var1);

        public FxBarrierFeatureBuilder setInformationSource(List<? extends InformationSource> var1);

        public FxBarrierFeatureBuilder setFxBarrierFeatureSequence(FxBarrierFeatureSequence var1);

        public FxBarrierFeatureBuilder addObservationPoint(FxBusinessCenterDateTime var1);

        public FxBarrierFeatureBuilder addObservationPoint(FxBusinessCenterDateTime var1, int var2);

        public FxBarrierFeatureBuilder addObservationPoint(List<? extends FxBusinessCenterDateTime> var1);

        public FxBarrierFeatureBuilder setObservationPoint(List<? extends FxBusinessCenterDateTime> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("barrierType"), FxBarrierTypeEnum.class, (Object)this.getBarrierType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("direction"), FxBarrierDirectionEnum.class, (Object)this.getDirection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.QuotedCurrencyPairBuilder.class, this.getQuotedCurrencyPair(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("triggerRate"), BigDecimal.class, (Object)this.getTriggerRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("informationSource"), processor, InformationSource.InformationSourceBuilder.class, this.getInformationSource(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxBarrierFeatureSequence"), processor, FxBarrierFeatureSequence.FxBarrierFeatureSequenceBuilder.class, this.getFxBarrierFeatureSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("observationPoint"), processor, FxBusinessCenterDateTime.FxBusinessCenterDateTimeBuilder.class, this.getObservationPoint(), new AttributeMeta[0]);
        }

        public FxBarrierFeatureBuilder prune();
    }

    public static class FxBarrierFeatureImpl
    implements FxBarrierFeature {
        private final FxBarrierTypeEnum barrierType;
        private final FxBarrierDirectionEnum direction;
        private final QuotedCurrencyPair quotedCurrencyPair;
        private final BigDecimal triggerRate;
        private final List<? extends InformationSource> informationSource;
        private final FxBarrierFeatureSequence fxBarrierFeatureSequence;
        private final List<? extends FxBusinessCenterDateTime> observationPoint;

        protected FxBarrierFeatureImpl(FxBarrierFeatureBuilder builder) {
            this.barrierType = builder.getBarrierType();
            this.direction = builder.getDirection();
            this.quotedCurrencyPair = Optional.ofNullable(builder.getQuotedCurrencyPair()).map(f -> f.build()).orElse(null);
            this.triggerRate = builder.getTriggerRate();
            this.informationSource = Optional.ofNullable(builder.getInformationSource()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.fxBarrierFeatureSequence = Optional.ofNullable(builder.getFxBarrierFeatureSequence()).map(f -> f.build()).orElse(null);
            this.observationPoint = Optional.ofNullable(builder.getObservationPoint()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="barrierType")
        @RuneAttribute(value="barrierType")
        public FxBarrierTypeEnum getBarrierType() {
            return this.barrierType;
        }

        @Override
        @RosettaAttribute(value="direction")
        @RuneAttribute(value="direction")
        public FxBarrierDirectionEnum getDirection() {
            return this.direction;
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair")
        @RuneAttribute(value="quotedCurrencyPair")
        public QuotedCurrencyPair getQuotedCurrencyPair() {
            return this.quotedCurrencyPair;
        }

        @Override
        @RosettaAttribute(value="triggerRate")
        @RuneAttribute(value="triggerRate")
        public BigDecimal getTriggerRate() {
            return this.triggerRate;
        }

        @Override
        @RosettaAttribute(value="informationSource")
        @RuneAttribute(value="informationSource")
        public List<? extends InformationSource> getInformationSource() {
            return this.informationSource;
        }

        @Override
        @RosettaAttribute(value="fxBarrierFeatureSequence")
        @RuneAttribute(value="fxBarrierFeatureSequence")
        public FxBarrierFeatureSequence getFxBarrierFeatureSequence() {
            return this.fxBarrierFeatureSequence;
        }

        @Override
        @RosettaAttribute(value="observationPoint")
        @RuneAttribute(value="observationPoint")
        public List<? extends FxBusinessCenterDateTime> getObservationPoint() {
            return this.observationPoint;
        }

        @Override
        public FxBarrierFeature build() {
            return this;
        }

        @Override
        public FxBarrierFeatureBuilder toBuilder() {
            FxBarrierFeatureBuilder builder = FxBarrierFeature.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxBarrierFeatureBuilder builder) {
            Optional.ofNullable(this.getBarrierType()).ifPresent(builder::setBarrierType);
            Optional.ofNullable(this.getDirection()).ifPresent(builder::setDirection);
            Optional.ofNullable(this.getQuotedCurrencyPair()).ifPresent(builder::setQuotedCurrencyPair);
            Optional.ofNullable(this.getTriggerRate()).ifPresent(builder::setTriggerRate);
            Optional.ofNullable(this.getInformationSource()).ifPresent(builder::setInformationSource);
            Optional.ofNullable(this.getFxBarrierFeatureSequence()).ifPresent(builder::setFxBarrierFeatureSequence);
            Optional.ofNullable(this.getObservationPoint()).ifPresent(builder::setObservationPoint);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxBarrierFeature _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.barrierType, (Object)_that.getBarrierType())) {
                return false;
            }
            if (!Objects.equals((Object)this.direction, (Object)_that.getDirection())) {
                return false;
            }
            if (!Objects.equals(this.quotedCurrencyPair, _that.getQuotedCurrencyPair())) {
                return false;
            }
            if (!Objects.equals(this.triggerRate, _that.getTriggerRate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.informationSource, _that.getInformationSource())) {
                return false;
            }
            if (!Objects.equals(this.fxBarrierFeatureSequence, _that.getFxBarrierFeatureSequence())) {
                return false;
            }
            return ListEquals.listEquals(this.observationPoint, _that.getObservationPoint());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.barrierType != null ? ((Object)((Object)this.barrierType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.direction != null ? ((Object)((Object)this.direction)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.quotedCurrencyPair != null ? this.quotedCurrencyPair.hashCode() : 0);
            _result = 31 * _result + (this.triggerRate != null ? this.triggerRate.hashCode() : 0);
            _result = 31 * _result + (this.informationSource != null ? this.informationSource.hashCode() : 0);
            _result = 31 * _result + (this.fxBarrierFeatureSequence != null ? this.fxBarrierFeatureSequence.hashCode() : 0);
            _result = 31 * _result + (this.observationPoint != null ? this.observationPoint.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxBarrierFeature {barrierType=" + String.valueOf((Object)this.barrierType) + ", direction=" + String.valueOf((Object)this.direction) + ", quotedCurrencyPair=" + String.valueOf(this.quotedCurrencyPair) + ", triggerRate=" + String.valueOf(this.triggerRate) + ", informationSource=" + String.valueOf(this.informationSource) + ", fxBarrierFeatureSequence=" + String.valueOf(this.fxBarrierFeatureSequence) + ", observationPoint=" + String.valueOf(this.observationPoint) + "}";
        }
    }
}

