/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fpmlstandard;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.asset.BasicQuotation;
import fpml.consolidated.fpmlstandard.meta.StandardProductMeta;
import fpml.consolidated.shared.CashflowNotional;
import fpml.consolidated.shared.Product;
import fpml.consolidated.shared.ProductModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="StandardProduct", builder=StandardProductBuilderImpl.class, version="1.2.2")
@RuneDataType(value="StandardProduct", model="fpml", builder=StandardProductBuilderImpl.class, version="1.2.2")
public interface StandardProduct
extends Product {
    public static final StandardProductMeta metaData = new StandardProductMeta();

    public CashflowNotional getNotional();

    public List<? extends BasicQuotation> getQuote();

    @Override
    public StandardProduct build();

    @Override
    public StandardProductBuilder toBuilder();

    public static StandardProductBuilder builder() {
        return new StandardProductBuilderImpl();
    }

    default public RosettaMetaData<? extends StandardProduct> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends StandardProduct> getType() {
        return StandardProduct.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notional"), processor, CashflowNotional.class, this.getNotional(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quote"), processor, BasicQuotation.class, this.getQuote(), new AttributeMeta[0]);
    }

    public static class StandardProductBuilderImpl
    extends Product.ProductBuilderImpl
    implements StandardProductBuilder {
        protected CashflowNotional.CashflowNotionalBuilder notional;
        protected List<BasicQuotation.BasicQuotationBuilder> quote = new ArrayList<BasicQuotation.BasicQuotationBuilder>();

        @Override
        @RosettaAttribute(value="notional")
        @RuneAttribute(value="notional")
        public CashflowNotional.CashflowNotionalBuilder getNotional() {
            return this.notional;
        }

        @Override
        public CashflowNotional.CashflowNotionalBuilder getOrCreateNotional() {
            CashflowNotional.CashflowNotionalBuilder result = this.notional != null ? this.notional : (this.notional = CashflowNotional.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="quote")
        @RuneAttribute(value="quote")
        public List<? extends BasicQuotation.BasicQuotationBuilder> getQuote() {
            return this.quote;
        }

        @Override
        public BasicQuotation.BasicQuotationBuilder getOrCreateQuote(int index) {
            if (this.quote == null) {
                this.quote = new ArrayList<BasicQuotation.BasicQuotationBuilder>();
            }
            return (BasicQuotation.BasicQuotationBuilder)this.getIndex(this.quote, index, () -> {
                BasicQuotation.BasicQuotationBuilder newQuote = BasicQuotation.builder();
                return newQuote;
            });
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public StandardProductBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public StandardProductBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="notional")
        @RuneAttribute(value="notional")
        public StandardProductBuilder setNotional(CashflowNotional _notional) {
            this.notional = _notional == null ? null : _notional.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="quote")
        @RuneAttribute(value="quote")
        public StandardProductBuilder addQuote(BasicQuotation _quote) {
            if (_quote != null) {
                this.quote.add(_quote.toBuilder());
            }
            return this;
        }

        @Override
        public StandardProductBuilder addQuote(BasicQuotation _quote, int idx) {
            this.getIndex(this.quote, idx, () -> _quote.toBuilder());
            return this;
        }

        @Override
        public StandardProductBuilder addQuote(List<? extends BasicQuotation> quotes) {
            if (quotes != null) {
                for (BasicQuotation basicQuotation : quotes) {
                    this.quote.add(basicQuotation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="quote")
        public StandardProductBuilder setQuote(List<? extends BasicQuotation> quotes) {
            this.quote = quotes == null ? new ArrayList<BasicQuotation.BasicQuotationBuilder>() : (List)quotes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public StandardProduct build() {
            return new StandardProductImpl(this);
        }

        @Override
        public StandardProductBuilder toBuilder() {
            return this;
        }

        @Override
        public StandardProductBuilder prune() {
            super.prune();
            if (this.notional != null && !this.notional.prune().hasData()) {
                this.notional = null;
            }
            this.quote = this.quote.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getNotional() != null && this.getNotional().hasData()) {
                return true;
            }
            return this.getQuote() != null && this.getQuote().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public StandardProductBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            StandardProductBuilder o = (StandardProductBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotional(), (RosettaModelObjectBuilder)o.getNotional(), this::setNotional);
            merger.mergeRosetta(this.getQuote(), o.getQuote(), this::getOrCreateQuote);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            StandardProduct _that = (StandardProduct)this.getType().cast(o);
            if (!Objects.equals(this.notional, _that.getNotional())) {
                return false;
            }
            return ListEquals.listEquals(this.quote, _that.getQuote());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.notional != null ? this.notional.hashCode() : 0);
            _result = 31 * _result + (this.quote != null ? this.quote.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "StandardProductBuilder {notional=" + String.valueOf(this.notional) + ", quote=" + String.valueOf(this.quote) + "} " + super.toString();
        }
    }

    public static interface StandardProductBuilder
    extends StandardProduct,
    Product.ProductBuilder {
        public CashflowNotional.CashflowNotionalBuilder getOrCreateNotional();

        @Override
        public CashflowNotional.CashflowNotionalBuilder getNotional();

        public BasicQuotation.BasicQuotationBuilder getOrCreateQuote(int var1);

        public List<? extends BasicQuotation.BasicQuotationBuilder> getQuote();

        @Override
        public StandardProductBuilder setProductModel(ProductModel var1);

        @Override
        public StandardProductBuilder setId(String var1);

        public StandardProductBuilder setNotional(CashflowNotional var1);

        public StandardProductBuilder addQuote(BasicQuotation var1);

        public StandardProductBuilder addQuote(BasicQuotation var1, int var2);

        public StandardProductBuilder addQuote(List<? extends BasicQuotation> var1);

        public StandardProductBuilder setQuote(List<? extends BasicQuotation> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notional"), processor, CashflowNotional.CashflowNotionalBuilder.class, this.getNotional(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quote"), processor, BasicQuotation.BasicQuotationBuilder.class, this.getQuote(), new AttributeMeta[0]);
        }

        @Override
        public StandardProductBuilder prune();
    }

    public static class StandardProductImpl
    extends Product.ProductImpl
    implements StandardProduct {
        private final CashflowNotional notional;
        private final List<? extends BasicQuotation> quote;

        protected StandardProductImpl(StandardProductBuilder builder) {
            super(builder);
            this.notional = Optional.ofNullable(builder.getNotional()).map(f -> f.build()).orElse(null);
            this.quote = Optional.ofNullable(builder.getQuote()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="notional")
        @RuneAttribute(value="notional")
        public CashflowNotional getNotional() {
            return this.notional;
        }

        @Override
        @RosettaAttribute(value="quote")
        @RuneAttribute(value="quote")
        public List<? extends BasicQuotation> getQuote() {
            return this.quote;
        }

        @Override
        public StandardProduct build() {
            return this;
        }

        @Override
        public StandardProductBuilder toBuilder() {
            StandardProductBuilder builder = StandardProduct.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(StandardProductBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getNotional()).ifPresent(builder::setNotional);
            Optional.ofNullable(this.getQuote()).ifPresent(builder::setQuote);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            StandardProduct _that = (StandardProduct)this.getType().cast(o);
            if (!Objects.equals(this.notional, _that.getNotional())) {
                return false;
            }
            return ListEquals.listEquals(this.quote, _that.getQuote());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.notional != null ? this.notional.hashCode() : 0);
            _result = 31 * _result + (this.quote != null ? this.quote.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "StandardProduct {notional=" + String.valueOf(this.notional) + ", quote=" + String.valueOf(this.quote) + "} " + super.toString();
        }
    }
}

