/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.eq.shared.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.eq.shared.Variance;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="VarianceChoice")
@ImplementedBy(value=Default.class)
public interface VarianceChoice
extends Validator<Variance> {
    public static final String NAME = "VarianceChoice";
    public static final String DEFINITION = "required choice volatilityStrikePrice, varianceStrikePrice";

    public static class NoOp
    implements VarianceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Variance variance) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements VarianceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Variance variance) {
            ComparisonResult result = this.executeDataRule(variance);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)VarianceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Variance", (RosettaPath)path, (String)VarianceChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)VarianceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Variance", (RosettaPath)path, (String)VarianceChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Variance variance) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)variance), Arrays.asList("volatilityStrikePrice", "varianceStrikePrice"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

