/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.doc.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.doc.InstrumentTradeQuantity;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="InstrumentTradeQuantityChoice")
@ImplementedBy(value=Default.class)
public interface InstrumentTradeQuantityChoice
extends Validator<InstrumentTradeQuantity> {
    public static final String NAME = "InstrumentTradeQuantityChoice";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements InstrumentTradeQuantityChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, InstrumentTradeQuantity instrumentTradeQuantity) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements InstrumentTradeQuantityChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, InstrumentTradeQuantity instrumentTradeQuantity) {
            ComparisonResult result = this.executeDataRule(instrumentTradeQuantity);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)InstrumentTradeQuantityChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"InstrumentTradeQuantity", (RosettaPath)path, (String)InstrumentTradeQuantityChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)InstrumentTradeQuantityChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"InstrumentTradeQuantity", (RosettaPath)path, (String)InstrumentTradeQuantityChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(InstrumentTradeQuantity instrumentTradeQuantity) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)instrumentTradeQuantity), Arrays.asList("number", "nominal"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

