/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.doc.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.doc.Allocation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="AllocationChoice")
@ImplementedBy(value=Default.class)
public interface AllocationChoice
extends Validator<Allocation> {
    public static final String NAME = "AllocationChoice";
    public static final String DEFINITION = "optional choice allocatedFraction, allocatedNotional";

    public static class NoOp
    implements AllocationChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Allocation allocation) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements AllocationChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Allocation allocation) {
            ComparisonResult result = this.executeDataRule(allocation);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)AllocationChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Allocation", (RosettaPath)path, (String)AllocationChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)AllocationChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Allocation", (RosettaPath)path, (String)AllocationChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Allocation allocation) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)allocation), Arrays.asList("allocatedFraction", "allocatedNotional"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

