/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.doc;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.LinkId;
import fpml.consolidated.doc.LinkedTrade;
import fpml.consolidated.doc.ProductComponentIdentifier;
import fpml.consolidated.doc.TradeIdentifier;
import fpml.consolidated.doc.TradeIdentifierExtended;
import fpml.consolidated.doc.TradeIdentifierSequence;
import fpml.consolidated.doc.meta.PartyTradeIdentifierMeta;
import fpml.consolidated.shared.IssuerTradeIdModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PartyTradeIdentifier", builder=PartyTradeIdentifierBuilderImpl.class, version="1.2.2")
@RuneDataType(value="PartyTradeIdentifier", model="fpml", builder=PartyTradeIdentifierBuilderImpl.class, version="1.2.2")
public interface PartyTradeIdentifier
extends TradeIdentifier {
    public static final PartyTradeIdentifierMeta metaData = new PartyTradeIdentifierMeta();

    public List<? extends LinkId> getLinkId();

    public List<? extends TradeIdentifier> getAllocationTradeId();

    public List<? extends TradeIdentifierExtended> getResultingTradeId();

    public TradeIdentifier getBlockTradeId();

    public List<? extends TradeIdentifier> getOriginatingTradeId();

    public List<? extends ProductComponentIdentifier> getProductComponentIdentifier();

    public List<? extends LinkedTrade> getLinkedTrade();

    @Override
    public PartyTradeIdentifier build();

    @Override
    public PartyTradeIdentifierBuilder toBuilder();

    public static PartyTradeIdentifierBuilder builder() {
        return new PartyTradeIdentifierBuilderImpl();
    }

    default public RosettaMetaData<? extends PartyTradeIdentifier> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PartyTradeIdentifier> getType() {
        return PartyTradeIdentifier.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("issuerTradeIdModel"), processor, IssuerTradeIdModel.class, this.getIssuerTradeIdModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeIdentifierSequence"), processor, TradeIdentifierSequence.class, this.getTradeIdentifierSequence(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("linkId"), processor, LinkId.class, this.getLinkId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("allocationTradeId"), processor, TradeIdentifier.class, this.getAllocationTradeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("resultingTradeId"), processor, TradeIdentifierExtended.class, this.getResultingTradeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("blockTradeId"), processor, TradeIdentifier.class, this.getBlockTradeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("originatingTradeId"), processor, TradeIdentifier.class, this.getOriginatingTradeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("productComponentIdentifier"), processor, ProductComponentIdentifier.class, this.getProductComponentIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("linkedTrade"), processor, LinkedTrade.class, this.getLinkedTrade(), new AttributeMeta[0]);
    }

    public static class PartyTradeIdentifierBuilderImpl
    extends TradeIdentifier.TradeIdentifierBuilderImpl
    implements PartyTradeIdentifierBuilder {
        protected List<LinkId.LinkIdBuilder> linkId = new ArrayList<LinkId.LinkIdBuilder>();
        protected List<TradeIdentifier.TradeIdentifierBuilder> allocationTradeId = new ArrayList<TradeIdentifier.TradeIdentifierBuilder>();
        protected List<TradeIdentifierExtended.TradeIdentifierExtendedBuilder> resultingTradeId = new ArrayList<TradeIdentifierExtended.TradeIdentifierExtendedBuilder>();
        protected TradeIdentifier.TradeIdentifierBuilder blockTradeId;
        protected List<TradeIdentifier.TradeIdentifierBuilder> originatingTradeId = new ArrayList<TradeIdentifier.TradeIdentifierBuilder>();
        protected List<ProductComponentIdentifier.ProductComponentIdentifierBuilder> productComponentIdentifier = new ArrayList<ProductComponentIdentifier.ProductComponentIdentifierBuilder>();
        protected List<LinkedTrade.LinkedTradeBuilder> linkedTrade = new ArrayList<LinkedTrade.LinkedTradeBuilder>();

        @Override
        @RosettaAttribute(value="linkId")
        @RuneAttribute(value="linkId")
        public List<? extends LinkId.LinkIdBuilder> getLinkId() {
            return this.linkId;
        }

        @Override
        public LinkId.LinkIdBuilder getOrCreateLinkId(int index) {
            if (this.linkId == null) {
                this.linkId = new ArrayList<LinkId.LinkIdBuilder>();
            }
            return (LinkId.LinkIdBuilder)this.getIndex(this.linkId, index, () -> {
                LinkId.LinkIdBuilder newLinkId = LinkId.builder();
                return newLinkId;
            });
        }

        @Override
        @RosettaAttribute(value="allocationTradeId")
        @RuneAttribute(value="allocationTradeId")
        public List<? extends TradeIdentifier.TradeIdentifierBuilder> getAllocationTradeId() {
            return this.allocationTradeId;
        }

        @Override
        public TradeIdentifier.TradeIdentifierBuilder getOrCreateAllocationTradeId(int index) {
            if (this.allocationTradeId == null) {
                this.allocationTradeId = new ArrayList<TradeIdentifier.TradeIdentifierBuilder>();
            }
            return (TradeIdentifier.TradeIdentifierBuilder)this.getIndex(this.allocationTradeId, index, () -> {
                TradeIdentifier.TradeIdentifierBuilder newAllocationTradeId = TradeIdentifier.builder();
                return newAllocationTradeId;
            });
        }

        @Override
        @RosettaAttribute(value="resultingTradeId")
        @RuneAttribute(value="resultingTradeId")
        public List<? extends TradeIdentifierExtended.TradeIdentifierExtendedBuilder> getResultingTradeId() {
            return this.resultingTradeId;
        }

        @Override
        public TradeIdentifierExtended.TradeIdentifierExtendedBuilder getOrCreateResultingTradeId(int index) {
            if (this.resultingTradeId == null) {
                this.resultingTradeId = new ArrayList<TradeIdentifierExtended.TradeIdentifierExtendedBuilder>();
            }
            return (TradeIdentifierExtended.TradeIdentifierExtendedBuilder)this.getIndex(this.resultingTradeId, index, () -> {
                TradeIdentifierExtended.TradeIdentifierExtendedBuilder newResultingTradeId = TradeIdentifierExtended.builder();
                return newResultingTradeId;
            });
        }

        @Override
        @RosettaAttribute(value="blockTradeId")
        @RuneAttribute(value="blockTradeId")
        public TradeIdentifier.TradeIdentifierBuilder getBlockTradeId() {
            return this.blockTradeId;
        }

        @Override
        public TradeIdentifier.TradeIdentifierBuilder getOrCreateBlockTradeId() {
            TradeIdentifier.TradeIdentifierBuilder result = this.blockTradeId != null ? this.blockTradeId : (this.blockTradeId = TradeIdentifier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="originatingTradeId")
        @RuneAttribute(value="originatingTradeId")
        public List<? extends TradeIdentifier.TradeIdentifierBuilder> getOriginatingTradeId() {
            return this.originatingTradeId;
        }

        @Override
        public TradeIdentifier.TradeIdentifierBuilder getOrCreateOriginatingTradeId(int index) {
            if (this.originatingTradeId == null) {
                this.originatingTradeId = new ArrayList<TradeIdentifier.TradeIdentifierBuilder>();
            }
            return (TradeIdentifier.TradeIdentifierBuilder)this.getIndex(this.originatingTradeId, index, () -> {
                TradeIdentifier.TradeIdentifierBuilder newOriginatingTradeId = TradeIdentifier.builder();
                return newOriginatingTradeId;
            });
        }

        @Override
        @RosettaAttribute(value="productComponentIdentifier")
        @RuneAttribute(value="productComponentIdentifier")
        public List<? extends ProductComponentIdentifier.ProductComponentIdentifierBuilder> getProductComponentIdentifier() {
            return this.productComponentIdentifier;
        }

        @Override
        public ProductComponentIdentifier.ProductComponentIdentifierBuilder getOrCreateProductComponentIdentifier(int index) {
            if (this.productComponentIdentifier == null) {
                this.productComponentIdentifier = new ArrayList<ProductComponentIdentifier.ProductComponentIdentifierBuilder>();
            }
            return (ProductComponentIdentifier.ProductComponentIdentifierBuilder)this.getIndex(this.productComponentIdentifier, index, () -> {
                ProductComponentIdentifier.ProductComponentIdentifierBuilder newProductComponentIdentifier = ProductComponentIdentifier.builder();
                return newProductComponentIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="linkedTrade")
        @RuneAttribute(value="linkedTrade")
        public List<? extends LinkedTrade.LinkedTradeBuilder> getLinkedTrade() {
            return this.linkedTrade;
        }

        @Override
        public LinkedTrade.LinkedTradeBuilder getOrCreateLinkedTrade(int index) {
            if (this.linkedTrade == null) {
                this.linkedTrade = new ArrayList<LinkedTrade.LinkedTradeBuilder>();
            }
            return (LinkedTrade.LinkedTradeBuilder)this.getIndex(this.linkedTrade, index, () -> {
                LinkedTrade.LinkedTradeBuilder newLinkedTrade = LinkedTrade.builder();
                return newLinkedTrade;
            });
        }

        @Override
        @RosettaAttribute(value="issuerTradeIdModel")
        @RuneAttribute(value="issuerTradeIdModel")
        public PartyTradeIdentifierBuilder setIssuerTradeIdModel(IssuerTradeIdModel _issuerTradeIdModel) {
            this.issuerTradeIdModel = _issuerTradeIdModel == null ? null : _issuerTradeIdModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifierSequence")
        @RuneAttribute(value="tradeIdentifierSequence")
        public PartyTradeIdentifierBuilder setTradeIdentifierSequence(TradeIdentifierSequence _tradeIdentifierSequence) {
            this.tradeIdentifierSequence = _tradeIdentifierSequence == null ? null : _tradeIdentifierSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public PartyTradeIdentifierBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="linkId")
        @RuneAttribute(value="linkId")
        public PartyTradeIdentifierBuilder addLinkId(LinkId _linkId) {
            if (_linkId != null) {
                this.linkId.add(_linkId.toBuilder());
            }
            return this;
        }

        @Override
        public PartyTradeIdentifierBuilder addLinkId(LinkId _linkId, int idx) {
            this.getIndex(this.linkId, idx, () -> _linkId.toBuilder());
            return this;
        }

        @Override
        public PartyTradeIdentifierBuilder addLinkId(List<? extends LinkId> linkIds) {
            if (linkIds != null) {
                for (LinkId linkId : linkIds) {
                    this.linkId.add(linkId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="linkId")
        public PartyTradeIdentifierBuilder setLinkId(List<? extends LinkId> linkIds) {
            this.linkId = linkIds == null ? new ArrayList<LinkId.LinkIdBuilder>() : (List)linkIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="allocationTradeId")
        @RuneAttribute(value="allocationTradeId")
        public PartyTradeIdentifierBuilder addAllocationTradeId(TradeIdentifier _allocationTradeId) {
            if (_allocationTradeId != null) {
                this.allocationTradeId.add(_allocationTradeId.toBuilder());
            }
            return this;
        }

        @Override
        public PartyTradeIdentifierBuilder addAllocationTradeId(TradeIdentifier _allocationTradeId, int idx) {
            this.getIndex(this.allocationTradeId, idx, () -> _allocationTradeId.toBuilder());
            return this;
        }

        @Override
        public PartyTradeIdentifierBuilder addAllocationTradeId(List<? extends TradeIdentifier> allocationTradeIds) {
            if (allocationTradeIds != null) {
                for (TradeIdentifier tradeIdentifier : allocationTradeIds) {
                    this.allocationTradeId.add(tradeIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="allocationTradeId")
        public PartyTradeIdentifierBuilder setAllocationTradeId(List<? extends TradeIdentifier> allocationTradeIds) {
            this.allocationTradeId = allocationTradeIds == null ? new ArrayList<TradeIdentifier.TradeIdentifierBuilder>() : (List)allocationTradeIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="resultingTradeId")
        @RuneAttribute(value="resultingTradeId")
        public PartyTradeIdentifierBuilder addResultingTradeId(TradeIdentifierExtended _resultingTradeId) {
            if (_resultingTradeId != null) {
                this.resultingTradeId.add(_resultingTradeId.toBuilder());
            }
            return this;
        }

        @Override
        public PartyTradeIdentifierBuilder addResultingTradeId(TradeIdentifierExtended _resultingTradeId, int idx) {
            this.getIndex(this.resultingTradeId, idx, () -> _resultingTradeId.toBuilder());
            return this;
        }

        @Override
        public PartyTradeIdentifierBuilder addResultingTradeId(List<? extends TradeIdentifierExtended> resultingTradeIds) {
            if (resultingTradeIds != null) {
                for (TradeIdentifierExtended tradeIdentifierExtended : resultingTradeIds) {
                    this.resultingTradeId.add(tradeIdentifierExtended.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="resultingTradeId")
        public PartyTradeIdentifierBuilder setResultingTradeId(List<? extends TradeIdentifierExtended> resultingTradeIds) {
            this.resultingTradeId = resultingTradeIds == null ? new ArrayList<TradeIdentifierExtended.TradeIdentifierExtendedBuilder>() : (List)resultingTradeIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="blockTradeId")
        @RuneAttribute(value="blockTradeId")
        public PartyTradeIdentifierBuilder setBlockTradeId(TradeIdentifier _blockTradeId) {
            this.blockTradeId = _blockTradeId == null ? null : _blockTradeId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="originatingTradeId")
        @RuneAttribute(value="originatingTradeId")
        public PartyTradeIdentifierBuilder addOriginatingTradeId(TradeIdentifier _originatingTradeId) {
            if (_originatingTradeId != null) {
                this.originatingTradeId.add(_originatingTradeId.toBuilder());
            }
            return this;
        }

        @Override
        public PartyTradeIdentifierBuilder addOriginatingTradeId(TradeIdentifier _originatingTradeId, int idx) {
            this.getIndex(this.originatingTradeId, idx, () -> _originatingTradeId.toBuilder());
            return this;
        }

        @Override
        public PartyTradeIdentifierBuilder addOriginatingTradeId(List<? extends TradeIdentifier> originatingTradeIds) {
            if (originatingTradeIds != null) {
                for (TradeIdentifier tradeIdentifier : originatingTradeIds) {
                    this.originatingTradeId.add(tradeIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="originatingTradeId")
        public PartyTradeIdentifierBuilder setOriginatingTradeId(List<? extends TradeIdentifier> originatingTradeIds) {
            this.originatingTradeId = originatingTradeIds == null ? new ArrayList<TradeIdentifier.TradeIdentifierBuilder>() : (List)originatingTradeIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="productComponentIdentifier")
        @RuneAttribute(value="productComponentIdentifier")
        public PartyTradeIdentifierBuilder addProductComponentIdentifier(ProductComponentIdentifier _productComponentIdentifier) {
            if (_productComponentIdentifier != null) {
                this.productComponentIdentifier.add(_productComponentIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public PartyTradeIdentifierBuilder addProductComponentIdentifier(ProductComponentIdentifier _productComponentIdentifier, int idx) {
            this.getIndex(this.productComponentIdentifier, idx, () -> _productComponentIdentifier.toBuilder());
            return this;
        }

        @Override
        public PartyTradeIdentifierBuilder addProductComponentIdentifier(List<? extends ProductComponentIdentifier> productComponentIdentifiers) {
            if (productComponentIdentifiers != null) {
                for (ProductComponentIdentifier productComponentIdentifier : productComponentIdentifiers) {
                    this.productComponentIdentifier.add(productComponentIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="productComponentIdentifier")
        public PartyTradeIdentifierBuilder setProductComponentIdentifier(List<? extends ProductComponentIdentifier> productComponentIdentifiers) {
            this.productComponentIdentifier = productComponentIdentifiers == null ? new ArrayList<ProductComponentIdentifier.ProductComponentIdentifierBuilder>() : (List)productComponentIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="linkedTrade")
        @RuneAttribute(value="linkedTrade")
        public PartyTradeIdentifierBuilder addLinkedTrade(LinkedTrade _linkedTrade) {
            if (_linkedTrade != null) {
                this.linkedTrade.add(_linkedTrade.toBuilder());
            }
            return this;
        }

        @Override
        public PartyTradeIdentifierBuilder addLinkedTrade(LinkedTrade _linkedTrade, int idx) {
            this.getIndex(this.linkedTrade, idx, () -> _linkedTrade.toBuilder());
            return this;
        }

        @Override
        public PartyTradeIdentifierBuilder addLinkedTrade(List<? extends LinkedTrade> linkedTrades) {
            if (linkedTrades != null) {
                for (LinkedTrade linkedTrade : linkedTrades) {
                    this.linkedTrade.add(linkedTrade.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="linkedTrade")
        public PartyTradeIdentifierBuilder setLinkedTrade(List<? extends LinkedTrade> linkedTrades) {
            this.linkedTrade = linkedTrades == null ? new ArrayList<LinkedTrade.LinkedTradeBuilder>() : (List)linkedTrades.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public PartyTradeIdentifier build() {
            return new PartyTradeIdentifierImpl(this);
        }

        @Override
        public PartyTradeIdentifierBuilder toBuilder() {
            return this;
        }

        @Override
        public PartyTradeIdentifierBuilder prune() {
            super.prune();
            this.linkId = this.linkId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.allocationTradeId = this.allocationTradeId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.resultingTradeId = this.resultingTradeId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.blockTradeId != null && !this.blockTradeId.prune().hasData()) {
                this.blockTradeId = null;
            }
            this.originatingTradeId = this.originatingTradeId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.productComponentIdentifier = this.productComponentIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.linkedTrade = this.linkedTrade.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getLinkId() != null && this.getLinkId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getAllocationTradeId() != null && this.getAllocationTradeId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getResultingTradeId() != null && this.getResultingTradeId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getBlockTradeId() != null && this.getBlockTradeId().hasData()) {
                return true;
            }
            if (this.getOriginatingTradeId() != null && this.getOriginatingTradeId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getProductComponentIdentifier() != null && this.getProductComponentIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getLinkedTrade() != null && this.getLinkedTrade().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public PartyTradeIdentifierBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            PartyTradeIdentifierBuilder o = (PartyTradeIdentifierBuilder)other;
            merger.mergeRosetta(this.getLinkId(), o.getLinkId(), this::getOrCreateLinkId);
            merger.mergeRosetta(this.getAllocationTradeId(), o.getAllocationTradeId(), this::getOrCreateAllocationTradeId);
            merger.mergeRosetta(this.getResultingTradeId(), o.getResultingTradeId(), this::getOrCreateResultingTradeId);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBlockTradeId(), (RosettaModelObjectBuilder)o.getBlockTradeId(), this::setBlockTradeId);
            merger.mergeRosetta(this.getOriginatingTradeId(), o.getOriginatingTradeId(), this::getOrCreateOriginatingTradeId);
            merger.mergeRosetta(this.getProductComponentIdentifier(), o.getProductComponentIdentifier(), this::getOrCreateProductComponentIdentifier);
            merger.mergeRosetta(this.getLinkedTrade(), o.getLinkedTrade(), this::getOrCreateLinkedTrade);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PartyTradeIdentifier _that = (PartyTradeIdentifier)this.getType().cast(o);
            if (!ListEquals.listEquals(this.linkId, _that.getLinkId())) {
                return false;
            }
            if (!ListEquals.listEquals(this.allocationTradeId, _that.getAllocationTradeId())) {
                return false;
            }
            if (!ListEquals.listEquals(this.resultingTradeId, _that.getResultingTradeId())) {
                return false;
            }
            if (!Objects.equals(this.blockTradeId, _that.getBlockTradeId())) {
                return false;
            }
            if (!ListEquals.listEquals(this.originatingTradeId, _that.getOriginatingTradeId())) {
                return false;
            }
            if (!ListEquals.listEquals(this.productComponentIdentifier, _that.getProductComponentIdentifier())) {
                return false;
            }
            return ListEquals.listEquals(this.linkedTrade, _that.getLinkedTrade());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.linkId != null ? this.linkId.hashCode() : 0);
            _result = 31 * _result + (this.allocationTradeId != null ? this.allocationTradeId.hashCode() : 0);
            _result = 31 * _result + (this.resultingTradeId != null ? this.resultingTradeId.hashCode() : 0);
            _result = 31 * _result + (this.blockTradeId != null ? this.blockTradeId.hashCode() : 0);
            _result = 31 * _result + (this.originatingTradeId != null ? this.originatingTradeId.hashCode() : 0);
            _result = 31 * _result + (this.productComponentIdentifier != null ? this.productComponentIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.linkedTrade != null ? this.linkedTrade.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "PartyTradeIdentifierBuilder {linkId=" + String.valueOf(this.linkId) + ", allocationTradeId=" + String.valueOf(this.allocationTradeId) + ", resultingTradeId=" + String.valueOf(this.resultingTradeId) + ", blockTradeId=" + String.valueOf(this.blockTradeId) + ", originatingTradeId=" + String.valueOf(this.originatingTradeId) + ", productComponentIdentifier=" + String.valueOf(this.productComponentIdentifier) + ", linkedTrade=" + String.valueOf(this.linkedTrade) + "} " + super.toString();
        }
    }

    public static interface PartyTradeIdentifierBuilder
    extends PartyTradeIdentifier,
    TradeIdentifier.TradeIdentifierBuilder {
        public LinkId.LinkIdBuilder getOrCreateLinkId(int var1);

        public List<? extends LinkId.LinkIdBuilder> getLinkId();

        public TradeIdentifier.TradeIdentifierBuilder getOrCreateAllocationTradeId(int var1);

        public List<? extends TradeIdentifier.TradeIdentifierBuilder> getAllocationTradeId();

        public TradeIdentifierExtended.TradeIdentifierExtendedBuilder getOrCreateResultingTradeId(int var1);

        public List<? extends TradeIdentifierExtended.TradeIdentifierExtendedBuilder> getResultingTradeId();

        public TradeIdentifier.TradeIdentifierBuilder getOrCreateBlockTradeId();

        @Override
        public TradeIdentifier.TradeIdentifierBuilder getBlockTradeId();

        public TradeIdentifier.TradeIdentifierBuilder getOrCreateOriginatingTradeId(int var1);

        public List<? extends TradeIdentifier.TradeIdentifierBuilder> getOriginatingTradeId();

        public ProductComponentIdentifier.ProductComponentIdentifierBuilder getOrCreateProductComponentIdentifier(int var1);

        public List<? extends ProductComponentIdentifier.ProductComponentIdentifierBuilder> getProductComponentIdentifier();

        public LinkedTrade.LinkedTradeBuilder getOrCreateLinkedTrade(int var1);

        public List<? extends LinkedTrade.LinkedTradeBuilder> getLinkedTrade();

        @Override
        public PartyTradeIdentifierBuilder setIssuerTradeIdModel(IssuerTradeIdModel var1);

        @Override
        public PartyTradeIdentifierBuilder setTradeIdentifierSequence(TradeIdentifierSequence var1);

        @Override
        public PartyTradeIdentifierBuilder setId(String var1);

        public PartyTradeIdentifierBuilder addLinkId(LinkId var1);

        public PartyTradeIdentifierBuilder addLinkId(LinkId var1, int var2);

        public PartyTradeIdentifierBuilder addLinkId(List<? extends LinkId> var1);

        public PartyTradeIdentifierBuilder setLinkId(List<? extends LinkId> var1);

        public PartyTradeIdentifierBuilder addAllocationTradeId(TradeIdentifier var1);

        public PartyTradeIdentifierBuilder addAllocationTradeId(TradeIdentifier var1, int var2);

        public PartyTradeIdentifierBuilder addAllocationTradeId(List<? extends TradeIdentifier> var1);

        public PartyTradeIdentifierBuilder setAllocationTradeId(List<? extends TradeIdentifier> var1);

        public PartyTradeIdentifierBuilder addResultingTradeId(TradeIdentifierExtended var1);

        public PartyTradeIdentifierBuilder addResultingTradeId(TradeIdentifierExtended var1, int var2);

        public PartyTradeIdentifierBuilder addResultingTradeId(List<? extends TradeIdentifierExtended> var1);

        public PartyTradeIdentifierBuilder setResultingTradeId(List<? extends TradeIdentifierExtended> var1);

        public PartyTradeIdentifierBuilder setBlockTradeId(TradeIdentifier var1);

        public PartyTradeIdentifierBuilder addOriginatingTradeId(TradeIdentifier var1);

        public PartyTradeIdentifierBuilder addOriginatingTradeId(TradeIdentifier var1, int var2);

        public PartyTradeIdentifierBuilder addOriginatingTradeId(List<? extends TradeIdentifier> var1);

        public PartyTradeIdentifierBuilder setOriginatingTradeId(List<? extends TradeIdentifier> var1);

        public PartyTradeIdentifierBuilder addProductComponentIdentifier(ProductComponentIdentifier var1);

        public PartyTradeIdentifierBuilder addProductComponentIdentifier(ProductComponentIdentifier var1, int var2);

        public PartyTradeIdentifierBuilder addProductComponentIdentifier(List<? extends ProductComponentIdentifier> var1);

        public PartyTradeIdentifierBuilder setProductComponentIdentifier(List<? extends ProductComponentIdentifier> var1);

        public PartyTradeIdentifierBuilder addLinkedTrade(LinkedTrade var1);

        public PartyTradeIdentifierBuilder addLinkedTrade(LinkedTrade var1, int var2);

        public PartyTradeIdentifierBuilder addLinkedTrade(List<? extends LinkedTrade> var1);

        public PartyTradeIdentifierBuilder setLinkedTrade(List<? extends LinkedTrade> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("issuerTradeIdModel"), processor, IssuerTradeIdModel.IssuerTradeIdModelBuilder.class, (RosettaModelObjectBuilder)this.getIssuerTradeIdModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeIdentifierSequence"), processor, TradeIdentifierSequence.TradeIdentifierSequenceBuilder.class, (RosettaModelObjectBuilder)this.getTradeIdentifierSequence(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("linkId"), processor, LinkId.LinkIdBuilder.class, this.getLinkId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("allocationTradeId"), processor, TradeIdentifier.TradeIdentifierBuilder.class, this.getAllocationTradeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("resultingTradeId"), processor, TradeIdentifierExtended.TradeIdentifierExtendedBuilder.class, this.getResultingTradeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("blockTradeId"), processor, TradeIdentifier.TradeIdentifierBuilder.class, this.getBlockTradeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("originatingTradeId"), processor, TradeIdentifier.TradeIdentifierBuilder.class, this.getOriginatingTradeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("productComponentIdentifier"), processor, ProductComponentIdentifier.ProductComponentIdentifierBuilder.class, this.getProductComponentIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("linkedTrade"), processor, LinkedTrade.LinkedTradeBuilder.class, this.getLinkedTrade(), new AttributeMeta[0]);
        }

        @Override
        public PartyTradeIdentifierBuilder prune();
    }

    public static class PartyTradeIdentifierImpl
    extends TradeIdentifier.TradeIdentifierImpl
    implements PartyTradeIdentifier {
        private final List<? extends LinkId> linkId;
        private final List<? extends TradeIdentifier> allocationTradeId;
        private final List<? extends TradeIdentifierExtended> resultingTradeId;
        private final TradeIdentifier blockTradeId;
        private final List<? extends TradeIdentifier> originatingTradeId;
        private final List<? extends ProductComponentIdentifier> productComponentIdentifier;
        private final List<? extends LinkedTrade> linkedTrade;

        protected PartyTradeIdentifierImpl(PartyTradeIdentifierBuilder builder) {
            super(builder);
            this.linkId = Optional.ofNullable(builder.getLinkId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.allocationTradeId = Optional.ofNullable(builder.getAllocationTradeId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.resultingTradeId = Optional.ofNullable(builder.getResultingTradeId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.blockTradeId = Optional.ofNullable(builder.getBlockTradeId()).map(f -> f.build()).orElse(null);
            this.originatingTradeId = Optional.ofNullable(builder.getOriginatingTradeId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.productComponentIdentifier = Optional.ofNullable(builder.getProductComponentIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.linkedTrade = Optional.ofNullable(builder.getLinkedTrade()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="linkId")
        @RuneAttribute(value="linkId")
        public List<? extends LinkId> getLinkId() {
            return this.linkId;
        }

        @Override
        @RosettaAttribute(value="allocationTradeId")
        @RuneAttribute(value="allocationTradeId")
        public List<? extends TradeIdentifier> getAllocationTradeId() {
            return this.allocationTradeId;
        }

        @Override
        @RosettaAttribute(value="resultingTradeId")
        @RuneAttribute(value="resultingTradeId")
        public List<? extends TradeIdentifierExtended> getResultingTradeId() {
            return this.resultingTradeId;
        }

        @Override
        @RosettaAttribute(value="blockTradeId")
        @RuneAttribute(value="blockTradeId")
        public TradeIdentifier getBlockTradeId() {
            return this.blockTradeId;
        }

        @Override
        @RosettaAttribute(value="originatingTradeId")
        @RuneAttribute(value="originatingTradeId")
        public List<? extends TradeIdentifier> getOriginatingTradeId() {
            return this.originatingTradeId;
        }

        @Override
        @RosettaAttribute(value="productComponentIdentifier")
        @RuneAttribute(value="productComponentIdentifier")
        public List<? extends ProductComponentIdentifier> getProductComponentIdentifier() {
            return this.productComponentIdentifier;
        }

        @Override
        @RosettaAttribute(value="linkedTrade")
        @RuneAttribute(value="linkedTrade")
        public List<? extends LinkedTrade> getLinkedTrade() {
            return this.linkedTrade;
        }

        @Override
        public PartyTradeIdentifier build() {
            return this;
        }

        @Override
        public PartyTradeIdentifierBuilder toBuilder() {
            PartyTradeIdentifierBuilder builder = PartyTradeIdentifier.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PartyTradeIdentifierBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getLinkId()).ifPresent(builder::setLinkId);
            Optional.ofNullable(this.getAllocationTradeId()).ifPresent(builder::setAllocationTradeId);
            Optional.ofNullable(this.getResultingTradeId()).ifPresent(builder::setResultingTradeId);
            Optional.ofNullable(this.getBlockTradeId()).ifPresent(builder::setBlockTradeId);
            Optional.ofNullable(this.getOriginatingTradeId()).ifPresent(builder::setOriginatingTradeId);
            Optional.ofNullable(this.getProductComponentIdentifier()).ifPresent(builder::setProductComponentIdentifier);
            Optional.ofNullable(this.getLinkedTrade()).ifPresent(builder::setLinkedTrade);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PartyTradeIdentifier _that = (PartyTradeIdentifier)this.getType().cast(o);
            if (!ListEquals.listEquals(this.linkId, _that.getLinkId())) {
                return false;
            }
            if (!ListEquals.listEquals(this.allocationTradeId, _that.getAllocationTradeId())) {
                return false;
            }
            if (!ListEquals.listEquals(this.resultingTradeId, _that.getResultingTradeId())) {
                return false;
            }
            if (!Objects.equals(this.blockTradeId, _that.getBlockTradeId())) {
                return false;
            }
            if (!ListEquals.listEquals(this.originatingTradeId, _that.getOriginatingTradeId())) {
                return false;
            }
            if (!ListEquals.listEquals(this.productComponentIdentifier, _that.getProductComponentIdentifier())) {
                return false;
            }
            return ListEquals.listEquals(this.linkedTrade, _that.getLinkedTrade());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.linkId != null ? this.linkId.hashCode() : 0);
            _result = 31 * _result + (this.allocationTradeId != null ? this.allocationTradeId.hashCode() : 0);
            _result = 31 * _result + (this.resultingTradeId != null ? this.resultingTradeId.hashCode() : 0);
            _result = 31 * _result + (this.blockTradeId != null ? this.blockTradeId.hashCode() : 0);
            _result = 31 * _result + (this.originatingTradeId != null ? this.originatingTradeId.hashCode() : 0);
            _result = 31 * _result + (this.productComponentIdentifier != null ? this.productComponentIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.linkedTrade != null ? this.linkedTrade.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "PartyTradeIdentifier {linkId=" + String.valueOf(this.linkId) + ", allocationTradeId=" + String.valueOf(this.allocationTradeId) + ", resultingTradeId=" + String.valueOf(this.resultingTradeId) + ", blockTradeId=" + String.valueOf(this.blockTradeId) + ", originatingTradeId=" + String.valueOf(this.originatingTradeId) + ", productComponentIdentifier=" + String.valueOf(this.productComponentIdentifier) + ", linkedTrade=" + String.valueOf(this.linkedTrade) + "} " + super.toString();
        }
    }
}

