/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.doc;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.Allocation;
import fpml.consolidated.doc.meta.AllocationsMeta;
import fpml.consolidated.shared.PartyReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Allocations", builder=AllocationsBuilderImpl.class, version="1.2.2")
@RuneDataType(value="Allocations", model="fpml", builder=AllocationsBuilderImpl.class, version="1.2.2")
public interface Allocations
extends RosettaModelObject {
    public static final AllocationsMeta metaData = new AllocationsMeta();

    public PartyReference getAllocatingPartyReference();

    public List<? extends Allocation> getAllocation();

    public Allocations build();

    public AllocationsBuilder toBuilder();

    public static AllocationsBuilder builder() {
        return new AllocationsBuilderImpl();
    }

    default public RosettaMetaData<? extends Allocations> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Allocations> getType() {
        return Allocations.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("allocatingPartyReference"), processor, PartyReference.class, this.getAllocatingPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("allocation"), processor, Allocation.class, this.getAllocation(), new AttributeMeta[0]);
    }

    public static class AllocationsBuilderImpl
    implements AllocationsBuilder {
        protected PartyReference.PartyReferenceBuilder allocatingPartyReference;
        protected List<Allocation.AllocationBuilder> allocation = new ArrayList<Allocation.AllocationBuilder>();

        @Override
        @RosettaAttribute(value="allocatingPartyReference")
        @RuneAttribute(value="allocatingPartyReference")
        public PartyReference.PartyReferenceBuilder getAllocatingPartyReference() {
            return this.allocatingPartyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateAllocatingPartyReference() {
            PartyReference.PartyReferenceBuilder result = this.allocatingPartyReference != null ? this.allocatingPartyReference : (this.allocatingPartyReference = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="allocation")
        @RuneAttribute(value="allocation")
        public List<? extends Allocation.AllocationBuilder> getAllocation() {
            return this.allocation;
        }

        @Override
        public Allocation.AllocationBuilder getOrCreateAllocation(int index) {
            if (this.allocation == null) {
                this.allocation = new ArrayList<Allocation.AllocationBuilder>();
            }
            return (Allocation.AllocationBuilder)this.getIndex(this.allocation, index, () -> {
                Allocation.AllocationBuilder newAllocation = Allocation.builder();
                return newAllocation;
            });
        }

        @Override
        @RosettaAttribute(value="allocatingPartyReference")
        @RuneAttribute(value="allocatingPartyReference")
        public AllocationsBuilder setAllocatingPartyReference(PartyReference _allocatingPartyReference) {
            this.allocatingPartyReference = _allocatingPartyReference == null ? null : _allocatingPartyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="allocation")
        @RuneAttribute(value="allocation")
        public AllocationsBuilder addAllocation(Allocation _allocation) {
            if (_allocation != null) {
                this.allocation.add(_allocation.toBuilder());
            }
            return this;
        }

        @Override
        public AllocationsBuilder addAllocation(Allocation _allocation, int idx) {
            this.getIndex(this.allocation, idx, () -> _allocation.toBuilder());
            return this;
        }

        @Override
        public AllocationsBuilder addAllocation(List<? extends Allocation> allocations) {
            if (allocations != null) {
                for (Allocation allocation : allocations) {
                    this.allocation.add(allocation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="allocation")
        public AllocationsBuilder setAllocation(List<? extends Allocation> allocations) {
            this.allocation = allocations == null ? new ArrayList<Allocation.AllocationBuilder>() : (List)allocations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public Allocations build() {
            return new AllocationsImpl(this);
        }

        @Override
        public AllocationsBuilder toBuilder() {
            return this;
        }

        @Override
        public AllocationsBuilder prune() {
            if (this.allocatingPartyReference != null && !this.allocatingPartyReference.prune().hasData()) {
                this.allocatingPartyReference = null;
            }
            this.allocation = this.allocation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getAllocatingPartyReference() != null && this.getAllocatingPartyReference().hasData()) {
                return true;
            }
            return this.getAllocation() != null && this.getAllocation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public AllocationsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AllocationsBuilder o = (AllocationsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAllocatingPartyReference(), (RosettaModelObjectBuilder)o.getAllocatingPartyReference(), this::setAllocatingPartyReference);
            merger.mergeRosetta(this.getAllocation(), o.getAllocation(), this::getOrCreateAllocation);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Allocations _that = this.getType().cast(o);
            if (!Objects.equals(this.allocatingPartyReference, _that.getAllocatingPartyReference())) {
                return false;
            }
            return ListEquals.listEquals(this.allocation, _that.getAllocation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.allocatingPartyReference != null ? this.allocatingPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.allocation != null ? this.allocation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AllocationsBuilder {allocatingPartyReference=" + String.valueOf(this.allocatingPartyReference) + ", allocation=" + String.valueOf(this.allocation) + "}";
        }
    }

    public static interface AllocationsBuilder
    extends Allocations,
    RosettaModelObjectBuilder {
        public PartyReference.PartyReferenceBuilder getOrCreateAllocatingPartyReference();

        @Override
        public PartyReference.PartyReferenceBuilder getAllocatingPartyReference();

        public Allocation.AllocationBuilder getOrCreateAllocation(int var1);

        public List<? extends Allocation.AllocationBuilder> getAllocation();

        public AllocationsBuilder setAllocatingPartyReference(PartyReference var1);

        public AllocationsBuilder addAllocation(Allocation var1);

        public AllocationsBuilder addAllocation(Allocation var1, int var2);

        public AllocationsBuilder addAllocation(List<? extends Allocation> var1);

        public AllocationsBuilder setAllocation(List<? extends Allocation> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("allocatingPartyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getAllocatingPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("allocation"), processor, Allocation.AllocationBuilder.class, this.getAllocation(), new AttributeMeta[0]);
        }

        public AllocationsBuilder prune();
    }

    public static class AllocationsImpl
    implements Allocations {
        private final PartyReference allocatingPartyReference;
        private final List<? extends Allocation> allocation;

        protected AllocationsImpl(AllocationsBuilder builder) {
            this.allocatingPartyReference = Optional.ofNullable(builder.getAllocatingPartyReference()).map(f -> f.build()).orElse(null);
            this.allocation = Optional.ofNullable(builder.getAllocation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="allocatingPartyReference")
        @RuneAttribute(value="allocatingPartyReference")
        public PartyReference getAllocatingPartyReference() {
            return this.allocatingPartyReference;
        }

        @Override
        @RosettaAttribute(value="allocation")
        @RuneAttribute(value="allocation")
        public List<? extends Allocation> getAllocation() {
            return this.allocation;
        }

        @Override
        public Allocations build() {
            return this;
        }

        @Override
        public AllocationsBuilder toBuilder() {
            AllocationsBuilder builder = Allocations.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AllocationsBuilder builder) {
            Optional.ofNullable(this.getAllocatingPartyReference()).ifPresent(builder::setAllocatingPartyReference);
            Optional.ofNullable(this.getAllocation()).ifPresent(builder::setAllocation);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Allocations _that = this.getType().cast(o);
            if (!Objects.equals(this.allocatingPartyReference, _that.getAllocatingPartyReference())) {
                return false;
            }
            return ListEquals.listEquals(this.allocation, _that.getAllocation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.allocatingPartyReference != null ? this.allocatingPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.allocation != null ? this.allocation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Allocations {allocatingPartyReference=" + String.valueOf(this.allocatingPartyReference) + ", allocation=" + String.valueOf(this.allocation) + "}";
        }
    }
}

