/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.confirmation.processes;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.CompressionModel;
import fpml.consolidated.business.events.CreditLimitInformation;
import fpml.consolidated.business.events.EventValuationModel;
import fpml.consolidated.business.events.TradeChangeContent;
import fpml.consolidated.confirmation.processes.ClearingResultsModel;
import fpml.consolidated.confirmation.processes.meta.ClearingConfirmedMeta;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.msg.CorrelationAndOptionalSequenceModel;
import fpml.consolidated.msg.NotificationMessage;
import fpml.consolidated.msg.NotificationMessageHeader;
import fpml.consolidated.msg.PortfolioReferenceModel;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.PartiesAndAccountsModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ClearingConfirmed", builder=ClearingConfirmedBuilderImpl.class, version="1.2.2")
@RuneDataType(value="ClearingConfirmed", model="fpml", builder=ClearingConfirmedBuilderImpl.class, version="1.2.2")
public interface ClearingConfirmed
extends NotificationMessage {
    public static final ClearingConfirmedMeta metaData = new ClearingConfirmedMeta();

    public CompressionModel getCompressionModel();

    public PortfolioReferenceModel getPortfolioReferenceModel();

    public ClearingResultsModel getClearingResultsModel();

    public TradeChangeContent getChange();

    public EventValuationModel getEventValuationModel();

    public List<? extends CreditLimitInformation> getCreditLimitInformation();

    public PartiesAndAccountsModel getPartiesAndAccountsModel();

    @Override
    public ClearingConfirmed build();

    @Override
    public ClearingConfirmedBuilder toBuilder();

    public static ClearingConfirmedBuilder builder() {
        return new ClearingConfirmedBuilderImpl();
    }

    default public RosettaMetaData<? extends ClearingConfirmed> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ClearingConfirmed> getType() {
        return ClearingConfirmed.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, NotificationMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndOptionalSequenceModel"), processor, CorrelationAndOptionalSequenceModel.class, this.getCorrelationAndOptionalSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("compressionModel"), processor, CompressionModel.class, this.getCompressionModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("portfolioReferenceModel"), processor, PortfolioReferenceModel.class, this.getPortfolioReferenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearingResultsModel"), processor, ClearingResultsModel.class, this.getClearingResultsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("change"), processor, TradeChangeContent.class, this.getChange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("eventValuationModel"), processor, EventValuationModel.class, this.getEventValuationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditLimitInformation"), processor, CreditLimitInformation.class, this.getCreditLimitInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
    }

    public static class ClearingConfirmedBuilderImpl
    extends NotificationMessage.NotificationMessageBuilderImpl
    implements ClearingConfirmedBuilder {
        protected CompressionModel.CompressionModelBuilder compressionModel;
        protected PortfolioReferenceModel.PortfolioReferenceModelBuilder portfolioReferenceModel;
        protected ClearingResultsModel.ClearingResultsModelBuilder clearingResultsModel;
        protected TradeChangeContent.TradeChangeContentBuilder change;
        protected EventValuationModel.EventValuationModelBuilder eventValuationModel;
        protected List<CreditLimitInformation.CreditLimitInformationBuilder> creditLimitInformation = new ArrayList<CreditLimitInformation.CreditLimitInformationBuilder>();
        protected PartiesAndAccountsModel.PartiesAndAccountsModelBuilder partiesAndAccountsModel;

        @Override
        @RosettaAttribute(value="compressionModel")
        @RuneAttribute(value="compressionModel")
        public CompressionModel.CompressionModelBuilder getCompressionModel() {
            return this.compressionModel;
        }

        @Override
        public CompressionModel.CompressionModelBuilder getOrCreateCompressionModel() {
            CompressionModel.CompressionModelBuilder result = this.compressionModel != null ? this.compressionModel : (this.compressionModel = CompressionModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="portfolioReferenceModel")
        @RuneAttribute(value="portfolioReferenceModel")
        public PortfolioReferenceModel.PortfolioReferenceModelBuilder getPortfolioReferenceModel() {
            return this.portfolioReferenceModel;
        }

        @Override
        public PortfolioReferenceModel.PortfolioReferenceModelBuilder getOrCreatePortfolioReferenceModel() {
            PortfolioReferenceModel.PortfolioReferenceModelBuilder result = this.portfolioReferenceModel != null ? this.portfolioReferenceModel : (this.portfolioReferenceModel = PortfolioReferenceModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="clearingResultsModel")
        @RuneAttribute(value="clearingResultsModel")
        public ClearingResultsModel.ClearingResultsModelBuilder getClearingResultsModel() {
            return this.clearingResultsModel;
        }

        @Override
        public ClearingResultsModel.ClearingResultsModelBuilder getOrCreateClearingResultsModel() {
            ClearingResultsModel.ClearingResultsModelBuilder result = this.clearingResultsModel != null ? this.clearingResultsModel : (this.clearingResultsModel = ClearingResultsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="change")
        @RuneAttribute(value="change")
        public TradeChangeContent.TradeChangeContentBuilder getChange() {
            return this.change;
        }

        @Override
        public TradeChangeContent.TradeChangeContentBuilder getOrCreateChange() {
            TradeChangeContent.TradeChangeContentBuilder result = this.change != null ? this.change : (this.change = TradeChangeContent.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventValuationModel")
        @RuneAttribute(value="eventValuationModel")
        public EventValuationModel.EventValuationModelBuilder getEventValuationModel() {
            return this.eventValuationModel;
        }

        @Override
        public EventValuationModel.EventValuationModelBuilder getOrCreateEventValuationModel() {
            EventValuationModel.EventValuationModelBuilder result = this.eventValuationModel != null ? this.eventValuationModel : (this.eventValuationModel = EventValuationModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="creditLimitInformation")
        @RuneAttribute(value="creditLimitInformation")
        public List<? extends CreditLimitInformation.CreditLimitInformationBuilder> getCreditLimitInformation() {
            return this.creditLimitInformation;
        }

        @Override
        public CreditLimitInformation.CreditLimitInformationBuilder getOrCreateCreditLimitInformation(int index) {
            if (this.creditLimitInformation == null) {
                this.creditLimitInformation = new ArrayList<CreditLimitInformation.CreditLimitInformationBuilder>();
            }
            return (CreditLimitInformation.CreditLimitInformationBuilder)this.getIndex(this.creditLimitInformation, index, () -> {
                CreditLimitInformation.CreditLimitInformationBuilder newCreditLimitInformation = CreditLimitInformation.builder();
                return newCreditLimitInformation;
            });
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel() {
            PartiesAndAccountsModel.PartiesAndAccountsModelBuilder result = this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel : (this.partiesAndAccountsModel = PartiesAndAccountsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public ClearingConfirmedBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public ClearingConfirmedBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public ClearingConfirmedBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public ClearingConfirmedBuilder setHeader(NotificationMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public ClearingConfirmedBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndOptionalSequenceModel")
        @RuneAttribute(value="correlationAndOptionalSequenceModel")
        public ClearingConfirmedBuilder setCorrelationAndOptionalSequenceModel(CorrelationAndOptionalSequenceModel _correlationAndOptionalSequenceModel) {
            this.correlationAndOptionalSequenceModel = _correlationAndOptionalSequenceModel == null ? null : _correlationAndOptionalSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public ClearingConfirmedBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="compressionModel")
        @RuneAttribute(value="compressionModel")
        public ClearingConfirmedBuilder setCompressionModel(CompressionModel _compressionModel) {
            this.compressionModel = _compressionModel == null ? null : _compressionModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="portfolioReferenceModel")
        @RuneAttribute(value="portfolioReferenceModel")
        public ClearingConfirmedBuilder setPortfolioReferenceModel(PortfolioReferenceModel _portfolioReferenceModel) {
            this.portfolioReferenceModel = _portfolioReferenceModel == null ? null : _portfolioReferenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingResultsModel")
        @RuneAttribute(value="clearingResultsModel")
        public ClearingConfirmedBuilder setClearingResultsModel(ClearingResultsModel _clearingResultsModel) {
            this.clearingResultsModel = _clearingResultsModel == null ? null : _clearingResultsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="change")
        @RuneAttribute(value="change")
        public ClearingConfirmedBuilder setChange(TradeChangeContent _change) {
            this.change = _change == null ? null : _change.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="eventValuationModel")
        @RuneAttribute(value="eventValuationModel")
        public ClearingConfirmedBuilder setEventValuationModel(EventValuationModel _eventValuationModel) {
            this.eventValuationModel = _eventValuationModel == null ? null : _eventValuationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="creditLimitInformation")
        @RuneAttribute(value="creditLimitInformation")
        public ClearingConfirmedBuilder addCreditLimitInformation(CreditLimitInformation _creditLimitInformation) {
            if (_creditLimitInformation != null) {
                this.creditLimitInformation.add(_creditLimitInformation.toBuilder());
            }
            return this;
        }

        @Override
        public ClearingConfirmedBuilder addCreditLimitInformation(CreditLimitInformation _creditLimitInformation, int idx) {
            this.getIndex(this.creditLimitInformation, idx, () -> _creditLimitInformation.toBuilder());
            return this;
        }

        @Override
        public ClearingConfirmedBuilder addCreditLimitInformation(List<? extends CreditLimitInformation> creditLimitInformations) {
            if (creditLimitInformations != null) {
                for (CreditLimitInformation creditLimitInformation : creditLimitInformations) {
                    this.creditLimitInformation.add(creditLimitInformation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="creditLimitInformation")
        public ClearingConfirmedBuilder setCreditLimitInformation(List<? extends CreditLimitInformation> creditLimitInformations) {
            this.creditLimitInformation = creditLimitInformations == null ? new ArrayList<CreditLimitInformation.CreditLimitInformationBuilder>() : (List)creditLimitInformations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public ClearingConfirmedBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel _partiesAndAccountsModel) {
            this.partiesAndAccountsModel = _partiesAndAccountsModel == null ? null : _partiesAndAccountsModel.toBuilder();
            return this;
        }

        @Override
        public ClearingConfirmed build() {
            return new ClearingConfirmedImpl(this);
        }

        @Override
        public ClearingConfirmedBuilder toBuilder() {
            return this;
        }

        @Override
        public ClearingConfirmedBuilder prune() {
            super.prune();
            if (this.compressionModel != null && !this.compressionModel.prune().hasData()) {
                this.compressionModel = null;
            }
            if (this.portfolioReferenceModel != null && !this.portfolioReferenceModel.prune().hasData()) {
                this.portfolioReferenceModel = null;
            }
            if (this.clearingResultsModel != null && !this.clearingResultsModel.prune().hasData()) {
                this.clearingResultsModel = null;
            }
            if (this.change != null && !this.change.prune().hasData()) {
                this.change = null;
            }
            if (this.eventValuationModel != null && !this.eventValuationModel.prune().hasData()) {
                this.eventValuationModel = null;
            }
            this.creditLimitInformation = this.creditLimitInformation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.partiesAndAccountsModel != null && !this.partiesAndAccountsModel.prune().hasData()) {
                this.partiesAndAccountsModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCompressionModel() != null && this.getCompressionModel().hasData()) {
                return true;
            }
            if (this.getPortfolioReferenceModel() != null && this.getPortfolioReferenceModel().hasData()) {
                return true;
            }
            if (this.getClearingResultsModel() != null && this.getClearingResultsModel().hasData()) {
                return true;
            }
            if (this.getChange() != null && this.getChange().hasData()) {
                return true;
            }
            if (this.getEventValuationModel() != null && this.getEventValuationModel().hasData()) {
                return true;
            }
            if (this.getCreditLimitInformation() != null && this.getCreditLimitInformation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getPartiesAndAccountsModel() != null && this.getPartiesAndAccountsModel().hasData();
        }

        @Override
        public ClearingConfirmedBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ClearingConfirmedBuilder o = (ClearingConfirmedBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCompressionModel(), (RosettaModelObjectBuilder)o.getCompressionModel(), this::setCompressionModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPortfolioReferenceModel(), (RosettaModelObjectBuilder)o.getPortfolioReferenceModel(), this::setPortfolioReferenceModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getClearingResultsModel(), (RosettaModelObjectBuilder)o.getClearingResultsModel(), this::setClearingResultsModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getChange(), (RosettaModelObjectBuilder)o.getChange(), this::setChange);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEventValuationModel(), (RosettaModelObjectBuilder)o.getEventValuationModel(), this::setEventValuationModel);
            merger.mergeRosetta(this.getCreditLimitInformation(), o.getCreditLimitInformation(), this::getOrCreateCreditLimitInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartiesAndAccountsModel(), (RosettaModelObjectBuilder)o.getPartiesAndAccountsModel(), this::setPartiesAndAccountsModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ClearingConfirmed _that = (ClearingConfirmed)this.getType().cast(o);
            if (!Objects.equals(this.compressionModel, _that.getCompressionModel())) {
                return false;
            }
            if (!Objects.equals(this.portfolioReferenceModel, _that.getPortfolioReferenceModel())) {
                return false;
            }
            if (!Objects.equals(this.clearingResultsModel, _that.getClearingResultsModel())) {
                return false;
            }
            if (!Objects.equals(this.change, _that.getChange())) {
                return false;
            }
            if (!Objects.equals(this.eventValuationModel, _that.getEventValuationModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.creditLimitInformation, _that.getCreditLimitInformation())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.compressionModel != null ? this.compressionModel.hashCode() : 0);
            _result = 31 * _result + (this.portfolioReferenceModel != null ? this.portfolioReferenceModel.hashCode() : 0);
            _result = 31 * _result + (this.clearingResultsModel != null ? this.clearingResultsModel.hashCode() : 0);
            _result = 31 * _result + (this.change != null ? this.change.hashCode() : 0);
            _result = 31 * _result + (this.eventValuationModel != null ? this.eventValuationModel.hashCode() : 0);
            _result = 31 * _result + (this.creditLimitInformation != null ? this.creditLimitInformation.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ClearingConfirmedBuilder {compressionModel=" + String.valueOf(this.compressionModel) + ", portfolioReferenceModel=" + String.valueOf(this.portfolioReferenceModel) + ", clearingResultsModel=" + String.valueOf(this.clearingResultsModel) + ", change=" + String.valueOf(this.change) + ", eventValuationModel=" + String.valueOf(this.eventValuationModel) + ", creditLimitInformation=" + String.valueOf(this.creditLimitInformation) + ", partiesAndAccountsModel=" + String.valueOf(this.partiesAndAccountsModel) + "} " + super.toString();
        }
    }

    public static interface ClearingConfirmedBuilder
    extends ClearingConfirmed,
    NotificationMessage.NotificationMessageBuilder {
        public CompressionModel.CompressionModelBuilder getOrCreateCompressionModel();

        @Override
        public CompressionModel.CompressionModelBuilder getCompressionModel();

        public PortfolioReferenceModel.PortfolioReferenceModelBuilder getOrCreatePortfolioReferenceModel();

        @Override
        public PortfolioReferenceModel.PortfolioReferenceModelBuilder getPortfolioReferenceModel();

        public ClearingResultsModel.ClearingResultsModelBuilder getOrCreateClearingResultsModel();

        @Override
        public ClearingResultsModel.ClearingResultsModelBuilder getClearingResultsModel();

        public TradeChangeContent.TradeChangeContentBuilder getOrCreateChange();

        @Override
        public TradeChangeContent.TradeChangeContentBuilder getChange();

        public EventValuationModel.EventValuationModelBuilder getOrCreateEventValuationModel();

        @Override
        public EventValuationModel.EventValuationModelBuilder getEventValuationModel();

        public CreditLimitInformation.CreditLimitInformationBuilder getOrCreateCreditLimitInformation(int var1);

        public List<? extends CreditLimitInformation.CreditLimitInformationBuilder> getCreditLimitInformation();

        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel();

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel();

        @Override
        public ClearingConfirmedBuilder setFpmlVersion(String var1);

        @Override
        public ClearingConfirmedBuilder setExpectedBuild(Integer var1);

        @Override
        public ClearingConfirmedBuilder setActualBuild(Integer var1);

        @Override
        public ClearingConfirmedBuilder setHeader(NotificationMessageHeader var1);

        @Override
        public ClearingConfirmedBuilder setValidationModel(ValidationModel var1);

        @Override
        public ClearingConfirmedBuilder setCorrelationAndOptionalSequenceModel(CorrelationAndOptionalSequenceModel var1);

        @Override
        public ClearingConfirmedBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public ClearingConfirmedBuilder setCompressionModel(CompressionModel var1);

        public ClearingConfirmedBuilder setPortfolioReferenceModel(PortfolioReferenceModel var1);

        public ClearingConfirmedBuilder setClearingResultsModel(ClearingResultsModel var1);

        public ClearingConfirmedBuilder setChange(TradeChangeContent var1);

        public ClearingConfirmedBuilder setEventValuationModel(EventValuationModel var1);

        public ClearingConfirmedBuilder addCreditLimitInformation(CreditLimitInformation var1);

        public ClearingConfirmedBuilder addCreditLimitInformation(CreditLimitInformation var1, int var2);

        public ClearingConfirmedBuilder addCreditLimitInformation(List<? extends CreditLimitInformation> var1);

        public ClearingConfirmedBuilder setCreditLimitInformation(List<? extends CreditLimitInformation> var1);

        public ClearingConfirmedBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, NotificationMessageHeader.NotificationMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndOptionalSequenceModel"), processor, CorrelationAndOptionalSequenceModel.CorrelationAndOptionalSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndOptionalSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("compressionModel"), processor, CompressionModel.CompressionModelBuilder.class, this.getCompressionModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("portfolioReferenceModel"), processor, PortfolioReferenceModel.PortfolioReferenceModelBuilder.class, this.getPortfolioReferenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearingResultsModel"), processor, ClearingResultsModel.ClearingResultsModelBuilder.class, this.getClearingResultsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("change"), processor, TradeChangeContent.TradeChangeContentBuilder.class, this.getChange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("eventValuationModel"), processor, EventValuationModel.EventValuationModelBuilder.class, this.getEventValuationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditLimitInformation"), processor, CreditLimitInformation.CreditLimitInformationBuilder.class, this.getCreditLimitInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.PartiesAndAccountsModelBuilder.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
        }

        @Override
        public ClearingConfirmedBuilder prune();
    }

    public static class ClearingConfirmedImpl
    extends NotificationMessage.NotificationMessageImpl
    implements ClearingConfirmed {
        private final CompressionModel compressionModel;
        private final PortfolioReferenceModel portfolioReferenceModel;
        private final ClearingResultsModel clearingResultsModel;
        private final TradeChangeContent change;
        private final EventValuationModel eventValuationModel;
        private final List<? extends CreditLimitInformation> creditLimitInformation;
        private final PartiesAndAccountsModel partiesAndAccountsModel;

        protected ClearingConfirmedImpl(ClearingConfirmedBuilder builder) {
            super(builder);
            this.compressionModel = Optional.ofNullable(builder.getCompressionModel()).map(f -> f.build()).orElse(null);
            this.portfolioReferenceModel = Optional.ofNullable(builder.getPortfolioReferenceModel()).map(f -> f.build()).orElse(null);
            this.clearingResultsModel = Optional.ofNullable(builder.getClearingResultsModel()).map(f -> f.build()).orElse(null);
            this.change = Optional.ofNullable(builder.getChange()).map(f -> f.build()).orElse(null);
            this.eventValuationModel = Optional.ofNullable(builder.getEventValuationModel()).map(f -> f.build()).orElse(null);
            this.creditLimitInformation = Optional.ofNullable(builder.getCreditLimitInformation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.partiesAndAccountsModel = Optional.ofNullable(builder.getPartiesAndAccountsModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="compressionModel")
        @RuneAttribute(value="compressionModel")
        public CompressionModel getCompressionModel() {
            return this.compressionModel;
        }

        @Override
        @RosettaAttribute(value="portfolioReferenceModel")
        @RuneAttribute(value="portfolioReferenceModel")
        public PortfolioReferenceModel getPortfolioReferenceModel() {
            return this.portfolioReferenceModel;
        }

        @Override
        @RosettaAttribute(value="clearingResultsModel")
        @RuneAttribute(value="clearingResultsModel")
        public ClearingResultsModel getClearingResultsModel() {
            return this.clearingResultsModel;
        }

        @Override
        @RosettaAttribute(value="change")
        @RuneAttribute(value="change")
        public TradeChangeContent getChange() {
            return this.change;
        }

        @Override
        @RosettaAttribute(value="eventValuationModel")
        @RuneAttribute(value="eventValuationModel")
        public EventValuationModel getEventValuationModel() {
            return this.eventValuationModel;
        }

        @Override
        @RosettaAttribute(value="creditLimitInformation")
        @RuneAttribute(value="creditLimitInformation")
        public List<? extends CreditLimitInformation> getCreditLimitInformation() {
            return this.creditLimitInformation;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public PartiesAndAccountsModel getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public ClearingConfirmed build() {
            return this;
        }

        @Override
        public ClearingConfirmedBuilder toBuilder() {
            ClearingConfirmedBuilder builder = ClearingConfirmed.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ClearingConfirmedBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCompressionModel()).ifPresent(builder::setCompressionModel);
            Optional.ofNullable(this.getPortfolioReferenceModel()).ifPresent(builder::setPortfolioReferenceModel);
            Optional.ofNullable(this.getClearingResultsModel()).ifPresent(builder::setClearingResultsModel);
            Optional.ofNullable(this.getChange()).ifPresent(builder::setChange);
            Optional.ofNullable(this.getEventValuationModel()).ifPresent(builder::setEventValuationModel);
            Optional.ofNullable(this.getCreditLimitInformation()).ifPresent(builder::setCreditLimitInformation);
            Optional.ofNullable(this.getPartiesAndAccountsModel()).ifPresent(builder::setPartiesAndAccountsModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ClearingConfirmed _that = (ClearingConfirmed)this.getType().cast(o);
            if (!Objects.equals(this.compressionModel, _that.getCompressionModel())) {
                return false;
            }
            if (!Objects.equals(this.portfolioReferenceModel, _that.getPortfolioReferenceModel())) {
                return false;
            }
            if (!Objects.equals(this.clearingResultsModel, _that.getClearingResultsModel())) {
                return false;
            }
            if (!Objects.equals(this.change, _that.getChange())) {
                return false;
            }
            if (!Objects.equals(this.eventValuationModel, _that.getEventValuationModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.creditLimitInformation, _that.getCreditLimitInformation())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.compressionModel != null ? this.compressionModel.hashCode() : 0);
            _result = 31 * _result + (this.portfolioReferenceModel != null ? this.portfolioReferenceModel.hashCode() : 0);
            _result = 31 * _result + (this.clearingResultsModel != null ? this.clearingResultsModel.hashCode() : 0);
            _result = 31 * _result + (this.change != null ? this.change.hashCode() : 0);
            _result = 31 * _result + (this.eventValuationModel != null ? this.eventValuationModel.hashCode() : 0);
            _result = 31 * _result + (this.creditLimitInformation != null ? this.creditLimitInformation.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ClearingConfirmed {compressionModel=" + String.valueOf(this.compressionModel) + ", portfolioReferenceModel=" + String.valueOf(this.portfolioReferenceModel) + ", clearingResultsModel=" + String.valueOf(this.clearingResultsModel) + ", change=" + String.valueOf(this.change) + ", eventValuationModel=" + String.valueOf(this.eventValuationModel) + ", creditLimitInformation=" + String.valueOf(this.creditLimitInformation) + ", partiesAndAccountsModel=" + String.valueOf(this.partiesAndAccountsModel) + "} " + super.toString();
        }
    }
}

