/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.asset.CommodityBusinessCalendar;
import fpml.consolidated.com.SettlementPeriodsSequence;
import fpml.consolidated.com.meta.SettlementPeriodsMeta;
import fpml.consolidated.fpmlenum.DayOfWeekExtEnum;
import fpml.consolidated.fpmlenum.SettlementPeriodDurationEnum;
import fpml.consolidated.shared.OffsetPrevailingTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="SettlementPeriods", builder=SettlementPeriodsBuilderImpl.class, version="1.2.2")
@RuneDataType(value="SettlementPeriods", model="fpml", builder=SettlementPeriodsBuilderImpl.class, version="1.2.2")
public interface SettlementPeriods
extends RosettaModelObject {
    public static final SettlementPeriodsMeta metaData = new SettlementPeriodsMeta();

    public SettlementPeriodDurationEnum getDuration();

    public List<DayOfWeekExtEnum> getApplicableDay();

    public SettlementPeriodsSequence getSettlementPeriodsSequence();

    public CommodityBusinessCalendar getExcludeHolidays();

    public CommodityBusinessCalendar getIncludeHolidays();

    public String getId();

    public OffsetPrevailingTime getStartTime();

    public OffsetPrevailingTime getEndTime();

    public LocalTime getTimeDuration();

    public SettlementPeriods build();

    public SettlementPeriodsBuilder toBuilder();

    public static SettlementPeriodsBuilder builder() {
        return new SettlementPeriodsBuilderImpl();
    }

    default public RosettaMetaData<? extends SettlementPeriods> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends SettlementPeriods> getType() {
        return SettlementPeriods.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("duration"), SettlementPeriodDurationEnum.class, (Object)this.getDuration(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("applicableDay"), DayOfWeekExtEnum.class, this.getApplicableDay(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementPeriodsSequence"), processor, SettlementPeriodsSequence.class, this.getSettlementPeriodsSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("excludeHolidays"), processor, CommodityBusinessCalendar.class, this.getExcludeHolidays(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("includeHolidays"), processor, CommodityBusinessCalendar.class, this.getIncludeHolidays(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("startTime"), processor, OffsetPrevailingTime.class, this.getStartTime(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("endTime"), processor, OffsetPrevailingTime.class, this.getEndTime(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("timeDuration"), LocalTime.class, (Object)this.getTimeDuration(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class SettlementPeriodsBuilderImpl
    implements SettlementPeriodsBuilder {
        protected SettlementPeriodDurationEnum duration;
        protected List<DayOfWeekExtEnum> applicableDay = new ArrayList<DayOfWeekExtEnum>();
        protected SettlementPeriodsSequence.SettlementPeriodsSequenceBuilder settlementPeriodsSequence;
        protected CommodityBusinessCalendar.CommodityBusinessCalendarBuilder excludeHolidays;
        protected CommodityBusinessCalendar.CommodityBusinessCalendarBuilder includeHolidays;
        protected String id;
        protected OffsetPrevailingTime.OffsetPrevailingTimeBuilder startTime;
        protected OffsetPrevailingTime.OffsetPrevailingTimeBuilder endTime;
        protected LocalTime timeDuration;

        @Override
        @RosettaAttribute(value="duration")
        @RuneAttribute(value="duration")
        public SettlementPeriodDurationEnum getDuration() {
            return this.duration;
        }

        @Override
        @RosettaAttribute(value="applicableDay")
        @RuneAttribute(value="applicableDay")
        public List<DayOfWeekExtEnum> getApplicableDay() {
            return this.applicableDay;
        }

        @Override
        @RosettaAttribute(value="settlementPeriodsSequence")
        @RuneAttribute(value="settlementPeriodsSequence")
        public SettlementPeriodsSequence.SettlementPeriodsSequenceBuilder getSettlementPeriodsSequence() {
            return this.settlementPeriodsSequence;
        }

        @Override
        public SettlementPeriodsSequence.SettlementPeriodsSequenceBuilder getOrCreateSettlementPeriodsSequence() {
            SettlementPeriodsSequence.SettlementPeriodsSequenceBuilder result = this.settlementPeriodsSequence != null ? this.settlementPeriodsSequence : (this.settlementPeriodsSequence = SettlementPeriodsSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="excludeHolidays")
        @RuneAttribute(value="excludeHolidays")
        public CommodityBusinessCalendar.CommodityBusinessCalendarBuilder getExcludeHolidays() {
            return this.excludeHolidays;
        }

        @Override
        public CommodityBusinessCalendar.CommodityBusinessCalendarBuilder getOrCreateExcludeHolidays() {
            CommodityBusinessCalendar.CommodityBusinessCalendarBuilder result = this.excludeHolidays != null ? this.excludeHolidays : (this.excludeHolidays = CommodityBusinessCalendar.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="includeHolidays")
        @RuneAttribute(value="includeHolidays")
        public CommodityBusinessCalendar.CommodityBusinessCalendarBuilder getIncludeHolidays() {
            return this.includeHolidays;
        }

        @Override
        public CommodityBusinessCalendar.CommodityBusinessCalendarBuilder getOrCreateIncludeHolidays() {
            CommodityBusinessCalendar.CommodityBusinessCalendarBuilder result = this.includeHolidays != null ? this.includeHolidays : (this.includeHolidays = CommodityBusinessCalendar.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="startTime", isRequired=true)
        @RuneAttribute(value="startTime", isRequired=true)
        public OffsetPrevailingTime.OffsetPrevailingTimeBuilder getStartTime() {
            return this.startTime;
        }

        @Override
        public OffsetPrevailingTime.OffsetPrevailingTimeBuilder getOrCreateStartTime() {
            OffsetPrevailingTime.OffsetPrevailingTimeBuilder result = this.startTime != null ? this.startTime : (this.startTime = OffsetPrevailingTime.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="endTime", isRequired=true)
        @RuneAttribute(value="endTime", isRequired=true)
        public OffsetPrevailingTime.OffsetPrevailingTimeBuilder getEndTime() {
            return this.endTime;
        }

        @Override
        public OffsetPrevailingTime.OffsetPrevailingTimeBuilder getOrCreateEndTime() {
            OffsetPrevailingTime.OffsetPrevailingTimeBuilder result = this.endTime != null ? this.endTime : (this.endTime = OffsetPrevailingTime.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="timeDuration")
        @RuneAttribute(value="timeDuration")
        public LocalTime getTimeDuration() {
            return this.timeDuration;
        }

        @Override
        @RosettaAttribute(value="duration")
        @RuneAttribute(value="duration")
        public SettlementPeriodsBuilder setDuration(SettlementPeriodDurationEnum _duration) {
            this.duration = _duration == null ? null : _duration;
            return this;
        }

        @Override
        @RosettaAttribute(value="applicableDay")
        @RuneAttribute(value="applicableDay")
        public SettlementPeriodsBuilder addApplicableDay(DayOfWeekExtEnum _applicableDay) {
            if (_applicableDay != null) {
                this.applicableDay.add(_applicableDay);
            }
            return this;
        }

        @Override
        public SettlementPeriodsBuilder addApplicableDay(DayOfWeekExtEnum _applicableDay, int idx) {
            this.getIndex(this.applicableDay, idx, () -> _applicableDay);
            return this;
        }

        @Override
        public SettlementPeriodsBuilder addApplicableDay(List<DayOfWeekExtEnum> applicableDays) {
            if (applicableDays != null) {
                for (DayOfWeekExtEnum toAdd : applicableDays) {
                    this.applicableDay.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="applicableDay")
        public SettlementPeriodsBuilder setApplicableDay(List<DayOfWeekExtEnum> applicableDays) {
            this.applicableDay = applicableDays == null ? new ArrayList<DayOfWeekExtEnum>() : (List)applicableDays.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementPeriodsSequence")
        @RuneAttribute(value="settlementPeriodsSequence")
        public SettlementPeriodsBuilder setSettlementPeriodsSequence(SettlementPeriodsSequence _settlementPeriodsSequence) {
            this.settlementPeriodsSequence = _settlementPeriodsSequence == null ? null : _settlementPeriodsSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="excludeHolidays")
        @RuneAttribute(value="excludeHolidays")
        public SettlementPeriodsBuilder setExcludeHolidays(CommodityBusinessCalendar _excludeHolidays) {
            this.excludeHolidays = _excludeHolidays == null ? null : _excludeHolidays.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="includeHolidays")
        @RuneAttribute(value="includeHolidays")
        public SettlementPeriodsBuilder setIncludeHolidays(CommodityBusinessCalendar _includeHolidays) {
            this.includeHolidays = _includeHolidays == null ? null : _includeHolidays.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public SettlementPeriodsBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="startTime", isRequired=true)
        @RuneAttribute(value="startTime", isRequired=true)
        public SettlementPeriodsBuilder setStartTime(OffsetPrevailingTime _startTime) {
            this.startTime = _startTime == null ? null : _startTime.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="endTime", isRequired=true)
        @RuneAttribute(value="endTime", isRequired=true)
        public SettlementPeriodsBuilder setEndTime(OffsetPrevailingTime _endTime) {
            this.endTime = _endTime == null ? null : _endTime.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="timeDuration")
        @RuneAttribute(value="timeDuration")
        public SettlementPeriodsBuilder setTimeDuration(LocalTime _timeDuration) {
            this.timeDuration = _timeDuration == null ? null : _timeDuration;
            return this;
        }

        @Override
        public SettlementPeriods build() {
            return new SettlementPeriodsImpl(this);
        }

        @Override
        public SettlementPeriodsBuilder toBuilder() {
            return this;
        }

        @Override
        public SettlementPeriodsBuilder prune() {
            if (this.settlementPeriodsSequence != null && !this.settlementPeriodsSequence.prune().hasData()) {
                this.settlementPeriodsSequence = null;
            }
            if (this.excludeHolidays != null && !this.excludeHolidays.prune().hasData()) {
                this.excludeHolidays = null;
            }
            if (this.includeHolidays != null && !this.includeHolidays.prune().hasData()) {
                this.includeHolidays = null;
            }
            if (this.startTime != null && !this.startTime.prune().hasData()) {
                this.startTime = null;
            }
            if (this.endTime != null && !this.endTime.prune().hasData()) {
                this.endTime = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getDuration() != null) {
                return true;
            }
            if (this.getApplicableDay() != null && !this.getApplicableDay().isEmpty()) {
                return true;
            }
            if (this.getSettlementPeriodsSequence() != null && this.getSettlementPeriodsSequence().hasData()) {
                return true;
            }
            if (this.getExcludeHolidays() != null && this.getExcludeHolidays().hasData()) {
                return true;
            }
            if (this.getIncludeHolidays() != null && this.getIncludeHolidays().hasData()) {
                return true;
            }
            if (this.getId() != null) {
                return true;
            }
            if (this.getStartTime() != null && this.getStartTime().hasData()) {
                return true;
            }
            if (this.getEndTime() != null && this.getEndTime().hasData()) {
                return true;
            }
            return this.getTimeDuration() != null;
        }

        public SettlementPeriodsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            SettlementPeriodsBuilder o = (SettlementPeriodsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementPeriodsSequence(), (RosettaModelObjectBuilder)o.getSettlementPeriodsSequence(), this::setSettlementPeriodsSequence);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExcludeHolidays(), (RosettaModelObjectBuilder)o.getExcludeHolidays(), this::setExcludeHolidays);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIncludeHolidays(), (RosettaModelObjectBuilder)o.getIncludeHolidays(), this::setIncludeHolidays);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStartTime(), (RosettaModelObjectBuilder)o.getStartTime(), this::setStartTime);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEndTime(), (RosettaModelObjectBuilder)o.getEndTime(), this::setEndTime);
            merger.mergeBasic((Object)this.getDuration(), (Object)o.getDuration(), this::setDuration, new AttributeMeta[0]);
            merger.mergeBasic(this.getApplicableDay(), o.getApplicableDay(), this::addApplicableDay);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTimeDuration(), (Object)o.getTimeDuration(), this::setTimeDuration, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SettlementPeriods _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.duration, (Object)_that.getDuration())) {
                return false;
            }
            if (!ListEquals.listEquals(this.applicableDay, _that.getApplicableDay())) {
                return false;
            }
            if (!Objects.equals(this.settlementPeriodsSequence, _that.getSettlementPeriodsSequence())) {
                return false;
            }
            if (!Objects.equals(this.excludeHolidays, _that.getExcludeHolidays())) {
                return false;
            }
            if (!Objects.equals(this.includeHolidays, _that.getIncludeHolidays())) {
                return false;
            }
            if (!Objects.equals(this.id, _that.getId())) {
                return false;
            }
            if (!Objects.equals(this.startTime, _that.getStartTime())) {
                return false;
            }
            if (!Objects.equals(this.endTime, _that.getEndTime())) {
                return false;
            }
            return Objects.equals(this.timeDuration, _that.getTimeDuration());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.duration != null ? ((Object)((Object)this.duration)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.applicableDay != null ? this.applicableDay.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.settlementPeriodsSequence != null ? this.settlementPeriodsSequence.hashCode() : 0);
            _result = 31 * _result + (this.excludeHolidays != null ? this.excludeHolidays.hashCode() : 0);
            _result = 31 * _result + (this.includeHolidays != null ? this.includeHolidays.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            _result = 31 * _result + (this.startTime != null ? this.startTime.hashCode() : 0);
            _result = 31 * _result + (this.endTime != null ? this.endTime.hashCode() : 0);
            _result = 31 * _result + (this.timeDuration != null ? this.timeDuration.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SettlementPeriodsBuilder {duration=" + String.valueOf((Object)this.duration) + ", applicableDay=" + String.valueOf(this.applicableDay) + ", settlementPeriodsSequence=" + String.valueOf(this.settlementPeriodsSequence) + ", excludeHolidays=" + String.valueOf(this.excludeHolidays) + ", includeHolidays=" + String.valueOf(this.includeHolidays) + ", id=" + this.id + ", startTime=" + String.valueOf(this.startTime) + ", endTime=" + String.valueOf(this.endTime) + ", timeDuration=" + String.valueOf(this.timeDuration) + "}";
        }
    }

    public static interface SettlementPeriodsBuilder
    extends SettlementPeriods,
    RosettaModelObjectBuilder {
        public SettlementPeriodsSequence.SettlementPeriodsSequenceBuilder getOrCreateSettlementPeriodsSequence();

        @Override
        public SettlementPeriodsSequence.SettlementPeriodsSequenceBuilder getSettlementPeriodsSequence();

        public CommodityBusinessCalendar.CommodityBusinessCalendarBuilder getOrCreateExcludeHolidays();

        @Override
        public CommodityBusinessCalendar.CommodityBusinessCalendarBuilder getExcludeHolidays();

        public CommodityBusinessCalendar.CommodityBusinessCalendarBuilder getOrCreateIncludeHolidays();

        @Override
        public CommodityBusinessCalendar.CommodityBusinessCalendarBuilder getIncludeHolidays();

        public OffsetPrevailingTime.OffsetPrevailingTimeBuilder getOrCreateStartTime();

        @Override
        public OffsetPrevailingTime.OffsetPrevailingTimeBuilder getStartTime();

        public OffsetPrevailingTime.OffsetPrevailingTimeBuilder getOrCreateEndTime();

        @Override
        public OffsetPrevailingTime.OffsetPrevailingTimeBuilder getEndTime();

        public SettlementPeriodsBuilder setDuration(SettlementPeriodDurationEnum var1);

        public SettlementPeriodsBuilder addApplicableDay(DayOfWeekExtEnum var1);

        public SettlementPeriodsBuilder addApplicableDay(DayOfWeekExtEnum var1, int var2);

        public SettlementPeriodsBuilder addApplicableDay(List<DayOfWeekExtEnum> var1);

        public SettlementPeriodsBuilder setApplicableDay(List<DayOfWeekExtEnum> var1);

        public SettlementPeriodsBuilder setSettlementPeriodsSequence(SettlementPeriodsSequence var1);

        public SettlementPeriodsBuilder setExcludeHolidays(CommodityBusinessCalendar var1);

        public SettlementPeriodsBuilder setIncludeHolidays(CommodityBusinessCalendar var1);

        public SettlementPeriodsBuilder setId(String var1);

        public SettlementPeriodsBuilder setStartTime(OffsetPrevailingTime var1);

        public SettlementPeriodsBuilder setEndTime(OffsetPrevailingTime var1);

        public SettlementPeriodsBuilder setTimeDuration(LocalTime var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("duration"), SettlementPeriodDurationEnum.class, (Object)this.getDuration(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("applicableDay"), DayOfWeekExtEnum.class, this.getApplicableDay(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementPeriodsSequence"), processor, SettlementPeriodsSequence.SettlementPeriodsSequenceBuilder.class, this.getSettlementPeriodsSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("excludeHolidays"), processor, CommodityBusinessCalendar.CommodityBusinessCalendarBuilder.class, this.getExcludeHolidays(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("includeHolidays"), processor, CommodityBusinessCalendar.CommodityBusinessCalendarBuilder.class, this.getIncludeHolidays(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("startTime"), processor, OffsetPrevailingTime.OffsetPrevailingTimeBuilder.class, this.getStartTime(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("endTime"), processor, OffsetPrevailingTime.OffsetPrevailingTimeBuilder.class, this.getEndTime(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("timeDuration"), LocalTime.class, (Object)this.getTimeDuration(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public SettlementPeriodsBuilder prune();
    }

    public static class SettlementPeriodsImpl
    implements SettlementPeriods {
        private final SettlementPeriodDurationEnum duration;
        private final List<DayOfWeekExtEnum> applicableDay;
        private final SettlementPeriodsSequence settlementPeriodsSequence;
        private final CommodityBusinessCalendar excludeHolidays;
        private final CommodityBusinessCalendar includeHolidays;
        private final String id;
        private final OffsetPrevailingTime startTime;
        private final OffsetPrevailingTime endTime;
        private final LocalTime timeDuration;

        protected SettlementPeriodsImpl(SettlementPeriodsBuilder builder) {
            this.duration = builder.getDuration();
            this.applicableDay = Optional.ofNullable(builder.getApplicableDay()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.settlementPeriodsSequence = Optional.ofNullable(builder.getSettlementPeriodsSequence()).map(f -> f.build()).orElse(null);
            this.excludeHolidays = Optional.ofNullable(builder.getExcludeHolidays()).map(f -> f.build()).orElse(null);
            this.includeHolidays = Optional.ofNullable(builder.getIncludeHolidays()).map(f -> f.build()).orElse(null);
            this.id = builder.getId();
            this.startTime = Optional.ofNullable(builder.getStartTime()).map(f -> f.build()).orElse(null);
            this.endTime = Optional.ofNullable(builder.getEndTime()).map(f -> f.build()).orElse(null);
            this.timeDuration = builder.getTimeDuration();
        }

        @Override
        @RosettaAttribute(value="duration")
        @RuneAttribute(value="duration")
        public SettlementPeriodDurationEnum getDuration() {
            return this.duration;
        }

        @Override
        @RosettaAttribute(value="applicableDay")
        @RuneAttribute(value="applicableDay")
        public List<DayOfWeekExtEnum> getApplicableDay() {
            return this.applicableDay;
        }

        @Override
        @RosettaAttribute(value="settlementPeriodsSequence")
        @RuneAttribute(value="settlementPeriodsSequence")
        public SettlementPeriodsSequence getSettlementPeriodsSequence() {
            return this.settlementPeriodsSequence;
        }

        @Override
        @RosettaAttribute(value="excludeHolidays")
        @RuneAttribute(value="excludeHolidays")
        public CommodityBusinessCalendar getExcludeHolidays() {
            return this.excludeHolidays;
        }

        @Override
        @RosettaAttribute(value="includeHolidays")
        @RuneAttribute(value="includeHolidays")
        public CommodityBusinessCalendar getIncludeHolidays() {
            return this.includeHolidays;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="startTime", isRequired=true)
        @RuneAttribute(value="startTime", isRequired=true)
        public OffsetPrevailingTime getStartTime() {
            return this.startTime;
        }

        @Override
        @RosettaAttribute(value="endTime", isRequired=true)
        @RuneAttribute(value="endTime", isRequired=true)
        public OffsetPrevailingTime getEndTime() {
            return this.endTime;
        }

        @Override
        @RosettaAttribute(value="timeDuration")
        @RuneAttribute(value="timeDuration")
        public LocalTime getTimeDuration() {
            return this.timeDuration;
        }

        @Override
        public SettlementPeriods build() {
            return this;
        }

        @Override
        public SettlementPeriodsBuilder toBuilder() {
            SettlementPeriodsBuilder builder = SettlementPeriods.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SettlementPeriodsBuilder builder) {
            Optional.ofNullable(this.getDuration()).ifPresent(builder::setDuration);
            Optional.ofNullable(this.getApplicableDay()).ifPresent(builder::setApplicableDay);
            Optional.ofNullable(this.getSettlementPeriodsSequence()).ifPresent(builder::setSettlementPeriodsSequence);
            Optional.ofNullable(this.getExcludeHolidays()).ifPresent(builder::setExcludeHolidays);
            Optional.ofNullable(this.getIncludeHolidays()).ifPresent(builder::setIncludeHolidays);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
            Optional.ofNullable(this.getStartTime()).ifPresent(builder::setStartTime);
            Optional.ofNullable(this.getEndTime()).ifPresent(builder::setEndTime);
            Optional.ofNullable(this.getTimeDuration()).ifPresent(builder::setTimeDuration);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SettlementPeriods _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.duration, (Object)_that.getDuration())) {
                return false;
            }
            if (!ListEquals.listEquals(this.applicableDay, _that.getApplicableDay())) {
                return false;
            }
            if (!Objects.equals(this.settlementPeriodsSequence, _that.getSettlementPeriodsSequence())) {
                return false;
            }
            if (!Objects.equals(this.excludeHolidays, _that.getExcludeHolidays())) {
                return false;
            }
            if (!Objects.equals(this.includeHolidays, _that.getIncludeHolidays())) {
                return false;
            }
            if (!Objects.equals(this.id, _that.getId())) {
                return false;
            }
            if (!Objects.equals(this.startTime, _that.getStartTime())) {
                return false;
            }
            if (!Objects.equals(this.endTime, _that.getEndTime())) {
                return false;
            }
            return Objects.equals(this.timeDuration, _that.getTimeDuration());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.duration != null ? ((Object)((Object)this.duration)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.applicableDay != null ? this.applicableDay.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.settlementPeriodsSequence != null ? this.settlementPeriodsSequence.hashCode() : 0);
            _result = 31 * _result + (this.excludeHolidays != null ? this.excludeHolidays.hashCode() : 0);
            _result = 31 * _result + (this.includeHolidays != null ? this.includeHolidays.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            _result = 31 * _result + (this.startTime != null ? this.startTime.hashCode() : 0);
            _result = 31 * _result + (this.endTime != null ? this.endTime.hashCode() : 0);
            _result = 31 * _result + (this.timeDuration != null ? this.timeDuration.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SettlementPeriods {duration=" + String.valueOf((Object)this.duration) + ", applicableDay=" + String.valueOf(this.applicableDay) + ", settlementPeriodsSequence=" + String.valueOf(this.settlementPeriodsSequence) + ", excludeHolidays=" + String.valueOf(this.excludeHolidays) + ", includeHolidays=" + String.valueOf(this.includeHolidays) + ", id=" + this.id + ", startTime=" + String.valueOf(this.startTime) + ", endTime=" + String.valueOf(this.endTime) + ", timeDuration=" + String.valueOf(this.timeDuration) + "}";
        }
    }
}

