/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.com.CommodityPricingDates;
import fpml.consolidated.com.CommodityValuationDates;
import fpml.consolidated.com.meta.CommodityVarianceCalculationMeta;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CommodityVarianceCalculation", builder=CommodityVarianceCalculationBuilderImpl.class, version="1.2.2")
@RuneDataType(value="CommodityVarianceCalculation", model="fpml", builder=CommodityVarianceCalculationBuilderImpl.class, version="1.2.2")
public interface CommodityVarianceCalculation
extends RosettaModelObject {
    public static final CommodityVarianceCalculationMeta metaData = new CommodityVarianceCalculationMeta();

    public CommodityPricingDates getPricingDates();

    public CommodityValuationDates getValuationDates();

    public BigDecimal getAnnualizationFactor();

    public Boolean getNAdjustment();

    public CommodityVarianceCalculation build();

    public CommodityVarianceCalculationBuilder toBuilder();

    public static CommodityVarianceCalculationBuilder builder() {
        return new CommodityVarianceCalculationBuilderImpl();
    }

    default public RosettaMetaData<? extends CommodityVarianceCalculation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommodityVarianceCalculation> getType() {
        return CommodityVarianceCalculation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("pricingDates"), processor, CommodityPricingDates.class, this.getPricingDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("valuationDates"), processor, CommodityValuationDates.class, this.getValuationDates(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("annualizationFactor"), BigDecimal.class, (Object)this.getAnnualizationFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nAdjustment"), Boolean.class, (Object)this.getNAdjustment(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CommodityVarianceCalculationBuilderImpl
    implements CommodityVarianceCalculationBuilder {
        protected CommodityPricingDates.CommodityPricingDatesBuilder pricingDates;
        protected CommodityValuationDates.CommodityValuationDatesBuilder valuationDates;
        protected BigDecimal annualizationFactor;
        protected Boolean nAdjustment;

        @Override
        @RosettaAttribute(value="pricingDates")
        @RuneAttribute(value="pricingDates")
        public CommodityPricingDates.CommodityPricingDatesBuilder getPricingDates() {
            return this.pricingDates;
        }

        @Override
        public CommodityPricingDates.CommodityPricingDatesBuilder getOrCreatePricingDates() {
            CommodityPricingDates.CommodityPricingDatesBuilder result = this.pricingDates != null ? this.pricingDates : (this.pricingDates = CommodityPricingDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="valuationDates")
        @RuneAttribute(value="valuationDates")
        public CommodityValuationDates.CommodityValuationDatesBuilder getValuationDates() {
            return this.valuationDates;
        }

        @Override
        public CommodityValuationDates.CommodityValuationDatesBuilder getOrCreateValuationDates() {
            CommodityValuationDates.CommodityValuationDatesBuilder result = this.valuationDates != null ? this.valuationDates : (this.valuationDates = CommodityValuationDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="annualizationFactor")
        @RuneAttribute(value="annualizationFactor")
        public BigDecimal getAnnualizationFactor() {
            return this.annualizationFactor;
        }

        @Override
        @RosettaAttribute(value="nAdjustment")
        @RuneAttribute(value="nAdjustment")
        public Boolean getNAdjustment() {
            return this.nAdjustment;
        }

        @Override
        @RosettaAttribute(value="pricingDates")
        @RuneAttribute(value="pricingDates")
        public CommodityVarianceCalculationBuilder setPricingDates(CommodityPricingDates _pricingDates) {
            this.pricingDates = _pricingDates == null ? null : _pricingDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationDates")
        @RuneAttribute(value="valuationDates")
        public CommodityVarianceCalculationBuilder setValuationDates(CommodityValuationDates _valuationDates) {
            this.valuationDates = _valuationDates == null ? null : _valuationDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="annualizationFactor")
        @RuneAttribute(value="annualizationFactor")
        public CommodityVarianceCalculationBuilder setAnnualizationFactor(BigDecimal _annualizationFactor) {
            this.annualizationFactor = _annualizationFactor == null ? null : _annualizationFactor;
            return this;
        }

        @Override
        @RosettaAttribute(value="nAdjustment")
        @RuneAttribute(value="nAdjustment")
        public CommodityVarianceCalculationBuilder setNAdjustment(Boolean _nAdjustment) {
            this.nAdjustment = _nAdjustment == null ? null : _nAdjustment;
            return this;
        }

        @Override
        public CommodityVarianceCalculation build() {
            return new CommodityVarianceCalculationImpl(this);
        }

        @Override
        public CommodityVarianceCalculationBuilder toBuilder() {
            return this;
        }

        @Override
        public CommodityVarianceCalculationBuilder prune() {
            if (this.pricingDates != null && !this.pricingDates.prune().hasData()) {
                this.pricingDates = null;
            }
            if (this.valuationDates != null && !this.valuationDates.prune().hasData()) {
                this.valuationDates = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPricingDates() != null && this.getPricingDates().hasData()) {
                return true;
            }
            if (this.getValuationDates() != null && this.getValuationDates().hasData()) {
                return true;
            }
            if (this.getAnnualizationFactor() != null) {
                return true;
            }
            return this.getNAdjustment() != null;
        }

        public CommodityVarianceCalculationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CommodityVarianceCalculationBuilder o = (CommodityVarianceCalculationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPricingDates(), (RosettaModelObjectBuilder)o.getPricingDates(), this::setPricingDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getValuationDates(), (RosettaModelObjectBuilder)o.getValuationDates(), this::setValuationDates);
            merger.mergeBasic((Object)this.getAnnualizationFactor(), (Object)o.getAnnualizationFactor(), this::setAnnualizationFactor, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNAdjustment(), (Object)o.getNAdjustment(), this::setNAdjustment, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityVarianceCalculation _that = this.getType().cast(o);
            if (!Objects.equals(this.pricingDates, _that.getPricingDates())) {
                return false;
            }
            if (!Objects.equals(this.valuationDates, _that.getValuationDates())) {
                return false;
            }
            if (!Objects.equals(this.annualizationFactor, _that.getAnnualizationFactor())) {
                return false;
            }
            return Objects.equals(this.nAdjustment, _that.getNAdjustment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.pricingDates != null ? this.pricingDates.hashCode() : 0);
            _result = 31 * _result + (this.valuationDates != null ? this.valuationDates.hashCode() : 0);
            _result = 31 * _result + (this.annualizationFactor != null ? this.annualizationFactor.hashCode() : 0);
            _result = 31 * _result + (this.nAdjustment != null ? this.nAdjustment.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityVarianceCalculationBuilder {pricingDates=" + String.valueOf(this.pricingDates) + ", valuationDates=" + String.valueOf(this.valuationDates) + ", annualizationFactor=" + String.valueOf(this.annualizationFactor) + ", nAdjustment=" + this.nAdjustment + "}";
        }
    }

    public static interface CommodityVarianceCalculationBuilder
    extends CommodityVarianceCalculation,
    RosettaModelObjectBuilder {
        public CommodityPricingDates.CommodityPricingDatesBuilder getOrCreatePricingDates();

        @Override
        public CommodityPricingDates.CommodityPricingDatesBuilder getPricingDates();

        public CommodityValuationDates.CommodityValuationDatesBuilder getOrCreateValuationDates();

        @Override
        public CommodityValuationDates.CommodityValuationDatesBuilder getValuationDates();

        public CommodityVarianceCalculationBuilder setPricingDates(CommodityPricingDates var1);

        public CommodityVarianceCalculationBuilder setValuationDates(CommodityValuationDates var1);

        public CommodityVarianceCalculationBuilder setAnnualizationFactor(BigDecimal var1);

        public CommodityVarianceCalculationBuilder setNAdjustment(Boolean var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("pricingDates"), processor, CommodityPricingDates.CommodityPricingDatesBuilder.class, this.getPricingDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("valuationDates"), processor, CommodityValuationDates.CommodityValuationDatesBuilder.class, this.getValuationDates(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("annualizationFactor"), BigDecimal.class, (Object)this.getAnnualizationFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nAdjustment"), Boolean.class, (Object)this.getNAdjustment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CommodityVarianceCalculationBuilder prune();
    }

    public static class CommodityVarianceCalculationImpl
    implements CommodityVarianceCalculation {
        private final CommodityPricingDates pricingDates;
        private final CommodityValuationDates valuationDates;
        private final BigDecimal annualizationFactor;
        private final Boolean nAdjustment;

        protected CommodityVarianceCalculationImpl(CommodityVarianceCalculationBuilder builder) {
            this.pricingDates = Optional.ofNullable(builder.getPricingDates()).map(f -> f.build()).orElse(null);
            this.valuationDates = Optional.ofNullable(builder.getValuationDates()).map(f -> f.build()).orElse(null);
            this.annualizationFactor = builder.getAnnualizationFactor();
            this.nAdjustment = builder.getNAdjustment();
        }

        @Override
        @RosettaAttribute(value="pricingDates")
        @RuneAttribute(value="pricingDates")
        public CommodityPricingDates getPricingDates() {
            return this.pricingDates;
        }

        @Override
        @RosettaAttribute(value="valuationDates")
        @RuneAttribute(value="valuationDates")
        public CommodityValuationDates getValuationDates() {
            return this.valuationDates;
        }

        @Override
        @RosettaAttribute(value="annualizationFactor")
        @RuneAttribute(value="annualizationFactor")
        public BigDecimal getAnnualizationFactor() {
            return this.annualizationFactor;
        }

        @Override
        @RosettaAttribute(value="nAdjustment")
        @RuneAttribute(value="nAdjustment")
        public Boolean getNAdjustment() {
            return this.nAdjustment;
        }

        @Override
        public CommodityVarianceCalculation build() {
            return this;
        }

        @Override
        public CommodityVarianceCalculationBuilder toBuilder() {
            CommodityVarianceCalculationBuilder builder = CommodityVarianceCalculation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommodityVarianceCalculationBuilder builder) {
            Optional.ofNullable(this.getPricingDates()).ifPresent(builder::setPricingDates);
            Optional.ofNullable(this.getValuationDates()).ifPresent(builder::setValuationDates);
            Optional.ofNullable(this.getAnnualizationFactor()).ifPresent(builder::setAnnualizationFactor);
            Optional.ofNullable(this.getNAdjustment()).ifPresent(builder::setNAdjustment);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityVarianceCalculation _that = this.getType().cast(o);
            if (!Objects.equals(this.pricingDates, _that.getPricingDates())) {
                return false;
            }
            if (!Objects.equals(this.valuationDates, _that.getValuationDates())) {
                return false;
            }
            if (!Objects.equals(this.annualizationFactor, _that.getAnnualizationFactor())) {
                return false;
            }
            return Objects.equals(this.nAdjustment, _that.getNAdjustment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.pricingDates != null ? this.pricingDates.hashCode() : 0);
            _result = 31 * _result + (this.valuationDates != null ? this.valuationDates.hashCode() : 0);
            _result = 31 * _result + (this.annualizationFactor != null ? this.annualizationFactor.hashCode() : 0);
            _result = 31 * _result + (this.nAdjustment != null ? this.nAdjustment.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityVarianceCalculation {pricingDates=" + String.valueOf(this.pricingDates) + ", valuationDates=" + String.valueOf(this.valuationDates) + ", annualizationFactor=" + String.valueOf(this.annualizationFactor) + ", nAdjustment=" + this.nAdjustment + "}";
        }
    }
}

