/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.com.CommodityContentModel;
import fpml.consolidated.com.CommodityPhysicalExercise;
import fpml.consolidated.com.CommodityPremium;
import fpml.consolidated.com.CommoditySwaptionUnderlying;
import fpml.consolidated.com.meta.CommoditySwaptionMeta;
import fpml.consolidated.fpmlenum.PutCallEnum;
import fpml.consolidated.shared.BuyerSellerModel;
import fpml.consolidated.shared.Product;
import fpml.consolidated.shared.ProductModel;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CommoditySwaption", builder=CommoditySwaptionBuilderImpl.class, version="1.2.2")
@RuneDataType(value="CommoditySwaption", model="fpml", builder=CommoditySwaptionBuilderImpl.class, version="1.2.2")
public interface CommoditySwaption
extends Product {
    public static final CommoditySwaptionMeta metaData = new CommoditySwaptionMeta();

    public BuyerSellerModel getBuyerSellerModel();

    public PutCallEnum getOptionType();

    public CommoditySwaptionUnderlying getCommoditySwap();

    public CommodityPhysicalExercise getPhysicalExercise();

    public CommodityPremium getPremium();

    public CommodityContentModel getCommodityContentModel();

    @Override
    public CommoditySwaption build();

    @Override
    public CommoditySwaptionBuilder toBuilder();

    public static CommoditySwaptionBuilder builder() {
        return new CommoditySwaptionBuilderImpl();
    }

    default public RosettaMetaData<? extends CommoditySwaption> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommoditySwaption> getType() {
        return CommoditySwaption.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionType"), PutCallEnum.class, (Object)this.getOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commoditySwap"), processor, CommoditySwaptionUnderlying.class, this.getCommoditySwap(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("physicalExercise"), processor, CommodityPhysicalExercise.class, this.getPhysicalExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("premium"), processor, CommodityPremium.class, this.getPremium(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityContentModel"), processor, CommodityContentModel.class, this.getCommodityContentModel(), new AttributeMeta[0]);
    }

    public static class CommoditySwaptionBuilderImpl
    extends Product.ProductBuilderImpl
    implements CommoditySwaptionBuilder {
        protected BuyerSellerModel.BuyerSellerModelBuilder buyerSellerModel;
        protected PutCallEnum optionType;
        protected CommoditySwaptionUnderlying.CommoditySwaptionUnderlyingBuilder commoditySwap;
        protected CommodityPhysicalExercise.CommodityPhysicalExerciseBuilder physicalExercise;
        protected CommodityPremium.CommodityPremiumBuilder premium;
        protected CommodityContentModel.CommodityContentModelBuilder commodityContentModel;

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public BuyerSellerModel.BuyerSellerModelBuilder getBuyerSellerModel() {
            return this.buyerSellerModel;
        }

        @Override
        public BuyerSellerModel.BuyerSellerModelBuilder getOrCreateBuyerSellerModel() {
            BuyerSellerModel.BuyerSellerModelBuilder result = this.buyerSellerModel != null ? this.buyerSellerModel : (this.buyerSellerModel = BuyerSellerModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="optionType", isRequired=true)
        @RuneAttribute(value="optionType", isRequired=true)
        public PutCallEnum getOptionType() {
            return this.optionType;
        }

        @Override
        @RosettaAttribute(value="commoditySwap", isRequired=true)
        @RuneAttribute(value="commoditySwap", isRequired=true)
        public CommoditySwaptionUnderlying.CommoditySwaptionUnderlyingBuilder getCommoditySwap() {
            return this.commoditySwap;
        }

        @Override
        public CommoditySwaptionUnderlying.CommoditySwaptionUnderlyingBuilder getOrCreateCommoditySwap() {
            CommoditySwaptionUnderlying.CommoditySwaptionUnderlyingBuilder result = this.commoditySwap != null ? this.commoditySwap : (this.commoditySwap = CommoditySwaptionUnderlying.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="physicalExercise")
        @RuneAttribute(value="physicalExercise")
        public CommodityPhysicalExercise.CommodityPhysicalExerciseBuilder getPhysicalExercise() {
            return this.physicalExercise;
        }

        @Override
        public CommodityPhysicalExercise.CommodityPhysicalExerciseBuilder getOrCreatePhysicalExercise() {
            CommodityPhysicalExercise.CommodityPhysicalExerciseBuilder result = this.physicalExercise != null ? this.physicalExercise : (this.physicalExercise = CommodityPhysicalExercise.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public CommodityPremium.CommodityPremiumBuilder getPremium() {
            return this.premium;
        }

        @Override
        public CommodityPremium.CommodityPremiumBuilder getOrCreatePremium() {
            CommodityPremium.CommodityPremiumBuilder result = this.premium != null ? this.premium : (this.premium = CommodityPremium.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="commodityContentModel")
        @RuneAttribute(value="commodityContentModel")
        public CommodityContentModel.CommodityContentModelBuilder getCommodityContentModel() {
            return this.commodityContentModel;
        }

        @Override
        public CommodityContentModel.CommodityContentModelBuilder getOrCreateCommodityContentModel() {
            CommodityContentModel.CommodityContentModelBuilder result = this.commodityContentModel != null ? this.commodityContentModel : (this.commodityContentModel = CommodityContentModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public CommoditySwaptionBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public CommoditySwaptionBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public CommoditySwaptionBuilder setBuyerSellerModel(BuyerSellerModel _buyerSellerModel) {
            this.buyerSellerModel = _buyerSellerModel == null ? null : _buyerSellerModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionType", isRequired=true)
        @RuneAttribute(value="optionType", isRequired=true)
        public CommoditySwaptionBuilder setOptionType(PutCallEnum _optionType) {
            this.optionType = _optionType == null ? null : _optionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="commoditySwap", isRequired=true)
        @RuneAttribute(value="commoditySwap", isRequired=true)
        public CommoditySwaptionBuilder setCommoditySwap(CommoditySwaptionUnderlying _commoditySwap) {
            this.commoditySwap = _commoditySwap == null ? null : _commoditySwap.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="physicalExercise")
        @RuneAttribute(value="physicalExercise")
        public CommoditySwaptionBuilder setPhysicalExercise(CommodityPhysicalExercise _physicalExercise) {
            this.physicalExercise = _physicalExercise == null ? null : _physicalExercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public CommoditySwaptionBuilder setPremium(CommodityPremium _premium) {
            this.premium = _premium == null ? null : _premium.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityContentModel")
        @RuneAttribute(value="commodityContentModel")
        public CommoditySwaptionBuilder setCommodityContentModel(CommodityContentModel _commodityContentModel) {
            this.commodityContentModel = _commodityContentModel == null ? null : _commodityContentModel.toBuilder();
            return this;
        }

        @Override
        public CommoditySwaption build() {
            return new CommoditySwaptionImpl(this);
        }

        @Override
        public CommoditySwaptionBuilder toBuilder() {
            return this;
        }

        @Override
        public CommoditySwaptionBuilder prune() {
            super.prune();
            if (this.buyerSellerModel != null && !this.buyerSellerModel.prune().hasData()) {
                this.buyerSellerModel = null;
            }
            if (this.commoditySwap != null && !this.commoditySwap.prune().hasData()) {
                this.commoditySwap = null;
            }
            if (this.physicalExercise != null && !this.physicalExercise.prune().hasData()) {
                this.physicalExercise = null;
            }
            if (this.premium != null && !this.premium.prune().hasData()) {
                this.premium = null;
            }
            if (this.commodityContentModel != null && !this.commodityContentModel.prune().hasData()) {
                this.commodityContentModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getBuyerSellerModel() != null && this.getBuyerSellerModel().hasData()) {
                return true;
            }
            if (this.getOptionType() != null) {
                return true;
            }
            if (this.getCommoditySwap() != null && this.getCommoditySwap().hasData()) {
                return true;
            }
            if (this.getPhysicalExercise() != null && this.getPhysicalExercise().hasData()) {
                return true;
            }
            if (this.getPremium() != null && this.getPremium().hasData()) {
                return true;
            }
            return this.getCommodityContentModel() != null && this.getCommodityContentModel().hasData();
        }

        @Override
        public CommoditySwaptionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CommoditySwaptionBuilder o = (CommoditySwaptionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBuyerSellerModel(), (RosettaModelObjectBuilder)o.getBuyerSellerModel(), this::setBuyerSellerModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommoditySwap(), (RosettaModelObjectBuilder)o.getCommoditySwap(), this::setCommoditySwap);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPhysicalExercise(), (RosettaModelObjectBuilder)o.getPhysicalExercise(), this::setPhysicalExercise);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPremium(), (RosettaModelObjectBuilder)o.getPremium(), this::setPremium);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodityContentModel(), (RosettaModelObjectBuilder)o.getCommodityContentModel(), this::setCommodityContentModel);
            merger.mergeBasic((Object)this.getOptionType(), (Object)o.getOptionType(), this::setOptionType, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommoditySwaption _that = (CommoditySwaption)this.getType().cast(o);
            if (!Objects.equals(this.buyerSellerModel, _that.getBuyerSellerModel())) {
                return false;
            }
            if (!Objects.equals((Object)this.optionType, (Object)_that.getOptionType())) {
                return false;
            }
            if (!Objects.equals(this.commoditySwap, _that.getCommoditySwap())) {
                return false;
            }
            if (!Objects.equals(this.physicalExercise, _that.getPhysicalExercise())) {
                return false;
            }
            if (!Objects.equals(this.premium, _that.getPremium())) {
                return false;
            }
            return Objects.equals(this.commodityContentModel, _that.getCommodityContentModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.buyerSellerModel != null ? this.buyerSellerModel.hashCode() : 0);
            _result = 31 * _result + (this.optionType != null ? ((Object)((Object)this.optionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.commoditySwap != null ? this.commoditySwap.hashCode() : 0);
            _result = 31 * _result + (this.physicalExercise != null ? this.physicalExercise.hashCode() : 0);
            _result = 31 * _result + (this.premium != null ? this.premium.hashCode() : 0);
            _result = 31 * _result + (this.commodityContentModel != null ? this.commodityContentModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommoditySwaptionBuilder {buyerSellerModel=" + String.valueOf(this.buyerSellerModel) + ", optionType=" + String.valueOf((Object)this.optionType) + ", commoditySwap=" + String.valueOf(this.commoditySwap) + ", physicalExercise=" + String.valueOf(this.physicalExercise) + ", premium=" + String.valueOf(this.premium) + ", commodityContentModel=" + String.valueOf(this.commodityContentModel) + "} " + super.toString();
        }
    }

    public static interface CommoditySwaptionBuilder
    extends CommoditySwaption,
    Product.ProductBuilder {
        public BuyerSellerModel.BuyerSellerModelBuilder getOrCreateBuyerSellerModel();

        @Override
        public BuyerSellerModel.BuyerSellerModelBuilder getBuyerSellerModel();

        public CommoditySwaptionUnderlying.CommoditySwaptionUnderlyingBuilder getOrCreateCommoditySwap();

        @Override
        public CommoditySwaptionUnderlying.CommoditySwaptionUnderlyingBuilder getCommoditySwap();

        public CommodityPhysicalExercise.CommodityPhysicalExerciseBuilder getOrCreatePhysicalExercise();

        @Override
        public CommodityPhysicalExercise.CommodityPhysicalExerciseBuilder getPhysicalExercise();

        public CommodityPremium.CommodityPremiumBuilder getOrCreatePremium();

        @Override
        public CommodityPremium.CommodityPremiumBuilder getPremium();

        public CommodityContentModel.CommodityContentModelBuilder getOrCreateCommodityContentModel();

        @Override
        public CommodityContentModel.CommodityContentModelBuilder getCommodityContentModel();

        @Override
        public CommoditySwaptionBuilder setProductModel(ProductModel var1);

        @Override
        public CommoditySwaptionBuilder setId(String var1);

        public CommoditySwaptionBuilder setBuyerSellerModel(BuyerSellerModel var1);

        public CommoditySwaptionBuilder setOptionType(PutCallEnum var1);

        public CommoditySwaptionBuilder setCommoditySwap(CommoditySwaptionUnderlying var1);

        public CommoditySwaptionBuilder setPhysicalExercise(CommodityPhysicalExercise var1);

        public CommoditySwaptionBuilder setPremium(CommodityPremium var1);

        public CommoditySwaptionBuilder setCommodityContentModel(CommodityContentModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.BuyerSellerModelBuilder.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionType"), PutCallEnum.class, (Object)this.getOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commoditySwap"), processor, CommoditySwaptionUnderlying.CommoditySwaptionUnderlyingBuilder.class, this.getCommoditySwap(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("physicalExercise"), processor, CommodityPhysicalExercise.CommodityPhysicalExerciseBuilder.class, this.getPhysicalExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("premium"), processor, CommodityPremium.CommodityPremiumBuilder.class, this.getPremium(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityContentModel"), processor, CommodityContentModel.CommodityContentModelBuilder.class, this.getCommodityContentModel(), new AttributeMeta[0]);
        }

        @Override
        public CommoditySwaptionBuilder prune();
    }

    public static class CommoditySwaptionImpl
    extends Product.ProductImpl
    implements CommoditySwaption {
        private final BuyerSellerModel buyerSellerModel;
        private final PutCallEnum optionType;
        private final CommoditySwaptionUnderlying commoditySwap;
        private final CommodityPhysicalExercise physicalExercise;
        private final CommodityPremium premium;
        private final CommodityContentModel commodityContentModel;

        protected CommoditySwaptionImpl(CommoditySwaptionBuilder builder) {
            super(builder);
            this.buyerSellerModel = Optional.ofNullable(builder.getBuyerSellerModel()).map(f -> f.build()).orElse(null);
            this.optionType = builder.getOptionType();
            this.commoditySwap = Optional.ofNullable(builder.getCommoditySwap()).map(f -> f.build()).orElse(null);
            this.physicalExercise = Optional.ofNullable(builder.getPhysicalExercise()).map(f -> f.build()).orElse(null);
            this.premium = Optional.ofNullable(builder.getPremium()).map(f -> f.build()).orElse(null);
            this.commodityContentModel = Optional.ofNullable(builder.getCommodityContentModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public BuyerSellerModel getBuyerSellerModel() {
            return this.buyerSellerModel;
        }

        @Override
        @RosettaAttribute(value="optionType", isRequired=true)
        @RuneAttribute(value="optionType", isRequired=true)
        public PutCallEnum getOptionType() {
            return this.optionType;
        }

        @Override
        @RosettaAttribute(value="commoditySwap", isRequired=true)
        @RuneAttribute(value="commoditySwap", isRequired=true)
        public CommoditySwaptionUnderlying getCommoditySwap() {
            return this.commoditySwap;
        }

        @Override
        @RosettaAttribute(value="physicalExercise")
        @RuneAttribute(value="physicalExercise")
        public CommodityPhysicalExercise getPhysicalExercise() {
            return this.physicalExercise;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public CommodityPremium getPremium() {
            return this.premium;
        }

        @Override
        @RosettaAttribute(value="commodityContentModel")
        @RuneAttribute(value="commodityContentModel")
        public CommodityContentModel getCommodityContentModel() {
            return this.commodityContentModel;
        }

        @Override
        public CommoditySwaption build() {
            return this;
        }

        @Override
        public CommoditySwaptionBuilder toBuilder() {
            CommoditySwaptionBuilder builder = CommoditySwaption.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommoditySwaptionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getBuyerSellerModel()).ifPresent(builder::setBuyerSellerModel);
            Optional.ofNullable(this.getOptionType()).ifPresent(builder::setOptionType);
            Optional.ofNullable(this.getCommoditySwap()).ifPresent(builder::setCommoditySwap);
            Optional.ofNullable(this.getPhysicalExercise()).ifPresent(builder::setPhysicalExercise);
            Optional.ofNullable(this.getPremium()).ifPresent(builder::setPremium);
            Optional.ofNullable(this.getCommodityContentModel()).ifPresent(builder::setCommodityContentModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommoditySwaption _that = (CommoditySwaption)this.getType().cast(o);
            if (!Objects.equals(this.buyerSellerModel, _that.getBuyerSellerModel())) {
                return false;
            }
            if (!Objects.equals((Object)this.optionType, (Object)_that.getOptionType())) {
                return false;
            }
            if (!Objects.equals(this.commoditySwap, _that.getCommoditySwap())) {
                return false;
            }
            if (!Objects.equals(this.physicalExercise, _that.getPhysicalExercise())) {
                return false;
            }
            if (!Objects.equals(this.premium, _that.getPremium())) {
                return false;
            }
            return Objects.equals(this.commodityContentModel, _that.getCommodityContentModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.buyerSellerModel != null ? this.buyerSellerModel.hashCode() : 0);
            _result = 31 * _result + (this.optionType != null ? ((Object)((Object)this.optionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.commoditySwap != null ? this.commoditySwap.hashCode() : 0);
            _result = 31 * _result + (this.physicalExercise != null ? this.physicalExercise.hashCode() : 0);
            _result = 31 * _result + (this.premium != null ? this.premium.hashCode() : 0);
            _result = 31 * _result + (this.commodityContentModel != null ? this.commodityContentModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommoditySwaption {buyerSellerModel=" + String.valueOf(this.buyerSellerModel) + ", optionType=" + String.valueOf((Object)this.optionType) + ", commoditySwap=" + String.valueOf(this.commoditySwap) + ", physicalExercise=" + String.valueOf(this.physicalExercise) + ", premium=" + String.valueOf(this.premium) + ", commodityContentModel=" + String.valueOf(this.commodityContentModel) + "} " + super.toString();
        }
    }
}

