/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.com.CommodityCalculationPeriodsPointerModel;
import fpml.consolidated.com.CommodityFixedPrice;
import fpml.consolidated.com.CommoditySettlementPeriodsPriceSchedule;
import fpml.consolidated.com.meta.CommodityFixedPriceScheduleMeta;
import fpml.consolidated.shared.NonNegativeMoney;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CommodityFixedPriceSchedule", builder=CommodityFixedPriceScheduleBuilderImpl.class, version="1.2.2")
@RuneDataType(value="CommodityFixedPriceSchedule", model="fpml", builder=CommodityFixedPriceScheduleBuilderImpl.class, version="1.2.2")
public interface CommodityFixedPriceSchedule
extends RosettaModelObject {
    public static final CommodityFixedPriceScheduleMeta metaData = new CommodityFixedPriceScheduleMeta();

    public List<? extends CommodityFixedPrice> getFixedPriceStep();

    public List<BigDecimal> getWorldscaleRateStep();

    public List<? extends NonNegativeMoney> getContractRateStep();

    public List<? extends CommoditySettlementPeriodsPriceSchedule> getSettlementPeriodsPriceSchedule();

    public CommodityCalculationPeriodsPointerModel getCommodityCalculationPeriodsPointerModel();

    public CommodityFixedPriceSchedule build();

    public CommodityFixedPriceScheduleBuilder toBuilder();

    public static CommodityFixedPriceScheduleBuilder builder() {
        return new CommodityFixedPriceScheduleBuilderImpl();
    }

    default public RosettaMetaData<? extends CommodityFixedPriceSchedule> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommodityFixedPriceSchedule> getType() {
        return CommodityFixedPriceSchedule.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("fixedPriceStep"), processor, CommodityFixedPrice.class, this.getFixedPriceStep(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("worldscaleRateStep"), BigDecimal.class, this.getWorldscaleRateStep(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("contractRateStep"), processor, NonNegativeMoney.class, this.getContractRateStep(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementPeriodsPriceSchedule"), processor, CommoditySettlementPeriodsPriceSchedule.class, this.getSettlementPeriodsPriceSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityCalculationPeriodsPointerModel"), processor, CommodityCalculationPeriodsPointerModel.class, this.getCommodityCalculationPeriodsPointerModel(), new AttributeMeta[0]);
    }

    public static class CommodityFixedPriceScheduleBuilderImpl
    implements CommodityFixedPriceScheduleBuilder {
        protected List<CommodityFixedPrice.CommodityFixedPriceBuilder> fixedPriceStep = new ArrayList<CommodityFixedPrice.CommodityFixedPriceBuilder>();
        protected List<BigDecimal> worldscaleRateStep = new ArrayList<BigDecimal>();
        protected List<NonNegativeMoney.NonNegativeMoneyBuilder> contractRateStep = new ArrayList<NonNegativeMoney.NonNegativeMoneyBuilder>();
        protected List<CommoditySettlementPeriodsPriceSchedule.CommoditySettlementPeriodsPriceScheduleBuilder> settlementPeriodsPriceSchedule = new ArrayList<CommoditySettlementPeriodsPriceSchedule.CommoditySettlementPeriodsPriceScheduleBuilder>();
        protected CommodityCalculationPeriodsPointerModel.CommodityCalculationPeriodsPointerModelBuilder commodityCalculationPeriodsPointerModel;

        @Override
        @RosettaAttribute(value="fixedPriceStep")
        @RuneAttribute(value="fixedPriceStep")
        public List<? extends CommodityFixedPrice.CommodityFixedPriceBuilder> getFixedPriceStep() {
            return this.fixedPriceStep;
        }

        @Override
        public CommodityFixedPrice.CommodityFixedPriceBuilder getOrCreateFixedPriceStep(int index) {
            if (this.fixedPriceStep == null) {
                this.fixedPriceStep = new ArrayList<CommodityFixedPrice.CommodityFixedPriceBuilder>();
            }
            return (CommodityFixedPrice.CommodityFixedPriceBuilder)this.getIndex(this.fixedPriceStep, index, () -> {
                CommodityFixedPrice.CommodityFixedPriceBuilder newFixedPriceStep = CommodityFixedPrice.builder();
                return newFixedPriceStep;
            });
        }

        @Override
        @RosettaAttribute(value="worldscaleRateStep")
        @RuneAttribute(value="worldscaleRateStep")
        public List<BigDecimal> getWorldscaleRateStep() {
            return this.worldscaleRateStep;
        }

        @Override
        @RosettaAttribute(value="contractRateStep")
        @RuneAttribute(value="contractRateStep")
        public List<? extends NonNegativeMoney.NonNegativeMoneyBuilder> getContractRateStep() {
            return this.contractRateStep;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateContractRateStep(int index) {
            if (this.contractRateStep == null) {
                this.contractRateStep = new ArrayList<NonNegativeMoney.NonNegativeMoneyBuilder>();
            }
            return (NonNegativeMoney.NonNegativeMoneyBuilder)this.getIndex(this.contractRateStep, index, () -> {
                NonNegativeMoney.NonNegativeMoneyBuilder newContractRateStep = NonNegativeMoney.builder();
                return newContractRateStep;
            });
        }

        @Override
        @RosettaAttribute(value="settlementPeriodsPriceSchedule")
        @RuneAttribute(value="settlementPeriodsPriceSchedule")
        public List<? extends CommoditySettlementPeriodsPriceSchedule.CommoditySettlementPeriodsPriceScheduleBuilder> getSettlementPeriodsPriceSchedule() {
            return this.settlementPeriodsPriceSchedule;
        }

        @Override
        public CommoditySettlementPeriodsPriceSchedule.CommoditySettlementPeriodsPriceScheduleBuilder getOrCreateSettlementPeriodsPriceSchedule(int index) {
            if (this.settlementPeriodsPriceSchedule == null) {
                this.settlementPeriodsPriceSchedule = new ArrayList<CommoditySettlementPeriodsPriceSchedule.CommoditySettlementPeriodsPriceScheduleBuilder>();
            }
            return (CommoditySettlementPeriodsPriceSchedule.CommoditySettlementPeriodsPriceScheduleBuilder)this.getIndex(this.settlementPeriodsPriceSchedule, index, () -> {
                CommoditySettlementPeriodsPriceSchedule.CommoditySettlementPeriodsPriceScheduleBuilder newSettlementPeriodsPriceSchedule = CommoditySettlementPeriodsPriceSchedule.builder();
                return newSettlementPeriodsPriceSchedule;
            });
        }

        @Override
        @RosettaAttribute(value="commodityCalculationPeriodsPointerModel")
        @RuneAttribute(value="commodityCalculationPeriodsPointerModel")
        public CommodityCalculationPeriodsPointerModel.CommodityCalculationPeriodsPointerModelBuilder getCommodityCalculationPeriodsPointerModel() {
            return this.commodityCalculationPeriodsPointerModel;
        }

        @Override
        public CommodityCalculationPeriodsPointerModel.CommodityCalculationPeriodsPointerModelBuilder getOrCreateCommodityCalculationPeriodsPointerModel() {
            CommodityCalculationPeriodsPointerModel.CommodityCalculationPeriodsPointerModelBuilder result = this.commodityCalculationPeriodsPointerModel != null ? this.commodityCalculationPeriodsPointerModel : (this.commodityCalculationPeriodsPointerModel = CommodityCalculationPeriodsPointerModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fixedPriceStep")
        @RuneAttribute(value="fixedPriceStep")
        public CommodityFixedPriceScheduleBuilder addFixedPriceStep(CommodityFixedPrice _fixedPriceStep) {
            if (_fixedPriceStep != null) {
                this.fixedPriceStep.add(_fixedPriceStep.toBuilder());
            }
            return this;
        }

        @Override
        public CommodityFixedPriceScheduleBuilder addFixedPriceStep(CommodityFixedPrice _fixedPriceStep, int idx) {
            this.getIndex(this.fixedPriceStep, idx, () -> _fixedPriceStep.toBuilder());
            return this;
        }

        @Override
        public CommodityFixedPriceScheduleBuilder addFixedPriceStep(List<? extends CommodityFixedPrice> fixedPriceSteps) {
            if (fixedPriceSteps != null) {
                for (CommodityFixedPrice commodityFixedPrice : fixedPriceSteps) {
                    this.fixedPriceStep.add(commodityFixedPrice.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="fixedPriceStep")
        public CommodityFixedPriceScheduleBuilder setFixedPriceStep(List<? extends CommodityFixedPrice> fixedPriceSteps) {
            this.fixedPriceStep = fixedPriceSteps == null ? new ArrayList<CommodityFixedPrice.CommodityFixedPriceBuilder>() : (List)fixedPriceSteps.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="worldscaleRateStep")
        @RuneAttribute(value="worldscaleRateStep")
        public CommodityFixedPriceScheduleBuilder addWorldscaleRateStep(BigDecimal _worldscaleRateStep) {
            if (_worldscaleRateStep != null) {
                this.worldscaleRateStep.add(_worldscaleRateStep);
            }
            return this;
        }

        @Override
        public CommodityFixedPriceScheduleBuilder addWorldscaleRateStep(BigDecimal _worldscaleRateStep, int idx) {
            this.getIndex(this.worldscaleRateStep, idx, () -> _worldscaleRateStep);
            return this;
        }

        @Override
        public CommodityFixedPriceScheduleBuilder addWorldscaleRateStep(List<BigDecimal> worldscaleRateSteps) {
            if (worldscaleRateSteps != null) {
                for (BigDecimal toAdd : worldscaleRateSteps) {
                    this.worldscaleRateStep.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="worldscaleRateStep")
        public CommodityFixedPriceScheduleBuilder setWorldscaleRateStep(List<BigDecimal> worldscaleRateSteps) {
            this.worldscaleRateStep = worldscaleRateSteps == null ? new ArrayList<BigDecimal>() : (List)worldscaleRateSteps.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="contractRateStep")
        @RuneAttribute(value="contractRateStep")
        public CommodityFixedPriceScheduleBuilder addContractRateStep(NonNegativeMoney _contractRateStep) {
            if (_contractRateStep != null) {
                this.contractRateStep.add(_contractRateStep.toBuilder());
            }
            return this;
        }

        @Override
        public CommodityFixedPriceScheduleBuilder addContractRateStep(NonNegativeMoney _contractRateStep, int idx) {
            this.getIndex(this.contractRateStep, idx, () -> _contractRateStep.toBuilder());
            return this;
        }

        @Override
        public CommodityFixedPriceScheduleBuilder addContractRateStep(List<? extends NonNegativeMoney> contractRateSteps) {
            if (contractRateSteps != null) {
                for (NonNegativeMoney nonNegativeMoney : contractRateSteps) {
                    this.contractRateStep.add(nonNegativeMoney.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="contractRateStep")
        public CommodityFixedPriceScheduleBuilder setContractRateStep(List<? extends NonNegativeMoney> contractRateSteps) {
            this.contractRateStep = contractRateSteps == null ? new ArrayList<NonNegativeMoney.NonNegativeMoneyBuilder>() : (List)contractRateSteps.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementPeriodsPriceSchedule")
        @RuneAttribute(value="settlementPeriodsPriceSchedule")
        public CommodityFixedPriceScheduleBuilder addSettlementPeriodsPriceSchedule(CommoditySettlementPeriodsPriceSchedule _settlementPeriodsPriceSchedule) {
            if (_settlementPeriodsPriceSchedule != null) {
                this.settlementPeriodsPriceSchedule.add(_settlementPeriodsPriceSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public CommodityFixedPriceScheduleBuilder addSettlementPeriodsPriceSchedule(CommoditySettlementPeriodsPriceSchedule _settlementPeriodsPriceSchedule, int idx) {
            this.getIndex(this.settlementPeriodsPriceSchedule, idx, () -> _settlementPeriodsPriceSchedule.toBuilder());
            return this;
        }

        @Override
        public CommodityFixedPriceScheduleBuilder addSettlementPeriodsPriceSchedule(List<? extends CommoditySettlementPeriodsPriceSchedule> settlementPeriodsPriceSchedules) {
            if (settlementPeriodsPriceSchedules != null) {
                for (CommoditySettlementPeriodsPriceSchedule commoditySettlementPeriodsPriceSchedule : settlementPeriodsPriceSchedules) {
                    this.settlementPeriodsPriceSchedule.add(commoditySettlementPeriodsPriceSchedule.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="settlementPeriodsPriceSchedule")
        public CommodityFixedPriceScheduleBuilder setSettlementPeriodsPriceSchedule(List<? extends CommoditySettlementPeriodsPriceSchedule> settlementPeriodsPriceSchedules) {
            this.settlementPeriodsPriceSchedule = settlementPeriodsPriceSchedules == null ? new ArrayList<CommoditySettlementPeriodsPriceSchedule.CommoditySettlementPeriodsPriceScheduleBuilder>() : (List)settlementPeriodsPriceSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityCalculationPeriodsPointerModel")
        @RuneAttribute(value="commodityCalculationPeriodsPointerModel")
        public CommodityFixedPriceScheduleBuilder setCommodityCalculationPeriodsPointerModel(CommodityCalculationPeriodsPointerModel _commodityCalculationPeriodsPointerModel) {
            this.commodityCalculationPeriodsPointerModel = _commodityCalculationPeriodsPointerModel == null ? null : _commodityCalculationPeriodsPointerModel.toBuilder();
            return this;
        }

        @Override
        public CommodityFixedPriceSchedule build() {
            return new CommodityFixedPriceScheduleImpl(this);
        }

        @Override
        public CommodityFixedPriceScheduleBuilder toBuilder() {
            return this;
        }

        @Override
        public CommodityFixedPriceScheduleBuilder prune() {
            this.fixedPriceStep = this.fixedPriceStep.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.contractRateStep = this.contractRateStep.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.settlementPeriodsPriceSchedule = this.settlementPeriodsPriceSchedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.commodityCalculationPeriodsPointerModel != null && !this.commodityCalculationPeriodsPointerModel.prune().hasData()) {
                this.commodityCalculationPeriodsPointerModel = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getFixedPriceStep() != null && this.getFixedPriceStep().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getWorldscaleRateStep() != null && !this.getWorldscaleRateStep().isEmpty()) {
                return true;
            }
            if (this.getContractRateStep() != null && this.getContractRateStep().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getSettlementPeriodsPriceSchedule() != null && this.getSettlementPeriodsPriceSchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getCommodityCalculationPeriodsPointerModel() != null && this.getCommodityCalculationPeriodsPointerModel().hasData();
        }

        public CommodityFixedPriceScheduleBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CommodityFixedPriceScheduleBuilder o = (CommodityFixedPriceScheduleBuilder)other;
            merger.mergeRosetta(this.getFixedPriceStep(), o.getFixedPriceStep(), this::getOrCreateFixedPriceStep);
            merger.mergeRosetta(this.getContractRateStep(), o.getContractRateStep(), this::getOrCreateContractRateStep);
            merger.mergeRosetta(this.getSettlementPeriodsPriceSchedule(), o.getSettlementPeriodsPriceSchedule(), this::getOrCreateSettlementPeriodsPriceSchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodityCalculationPeriodsPointerModel(), (RosettaModelObjectBuilder)o.getCommodityCalculationPeriodsPointerModel(), this::setCommodityCalculationPeriodsPointerModel);
            merger.mergeBasic(this.getWorldscaleRateStep(), o.getWorldscaleRateStep(), this::addWorldscaleRateStep);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityFixedPriceSchedule _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.fixedPriceStep, _that.getFixedPriceStep())) {
                return false;
            }
            if (!ListEquals.listEquals(this.worldscaleRateStep, _that.getWorldscaleRateStep())) {
                return false;
            }
            if (!ListEquals.listEquals(this.contractRateStep, _that.getContractRateStep())) {
                return false;
            }
            if (!ListEquals.listEquals(this.settlementPeriodsPriceSchedule, _that.getSettlementPeriodsPriceSchedule())) {
                return false;
            }
            return Objects.equals(this.commodityCalculationPeriodsPointerModel, _that.getCommodityCalculationPeriodsPointerModel());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.fixedPriceStep != null ? this.fixedPriceStep.hashCode() : 0);
            _result = 31 * _result + (this.worldscaleRateStep != null ? this.worldscaleRateStep.hashCode() : 0);
            _result = 31 * _result + (this.contractRateStep != null ? this.contractRateStep.hashCode() : 0);
            _result = 31 * _result + (this.settlementPeriodsPriceSchedule != null ? this.settlementPeriodsPriceSchedule.hashCode() : 0);
            _result = 31 * _result + (this.commodityCalculationPeriodsPointerModel != null ? this.commodityCalculationPeriodsPointerModel.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityFixedPriceScheduleBuilder {fixedPriceStep=" + String.valueOf(this.fixedPriceStep) + ", worldscaleRateStep=" + String.valueOf(this.worldscaleRateStep) + ", contractRateStep=" + String.valueOf(this.contractRateStep) + ", settlementPeriodsPriceSchedule=" + String.valueOf(this.settlementPeriodsPriceSchedule) + ", commodityCalculationPeriodsPointerModel=" + String.valueOf(this.commodityCalculationPeriodsPointerModel) + "}";
        }
    }

    public static interface CommodityFixedPriceScheduleBuilder
    extends CommodityFixedPriceSchedule,
    RosettaModelObjectBuilder {
        public CommodityFixedPrice.CommodityFixedPriceBuilder getOrCreateFixedPriceStep(int var1);

        public List<? extends CommodityFixedPrice.CommodityFixedPriceBuilder> getFixedPriceStep();

        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateContractRateStep(int var1);

        public List<? extends NonNegativeMoney.NonNegativeMoneyBuilder> getContractRateStep();

        public CommoditySettlementPeriodsPriceSchedule.CommoditySettlementPeriodsPriceScheduleBuilder getOrCreateSettlementPeriodsPriceSchedule(int var1);

        public List<? extends CommoditySettlementPeriodsPriceSchedule.CommoditySettlementPeriodsPriceScheduleBuilder> getSettlementPeriodsPriceSchedule();

        public CommodityCalculationPeriodsPointerModel.CommodityCalculationPeriodsPointerModelBuilder getOrCreateCommodityCalculationPeriodsPointerModel();

        @Override
        public CommodityCalculationPeriodsPointerModel.CommodityCalculationPeriodsPointerModelBuilder getCommodityCalculationPeriodsPointerModel();

        public CommodityFixedPriceScheduleBuilder addFixedPriceStep(CommodityFixedPrice var1);

        public CommodityFixedPriceScheduleBuilder addFixedPriceStep(CommodityFixedPrice var1, int var2);

        public CommodityFixedPriceScheduleBuilder addFixedPriceStep(List<? extends CommodityFixedPrice> var1);

        public CommodityFixedPriceScheduleBuilder setFixedPriceStep(List<? extends CommodityFixedPrice> var1);

        public CommodityFixedPriceScheduleBuilder addWorldscaleRateStep(BigDecimal var1);

        public CommodityFixedPriceScheduleBuilder addWorldscaleRateStep(BigDecimal var1, int var2);

        public CommodityFixedPriceScheduleBuilder addWorldscaleRateStep(List<BigDecimal> var1);

        public CommodityFixedPriceScheduleBuilder setWorldscaleRateStep(List<BigDecimal> var1);

        public CommodityFixedPriceScheduleBuilder addContractRateStep(NonNegativeMoney var1);

        public CommodityFixedPriceScheduleBuilder addContractRateStep(NonNegativeMoney var1, int var2);

        public CommodityFixedPriceScheduleBuilder addContractRateStep(List<? extends NonNegativeMoney> var1);

        public CommodityFixedPriceScheduleBuilder setContractRateStep(List<? extends NonNegativeMoney> var1);

        public CommodityFixedPriceScheduleBuilder addSettlementPeriodsPriceSchedule(CommoditySettlementPeriodsPriceSchedule var1);

        public CommodityFixedPriceScheduleBuilder addSettlementPeriodsPriceSchedule(CommoditySettlementPeriodsPriceSchedule var1, int var2);

        public CommodityFixedPriceScheduleBuilder addSettlementPeriodsPriceSchedule(List<? extends CommoditySettlementPeriodsPriceSchedule> var1);

        public CommodityFixedPriceScheduleBuilder setSettlementPeriodsPriceSchedule(List<? extends CommoditySettlementPeriodsPriceSchedule> var1);

        public CommodityFixedPriceScheduleBuilder setCommodityCalculationPeriodsPointerModel(CommodityCalculationPeriodsPointerModel var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("fixedPriceStep"), processor, CommodityFixedPrice.CommodityFixedPriceBuilder.class, this.getFixedPriceStep(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("worldscaleRateStep"), BigDecimal.class, this.getWorldscaleRateStep(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("contractRateStep"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getContractRateStep(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementPeriodsPriceSchedule"), processor, CommoditySettlementPeriodsPriceSchedule.CommoditySettlementPeriodsPriceScheduleBuilder.class, this.getSettlementPeriodsPriceSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityCalculationPeriodsPointerModel"), processor, CommodityCalculationPeriodsPointerModel.CommodityCalculationPeriodsPointerModelBuilder.class, this.getCommodityCalculationPeriodsPointerModel(), new AttributeMeta[0]);
        }

        public CommodityFixedPriceScheduleBuilder prune();
    }

    public static class CommodityFixedPriceScheduleImpl
    implements CommodityFixedPriceSchedule {
        private final List<? extends CommodityFixedPrice> fixedPriceStep;
        private final List<BigDecimal> worldscaleRateStep;
        private final List<? extends NonNegativeMoney> contractRateStep;
        private final List<? extends CommoditySettlementPeriodsPriceSchedule> settlementPeriodsPriceSchedule;
        private final CommodityCalculationPeriodsPointerModel commodityCalculationPeriodsPointerModel;

        protected CommodityFixedPriceScheduleImpl(CommodityFixedPriceScheduleBuilder builder) {
            this.fixedPriceStep = Optional.ofNullable(builder.getFixedPriceStep()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.worldscaleRateStep = Optional.ofNullable(builder.getWorldscaleRateStep()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.contractRateStep = Optional.ofNullable(builder.getContractRateStep()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.settlementPeriodsPriceSchedule = Optional.ofNullable(builder.getSettlementPeriodsPriceSchedule()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.commodityCalculationPeriodsPointerModel = Optional.ofNullable(builder.getCommodityCalculationPeriodsPointerModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="fixedPriceStep")
        @RuneAttribute(value="fixedPriceStep")
        public List<? extends CommodityFixedPrice> getFixedPriceStep() {
            return this.fixedPriceStep;
        }

        @Override
        @RosettaAttribute(value="worldscaleRateStep")
        @RuneAttribute(value="worldscaleRateStep")
        public List<BigDecimal> getWorldscaleRateStep() {
            return this.worldscaleRateStep;
        }

        @Override
        @RosettaAttribute(value="contractRateStep")
        @RuneAttribute(value="contractRateStep")
        public List<? extends NonNegativeMoney> getContractRateStep() {
            return this.contractRateStep;
        }

        @Override
        @RosettaAttribute(value="settlementPeriodsPriceSchedule")
        @RuneAttribute(value="settlementPeriodsPriceSchedule")
        public List<? extends CommoditySettlementPeriodsPriceSchedule> getSettlementPeriodsPriceSchedule() {
            return this.settlementPeriodsPriceSchedule;
        }

        @Override
        @RosettaAttribute(value="commodityCalculationPeriodsPointerModel")
        @RuneAttribute(value="commodityCalculationPeriodsPointerModel")
        public CommodityCalculationPeriodsPointerModel getCommodityCalculationPeriodsPointerModel() {
            return this.commodityCalculationPeriodsPointerModel;
        }

        @Override
        public CommodityFixedPriceSchedule build() {
            return this;
        }

        @Override
        public CommodityFixedPriceScheduleBuilder toBuilder() {
            CommodityFixedPriceScheduleBuilder builder = CommodityFixedPriceSchedule.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommodityFixedPriceScheduleBuilder builder) {
            Optional.ofNullable(this.getFixedPriceStep()).ifPresent(builder::setFixedPriceStep);
            Optional.ofNullable(this.getWorldscaleRateStep()).ifPresent(builder::setWorldscaleRateStep);
            Optional.ofNullable(this.getContractRateStep()).ifPresent(builder::setContractRateStep);
            Optional.ofNullable(this.getSettlementPeriodsPriceSchedule()).ifPresent(builder::setSettlementPeriodsPriceSchedule);
            Optional.ofNullable(this.getCommodityCalculationPeriodsPointerModel()).ifPresent(builder::setCommodityCalculationPeriodsPointerModel);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityFixedPriceSchedule _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.fixedPriceStep, _that.getFixedPriceStep())) {
                return false;
            }
            if (!ListEquals.listEquals(this.worldscaleRateStep, _that.getWorldscaleRateStep())) {
                return false;
            }
            if (!ListEquals.listEquals(this.contractRateStep, _that.getContractRateStep())) {
                return false;
            }
            if (!ListEquals.listEquals(this.settlementPeriodsPriceSchedule, _that.getSettlementPeriodsPriceSchedule())) {
                return false;
            }
            return Objects.equals(this.commodityCalculationPeriodsPointerModel, _that.getCommodityCalculationPeriodsPointerModel());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.fixedPriceStep != null ? this.fixedPriceStep.hashCode() : 0);
            _result = 31 * _result + (this.worldscaleRateStep != null ? this.worldscaleRateStep.hashCode() : 0);
            _result = 31 * _result + (this.contractRateStep != null ? this.contractRateStep.hashCode() : 0);
            _result = 31 * _result + (this.settlementPeriodsPriceSchedule != null ? this.settlementPeriodsPriceSchedule.hashCode() : 0);
            _result = 31 * _result + (this.commodityCalculationPeriodsPointerModel != null ? this.commodityCalculationPeriodsPointerModel.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityFixedPriceSchedule {fixedPriceStep=" + String.valueOf(this.fixedPriceStep) + ", worldscaleRateStep=" + String.valueOf(this.worldscaleRateStep) + ", contractRateStep=" + String.valueOf(this.contractRateStep) + ", settlementPeriodsPriceSchedule=" + String.valueOf(this.settlementPeriodsPriceSchedule) + ", commodityCalculationPeriodsPointerModel=" + String.valueOf(this.commodityCalculationPeriodsPointerModel) + "}";
        }
    }
}

