/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.com.CommodityBasketModel;
import fpml.consolidated.com.CommodityBasketOptionFeaturesModel;
import fpml.consolidated.com.CommodityContentModel;
import fpml.consolidated.com.CommodityExerciseBasket;
import fpml.consolidated.com.CommodityFloatingStrikePriceModel;
import fpml.consolidated.com.CommodityPremium;
import fpml.consolidated.com.CommodityStrikePriceModel;
import fpml.consolidated.com.StrikePriceBasketReference;
import fpml.consolidated.com.StrikePriceUnderlyingReference;
import fpml.consolidated.com.meta.CommodityBasketOptionMeta;
import fpml.consolidated.fpmlenum.PutCallEnum;
import fpml.consolidated.option.shared.Option;
import fpml.consolidated.shared.BuyerSellerModel;
import fpml.consolidated.shared.ProductModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CommodityBasketOption", builder=CommodityBasketOptionBuilderImpl.class, version="1.2.2")
@RuneDataType(value="CommodityBasketOption", model="fpml", builder=CommodityBasketOptionBuilderImpl.class, version="1.2.2")
public interface CommodityBasketOption
extends Option {
    public static final CommodityBasketOptionMeta metaData = new CommodityBasketOptionMeta();

    public PutCallEnum getOptionType();

    public CommodityBasketOptionFeaturesModel getCommodityBasketOptionFeaturesModel();

    public CommodityBasketModel getCommodityBasketModel();

    public StrikePriceUnderlyingReference getStrikePriceUnderlyingReference();

    public StrikePriceBasketReference getStrikePriceBasketReference();

    public CommodityStrikePriceModel getCommodityStrikePriceModel();

    public CommodityFloatingStrikePriceModel getCommodityFloatingStrikePriceModel();

    public CommodityExerciseBasket getExercise();

    public List<? extends CommodityPremium> getPremium();

    public CommodityContentModel getCommodityContentModel();

    @Override
    public CommodityBasketOption build();

    @Override
    public CommodityBasketOptionBuilder toBuilder();

    public static CommodityBasketOptionBuilder builder() {
        return new CommodityBasketOptionBuilderImpl();
    }

    default public RosettaMetaData<? extends CommodityBasketOption> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommodityBasketOption> getType() {
        return CommodityBasketOption.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionType"), PutCallEnum.class, (Object)this.getOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityBasketOptionFeaturesModel"), processor, CommodityBasketOptionFeaturesModel.class, this.getCommodityBasketOptionFeaturesModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityBasketModel"), processor, CommodityBasketModel.class, this.getCommodityBasketModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikePriceUnderlyingReference"), processor, StrikePriceUnderlyingReference.class, this.getStrikePriceUnderlyingReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikePriceBasketReference"), processor, StrikePriceBasketReference.class, this.getStrikePriceBasketReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityStrikePriceModel"), processor, CommodityStrikePriceModel.class, this.getCommodityStrikePriceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityFloatingStrikePriceModel"), processor, CommodityFloatingStrikePriceModel.class, this.getCommodityFloatingStrikePriceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exercise"), processor, CommodityExerciseBasket.class, this.getExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("premium"), processor, CommodityPremium.class, this.getPremium(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityContentModel"), processor, CommodityContentModel.class, this.getCommodityContentModel(), new AttributeMeta[0]);
    }

    public static class CommodityBasketOptionBuilderImpl
    extends Option.OptionBuilderImpl
    implements CommodityBasketOptionBuilder {
        protected PutCallEnum optionType;
        protected CommodityBasketOptionFeaturesModel.CommodityBasketOptionFeaturesModelBuilder commodityBasketOptionFeaturesModel;
        protected CommodityBasketModel.CommodityBasketModelBuilder commodityBasketModel;
        protected StrikePriceUnderlyingReference.StrikePriceUnderlyingReferenceBuilder strikePriceUnderlyingReference;
        protected StrikePriceBasketReference.StrikePriceBasketReferenceBuilder strikePriceBasketReference;
        protected CommodityStrikePriceModel.CommodityStrikePriceModelBuilder commodityStrikePriceModel;
        protected CommodityFloatingStrikePriceModel.CommodityFloatingStrikePriceModelBuilder commodityFloatingStrikePriceModel;
        protected CommodityExerciseBasket.CommodityExerciseBasketBuilder exercise;
        protected List<CommodityPremium.CommodityPremiumBuilder> premium = new ArrayList<CommodityPremium.CommodityPremiumBuilder>();
        protected CommodityContentModel.CommodityContentModelBuilder commodityContentModel;

        @Override
        @RosettaAttribute(value="optionType", isRequired=true)
        @RuneAttribute(value="optionType", isRequired=true)
        public PutCallEnum getOptionType() {
            return this.optionType;
        }

        @Override
        @RosettaAttribute(value="commodityBasketOptionFeaturesModel")
        @RuneAttribute(value="commodityBasketOptionFeaturesModel")
        public CommodityBasketOptionFeaturesModel.CommodityBasketOptionFeaturesModelBuilder getCommodityBasketOptionFeaturesModel() {
            return this.commodityBasketOptionFeaturesModel;
        }

        @Override
        public CommodityBasketOptionFeaturesModel.CommodityBasketOptionFeaturesModelBuilder getOrCreateCommodityBasketOptionFeaturesModel() {
            CommodityBasketOptionFeaturesModel.CommodityBasketOptionFeaturesModelBuilder result = this.commodityBasketOptionFeaturesModel != null ? this.commodityBasketOptionFeaturesModel : (this.commodityBasketOptionFeaturesModel = CommodityBasketOptionFeaturesModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="commodityBasketModel", isRequired=true)
        @RuneAttribute(value="commodityBasketModel", isRequired=true)
        public CommodityBasketModel.CommodityBasketModelBuilder getCommodityBasketModel() {
            return this.commodityBasketModel;
        }

        @Override
        public CommodityBasketModel.CommodityBasketModelBuilder getOrCreateCommodityBasketModel() {
            CommodityBasketModel.CommodityBasketModelBuilder result = this.commodityBasketModel != null ? this.commodityBasketModel : (this.commodityBasketModel = CommodityBasketModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="strikePriceUnderlyingReference")
        @RuneAttribute(value="strikePriceUnderlyingReference")
        public StrikePriceUnderlyingReference.StrikePriceUnderlyingReferenceBuilder getStrikePriceUnderlyingReference() {
            return this.strikePriceUnderlyingReference;
        }

        @Override
        public StrikePriceUnderlyingReference.StrikePriceUnderlyingReferenceBuilder getOrCreateStrikePriceUnderlyingReference() {
            StrikePriceUnderlyingReference.StrikePriceUnderlyingReferenceBuilder result = this.strikePriceUnderlyingReference != null ? this.strikePriceUnderlyingReference : (this.strikePriceUnderlyingReference = StrikePriceUnderlyingReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="strikePriceBasketReference")
        @RuneAttribute(value="strikePriceBasketReference")
        public StrikePriceBasketReference.StrikePriceBasketReferenceBuilder getStrikePriceBasketReference() {
            return this.strikePriceBasketReference;
        }

        @Override
        public StrikePriceBasketReference.StrikePriceBasketReferenceBuilder getOrCreateStrikePriceBasketReference() {
            StrikePriceBasketReference.StrikePriceBasketReferenceBuilder result = this.strikePriceBasketReference != null ? this.strikePriceBasketReference : (this.strikePriceBasketReference = StrikePriceBasketReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="commodityStrikePriceModel")
        @RuneAttribute(value="commodityStrikePriceModel")
        public CommodityStrikePriceModel.CommodityStrikePriceModelBuilder getCommodityStrikePriceModel() {
            return this.commodityStrikePriceModel;
        }

        @Override
        public CommodityStrikePriceModel.CommodityStrikePriceModelBuilder getOrCreateCommodityStrikePriceModel() {
            CommodityStrikePriceModel.CommodityStrikePriceModelBuilder result = this.commodityStrikePriceModel != null ? this.commodityStrikePriceModel : (this.commodityStrikePriceModel = CommodityStrikePriceModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="commodityFloatingStrikePriceModel")
        @RuneAttribute(value="commodityFloatingStrikePriceModel")
        public CommodityFloatingStrikePriceModel.CommodityFloatingStrikePriceModelBuilder getCommodityFloatingStrikePriceModel() {
            return this.commodityFloatingStrikePriceModel;
        }

        @Override
        public CommodityFloatingStrikePriceModel.CommodityFloatingStrikePriceModelBuilder getOrCreateCommodityFloatingStrikePriceModel() {
            CommodityFloatingStrikePriceModel.CommodityFloatingStrikePriceModelBuilder result = this.commodityFloatingStrikePriceModel != null ? this.commodityFloatingStrikePriceModel : (this.commodityFloatingStrikePriceModel = CommodityFloatingStrikePriceModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exercise", isRequired=true)
        @RuneAttribute(value="exercise", isRequired=true)
        public CommodityExerciseBasket.CommodityExerciseBasketBuilder getExercise() {
            return this.exercise;
        }

        @Override
        public CommodityExerciseBasket.CommodityExerciseBasketBuilder getOrCreateExercise() {
            CommodityExerciseBasket.CommodityExerciseBasketBuilder result = this.exercise != null ? this.exercise : (this.exercise = CommodityExerciseBasket.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="premium", isRequired=true)
        @RuneAttribute(value="premium", isRequired=true)
        public List<? extends CommodityPremium.CommodityPremiumBuilder> getPremium() {
            return this.premium;
        }

        @Override
        public CommodityPremium.CommodityPremiumBuilder getOrCreatePremium(int index) {
            if (this.premium == null) {
                this.premium = new ArrayList<CommodityPremium.CommodityPremiumBuilder>();
            }
            return (CommodityPremium.CommodityPremiumBuilder)this.getIndex(this.premium, index, () -> {
                CommodityPremium.CommodityPremiumBuilder newPremium = CommodityPremium.builder();
                return newPremium;
            });
        }

        @Override
        @RosettaAttribute(value="commodityContentModel")
        @RuneAttribute(value="commodityContentModel")
        public CommodityContentModel.CommodityContentModelBuilder getCommodityContentModel() {
            return this.commodityContentModel;
        }

        @Override
        public CommodityContentModel.CommodityContentModelBuilder getOrCreateCommodityContentModel() {
            CommodityContentModel.CommodityContentModelBuilder result = this.commodityContentModel != null ? this.commodityContentModel : (this.commodityContentModel = CommodityContentModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public CommodityBasketOptionBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public CommodityBasketOptionBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public CommodityBasketOptionBuilder setBuyerSellerModel(BuyerSellerModel _buyerSellerModel) {
            this.buyerSellerModel = _buyerSellerModel == null ? null : _buyerSellerModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionType", isRequired=true)
        @RuneAttribute(value="optionType", isRequired=true)
        public CommodityBasketOptionBuilder setOptionType(PutCallEnum _optionType) {
            this.optionType = _optionType == null ? null : _optionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityBasketOptionFeaturesModel")
        @RuneAttribute(value="commodityBasketOptionFeaturesModel")
        public CommodityBasketOptionBuilder setCommodityBasketOptionFeaturesModel(CommodityBasketOptionFeaturesModel _commodityBasketOptionFeaturesModel) {
            this.commodityBasketOptionFeaturesModel = _commodityBasketOptionFeaturesModel == null ? null : _commodityBasketOptionFeaturesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityBasketModel", isRequired=true)
        @RuneAttribute(value="commodityBasketModel", isRequired=true)
        public CommodityBasketOptionBuilder setCommodityBasketModel(CommodityBasketModel _commodityBasketModel) {
            this.commodityBasketModel = _commodityBasketModel == null ? null : _commodityBasketModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePriceUnderlyingReference")
        @RuneAttribute(value="strikePriceUnderlyingReference")
        public CommodityBasketOptionBuilder setStrikePriceUnderlyingReference(StrikePriceUnderlyingReference _strikePriceUnderlyingReference) {
            this.strikePriceUnderlyingReference = _strikePriceUnderlyingReference == null ? null : _strikePriceUnderlyingReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePriceBasketReference")
        @RuneAttribute(value="strikePriceBasketReference")
        public CommodityBasketOptionBuilder setStrikePriceBasketReference(StrikePriceBasketReference _strikePriceBasketReference) {
            this.strikePriceBasketReference = _strikePriceBasketReference == null ? null : _strikePriceBasketReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityStrikePriceModel")
        @RuneAttribute(value="commodityStrikePriceModel")
        public CommodityBasketOptionBuilder setCommodityStrikePriceModel(CommodityStrikePriceModel _commodityStrikePriceModel) {
            this.commodityStrikePriceModel = _commodityStrikePriceModel == null ? null : _commodityStrikePriceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityFloatingStrikePriceModel")
        @RuneAttribute(value="commodityFloatingStrikePriceModel")
        public CommodityBasketOptionBuilder setCommodityFloatingStrikePriceModel(CommodityFloatingStrikePriceModel _commodityFloatingStrikePriceModel) {
            this.commodityFloatingStrikePriceModel = _commodityFloatingStrikePriceModel == null ? null : _commodityFloatingStrikePriceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exercise", isRequired=true)
        @RuneAttribute(value="exercise", isRequired=true)
        public CommodityBasketOptionBuilder setExercise(CommodityExerciseBasket _exercise) {
            this.exercise = _exercise == null ? null : _exercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="premium", isRequired=true)
        @RuneAttribute(value="premium", isRequired=true)
        public CommodityBasketOptionBuilder addPremium(CommodityPremium _premium) {
            if (_premium != null) {
                this.premium.add(_premium.toBuilder());
            }
            return this;
        }

        @Override
        public CommodityBasketOptionBuilder addPremium(CommodityPremium _premium, int idx) {
            this.getIndex(this.premium, idx, () -> _premium.toBuilder());
            return this;
        }

        @Override
        public CommodityBasketOptionBuilder addPremium(List<? extends CommodityPremium> premiums) {
            if (premiums != null) {
                for (CommodityPremium commodityPremium : premiums) {
                    this.premium.add(commodityPremium.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="premium")
        public CommodityBasketOptionBuilder setPremium(List<? extends CommodityPremium> premiums) {
            this.premium = premiums == null ? new ArrayList<CommodityPremium.CommodityPremiumBuilder>() : (List)premiums.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityContentModel")
        @RuneAttribute(value="commodityContentModel")
        public CommodityBasketOptionBuilder setCommodityContentModel(CommodityContentModel _commodityContentModel) {
            this.commodityContentModel = _commodityContentModel == null ? null : _commodityContentModel.toBuilder();
            return this;
        }

        @Override
        public CommodityBasketOption build() {
            return new CommodityBasketOptionImpl(this);
        }

        @Override
        public CommodityBasketOptionBuilder toBuilder() {
            return this;
        }

        @Override
        public CommodityBasketOptionBuilder prune() {
            super.prune();
            if (this.commodityBasketOptionFeaturesModel != null && !this.commodityBasketOptionFeaturesModel.prune().hasData()) {
                this.commodityBasketOptionFeaturesModel = null;
            }
            if (this.commodityBasketModel != null && !this.commodityBasketModel.prune().hasData()) {
                this.commodityBasketModel = null;
            }
            if (this.strikePriceUnderlyingReference != null && !this.strikePriceUnderlyingReference.prune().hasData()) {
                this.strikePriceUnderlyingReference = null;
            }
            if (this.strikePriceBasketReference != null && !this.strikePriceBasketReference.prune().hasData()) {
                this.strikePriceBasketReference = null;
            }
            if (this.commodityStrikePriceModel != null && !this.commodityStrikePriceModel.prune().hasData()) {
                this.commodityStrikePriceModel = null;
            }
            if (this.commodityFloatingStrikePriceModel != null && !this.commodityFloatingStrikePriceModel.prune().hasData()) {
                this.commodityFloatingStrikePriceModel = null;
            }
            if (this.exercise != null && !this.exercise.prune().hasData()) {
                this.exercise = null;
            }
            this.premium = this.premium.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.commodityContentModel != null && !this.commodityContentModel.prune().hasData()) {
                this.commodityContentModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getOptionType() != null) {
                return true;
            }
            if (this.getCommodityBasketOptionFeaturesModel() != null && this.getCommodityBasketOptionFeaturesModel().hasData()) {
                return true;
            }
            if (this.getCommodityBasketModel() != null && this.getCommodityBasketModel().hasData()) {
                return true;
            }
            if (this.getStrikePriceUnderlyingReference() != null && this.getStrikePriceUnderlyingReference().hasData()) {
                return true;
            }
            if (this.getStrikePriceBasketReference() != null && this.getStrikePriceBasketReference().hasData()) {
                return true;
            }
            if (this.getCommodityStrikePriceModel() != null && this.getCommodityStrikePriceModel().hasData()) {
                return true;
            }
            if (this.getCommodityFloatingStrikePriceModel() != null && this.getCommodityFloatingStrikePriceModel().hasData()) {
                return true;
            }
            if (this.getExercise() != null && this.getExercise().hasData()) {
                return true;
            }
            if (this.getPremium() != null && this.getPremium().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getCommodityContentModel() != null && this.getCommodityContentModel().hasData();
        }

        @Override
        public CommodityBasketOptionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CommodityBasketOptionBuilder o = (CommodityBasketOptionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodityBasketOptionFeaturesModel(), (RosettaModelObjectBuilder)o.getCommodityBasketOptionFeaturesModel(), this::setCommodityBasketOptionFeaturesModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodityBasketModel(), (RosettaModelObjectBuilder)o.getCommodityBasketModel(), this::setCommodityBasketModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStrikePriceUnderlyingReference(), (RosettaModelObjectBuilder)o.getStrikePriceUnderlyingReference(), this::setStrikePriceUnderlyingReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStrikePriceBasketReference(), (RosettaModelObjectBuilder)o.getStrikePriceBasketReference(), this::setStrikePriceBasketReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodityStrikePriceModel(), (RosettaModelObjectBuilder)o.getCommodityStrikePriceModel(), this::setCommodityStrikePriceModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodityFloatingStrikePriceModel(), (RosettaModelObjectBuilder)o.getCommodityFloatingStrikePriceModel(), this::setCommodityFloatingStrikePriceModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExercise(), (RosettaModelObjectBuilder)o.getExercise(), this::setExercise);
            merger.mergeRosetta(this.getPremium(), o.getPremium(), this::getOrCreatePremium);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodityContentModel(), (RosettaModelObjectBuilder)o.getCommodityContentModel(), this::setCommodityContentModel);
            merger.mergeBasic((Object)this.getOptionType(), (Object)o.getOptionType(), this::setOptionType, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommodityBasketOption _that = (CommodityBasketOption)this.getType().cast(o);
            if (!Objects.equals((Object)this.optionType, (Object)_that.getOptionType())) {
                return false;
            }
            if (!Objects.equals(this.commodityBasketOptionFeaturesModel, _that.getCommodityBasketOptionFeaturesModel())) {
                return false;
            }
            if (!Objects.equals(this.commodityBasketModel, _that.getCommodityBasketModel())) {
                return false;
            }
            if (!Objects.equals(this.strikePriceUnderlyingReference, _that.getStrikePriceUnderlyingReference())) {
                return false;
            }
            if (!Objects.equals(this.strikePriceBasketReference, _that.getStrikePriceBasketReference())) {
                return false;
            }
            if (!Objects.equals(this.commodityStrikePriceModel, _that.getCommodityStrikePriceModel())) {
                return false;
            }
            if (!Objects.equals(this.commodityFloatingStrikePriceModel, _that.getCommodityFloatingStrikePriceModel())) {
                return false;
            }
            if (!Objects.equals(this.exercise, _that.getExercise())) {
                return false;
            }
            if (!ListEquals.listEquals(this.premium, _that.getPremium())) {
                return false;
            }
            return Objects.equals(this.commodityContentModel, _that.getCommodityContentModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.optionType != null ? ((Object)((Object)this.optionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.commodityBasketOptionFeaturesModel != null ? this.commodityBasketOptionFeaturesModel.hashCode() : 0);
            _result = 31 * _result + (this.commodityBasketModel != null ? this.commodityBasketModel.hashCode() : 0);
            _result = 31 * _result + (this.strikePriceUnderlyingReference != null ? this.strikePriceUnderlyingReference.hashCode() : 0);
            _result = 31 * _result + (this.strikePriceBasketReference != null ? this.strikePriceBasketReference.hashCode() : 0);
            _result = 31 * _result + (this.commodityStrikePriceModel != null ? this.commodityStrikePriceModel.hashCode() : 0);
            _result = 31 * _result + (this.commodityFloatingStrikePriceModel != null ? this.commodityFloatingStrikePriceModel.hashCode() : 0);
            _result = 31 * _result + (this.exercise != null ? this.exercise.hashCode() : 0);
            _result = 31 * _result + (this.premium != null ? this.premium.hashCode() : 0);
            _result = 31 * _result + (this.commodityContentModel != null ? this.commodityContentModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommodityBasketOptionBuilder {optionType=" + String.valueOf((Object)this.optionType) + ", commodityBasketOptionFeaturesModel=" + String.valueOf(this.commodityBasketOptionFeaturesModel) + ", commodityBasketModel=" + String.valueOf(this.commodityBasketModel) + ", strikePriceUnderlyingReference=" + String.valueOf(this.strikePriceUnderlyingReference) + ", strikePriceBasketReference=" + String.valueOf(this.strikePriceBasketReference) + ", commodityStrikePriceModel=" + String.valueOf(this.commodityStrikePriceModel) + ", commodityFloatingStrikePriceModel=" + String.valueOf(this.commodityFloatingStrikePriceModel) + ", exercise=" + String.valueOf(this.exercise) + ", premium=" + String.valueOf(this.premium) + ", commodityContentModel=" + String.valueOf(this.commodityContentModel) + "} " + super.toString();
        }
    }

    public static interface CommodityBasketOptionBuilder
    extends CommodityBasketOption,
    Option.OptionBuilder {
        public CommodityBasketOptionFeaturesModel.CommodityBasketOptionFeaturesModelBuilder getOrCreateCommodityBasketOptionFeaturesModel();

        @Override
        public CommodityBasketOptionFeaturesModel.CommodityBasketOptionFeaturesModelBuilder getCommodityBasketOptionFeaturesModel();

        public CommodityBasketModel.CommodityBasketModelBuilder getOrCreateCommodityBasketModel();

        @Override
        public CommodityBasketModel.CommodityBasketModelBuilder getCommodityBasketModel();

        public StrikePriceUnderlyingReference.StrikePriceUnderlyingReferenceBuilder getOrCreateStrikePriceUnderlyingReference();

        @Override
        public StrikePriceUnderlyingReference.StrikePriceUnderlyingReferenceBuilder getStrikePriceUnderlyingReference();

        public StrikePriceBasketReference.StrikePriceBasketReferenceBuilder getOrCreateStrikePriceBasketReference();

        @Override
        public StrikePriceBasketReference.StrikePriceBasketReferenceBuilder getStrikePriceBasketReference();

        public CommodityStrikePriceModel.CommodityStrikePriceModelBuilder getOrCreateCommodityStrikePriceModel();

        @Override
        public CommodityStrikePriceModel.CommodityStrikePriceModelBuilder getCommodityStrikePriceModel();

        public CommodityFloatingStrikePriceModel.CommodityFloatingStrikePriceModelBuilder getOrCreateCommodityFloatingStrikePriceModel();

        @Override
        public CommodityFloatingStrikePriceModel.CommodityFloatingStrikePriceModelBuilder getCommodityFloatingStrikePriceModel();

        public CommodityExerciseBasket.CommodityExerciseBasketBuilder getOrCreateExercise();

        @Override
        public CommodityExerciseBasket.CommodityExerciseBasketBuilder getExercise();

        public CommodityPremium.CommodityPremiumBuilder getOrCreatePremium(int var1);

        public List<? extends CommodityPremium.CommodityPremiumBuilder> getPremium();

        public CommodityContentModel.CommodityContentModelBuilder getOrCreateCommodityContentModel();

        @Override
        public CommodityContentModel.CommodityContentModelBuilder getCommodityContentModel();

        @Override
        public CommodityBasketOptionBuilder setProductModel(ProductModel var1);

        @Override
        public CommodityBasketOptionBuilder setId(String var1);

        @Override
        public CommodityBasketOptionBuilder setBuyerSellerModel(BuyerSellerModel var1);

        public CommodityBasketOptionBuilder setOptionType(PutCallEnum var1);

        public CommodityBasketOptionBuilder setCommodityBasketOptionFeaturesModel(CommodityBasketOptionFeaturesModel var1);

        public CommodityBasketOptionBuilder setCommodityBasketModel(CommodityBasketModel var1);

        public CommodityBasketOptionBuilder setStrikePriceUnderlyingReference(StrikePriceUnderlyingReference var1);

        public CommodityBasketOptionBuilder setStrikePriceBasketReference(StrikePriceBasketReference var1);

        public CommodityBasketOptionBuilder setCommodityStrikePriceModel(CommodityStrikePriceModel var1);

        public CommodityBasketOptionBuilder setCommodityFloatingStrikePriceModel(CommodityFloatingStrikePriceModel var1);

        public CommodityBasketOptionBuilder setExercise(CommodityExerciseBasket var1);

        public CommodityBasketOptionBuilder addPremium(CommodityPremium var1);

        public CommodityBasketOptionBuilder addPremium(CommodityPremium var1, int var2);

        public CommodityBasketOptionBuilder addPremium(List<? extends CommodityPremium> var1);

        public CommodityBasketOptionBuilder setPremium(List<? extends CommodityPremium> var1);

        public CommodityBasketOptionBuilder setCommodityContentModel(CommodityContentModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.BuyerSellerModelBuilder.class, (RosettaModelObjectBuilder)this.getBuyerSellerModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionType"), PutCallEnum.class, (Object)this.getOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityBasketOptionFeaturesModel"), processor, CommodityBasketOptionFeaturesModel.CommodityBasketOptionFeaturesModelBuilder.class, this.getCommodityBasketOptionFeaturesModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityBasketModel"), processor, CommodityBasketModel.CommodityBasketModelBuilder.class, this.getCommodityBasketModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikePriceUnderlyingReference"), processor, StrikePriceUnderlyingReference.StrikePriceUnderlyingReferenceBuilder.class, this.getStrikePriceUnderlyingReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikePriceBasketReference"), processor, StrikePriceBasketReference.StrikePriceBasketReferenceBuilder.class, this.getStrikePriceBasketReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityStrikePriceModel"), processor, CommodityStrikePriceModel.CommodityStrikePriceModelBuilder.class, this.getCommodityStrikePriceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityFloatingStrikePriceModel"), processor, CommodityFloatingStrikePriceModel.CommodityFloatingStrikePriceModelBuilder.class, this.getCommodityFloatingStrikePriceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exercise"), processor, CommodityExerciseBasket.CommodityExerciseBasketBuilder.class, this.getExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("premium"), processor, CommodityPremium.CommodityPremiumBuilder.class, this.getPremium(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityContentModel"), processor, CommodityContentModel.CommodityContentModelBuilder.class, this.getCommodityContentModel(), new AttributeMeta[0]);
        }

        @Override
        public CommodityBasketOptionBuilder prune();
    }

    public static class CommodityBasketOptionImpl
    extends Option.OptionImpl
    implements CommodityBasketOption {
        private final PutCallEnum optionType;
        private final CommodityBasketOptionFeaturesModel commodityBasketOptionFeaturesModel;
        private final CommodityBasketModel commodityBasketModel;
        private final StrikePriceUnderlyingReference strikePriceUnderlyingReference;
        private final StrikePriceBasketReference strikePriceBasketReference;
        private final CommodityStrikePriceModel commodityStrikePriceModel;
        private final CommodityFloatingStrikePriceModel commodityFloatingStrikePriceModel;
        private final CommodityExerciseBasket exercise;
        private final List<? extends CommodityPremium> premium;
        private final CommodityContentModel commodityContentModel;

        protected CommodityBasketOptionImpl(CommodityBasketOptionBuilder builder) {
            super(builder);
            this.optionType = builder.getOptionType();
            this.commodityBasketOptionFeaturesModel = Optional.ofNullable(builder.getCommodityBasketOptionFeaturesModel()).map(f -> f.build()).orElse(null);
            this.commodityBasketModel = Optional.ofNullable(builder.getCommodityBasketModel()).map(f -> f.build()).orElse(null);
            this.strikePriceUnderlyingReference = Optional.ofNullable(builder.getStrikePriceUnderlyingReference()).map(f -> f.build()).orElse(null);
            this.strikePriceBasketReference = Optional.ofNullable(builder.getStrikePriceBasketReference()).map(f -> f.build()).orElse(null);
            this.commodityStrikePriceModel = Optional.ofNullable(builder.getCommodityStrikePriceModel()).map(f -> f.build()).orElse(null);
            this.commodityFloatingStrikePriceModel = Optional.ofNullable(builder.getCommodityFloatingStrikePriceModel()).map(f -> f.build()).orElse(null);
            this.exercise = Optional.ofNullable(builder.getExercise()).map(f -> f.build()).orElse(null);
            this.premium = Optional.ofNullable(builder.getPremium()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.commodityContentModel = Optional.ofNullable(builder.getCommodityContentModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="optionType", isRequired=true)
        @RuneAttribute(value="optionType", isRequired=true)
        public PutCallEnum getOptionType() {
            return this.optionType;
        }

        @Override
        @RosettaAttribute(value="commodityBasketOptionFeaturesModel")
        @RuneAttribute(value="commodityBasketOptionFeaturesModel")
        public CommodityBasketOptionFeaturesModel getCommodityBasketOptionFeaturesModel() {
            return this.commodityBasketOptionFeaturesModel;
        }

        @Override
        @RosettaAttribute(value="commodityBasketModel", isRequired=true)
        @RuneAttribute(value="commodityBasketModel", isRequired=true)
        public CommodityBasketModel getCommodityBasketModel() {
            return this.commodityBasketModel;
        }

        @Override
        @RosettaAttribute(value="strikePriceUnderlyingReference")
        @RuneAttribute(value="strikePriceUnderlyingReference")
        public StrikePriceUnderlyingReference getStrikePriceUnderlyingReference() {
            return this.strikePriceUnderlyingReference;
        }

        @Override
        @RosettaAttribute(value="strikePriceBasketReference")
        @RuneAttribute(value="strikePriceBasketReference")
        public StrikePriceBasketReference getStrikePriceBasketReference() {
            return this.strikePriceBasketReference;
        }

        @Override
        @RosettaAttribute(value="commodityStrikePriceModel")
        @RuneAttribute(value="commodityStrikePriceModel")
        public CommodityStrikePriceModel getCommodityStrikePriceModel() {
            return this.commodityStrikePriceModel;
        }

        @Override
        @RosettaAttribute(value="commodityFloatingStrikePriceModel")
        @RuneAttribute(value="commodityFloatingStrikePriceModel")
        public CommodityFloatingStrikePriceModel getCommodityFloatingStrikePriceModel() {
            return this.commodityFloatingStrikePriceModel;
        }

        @Override
        @RosettaAttribute(value="exercise", isRequired=true)
        @RuneAttribute(value="exercise", isRequired=true)
        public CommodityExerciseBasket getExercise() {
            return this.exercise;
        }

        @Override
        @RosettaAttribute(value="premium", isRequired=true)
        @RuneAttribute(value="premium", isRequired=true)
        public List<? extends CommodityPremium> getPremium() {
            return this.premium;
        }

        @Override
        @RosettaAttribute(value="commodityContentModel")
        @RuneAttribute(value="commodityContentModel")
        public CommodityContentModel getCommodityContentModel() {
            return this.commodityContentModel;
        }

        @Override
        public CommodityBasketOption build() {
            return this;
        }

        @Override
        public CommodityBasketOptionBuilder toBuilder() {
            CommodityBasketOptionBuilder builder = CommodityBasketOption.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommodityBasketOptionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getOptionType()).ifPresent(builder::setOptionType);
            Optional.ofNullable(this.getCommodityBasketOptionFeaturesModel()).ifPresent(builder::setCommodityBasketOptionFeaturesModel);
            Optional.ofNullable(this.getCommodityBasketModel()).ifPresent(builder::setCommodityBasketModel);
            Optional.ofNullable(this.getStrikePriceUnderlyingReference()).ifPresent(builder::setStrikePriceUnderlyingReference);
            Optional.ofNullable(this.getStrikePriceBasketReference()).ifPresent(builder::setStrikePriceBasketReference);
            Optional.ofNullable(this.getCommodityStrikePriceModel()).ifPresent(builder::setCommodityStrikePriceModel);
            Optional.ofNullable(this.getCommodityFloatingStrikePriceModel()).ifPresent(builder::setCommodityFloatingStrikePriceModel);
            Optional.ofNullable(this.getExercise()).ifPresent(builder::setExercise);
            Optional.ofNullable(this.getPremium()).ifPresent(builder::setPremium);
            Optional.ofNullable(this.getCommodityContentModel()).ifPresent(builder::setCommodityContentModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommodityBasketOption _that = (CommodityBasketOption)this.getType().cast(o);
            if (!Objects.equals((Object)this.optionType, (Object)_that.getOptionType())) {
                return false;
            }
            if (!Objects.equals(this.commodityBasketOptionFeaturesModel, _that.getCommodityBasketOptionFeaturesModel())) {
                return false;
            }
            if (!Objects.equals(this.commodityBasketModel, _that.getCommodityBasketModel())) {
                return false;
            }
            if (!Objects.equals(this.strikePriceUnderlyingReference, _that.getStrikePriceUnderlyingReference())) {
                return false;
            }
            if (!Objects.equals(this.strikePriceBasketReference, _that.getStrikePriceBasketReference())) {
                return false;
            }
            if (!Objects.equals(this.commodityStrikePriceModel, _that.getCommodityStrikePriceModel())) {
                return false;
            }
            if (!Objects.equals(this.commodityFloatingStrikePriceModel, _that.getCommodityFloatingStrikePriceModel())) {
                return false;
            }
            if (!Objects.equals(this.exercise, _that.getExercise())) {
                return false;
            }
            if (!ListEquals.listEquals(this.premium, _that.getPremium())) {
                return false;
            }
            return Objects.equals(this.commodityContentModel, _that.getCommodityContentModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.optionType != null ? ((Object)((Object)this.optionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.commodityBasketOptionFeaturesModel != null ? this.commodityBasketOptionFeaturesModel.hashCode() : 0);
            _result = 31 * _result + (this.commodityBasketModel != null ? this.commodityBasketModel.hashCode() : 0);
            _result = 31 * _result + (this.strikePriceUnderlyingReference != null ? this.strikePriceUnderlyingReference.hashCode() : 0);
            _result = 31 * _result + (this.strikePriceBasketReference != null ? this.strikePriceBasketReference.hashCode() : 0);
            _result = 31 * _result + (this.commodityStrikePriceModel != null ? this.commodityStrikePriceModel.hashCode() : 0);
            _result = 31 * _result + (this.commodityFloatingStrikePriceModel != null ? this.commodityFloatingStrikePriceModel.hashCode() : 0);
            _result = 31 * _result + (this.exercise != null ? this.exercise.hashCode() : 0);
            _result = 31 * _result + (this.premium != null ? this.premium.hashCode() : 0);
            _result = 31 * _result + (this.commodityContentModel != null ? this.commodityContentModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommodityBasketOption {optionType=" + String.valueOf((Object)this.optionType) + ", commodityBasketOptionFeaturesModel=" + String.valueOf(this.commodityBasketOptionFeaturesModel) + ", commodityBasketModel=" + String.valueOf(this.commodityBasketModel) + ", strikePriceUnderlyingReference=" + String.valueOf(this.strikePriceUnderlyingReference) + ", strikePriceBasketReference=" + String.valueOf(this.strikePriceBasketReference) + ", commodityStrikePriceModel=" + String.valueOf(this.commodityStrikePriceModel) + ", commodityFloatingStrikePriceModel=" + String.valueOf(this.commodityFloatingStrikePriceModel) + ", exercise=" + String.valueOf(this.exercise) + ", premium=" + String.valueOf(this.premium) + ", commodityContentModel=" + String.valueOf(this.commodityContentModel) + "} " + super.toString();
        }
    }
}

