/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.com.CommodityBasketBase;
import fpml.consolidated.com.CommodityBasketUnderlyingByPercentage;
import fpml.consolidated.com.meta.CommodityBasketByPercentageMeta;
import fpml.consolidated.shared.NotionalAmount;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CommodityBasketByPercentage", builder=CommodityBasketByPercentageBuilderImpl.class, version="1.2.2")
@RuneDataType(value="CommodityBasketByPercentage", model="fpml", builder=CommodityBasketByPercentageBuilderImpl.class, version="1.2.2")
public interface CommodityBasketByPercentage
extends CommodityBasketBase {
    public static final CommodityBasketByPercentageMeta metaData = new CommodityBasketByPercentageMeta();

    public List<? extends CommodityBasketUnderlyingByPercentage> getUnderlying();

    public NotionalAmount getNotionalAmount();

    @Override
    public CommodityBasketByPercentage build();

    @Override
    public CommodityBasketByPercentageBuilder toBuilder();

    public static CommodityBasketByPercentageBuilder builder() {
        return new CommodityBasketByPercentageBuilderImpl();
    }

    default public RosettaMetaData<? extends CommodityBasketByPercentage> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommodityBasketByPercentage> getType() {
        return CommodityBasketByPercentage.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlying"), processor, CommodityBasketUnderlyingByPercentage.class, this.getUnderlying(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalAmount"), processor, NotionalAmount.class, this.getNotionalAmount(), new AttributeMeta[0]);
    }

    public static class CommodityBasketByPercentageBuilderImpl
    extends CommodityBasketBase.CommodityBasketBaseBuilderImpl
    implements CommodityBasketByPercentageBuilder {
        protected List<CommodityBasketUnderlyingByPercentage.CommodityBasketUnderlyingByPercentageBuilder> underlying = new ArrayList<CommodityBasketUnderlyingByPercentage.CommodityBasketUnderlyingByPercentageBuilder>();
        protected NotionalAmount.NotionalAmountBuilder notionalAmount;

        @Override
        @RosettaAttribute(value="underlying")
        @RuneAttribute(value="underlying")
        public List<? extends CommodityBasketUnderlyingByPercentage.CommodityBasketUnderlyingByPercentageBuilder> getUnderlying() {
            return this.underlying;
        }

        @Override
        public CommodityBasketUnderlyingByPercentage.CommodityBasketUnderlyingByPercentageBuilder getOrCreateUnderlying(int index) {
            if (this.underlying == null) {
                this.underlying = new ArrayList<CommodityBasketUnderlyingByPercentage.CommodityBasketUnderlyingByPercentageBuilder>();
            }
            return (CommodityBasketUnderlyingByPercentage.CommodityBasketUnderlyingByPercentageBuilder)this.getIndex(this.underlying, index, () -> {
                CommodityBasketUnderlyingByPercentage.CommodityBasketUnderlyingByPercentageBuilder newUnderlying = CommodityBasketUnderlyingByPercentage.builder();
                return newUnderlying;
            });
        }

        @Override
        @RosettaAttribute(value="notionalAmount")
        @RuneAttribute(value="notionalAmount")
        public NotionalAmount.NotionalAmountBuilder getNotionalAmount() {
            return this.notionalAmount;
        }

        @Override
        public NotionalAmount.NotionalAmountBuilder getOrCreateNotionalAmount() {
            NotionalAmount.NotionalAmountBuilder result = this.notionalAmount != null ? this.notionalAmount : (this.notionalAmount = NotionalAmount.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public CommodityBasketByPercentageBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlying")
        @RuneAttribute(value="underlying")
        public CommodityBasketByPercentageBuilder addUnderlying(CommodityBasketUnderlyingByPercentage _underlying) {
            if (_underlying != null) {
                this.underlying.add(_underlying.toBuilder());
            }
            return this;
        }

        @Override
        public CommodityBasketByPercentageBuilder addUnderlying(CommodityBasketUnderlyingByPercentage _underlying, int idx) {
            this.getIndex(this.underlying, idx, () -> _underlying.toBuilder());
            return this;
        }

        @Override
        public CommodityBasketByPercentageBuilder addUnderlying(List<? extends CommodityBasketUnderlyingByPercentage> underlyings) {
            if (underlyings != null) {
                for (CommodityBasketUnderlyingByPercentage commodityBasketUnderlyingByPercentage : underlyings) {
                    this.underlying.add(commodityBasketUnderlyingByPercentage.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="underlying")
        public CommodityBasketByPercentageBuilder setUnderlying(List<? extends CommodityBasketUnderlyingByPercentage> underlyings) {
            this.underlying = underlyings == null ? new ArrayList<CommodityBasketUnderlyingByPercentage.CommodityBasketUnderlyingByPercentageBuilder>() : (List)underlyings.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmount")
        @RuneAttribute(value="notionalAmount")
        public CommodityBasketByPercentageBuilder setNotionalAmount(NotionalAmount _notionalAmount) {
            this.notionalAmount = _notionalAmount == null ? null : _notionalAmount.toBuilder();
            return this;
        }

        @Override
        public CommodityBasketByPercentage build() {
            return new CommodityBasketByPercentageImpl(this);
        }

        @Override
        public CommodityBasketByPercentageBuilder toBuilder() {
            return this;
        }

        @Override
        public CommodityBasketByPercentageBuilder prune() {
            super.prune();
            this.underlying = this.underlying.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.notionalAmount != null && !this.notionalAmount.prune().hasData()) {
                this.notionalAmount = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getUnderlying() != null && this.getUnderlying().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getNotionalAmount() != null && this.getNotionalAmount().hasData();
        }

        @Override
        public CommodityBasketByPercentageBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CommodityBasketByPercentageBuilder o = (CommodityBasketByPercentageBuilder)other;
            merger.mergeRosetta(this.getUnderlying(), o.getUnderlying(), this::getOrCreateUnderlying);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotionalAmount(), (RosettaModelObjectBuilder)o.getNotionalAmount(), this::setNotionalAmount);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommodityBasketByPercentage _that = (CommodityBasketByPercentage)this.getType().cast(o);
            if (!ListEquals.listEquals(this.underlying, _that.getUnderlying())) {
                return false;
            }
            return Objects.equals(this.notionalAmount, _that.getNotionalAmount());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.underlying != null ? this.underlying.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmount != null ? this.notionalAmount.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommodityBasketByPercentageBuilder {underlying=" + String.valueOf(this.underlying) + ", notionalAmount=" + String.valueOf(this.notionalAmount) + "} " + super.toString();
        }
    }

    public static interface CommodityBasketByPercentageBuilder
    extends CommodityBasketByPercentage,
    CommodityBasketBase.CommodityBasketBaseBuilder {
        public CommodityBasketUnderlyingByPercentage.CommodityBasketUnderlyingByPercentageBuilder getOrCreateUnderlying(int var1);

        public List<? extends CommodityBasketUnderlyingByPercentage.CommodityBasketUnderlyingByPercentageBuilder> getUnderlying();

        public NotionalAmount.NotionalAmountBuilder getOrCreateNotionalAmount();

        @Override
        public NotionalAmount.NotionalAmountBuilder getNotionalAmount();

        @Override
        public CommodityBasketByPercentageBuilder setId(String var1);

        public CommodityBasketByPercentageBuilder addUnderlying(CommodityBasketUnderlyingByPercentage var1);

        public CommodityBasketByPercentageBuilder addUnderlying(CommodityBasketUnderlyingByPercentage var1, int var2);

        public CommodityBasketByPercentageBuilder addUnderlying(List<? extends CommodityBasketUnderlyingByPercentage> var1);

        public CommodityBasketByPercentageBuilder setUnderlying(List<? extends CommodityBasketUnderlyingByPercentage> var1);

        public CommodityBasketByPercentageBuilder setNotionalAmount(NotionalAmount var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlying"), processor, CommodityBasketUnderlyingByPercentage.CommodityBasketUnderlyingByPercentageBuilder.class, this.getUnderlying(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalAmount"), processor, NotionalAmount.NotionalAmountBuilder.class, this.getNotionalAmount(), new AttributeMeta[0]);
        }

        @Override
        public CommodityBasketByPercentageBuilder prune();
    }

    public static class CommodityBasketByPercentageImpl
    extends CommodityBasketBase.CommodityBasketBaseImpl
    implements CommodityBasketByPercentage {
        private final List<? extends CommodityBasketUnderlyingByPercentage> underlying;
        private final NotionalAmount notionalAmount;

        protected CommodityBasketByPercentageImpl(CommodityBasketByPercentageBuilder builder) {
            super(builder);
            this.underlying = Optional.ofNullable(builder.getUnderlying()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.notionalAmount = Optional.ofNullable(builder.getNotionalAmount()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="underlying")
        @RuneAttribute(value="underlying")
        public List<? extends CommodityBasketUnderlyingByPercentage> getUnderlying() {
            return this.underlying;
        }

        @Override
        @RosettaAttribute(value="notionalAmount")
        @RuneAttribute(value="notionalAmount")
        public NotionalAmount getNotionalAmount() {
            return this.notionalAmount;
        }

        @Override
        public CommodityBasketByPercentage build() {
            return this;
        }

        @Override
        public CommodityBasketByPercentageBuilder toBuilder() {
            CommodityBasketByPercentageBuilder builder = CommodityBasketByPercentage.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommodityBasketByPercentageBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getUnderlying()).ifPresent(builder::setUnderlying);
            Optional.ofNullable(this.getNotionalAmount()).ifPresent(builder::setNotionalAmount);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommodityBasketByPercentage _that = (CommodityBasketByPercentage)this.getType().cast(o);
            if (!ListEquals.listEquals(this.underlying, _that.getUnderlying())) {
                return false;
            }
            return Objects.equals(this.notionalAmount, _that.getNotionalAmount());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.underlying != null ? this.underlying.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmount != null ? this.notionalAmount.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommodityBasketByPercentage {underlying=" + String.valueOf(this.underlying) + ", notionalAmount=" + String.valueOf(this.notionalAmount) + "} " + super.toString();
        }
    }
}

