/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.cd;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.cd.AdditionalTerm;
import fpml.consolidated.cd.BasketReferenceInformation;
import fpml.consolidated.cd.IndexReferenceInformation;
import fpml.consolidated.cd.ReferenceInformation;
import fpml.consolidated.cd.meta.GeneralTermsMeta;
import fpml.consolidated.shared.AdjustableDate2;
import fpml.consolidated.shared.BusinessDayAdjustments;
import fpml.consolidated.shared.BuyerSellerModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="GeneralTerms", builder=GeneralTermsBuilderImpl.class, version="1.2.2")
@RuneDataType(value="GeneralTerms", model="fpml", builder=GeneralTermsBuilderImpl.class, version="1.2.2")
public interface GeneralTerms
extends RosettaModelObject {
    public static final GeneralTermsMeta metaData = new GeneralTermsMeta();

    public AdjustableDate2 getEffectiveDate();

    public AdjustableDate2 getScheduledTerminationDate();

    public BuyerSellerModel getBuyerSellerModel();

    public BusinessDayAdjustments getDateAdjustments();

    public ReferenceInformation getReferenceInformation();

    public IndexReferenceInformation getIndexReferenceInformation();

    public BasketReferenceInformation getBasketReferenceInformation();

    public List<? extends AdditionalTerm> getAdditionalTerm();

    public Boolean getSubstitution();

    public Boolean getModifiedEquityDelivery();

    public GeneralTerms build();

    public GeneralTermsBuilder toBuilder();

    public static GeneralTermsBuilder builder() {
        return new GeneralTermsBuilderImpl();
    }

    default public RosettaMetaData<? extends GeneralTerms> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends GeneralTerms> getType() {
        return GeneralTerms.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableDate2.class, this.getEffectiveDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("scheduledTerminationDate"), processor, AdjustableDate2.class, this.getScheduledTerminationDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dateAdjustments"), processor, BusinessDayAdjustments.class, this.getDateAdjustments(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("referenceInformation"), processor, ReferenceInformation.class, this.getReferenceInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("indexReferenceInformation"), processor, IndexReferenceInformation.class, this.getIndexReferenceInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("basketReferenceInformation"), processor, BasketReferenceInformation.class, this.getBasketReferenceInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("additionalTerm"), processor, AdditionalTerm.class, this.getAdditionalTerm(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("substitution"), Boolean.class, (Object)this.getSubstitution(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("modifiedEquityDelivery"), Boolean.class, (Object)this.getModifiedEquityDelivery(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class GeneralTermsBuilderImpl
    implements GeneralTermsBuilder {
        protected AdjustableDate2.AdjustableDate2Builder effectiveDate;
        protected AdjustableDate2.AdjustableDate2Builder scheduledTerminationDate;
        protected BuyerSellerModel.BuyerSellerModelBuilder buyerSellerModel;
        protected BusinessDayAdjustments.BusinessDayAdjustmentsBuilder dateAdjustments;
        protected ReferenceInformation.ReferenceInformationBuilder referenceInformation;
        protected IndexReferenceInformation.IndexReferenceInformationBuilder indexReferenceInformation;
        protected BasketReferenceInformation.BasketReferenceInformationBuilder basketReferenceInformation;
        protected List<AdditionalTerm.AdditionalTermBuilder> additionalTerm = new ArrayList<AdditionalTerm.AdditionalTermBuilder>();
        protected Boolean substitution;
        protected Boolean modifiedEquityDelivery;

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public AdjustableDate2.AdjustableDate2Builder getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        public AdjustableDate2.AdjustableDate2Builder getOrCreateEffectiveDate() {
            AdjustableDate2.AdjustableDate2Builder result = this.effectiveDate != null ? this.effectiveDate : (this.effectiveDate = AdjustableDate2.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="scheduledTerminationDate")
        @RuneAttribute(value="scheduledTerminationDate")
        public AdjustableDate2.AdjustableDate2Builder getScheduledTerminationDate() {
            return this.scheduledTerminationDate;
        }

        @Override
        public AdjustableDate2.AdjustableDate2Builder getOrCreateScheduledTerminationDate() {
            AdjustableDate2.AdjustableDate2Builder result = this.scheduledTerminationDate != null ? this.scheduledTerminationDate : (this.scheduledTerminationDate = AdjustableDate2.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public BuyerSellerModel.BuyerSellerModelBuilder getBuyerSellerModel() {
            return this.buyerSellerModel;
        }

        @Override
        public BuyerSellerModel.BuyerSellerModelBuilder getOrCreateBuyerSellerModel() {
            BuyerSellerModel.BuyerSellerModelBuilder result = this.buyerSellerModel != null ? this.buyerSellerModel : (this.buyerSellerModel = BuyerSellerModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dateAdjustments")
        @RuneAttribute(value="dateAdjustments")
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getDateAdjustments() {
            return this.dateAdjustments;
        }

        @Override
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getOrCreateDateAdjustments() {
            BusinessDayAdjustments.BusinessDayAdjustmentsBuilder result = this.dateAdjustments != null ? this.dateAdjustments : (this.dateAdjustments = BusinessDayAdjustments.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="referenceInformation")
        @RuneAttribute(value="referenceInformation")
        public ReferenceInformation.ReferenceInformationBuilder getReferenceInformation() {
            return this.referenceInformation;
        }

        @Override
        public ReferenceInformation.ReferenceInformationBuilder getOrCreateReferenceInformation() {
            ReferenceInformation.ReferenceInformationBuilder result = this.referenceInformation != null ? this.referenceInformation : (this.referenceInformation = ReferenceInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="indexReferenceInformation")
        @RuneAttribute(value="indexReferenceInformation")
        public IndexReferenceInformation.IndexReferenceInformationBuilder getIndexReferenceInformation() {
            return this.indexReferenceInformation;
        }

        @Override
        public IndexReferenceInformation.IndexReferenceInformationBuilder getOrCreateIndexReferenceInformation() {
            IndexReferenceInformation.IndexReferenceInformationBuilder result = this.indexReferenceInformation != null ? this.indexReferenceInformation : (this.indexReferenceInformation = IndexReferenceInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="basketReferenceInformation")
        @RuneAttribute(value="basketReferenceInformation")
        public BasketReferenceInformation.BasketReferenceInformationBuilder getBasketReferenceInformation() {
            return this.basketReferenceInformation;
        }

        @Override
        public BasketReferenceInformation.BasketReferenceInformationBuilder getOrCreateBasketReferenceInformation() {
            BasketReferenceInformation.BasketReferenceInformationBuilder result = this.basketReferenceInformation != null ? this.basketReferenceInformation : (this.basketReferenceInformation = BasketReferenceInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="additionalTerm")
        @RuneAttribute(value="additionalTerm")
        public List<? extends AdditionalTerm.AdditionalTermBuilder> getAdditionalTerm() {
            return this.additionalTerm;
        }

        @Override
        public AdditionalTerm.AdditionalTermBuilder getOrCreateAdditionalTerm(int index) {
            if (this.additionalTerm == null) {
                this.additionalTerm = new ArrayList<AdditionalTerm.AdditionalTermBuilder>();
            }
            return (AdditionalTerm.AdditionalTermBuilder)this.getIndex(this.additionalTerm, index, () -> {
                AdditionalTerm.AdditionalTermBuilder newAdditionalTerm = AdditionalTerm.builder();
                return newAdditionalTerm;
            });
        }

        @Override
        @RosettaAttribute(value="substitution")
        @RuneAttribute(value="substitution")
        public Boolean getSubstitution() {
            return this.substitution;
        }

        @Override
        @RosettaAttribute(value="modifiedEquityDelivery")
        @RuneAttribute(value="modifiedEquityDelivery")
        public Boolean getModifiedEquityDelivery() {
            return this.modifiedEquityDelivery;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public GeneralTermsBuilder setEffectiveDate(AdjustableDate2 _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="scheduledTerminationDate")
        @RuneAttribute(value="scheduledTerminationDate")
        public GeneralTermsBuilder setScheduledTerminationDate(AdjustableDate2 _scheduledTerminationDate) {
            this.scheduledTerminationDate = _scheduledTerminationDate == null ? null : _scheduledTerminationDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public GeneralTermsBuilder setBuyerSellerModel(BuyerSellerModel _buyerSellerModel) {
            this.buyerSellerModel = _buyerSellerModel == null ? null : _buyerSellerModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dateAdjustments")
        @RuneAttribute(value="dateAdjustments")
        public GeneralTermsBuilder setDateAdjustments(BusinessDayAdjustments _dateAdjustments) {
            this.dateAdjustments = _dateAdjustments == null ? null : _dateAdjustments.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="referenceInformation")
        @RuneAttribute(value="referenceInformation")
        public GeneralTermsBuilder setReferenceInformation(ReferenceInformation _referenceInformation) {
            this.referenceInformation = _referenceInformation == null ? null : _referenceInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="indexReferenceInformation")
        @RuneAttribute(value="indexReferenceInformation")
        public GeneralTermsBuilder setIndexReferenceInformation(IndexReferenceInformation _indexReferenceInformation) {
            this.indexReferenceInformation = _indexReferenceInformation == null ? null : _indexReferenceInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="basketReferenceInformation")
        @RuneAttribute(value="basketReferenceInformation")
        public GeneralTermsBuilder setBasketReferenceInformation(BasketReferenceInformation _basketReferenceInformation) {
            this.basketReferenceInformation = _basketReferenceInformation == null ? null : _basketReferenceInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalTerm")
        @RuneAttribute(value="additionalTerm")
        public GeneralTermsBuilder addAdditionalTerm(AdditionalTerm _additionalTerm) {
            if (_additionalTerm != null) {
                this.additionalTerm.add(_additionalTerm.toBuilder());
            }
            return this;
        }

        @Override
        public GeneralTermsBuilder addAdditionalTerm(AdditionalTerm _additionalTerm, int idx) {
            this.getIndex(this.additionalTerm, idx, () -> _additionalTerm.toBuilder());
            return this;
        }

        @Override
        public GeneralTermsBuilder addAdditionalTerm(List<? extends AdditionalTerm> additionalTerms) {
            if (additionalTerms != null) {
                for (AdditionalTerm additionalTerm : additionalTerms) {
                    this.additionalTerm.add(additionalTerm.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="additionalTerm")
        public GeneralTermsBuilder setAdditionalTerm(List<? extends AdditionalTerm> additionalTerms) {
            this.additionalTerm = additionalTerms == null ? new ArrayList<AdditionalTerm.AdditionalTermBuilder>() : (List)additionalTerms.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="substitution")
        @RuneAttribute(value="substitution")
        public GeneralTermsBuilder setSubstitution(Boolean _substitution) {
            this.substitution = _substitution == null ? null : _substitution;
            return this;
        }

        @Override
        @RosettaAttribute(value="modifiedEquityDelivery")
        @RuneAttribute(value="modifiedEquityDelivery")
        public GeneralTermsBuilder setModifiedEquityDelivery(Boolean _modifiedEquityDelivery) {
            this.modifiedEquityDelivery = _modifiedEquityDelivery == null ? null : _modifiedEquityDelivery;
            return this;
        }

        @Override
        public GeneralTerms build() {
            return new GeneralTermsImpl(this);
        }

        @Override
        public GeneralTermsBuilder toBuilder() {
            return this;
        }

        @Override
        public GeneralTermsBuilder prune() {
            if (this.effectiveDate != null && !this.effectiveDate.prune().hasData()) {
                this.effectiveDate = null;
            }
            if (this.scheduledTerminationDate != null && !this.scheduledTerminationDate.prune().hasData()) {
                this.scheduledTerminationDate = null;
            }
            if (this.buyerSellerModel != null && !this.buyerSellerModel.prune().hasData()) {
                this.buyerSellerModel = null;
            }
            if (this.dateAdjustments != null && !this.dateAdjustments.prune().hasData()) {
                this.dateAdjustments = null;
            }
            if (this.referenceInformation != null && !this.referenceInformation.prune().hasData()) {
                this.referenceInformation = null;
            }
            if (this.indexReferenceInformation != null && !this.indexReferenceInformation.prune().hasData()) {
                this.indexReferenceInformation = null;
            }
            if (this.basketReferenceInformation != null && !this.basketReferenceInformation.prune().hasData()) {
                this.basketReferenceInformation = null;
            }
            this.additionalTerm = this.additionalTerm.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getEffectiveDate() != null && this.getEffectiveDate().hasData()) {
                return true;
            }
            if (this.getScheduledTerminationDate() != null && this.getScheduledTerminationDate().hasData()) {
                return true;
            }
            if (this.getBuyerSellerModel() != null && this.getBuyerSellerModel().hasData()) {
                return true;
            }
            if (this.getDateAdjustments() != null && this.getDateAdjustments().hasData()) {
                return true;
            }
            if (this.getReferenceInformation() != null && this.getReferenceInformation().hasData()) {
                return true;
            }
            if (this.getIndexReferenceInformation() != null && this.getIndexReferenceInformation().hasData()) {
                return true;
            }
            if (this.getBasketReferenceInformation() != null && this.getBasketReferenceInformation().hasData()) {
                return true;
            }
            if (this.getAdditionalTerm() != null && this.getAdditionalTerm().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getSubstitution() != null) {
                return true;
            }
            return this.getModifiedEquityDelivery() != null;
        }

        public GeneralTermsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            GeneralTermsBuilder o = (GeneralTermsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEffectiveDate(), (RosettaModelObjectBuilder)o.getEffectiveDate(), this::setEffectiveDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getScheduledTerminationDate(), (RosettaModelObjectBuilder)o.getScheduledTerminationDate(), this::setScheduledTerminationDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBuyerSellerModel(), (RosettaModelObjectBuilder)o.getBuyerSellerModel(), this::setBuyerSellerModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDateAdjustments(), (RosettaModelObjectBuilder)o.getDateAdjustments(), this::setDateAdjustments);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReferenceInformation(), (RosettaModelObjectBuilder)o.getReferenceInformation(), this::setReferenceInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIndexReferenceInformation(), (RosettaModelObjectBuilder)o.getIndexReferenceInformation(), this::setIndexReferenceInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBasketReferenceInformation(), (RosettaModelObjectBuilder)o.getBasketReferenceInformation(), this::setBasketReferenceInformation);
            merger.mergeRosetta(this.getAdditionalTerm(), o.getAdditionalTerm(), this::getOrCreateAdditionalTerm);
            merger.mergeBasic((Object)this.getSubstitution(), (Object)o.getSubstitution(), this::setSubstitution, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getModifiedEquityDelivery(), (Object)o.getModifiedEquityDelivery(), this::setModifiedEquityDelivery, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            GeneralTerms _that = this.getType().cast(o);
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.scheduledTerminationDate, _that.getScheduledTerminationDate())) {
                return false;
            }
            if (!Objects.equals(this.buyerSellerModel, _that.getBuyerSellerModel())) {
                return false;
            }
            if (!Objects.equals(this.dateAdjustments, _that.getDateAdjustments())) {
                return false;
            }
            if (!Objects.equals(this.referenceInformation, _that.getReferenceInformation())) {
                return false;
            }
            if (!Objects.equals(this.indexReferenceInformation, _that.getIndexReferenceInformation())) {
                return false;
            }
            if (!Objects.equals(this.basketReferenceInformation, _that.getBasketReferenceInformation())) {
                return false;
            }
            if (!ListEquals.listEquals(this.additionalTerm, _that.getAdditionalTerm())) {
                return false;
            }
            if (!Objects.equals(this.substitution, _that.getSubstitution())) {
                return false;
            }
            return Objects.equals(this.modifiedEquityDelivery, _that.getModifiedEquityDelivery());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.scheduledTerminationDate != null ? this.scheduledTerminationDate.hashCode() : 0);
            _result = 31 * _result + (this.buyerSellerModel != null ? this.buyerSellerModel.hashCode() : 0);
            _result = 31 * _result + (this.dateAdjustments != null ? this.dateAdjustments.hashCode() : 0);
            _result = 31 * _result + (this.referenceInformation != null ? this.referenceInformation.hashCode() : 0);
            _result = 31 * _result + (this.indexReferenceInformation != null ? this.indexReferenceInformation.hashCode() : 0);
            _result = 31 * _result + (this.basketReferenceInformation != null ? this.basketReferenceInformation.hashCode() : 0);
            _result = 31 * _result + (this.additionalTerm != null ? this.additionalTerm.hashCode() : 0);
            _result = 31 * _result + (this.substitution != null ? this.substitution.hashCode() : 0);
            _result = 31 * _result + (this.modifiedEquityDelivery != null ? this.modifiedEquityDelivery.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "GeneralTermsBuilder {effectiveDate=" + String.valueOf(this.effectiveDate) + ", scheduledTerminationDate=" + String.valueOf(this.scheduledTerminationDate) + ", buyerSellerModel=" + String.valueOf(this.buyerSellerModel) + ", dateAdjustments=" + String.valueOf(this.dateAdjustments) + ", referenceInformation=" + String.valueOf(this.referenceInformation) + ", indexReferenceInformation=" + String.valueOf(this.indexReferenceInformation) + ", basketReferenceInformation=" + String.valueOf(this.basketReferenceInformation) + ", additionalTerm=" + String.valueOf(this.additionalTerm) + ", substitution=" + this.substitution + ", modifiedEquityDelivery=" + this.modifiedEquityDelivery + "}";
        }
    }

    public static interface GeneralTermsBuilder
    extends GeneralTerms,
    RosettaModelObjectBuilder {
        public AdjustableDate2.AdjustableDate2Builder getOrCreateEffectiveDate();

        @Override
        public AdjustableDate2.AdjustableDate2Builder getEffectiveDate();

        public AdjustableDate2.AdjustableDate2Builder getOrCreateScheduledTerminationDate();

        @Override
        public AdjustableDate2.AdjustableDate2Builder getScheduledTerminationDate();

        public BuyerSellerModel.BuyerSellerModelBuilder getOrCreateBuyerSellerModel();

        @Override
        public BuyerSellerModel.BuyerSellerModelBuilder getBuyerSellerModel();

        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getOrCreateDateAdjustments();

        @Override
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getDateAdjustments();

        public ReferenceInformation.ReferenceInformationBuilder getOrCreateReferenceInformation();

        @Override
        public ReferenceInformation.ReferenceInformationBuilder getReferenceInformation();

        public IndexReferenceInformation.IndexReferenceInformationBuilder getOrCreateIndexReferenceInformation();

        @Override
        public IndexReferenceInformation.IndexReferenceInformationBuilder getIndexReferenceInformation();

        public BasketReferenceInformation.BasketReferenceInformationBuilder getOrCreateBasketReferenceInformation();

        @Override
        public BasketReferenceInformation.BasketReferenceInformationBuilder getBasketReferenceInformation();

        public AdditionalTerm.AdditionalTermBuilder getOrCreateAdditionalTerm(int var1);

        public List<? extends AdditionalTerm.AdditionalTermBuilder> getAdditionalTerm();

        public GeneralTermsBuilder setEffectiveDate(AdjustableDate2 var1);

        public GeneralTermsBuilder setScheduledTerminationDate(AdjustableDate2 var1);

        public GeneralTermsBuilder setBuyerSellerModel(BuyerSellerModel var1);

        public GeneralTermsBuilder setDateAdjustments(BusinessDayAdjustments var1);

        public GeneralTermsBuilder setReferenceInformation(ReferenceInformation var1);

        public GeneralTermsBuilder setIndexReferenceInformation(IndexReferenceInformation var1);

        public GeneralTermsBuilder setBasketReferenceInformation(BasketReferenceInformation var1);

        public GeneralTermsBuilder addAdditionalTerm(AdditionalTerm var1);

        public GeneralTermsBuilder addAdditionalTerm(AdditionalTerm var1, int var2);

        public GeneralTermsBuilder addAdditionalTerm(List<? extends AdditionalTerm> var1);

        public GeneralTermsBuilder setAdditionalTerm(List<? extends AdditionalTerm> var1);

        public GeneralTermsBuilder setSubstitution(Boolean var1);

        public GeneralTermsBuilder setModifiedEquityDelivery(Boolean var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableDate2.AdjustableDate2Builder.class, this.getEffectiveDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("scheduledTerminationDate"), processor, AdjustableDate2.AdjustableDate2Builder.class, this.getScheduledTerminationDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.BuyerSellerModelBuilder.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dateAdjustments"), processor, BusinessDayAdjustments.BusinessDayAdjustmentsBuilder.class, this.getDateAdjustments(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("referenceInformation"), processor, ReferenceInformation.ReferenceInformationBuilder.class, this.getReferenceInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("indexReferenceInformation"), processor, IndexReferenceInformation.IndexReferenceInformationBuilder.class, this.getIndexReferenceInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("basketReferenceInformation"), processor, BasketReferenceInformation.BasketReferenceInformationBuilder.class, this.getBasketReferenceInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("additionalTerm"), processor, AdditionalTerm.AdditionalTermBuilder.class, this.getAdditionalTerm(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("substitution"), Boolean.class, (Object)this.getSubstitution(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("modifiedEquityDelivery"), Boolean.class, (Object)this.getModifiedEquityDelivery(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public GeneralTermsBuilder prune();
    }

    public static class GeneralTermsImpl
    implements GeneralTerms {
        private final AdjustableDate2 effectiveDate;
        private final AdjustableDate2 scheduledTerminationDate;
        private final BuyerSellerModel buyerSellerModel;
        private final BusinessDayAdjustments dateAdjustments;
        private final ReferenceInformation referenceInformation;
        private final IndexReferenceInformation indexReferenceInformation;
        private final BasketReferenceInformation basketReferenceInformation;
        private final List<? extends AdditionalTerm> additionalTerm;
        private final Boolean substitution;
        private final Boolean modifiedEquityDelivery;

        protected GeneralTermsImpl(GeneralTermsBuilder builder) {
            this.effectiveDate = Optional.ofNullable(builder.getEffectiveDate()).map(f -> f.build()).orElse(null);
            this.scheduledTerminationDate = Optional.ofNullable(builder.getScheduledTerminationDate()).map(f -> f.build()).orElse(null);
            this.buyerSellerModel = Optional.ofNullable(builder.getBuyerSellerModel()).map(f -> f.build()).orElse(null);
            this.dateAdjustments = Optional.ofNullable(builder.getDateAdjustments()).map(f -> f.build()).orElse(null);
            this.referenceInformation = Optional.ofNullable(builder.getReferenceInformation()).map(f -> f.build()).orElse(null);
            this.indexReferenceInformation = Optional.ofNullable(builder.getIndexReferenceInformation()).map(f -> f.build()).orElse(null);
            this.basketReferenceInformation = Optional.ofNullable(builder.getBasketReferenceInformation()).map(f -> f.build()).orElse(null);
            this.additionalTerm = Optional.ofNullable(builder.getAdditionalTerm()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.substitution = builder.getSubstitution();
            this.modifiedEquityDelivery = builder.getModifiedEquityDelivery();
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public AdjustableDate2 getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="scheduledTerminationDate")
        @RuneAttribute(value="scheduledTerminationDate")
        public AdjustableDate2 getScheduledTerminationDate() {
            return this.scheduledTerminationDate;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public BuyerSellerModel getBuyerSellerModel() {
            return this.buyerSellerModel;
        }

        @Override
        @RosettaAttribute(value="dateAdjustments")
        @RuneAttribute(value="dateAdjustments")
        public BusinessDayAdjustments getDateAdjustments() {
            return this.dateAdjustments;
        }

        @Override
        @RosettaAttribute(value="referenceInformation")
        @RuneAttribute(value="referenceInformation")
        public ReferenceInformation getReferenceInformation() {
            return this.referenceInformation;
        }

        @Override
        @RosettaAttribute(value="indexReferenceInformation")
        @RuneAttribute(value="indexReferenceInformation")
        public IndexReferenceInformation getIndexReferenceInformation() {
            return this.indexReferenceInformation;
        }

        @Override
        @RosettaAttribute(value="basketReferenceInformation")
        @RuneAttribute(value="basketReferenceInformation")
        public BasketReferenceInformation getBasketReferenceInformation() {
            return this.basketReferenceInformation;
        }

        @Override
        @RosettaAttribute(value="additionalTerm")
        @RuneAttribute(value="additionalTerm")
        public List<? extends AdditionalTerm> getAdditionalTerm() {
            return this.additionalTerm;
        }

        @Override
        @RosettaAttribute(value="substitution")
        @RuneAttribute(value="substitution")
        public Boolean getSubstitution() {
            return this.substitution;
        }

        @Override
        @RosettaAttribute(value="modifiedEquityDelivery")
        @RuneAttribute(value="modifiedEquityDelivery")
        public Boolean getModifiedEquityDelivery() {
            return this.modifiedEquityDelivery;
        }

        @Override
        public GeneralTerms build() {
            return this;
        }

        @Override
        public GeneralTermsBuilder toBuilder() {
            GeneralTermsBuilder builder = GeneralTerms.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(GeneralTermsBuilder builder) {
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getScheduledTerminationDate()).ifPresent(builder::setScheduledTerminationDate);
            Optional.ofNullable(this.getBuyerSellerModel()).ifPresent(builder::setBuyerSellerModel);
            Optional.ofNullable(this.getDateAdjustments()).ifPresent(builder::setDateAdjustments);
            Optional.ofNullable(this.getReferenceInformation()).ifPresent(builder::setReferenceInformation);
            Optional.ofNullable(this.getIndexReferenceInformation()).ifPresent(builder::setIndexReferenceInformation);
            Optional.ofNullable(this.getBasketReferenceInformation()).ifPresent(builder::setBasketReferenceInformation);
            Optional.ofNullable(this.getAdditionalTerm()).ifPresent(builder::setAdditionalTerm);
            Optional.ofNullable(this.getSubstitution()).ifPresent(builder::setSubstitution);
            Optional.ofNullable(this.getModifiedEquityDelivery()).ifPresent(builder::setModifiedEquityDelivery);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            GeneralTerms _that = this.getType().cast(o);
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.scheduledTerminationDate, _that.getScheduledTerminationDate())) {
                return false;
            }
            if (!Objects.equals(this.buyerSellerModel, _that.getBuyerSellerModel())) {
                return false;
            }
            if (!Objects.equals(this.dateAdjustments, _that.getDateAdjustments())) {
                return false;
            }
            if (!Objects.equals(this.referenceInformation, _that.getReferenceInformation())) {
                return false;
            }
            if (!Objects.equals(this.indexReferenceInformation, _that.getIndexReferenceInformation())) {
                return false;
            }
            if (!Objects.equals(this.basketReferenceInformation, _that.getBasketReferenceInformation())) {
                return false;
            }
            if (!ListEquals.listEquals(this.additionalTerm, _that.getAdditionalTerm())) {
                return false;
            }
            if (!Objects.equals(this.substitution, _that.getSubstitution())) {
                return false;
            }
            return Objects.equals(this.modifiedEquityDelivery, _that.getModifiedEquityDelivery());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.scheduledTerminationDate != null ? this.scheduledTerminationDate.hashCode() : 0);
            _result = 31 * _result + (this.buyerSellerModel != null ? this.buyerSellerModel.hashCode() : 0);
            _result = 31 * _result + (this.dateAdjustments != null ? this.dateAdjustments.hashCode() : 0);
            _result = 31 * _result + (this.referenceInformation != null ? this.referenceInformation.hashCode() : 0);
            _result = 31 * _result + (this.indexReferenceInformation != null ? this.indexReferenceInformation.hashCode() : 0);
            _result = 31 * _result + (this.basketReferenceInformation != null ? this.basketReferenceInformation.hashCode() : 0);
            _result = 31 * _result + (this.additionalTerm != null ? this.additionalTerm.hashCode() : 0);
            _result = 31 * _result + (this.substitution != null ? this.substitution.hashCode() : 0);
            _result = 31 * _result + (this.modifiedEquityDelivery != null ? this.modifiedEquityDelivery.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "GeneralTerms {effectiveDate=" + String.valueOf(this.effectiveDate) + ", scheduledTerminationDate=" + String.valueOf(this.scheduledTerminationDate) + ", buyerSellerModel=" + String.valueOf(this.buyerSellerModel) + ", dateAdjustments=" + String.valueOf(this.dateAdjustments) + ", referenceInformation=" + String.valueOf(this.referenceInformation) + ", indexReferenceInformation=" + String.valueOf(this.indexReferenceInformation) + ", basketReferenceInformation=" + String.valueOf(this.basketReferenceInformation) + ", additionalTerm=" + String.valueOf(this.additionalTerm) + ", substitution=" + this.substitution + ", modifiedEquityDelivery=" + this.modifiedEquityDelivery + "}";
        }
    }
}

