/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.business.events.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.business.events.TradeChangeBase;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="TradeChangeBaseChoice")
@ImplementedBy(value=Default.class)
public interface TradeChangeBaseChoice
extends Validator<TradeChangeBase> {
    public static final String NAME = "TradeChangeBaseChoice";
    public static final String DEFINITION = "optional choice tradeIdentifier, originalTrade";

    public static class NoOp
    implements TradeChangeBaseChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, TradeChangeBase tradeChangeBase) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements TradeChangeBaseChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, TradeChangeBase tradeChangeBase) {
            ComparisonResult result = this.executeDataRule(tradeChangeBase);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)TradeChangeBaseChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TradeChangeBase", (RosettaPath)path, (String)TradeChangeBaseChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)TradeChangeBaseChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TradeChangeBase", (RosettaPath)path, (String)TradeChangeBaseChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(TradeChangeBase tradeChangeBase) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)tradeChangeBase), Arrays.asList("tradeIdentifier", "originalTrade"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

