/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.business.events;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.business.events.CashOrPhysicalSettlementEnum;
import fpml.consolidated.business.events.ChangeEvent;
import fpml.consolidated.business.events.CreditEventType;
import fpml.consolidated.business.events.meta.CreditChangeEventBaseMeta;
import fpml.consolidated.shared.Resource;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CreditChangeEventBase", builder=CreditChangeEventBaseBuilderImpl.class, version="1.2.2")
@RuneDataType(value="CreditChangeEventBase", model="fpml", builder=CreditChangeEventBaseBuilderImpl.class, version="1.2.2")
public interface CreditChangeEventBase
extends ChangeEvent {
    public static final CreditChangeEventBaseMeta metaData = new CreditChangeEventBaseMeta();

    public CreditEventType getCreditEventType();

    public ZonedDateTime getEventDeterminationDate();

    public ZonedDateTime getAuctionDate();

    public CashOrPhysicalSettlementEnum getSettlementMethod();

    public ZonedDateTime getSettlementDate();

    public BigDecimal getFinalPrice();

    public BigDecimal getRecoveryPercent();

    public List<? extends Resource> getPubliclyAvailableInformation();

    @Override
    public CreditChangeEventBase build();

    @Override
    public CreditChangeEventBaseBuilder toBuilder();

    public static CreditChangeEventBaseBuilder builder() {
        return new CreditChangeEventBaseBuilderImpl();
    }

    default public RosettaMetaData<? extends CreditChangeEventBase> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CreditChangeEventBase> getType() {
        return CreditChangeEventBase.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditEventType"), processor, CreditEventType.class, this.getCreditEventType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventDeterminationDate"), ZonedDateTime.class, (Object)this.getEventDeterminationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("auctionDate"), ZonedDateTime.class, (Object)this.getAuctionDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementMethod"), CashOrPhysicalSettlementEnum.class, (Object)this.getSettlementMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementDate"), ZonedDateTime.class, (Object)this.getSettlementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("finalPrice"), BigDecimal.class, (Object)this.getFinalPrice(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("recoveryPercent"), BigDecimal.class, (Object)this.getRecoveryPercent(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("publiclyAvailableInformation"), processor, Resource.class, this.getPubliclyAvailableInformation(), new AttributeMeta[0]);
    }

    public static class CreditChangeEventBaseBuilderImpl
    extends ChangeEvent.ChangeEventBuilderImpl
    implements CreditChangeEventBaseBuilder {
        protected CreditEventType.CreditEventTypeBuilder creditEventType;
        protected ZonedDateTime eventDeterminationDate;
        protected ZonedDateTime auctionDate;
        protected CashOrPhysicalSettlementEnum settlementMethod;
        protected ZonedDateTime settlementDate;
        protected BigDecimal finalPrice;
        protected BigDecimal recoveryPercent;
        protected List<Resource.ResourceBuilder> publiclyAvailableInformation = new ArrayList<Resource.ResourceBuilder>();

        @Override
        @RosettaAttribute(value="creditEventType")
        @RuneAttribute(value="creditEventType")
        public CreditEventType.CreditEventTypeBuilder getCreditEventType() {
            return this.creditEventType;
        }

        @Override
        public CreditEventType.CreditEventTypeBuilder getOrCreateCreditEventType() {
            CreditEventType.CreditEventTypeBuilder result = this.creditEventType != null ? this.creditEventType : (this.creditEventType = CreditEventType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventDeterminationDate")
        @RuneAttribute(value="eventDeterminationDate")
        public ZonedDateTime getEventDeterminationDate() {
            return this.eventDeterminationDate;
        }

        @Override
        @RosettaAttribute(value="auctionDate")
        @RuneAttribute(value="auctionDate")
        public ZonedDateTime getAuctionDate() {
            return this.auctionDate;
        }

        @Override
        @RosettaAttribute(value="settlementMethod")
        @RuneAttribute(value="settlementMethod")
        public CashOrPhysicalSettlementEnum getSettlementMethod() {
            return this.settlementMethod;
        }

        @Override
        @RosettaAttribute(value="settlementDate")
        @RuneAttribute(value="settlementDate")
        public ZonedDateTime getSettlementDate() {
            return this.settlementDate;
        }

        @Override
        @RosettaAttribute(value="finalPrice")
        @RuneAttribute(value="finalPrice")
        public BigDecimal getFinalPrice() {
            return this.finalPrice;
        }

        @Override
        @RosettaAttribute(value="recoveryPercent")
        @RuneAttribute(value="recoveryPercent")
        public BigDecimal getRecoveryPercent() {
            return this.recoveryPercent;
        }

        @Override
        @RosettaAttribute(value="publiclyAvailableInformation")
        @RuneAttribute(value="publiclyAvailableInformation")
        public List<? extends Resource.ResourceBuilder> getPubliclyAvailableInformation() {
            return this.publiclyAvailableInformation;
        }

        @Override
        public Resource.ResourceBuilder getOrCreatePubliclyAvailableInformation(int index) {
            if (this.publiclyAvailableInformation == null) {
                this.publiclyAvailableInformation = new ArrayList<Resource.ResourceBuilder>();
            }
            return (Resource.ResourceBuilder)this.getIndex(this.publiclyAvailableInformation, index, () -> {
                Resource.ResourceBuilder newPubliclyAvailableInformation = Resource.builder();
                return newPubliclyAvailableInformation;
            });
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public CreditChangeEventBaseBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public CreditChangeEventBaseBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public CreditChangeEventBaseBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public CreditChangeEventBaseBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="creditEventType")
        @RuneAttribute(value="creditEventType")
        public CreditChangeEventBaseBuilder setCreditEventType(CreditEventType _creditEventType) {
            this.creditEventType = _creditEventType == null ? null : _creditEventType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="eventDeterminationDate")
        @RuneAttribute(value="eventDeterminationDate")
        public CreditChangeEventBaseBuilder setEventDeterminationDate(ZonedDateTime _eventDeterminationDate) {
            this.eventDeterminationDate = _eventDeterminationDate == null ? null : _eventDeterminationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="auctionDate")
        @RuneAttribute(value="auctionDate")
        public CreditChangeEventBaseBuilder setAuctionDate(ZonedDateTime _auctionDate) {
            this.auctionDate = _auctionDate == null ? null : _auctionDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementMethod")
        @RuneAttribute(value="settlementMethod")
        public CreditChangeEventBaseBuilder setSettlementMethod(CashOrPhysicalSettlementEnum _settlementMethod) {
            this.settlementMethod = _settlementMethod == null ? null : _settlementMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementDate")
        @RuneAttribute(value="settlementDate")
        public CreditChangeEventBaseBuilder setSettlementDate(ZonedDateTime _settlementDate) {
            this.settlementDate = _settlementDate == null ? null : _settlementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="finalPrice")
        @RuneAttribute(value="finalPrice")
        public CreditChangeEventBaseBuilder setFinalPrice(BigDecimal _finalPrice) {
            this.finalPrice = _finalPrice == null ? null : _finalPrice;
            return this;
        }

        @Override
        @RosettaAttribute(value="recoveryPercent")
        @RuneAttribute(value="recoveryPercent")
        public CreditChangeEventBaseBuilder setRecoveryPercent(BigDecimal _recoveryPercent) {
            this.recoveryPercent = _recoveryPercent == null ? null : _recoveryPercent;
            return this;
        }

        @Override
        @RosettaAttribute(value="publiclyAvailableInformation")
        @RuneAttribute(value="publiclyAvailableInformation")
        public CreditChangeEventBaseBuilder addPubliclyAvailableInformation(Resource _publiclyAvailableInformation) {
            if (_publiclyAvailableInformation != null) {
                this.publiclyAvailableInformation.add(_publiclyAvailableInformation.toBuilder());
            }
            return this;
        }

        @Override
        public CreditChangeEventBaseBuilder addPubliclyAvailableInformation(Resource _publiclyAvailableInformation, int idx) {
            this.getIndex(this.publiclyAvailableInformation, idx, () -> _publiclyAvailableInformation.toBuilder());
            return this;
        }

        @Override
        public CreditChangeEventBaseBuilder addPubliclyAvailableInformation(List<? extends Resource> publiclyAvailableInformations) {
            if (publiclyAvailableInformations != null) {
                for (Resource resource : publiclyAvailableInformations) {
                    this.publiclyAvailableInformation.add(resource.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="publiclyAvailableInformation")
        public CreditChangeEventBaseBuilder setPubliclyAvailableInformation(List<? extends Resource> publiclyAvailableInformations) {
            this.publiclyAvailableInformation = publiclyAvailableInformations == null ? new ArrayList<Resource.ResourceBuilder>() : (List)publiclyAvailableInformations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CreditChangeEventBase build() {
            return new CreditChangeEventBaseImpl(this);
        }

        @Override
        public CreditChangeEventBaseBuilder toBuilder() {
            return this;
        }

        @Override
        public CreditChangeEventBaseBuilder prune() {
            super.prune();
            if (this.creditEventType != null && !this.creditEventType.prune().hasData()) {
                this.creditEventType = null;
            }
            this.publiclyAvailableInformation = this.publiclyAvailableInformation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCreditEventType() != null && this.getCreditEventType().hasData()) {
                return true;
            }
            if (this.getEventDeterminationDate() != null) {
                return true;
            }
            if (this.getAuctionDate() != null) {
                return true;
            }
            if (this.getSettlementMethod() != null) {
                return true;
            }
            if (this.getSettlementDate() != null) {
                return true;
            }
            if (this.getFinalPrice() != null) {
                return true;
            }
            if (this.getRecoveryPercent() != null) {
                return true;
            }
            return this.getPubliclyAvailableInformation() != null && this.getPubliclyAvailableInformation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public CreditChangeEventBaseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CreditChangeEventBaseBuilder o = (CreditChangeEventBaseBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCreditEventType(), (RosettaModelObjectBuilder)o.getCreditEventType(), this::setCreditEventType);
            merger.mergeRosetta(this.getPubliclyAvailableInformation(), o.getPubliclyAvailableInformation(), this::getOrCreatePubliclyAvailableInformation);
            merger.mergeBasic((Object)this.getEventDeterminationDate(), (Object)o.getEventDeterminationDate(), this::setEventDeterminationDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAuctionDate(), (Object)o.getAuctionDate(), this::setAuctionDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSettlementMethod(), (Object)o.getSettlementMethod(), this::setSettlementMethod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSettlementDate(), (Object)o.getSettlementDate(), this::setSettlementDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFinalPrice(), (Object)o.getFinalPrice(), this::setFinalPrice, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRecoveryPercent(), (Object)o.getRecoveryPercent(), this::setRecoveryPercent, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CreditChangeEventBase _that = (CreditChangeEventBase)this.getType().cast(o);
            if (!Objects.equals(this.creditEventType, _that.getCreditEventType())) {
                return false;
            }
            if (!Objects.equals(this.eventDeterminationDate, _that.getEventDeterminationDate())) {
                return false;
            }
            if (!Objects.equals(this.auctionDate, _that.getAuctionDate())) {
                return false;
            }
            if (!Objects.equals((Object)this.settlementMethod, (Object)_that.getSettlementMethod())) {
                return false;
            }
            if (!Objects.equals(this.settlementDate, _that.getSettlementDate())) {
                return false;
            }
            if (!Objects.equals(this.finalPrice, _that.getFinalPrice())) {
                return false;
            }
            if (!Objects.equals(this.recoveryPercent, _that.getRecoveryPercent())) {
                return false;
            }
            return ListEquals.listEquals(this.publiclyAvailableInformation, _that.getPubliclyAvailableInformation());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.creditEventType != null ? this.creditEventType.hashCode() : 0);
            _result = 31 * _result + (this.eventDeterminationDate != null ? this.eventDeterminationDate.hashCode() : 0);
            _result = 31 * _result + (this.auctionDate != null ? this.auctionDate.hashCode() : 0);
            _result = 31 * _result + (this.settlementMethod != null ? ((Object)((Object)this.settlementMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.settlementDate != null ? this.settlementDate.hashCode() : 0);
            _result = 31 * _result + (this.finalPrice != null ? this.finalPrice.hashCode() : 0);
            _result = 31 * _result + (this.recoveryPercent != null ? this.recoveryPercent.hashCode() : 0);
            _result = 31 * _result + (this.publiclyAvailableInformation != null ? this.publiclyAvailableInformation.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CreditChangeEventBaseBuilder {creditEventType=" + String.valueOf(this.creditEventType) + ", eventDeterminationDate=" + String.valueOf(this.eventDeterminationDate) + ", auctionDate=" + String.valueOf(this.auctionDate) + ", settlementMethod=" + String.valueOf((Object)this.settlementMethod) + ", settlementDate=" + String.valueOf(this.settlementDate) + ", finalPrice=" + String.valueOf(this.finalPrice) + ", recoveryPercent=" + String.valueOf(this.recoveryPercent) + ", publiclyAvailableInformation=" + String.valueOf(this.publiclyAvailableInformation) + "} " + super.toString();
        }
    }

    public static interface CreditChangeEventBaseBuilder
    extends CreditChangeEventBase,
    ChangeEvent.ChangeEventBuilder {
        public CreditEventType.CreditEventTypeBuilder getOrCreateCreditEventType();

        @Override
        public CreditEventType.CreditEventTypeBuilder getCreditEventType();

        public Resource.ResourceBuilder getOrCreatePubliclyAvailableInformation(int var1);

        public List<? extends Resource.ResourceBuilder> getPubliclyAvailableInformation();

        @Override
        public CreditChangeEventBaseBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public CreditChangeEventBaseBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public CreditChangeEventBaseBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public CreditChangeEventBaseBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        public CreditChangeEventBaseBuilder setCreditEventType(CreditEventType var1);

        public CreditChangeEventBaseBuilder setEventDeterminationDate(ZonedDateTime var1);

        public CreditChangeEventBaseBuilder setAuctionDate(ZonedDateTime var1);

        public CreditChangeEventBaseBuilder setSettlementMethod(CashOrPhysicalSettlementEnum var1);

        public CreditChangeEventBaseBuilder setSettlementDate(ZonedDateTime var1);

        public CreditChangeEventBaseBuilder setFinalPrice(BigDecimal var1);

        public CreditChangeEventBaseBuilder setRecoveryPercent(BigDecimal var1);

        public CreditChangeEventBaseBuilder addPubliclyAvailableInformation(Resource var1);

        public CreditChangeEventBaseBuilder addPubliclyAvailableInformation(Resource var1, int var2);

        public CreditChangeEventBaseBuilder addPubliclyAvailableInformation(List<? extends Resource> var1);

        public CreditChangeEventBaseBuilder setPubliclyAvailableInformation(List<? extends Resource> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditEventType"), processor, CreditEventType.CreditEventTypeBuilder.class, this.getCreditEventType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventDeterminationDate"), ZonedDateTime.class, (Object)this.getEventDeterminationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("auctionDate"), ZonedDateTime.class, (Object)this.getAuctionDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementMethod"), CashOrPhysicalSettlementEnum.class, (Object)this.getSettlementMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementDate"), ZonedDateTime.class, (Object)this.getSettlementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("finalPrice"), BigDecimal.class, (Object)this.getFinalPrice(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("recoveryPercent"), BigDecimal.class, (Object)this.getRecoveryPercent(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("publiclyAvailableInformation"), processor, Resource.ResourceBuilder.class, this.getPubliclyAvailableInformation(), new AttributeMeta[0]);
        }

        @Override
        public CreditChangeEventBaseBuilder prune();
    }

    public static class CreditChangeEventBaseImpl
    extends ChangeEvent.ChangeEventImpl
    implements CreditChangeEventBase {
        private final CreditEventType creditEventType;
        private final ZonedDateTime eventDeterminationDate;
        private final ZonedDateTime auctionDate;
        private final CashOrPhysicalSettlementEnum settlementMethod;
        private final ZonedDateTime settlementDate;
        private final BigDecimal finalPrice;
        private final BigDecimal recoveryPercent;
        private final List<? extends Resource> publiclyAvailableInformation;

        protected CreditChangeEventBaseImpl(CreditChangeEventBaseBuilder builder) {
            super(builder);
            this.creditEventType = Optional.ofNullable(builder.getCreditEventType()).map(f -> f.build()).orElse(null);
            this.eventDeterminationDate = builder.getEventDeterminationDate();
            this.auctionDate = builder.getAuctionDate();
            this.settlementMethod = builder.getSettlementMethod();
            this.settlementDate = builder.getSettlementDate();
            this.finalPrice = builder.getFinalPrice();
            this.recoveryPercent = builder.getRecoveryPercent();
            this.publiclyAvailableInformation = Optional.ofNullable(builder.getPubliclyAvailableInformation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="creditEventType")
        @RuneAttribute(value="creditEventType")
        public CreditEventType getCreditEventType() {
            return this.creditEventType;
        }

        @Override
        @RosettaAttribute(value="eventDeterminationDate")
        @RuneAttribute(value="eventDeterminationDate")
        public ZonedDateTime getEventDeterminationDate() {
            return this.eventDeterminationDate;
        }

        @Override
        @RosettaAttribute(value="auctionDate")
        @RuneAttribute(value="auctionDate")
        public ZonedDateTime getAuctionDate() {
            return this.auctionDate;
        }

        @Override
        @RosettaAttribute(value="settlementMethod")
        @RuneAttribute(value="settlementMethod")
        public CashOrPhysicalSettlementEnum getSettlementMethod() {
            return this.settlementMethod;
        }

        @Override
        @RosettaAttribute(value="settlementDate")
        @RuneAttribute(value="settlementDate")
        public ZonedDateTime getSettlementDate() {
            return this.settlementDate;
        }

        @Override
        @RosettaAttribute(value="finalPrice")
        @RuneAttribute(value="finalPrice")
        public BigDecimal getFinalPrice() {
            return this.finalPrice;
        }

        @Override
        @RosettaAttribute(value="recoveryPercent")
        @RuneAttribute(value="recoveryPercent")
        public BigDecimal getRecoveryPercent() {
            return this.recoveryPercent;
        }

        @Override
        @RosettaAttribute(value="publiclyAvailableInformation")
        @RuneAttribute(value="publiclyAvailableInformation")
        public List<? extends Resource> getPubliclyAvailableInformation() {
            return this.publiclyAvailableInformation;
        }

        @Override
        public CreditChangeEventBase build() {
            return this;
        }

        @Override
        public CreditChangeEventBaseBuilder toBuilder() {
            CreditChangeEventBaseBuilder builder = CreditChangeEventBase.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CreditChangeEventBaseBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCreditEventType()).ifPresent(builder::setCreditEventType);
            Optional.ofNullable(this.getEventDeterminationDate()).ifPresent(builder::setEventDeterminationDate);
            Optional.ofNullable(this.getAuctionDate()).ifPresent(builder::setAuctionDate);
            Optional.ofNullable(this.getSettlementMethod()).ifPresent(builder::setSettlementMethod);
            Optional.ofNullable(this.getSettlementDate()).ifPresent(builder::setSettlementDate);
            Optional.ofNullable(this.getFinalPrice()).ifPresent(builder::setFinalPrice);
            Optional.ofNullable(this.getRecoveryPercent()).ifPresent(builder::setRecoveryPercent);
            Optional.ofNullable(this.getPubliclyAvailableInformation()).ifPresent(builder::setPubliclyAvailableInformation);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CreditChangeEventBase _that = (CreditChangeEventBase)this.getType().cast(o);
            if (!Objects.equals(this.creditEventType, _that.getCreditEventType())) {
                return false;
            }
            if (!Objects.equals(this.eventDeterminationDate, _that.getEventDeterminationDate())) {
                return false;
            }
            if (!Objects.equals(this.auctionDate, _that.getAuctionDate())) {
                return false;
            }
            if (!Objects.equals((Object)this.settlementMethod, (Object)_that.getSettlementMethod())) {
                return false;
            }
            if (!Objects.equals(this.settlementDate, _that.getSettlementDate())) {
                return false;
            }
            if (!Objects.equals(this.finalPrice, _that.getFinalPrice())) {
                return false;
            }
            if (!Objects.equals(this.recoveryPercent, _that.getRecoveryPercent())) {
                return false;
            }
            return ListEquals.listEquals(this.publiclyAvailableInformation, _that.getPubliclyAvailableInformation());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.creditEventType != null ? this.creditEventType.hashCode() : 0);
            _result = 31 * _result + (this.eventDeterminationDate != null ? this.eventDeterminationDate.hashCode() : 0);
            _result = 31 * _result + (this.auctionDate != null ? this.auctionDate.hashCode() : 0);
            _result = 31 * _result + (this.settlementMethod != null ? ((Object)((Object)this.settlementMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.settlementDate != null ? this.settlementDate.hashCode() : 0);
            _result = 31 * _result + (this.finalPrice != null ? this.finalPrice.hashCode() : 0);
            _result = 31 * _result + (this.recoveryPercent != null ? this.recoveryPercent.hashCode() : 0);
            _result = 31 * _result + (this.publiclyAvailableInformation != null ? this.publiclyAvailableInformation.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CreditChangeEventBase {creditEventType=" + String.valueOf(this.creditEventType) + ", eventDeterminationDate=" + String.valueOf(this.eventDeterminationDate) + ", auctionDate=" + String.valueOf(this.auctionDate) + ", settlementMethod=" + String.valueOf((Object)this.settlementMethod) + ", settlementDate=" + String.valueOf(this.settlementDate) + ", finalPrice=" + String.valueOf(this.finalPrice) + ", recoveryPercent=" + String.valueOf(this.recoveryPercent) + ", publiclyAvailableInformation=" + String.valueOf(this.publiclyAvailableInformation) + "} " + super.toString();
        }
    }
}

