/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.bond.option;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.bond.option.SwapCurveValuation;
import fpml.consolidated.bond.option.meta.MakeWholeAmountMeta;
import fpml.consolidated.fpmlenum.QuotationSideEnum;
import fpml.consolidated.shared.FloatingRateIndexModel;
import fpml.consolidated.shared.IdentifiedDate;
import fpml.consolidated.shared.InterpolationMethod;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="MakeWholeAmount", builder=MakeWholeAmountBuilderImpl.class, version="1.2.2")
@RuneDataType(value="MakeWholeAmount", model="fpml", builder=MakeWholeAmountBuilderImpl.class, version="1.2.2")
public interface MakeWholeAmount
extends SwapCurveValuation {
    public static final MakeWholeAmountMeta metaData = new MakeWholeAmountMeta();

    public InterpolationMethod getInterpolationMethod();

    public IdentifiedDate getEarlyCallDate();

    @Override
    public MakeWholeAmount build();

    @Override
    public MakeWholeAmountBuilder toBuilder();

    public static MakeWholeAmountBuilder builder() {
        return new MakeWholeAmountBuilderImpl();
    }

    default public RosettaMetaData<? extends MakeWholeAmount> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends MakeWholeAmount> getType() {
        return MakeWholeAmount.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("floatingRateIndexModel"), processor, FloatingRateIndexModel.class, this.getFloatingRateIndexModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spread"), BigDecimal.class, (Object)this.getSpread(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("side"), QuotationSideEnum.class, (Object)this.getSide(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("interpolationMethod"), processor, InterpolationMethod.class, this.getInterpolationMethod(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("earlyCallDate"), processor, IdentifiedDate.class, this.getEarlyCallDate(), new AttributeMeta[0]);
    }

    public static class MakeWholeAmountBuilderImpl
    extends SwapCurveValuation.SwapCurveValuationBuilderImpl
    implements MakeWholeAmountBuilder {
        protected InterpolationMethod.InterpolationMethodBuilder interpolationMethod;
        protected IdentifiedDate.IdentifiedDateBuilder earlyCallDate;

        @Override
        @RosettaAttribute(value="interpolationMethod")
        @RuneAttribute(value="interpolationMethod")
        public InterpolationMethod.InterpolationMethodBuilder getInterpolationMethod() {
            return this.interpolationMethod;
        }

        @Override
        public InterpolationMethod.InterpolationMethodBuilder getOrCreateInterpolationMethod() {
            InterpolationMethod.InterpolationMethodBuilder result = this.interpolationMethod != null ? this.interpolationMethod : (this.interpolationMethod = InterpolationMethod.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="earlyCallDate")
        @RuneAttribute(value="earlyCallDate")
        public IdentifiedDate.IdentifiedDateBuilder getEarlyCallDate() {
            return this.earlyCallDate;
        }

        @Override
        public IdentifiedDate.IdentifiedDateBuilder getOrCreateEarlyCallDate() {
            IdentifiedDate.IdentifiedDateBuilder result = this.earlyCallDate != null ? this.earlyCallDate : (this.earlyCallDate = IdentifiedDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="floatingRateIndexModel", isRequired=true)
        @RuneAttribute(value="floatingRateIndexModel", isRequired=true)
        public MakeWholeAmountBuilder setFloatingRateIndexModel(FloatingRateIndexModel _floatingRateIndexModel) {
            this.floatingRateIndexModel = _floatingRateIndexModel == null ? null : _floatingRateIndexModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="spread")
        @RuneAttribute(value="spread")
        public MakeWholeAmountBuilder setSpread(BigDecimal _spread) {
            this.spread = _spread == null ? null : _spread;
            return this;
        }

        @Override
        @RosettaAttribute(value="side")
        @RuneAttribute(value="side")
        public MakeWholeAmountBuilder setSide(QuotationSideEnum _side) {
            this.side = _side == null ? null : _side;
            return this;
        }

        @Override
        @RosettaAttribute(value="interpolationMethod")
        @RuneAttribute(value="interpolationMethod")
        public MakeWholeAmountBuilder setInterpolationMethod(InterpolationMethod _interpolationMethod) {
            this.interpolationMethod = _interpolationMethod == null ? null : _interpolationMethod.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="earlyCallDate")
        @RuneAttribute(value="earlyCallDate")
        public MakeWholeAmountBuilder setEarlyCallDate(IdentifiedDate _earlyCallDate) {
            this.earlyCallDate = _earlyCallDate == null ? null : _earlyCallDate.toBuilder();
            return this;
        }

        @Override
        public MakeWholeAmount build() {
            return new MakeWholeAmountImpl(this);
        }

        @Override
        public MakeWholeAmountBuilder toBuilder() {
            return this;
        }

        @Override
        public MakeWholeAmountBuilder prune() {
            super.prune();
            if (this.interpolationMethod != null && !this.interpolationMethod.prune().hasData()) {
                this.interpolationMethod = null;
            }
            if (this.earlyCallDate != null && !this.earlyCallDate.prune().hasData()) {
                this.earlyCallDate = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getInterpolationMethod() != null && this.getInterpolationMethod().hasData()) {
                return true;
            }
            return this.getEarlyCallDate() != null && this.getEarlyCallDate().hasData();
        }

        @Override
        public MakeWholeAmountBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            MakeWholeAmountBuilder o = (MakeWholeAmountBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInterpolationMethod(), (RosettaModelObjectBuilder)o.getInterpolationMethod(), this::setInterpolationMethod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEarlyCallDate(), (RosettaModelObjectBuilder)o.getEarlyCallDate(), this::setEarlyCallDate);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MakeWholeAmount _that = (MakeWholeAmount)this.getType().cast(o);
            if (!Objects.equals(this.interpolationMethod, _that.getInterpolationMethod())) {
                return false;
            }
            return Objects.equals(this.earlyCallDate, _that.getEarlyCallDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.interpolationMethod != null ? this.interpolationMethod.hashCode() : 0);
            _result = 31 * _result + (this.earlyCallDate != null ? this.earlyCallDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MakeWholeAmountBuilder {interpolationMethod=" + String.valueOf(this.interpolationMethod) + ", earlyCallDate=" + String.valueOf(this.earlyCallDate) + "} " + super.toString();
        }
    }

    public static interface MakeWholeAmountBuilder
    extends MakeWholeAmount,
    SwapCurveValuation.SwapCurveValuationBuilder {
        public InterpolationMethod.InterpolationMethodBuilder getOrCreateInterpolationMethod();

        @Override
        public InterpolationMethod.InterpolationMethodBuilder getInterpolationMethod();

        public IdentifiedDate.IdentifiedDateBuilder getOrCreateEarlyCallDate();

        @Override
        public IdentifiedDate.IdentifiedDateBuilder getEarlyCallDate();

        @Override
        public MakeWholeAmountBuilder setFloatingRateIndexModel(FloatingRateIndexModel var1);

        @Override
        public MakeWholeAmountBuilder setSpread(BigDecimal var1);

        @Override
        public MakeWholeAmountBuilder setSide(QuotationSideEnum var1);

        public MakeWholeAmountBuilder setInterpolationMethod(InterpolationMethod var1);

        public MakeWholeAmountBuilder setEarlyCallDate(IdentifiedDate var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("floatingRateIndexModel"), processor, FloatingRateIndexModel.FloatingRateIndexModelBuilder.class, (RosettaModelObjectBuilder)this.getFloatingRateIndexModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spread"), BigDecimal.class, (Object)this.getSpread(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("side"), QuotationSideEnum.class, (Object)this.getSide(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("interpolationMethod"), processor, InterpolationMethod.InterpolationMethodBuilder.class, this.getInterpolationMethod(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("earlyCallDate"), processor, IdentifiedDate.IdentifiedDateBuilder.class, this.getEarlyCallDate(), new AttributeMeta[0]);
        }

        @Override
        public MakeWholeAmountBuilder prune();
    }

    public static class MakeWholeAmountImpl
    extends SwapCurveValuation.SwapCurveValuationImpl
    implements MakeWholeAmount {
        private final InterpolationMethod interpolationMethod;
        private final IdentifiedDate earlyCallDate;

        protected MakeWholeAmountImpl(MakeWholeAmountBuilder builder) {
            super(builder);
            this.interpolationMethod = Optional.ofNullable(builder.getInterpolationMethod()).map(f -> f.build()).orElse(null);
            this.earlyCallDate = Optional.ofNullable(builder.getEarlyCallDate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="interpolationMethod")
        @RuneAttribute(value="interpolationMethod")
        public InterpolationMethod getInterpolationMethod() {
            return this.interpolationMethod;
        }

        @Override
        @RosettaAttribute(value="earlyCallDate")
        @RuneAttribute(value="earlyCallDate")
        public IdentifiedDate getEarlyCallDate() {
            return this.earlyCallDate;
        }

        @Override
        public MakeWholeAmount build() {
            return this;
        }

        @Override
        public MakeWholeAmountBuilder toBuilder() {
            MakeWholeAmountBuilder builder = MakeWholeAmount.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MakeWholeAmountBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getInterpolationMethod()).ifPresent(builder::setInterpolationMethod);
            Optional.ofNullable(this.getEarlyCallDate()).ifPresent(builder::setEarlyCallDate);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MakeWholeAmount _that = (MakeWholeAmount)this.getType().cast(o);
            if (!Objects.equals(this.interpolationMethod, _that.getInterpolationMethod())) {
                return false;
            }
            return Objects.equals(this.earlyCallDate, _that.getEarlyCallDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.interpolationMethod != null ? this.interpolationMethod.hashCode() : 0);
            _result = 31 * _result + (this.earlyCallDate != null ? this.earlyCallDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MakeWholeAmount {interpolationMethod=" + String.valueOf(this.interpolationMethod) + ", earlyCallDate=" + String.valueOf(this.earlyCallDate) + "} " + super.toString();
        }
    }
}

