/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.meta.PendingPaymentMeta;
import fpml.consolidated.shared.Money;
import fpml.consolidated.shared.PaymentBase;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="PendingPayment", builder=PendingPaymentBuilderImpl.class, version="1.2.2")
@RuneDataType(value="PendingPayment", model="fpml", builder=PendingPaymentBuilderImpl.class, version="1.2.2")
public interface PendingPayment
extends PaymentBase {
    public static final PendingPaymentMeta metaData = new PendingPaymentMeta();

    public ZonedDateTime getPaymentDate();

    public Money getAmount();

    public Money getAccruedInterest();

    @Override
    public PendingPayment build();

    @Override
    public PendingPaymentBuilder toBuilder();

    public static PendingPaymentBuilder builder() {
        return new PendingPaymentBuilderImpl();
    }

    default public RosettaMetaData<? extends PendingPayment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PendingPayment> getType() {
        return PendingPayment.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("paymentDate"), ZonedDateTime.class, (Object)this.getPaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amount"), processor, Money.class, this.getAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("accruedInterest"), processor, Money.class, this.getAccruedInterest(), new AttributeMeta[0]);
    }

    public static class PendingPaymentBuilderImpl
    extends PaymentBase.PaymentBaseBuilderImpl
    implements PendingPaymentBuilder {
        protected ZonedDateTime paymentDate;
        protected Money.MoneyBuilder amount;
        protected Money.MoneyBuilder accruedInterest;

        @Override
        @RosettaAttribute(value="paymentDate")
        @RuneAttribute(value="paymentDate")
        public ZonedDateTime getPaymentDate() {
            return this.paymentDate;
        }

        @Override
        @RosettaAttribute(value="amount")
        @RuneAttribute(value="amount")
        public Money.MoneyBuilder getAmount() {
            return this.amount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateAmount() {
            Money.MoneyBuilder result = this.amount != null ? this.amount : (this.amount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="accruedInterest")
        @RuneAttribute(value="accruedInterest")
        public Money.MoneyBuilder getAccruedInterest() {
            return this.accruedInterest;
        }

        @Override
        public Money.MoneyBuilder getOrCreateAccruedInterest() {
            Money.MoneyBuilder result = this.accruedInterest != null ? this.accruedInterest : (this.accruedInterest = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public PendingPaymentBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDate")
        @RuneAttribute(value="paymentDate")
        public PendingPaymentBuilder setPaymentDate(ZonedDateTime _paymentDate) {
            this.paymentDate = _paymentDate == null ? null : _paymentDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="amount")
        @RuneAttribute(value="amount")
        public PendingPaymentBuilder setAmount(Money _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="accruedInterest")
        @RuneAttribute(value="accruedInterest")
        public PendingPaymentBuilder setAccruedInterest(Money _accruedInterest) {
            this.accruedInterest = _accruedInterest == null ? null : _accruedInterest.toBuilder();
            return this;
        }

        @Override
        public PendingPayment build() {
            return new PendingPaymentImpl(this);
        }

        @Override
        public PendingPaymentBuilder toBuilder() {
            return this;
        }

        @Override
        public PendingPaymentBuilder prune() {
            super.prune();
            if (this.amount != null && !this.amount.prune().hasData()) {
                this.amount = null;
            }
            if (this.accruedInterest != null && !this.accruedInterest.prune().hasData()) {
                this.accruedInterest = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPaymentDate() != null) {
                return true;
            }
            if (this.getAmount() != null && this.getAmount().hasData()) {
                return true;
            }
            return this.getAccruedInterest() != null && this.getAccruedInterest().hasData();
        }

        @Override
        public PendingPaymentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            PendingPaymentBuilder o = (PendingPaymentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmount(), (RosettaModelObjectBuilder)o.getAmount(), this::setAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAccruedInterest(), (RosettaModelObjectBuilder)o.getAccruedInterest(), this::setAccruedInterest);
            merger.mergeBasic((Object)this.getPaymentDate(), (Object)o.getPaymentDate(), this::setPaymentDate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PendingPayment _that = (PendingPayment)this.getType().cast(o);
            if (!Objects.equals(this.paymentDate, _that.getPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return Objects.equals(this.accruedInterest, _that.getAccruedInterest());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.paymentDate != null ? this.paymentDate.hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.accruedInterest != null ? this.accruedInterest.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "PendingPaymentBuilder {paymentDate=" + String.valueOf(this.paymentDate) + ", amount=" + String.valueOf(this.amount) + ", accruedInterest=" + String.valueOf(this.accruedInterest) + "} " + super.toString();
        }
    }

    public static interface PendingPaymentBuilder
    extends PendingPayment,
    PaymentBase.PaymentBaseBuilder {
        public Money.MoneyBuilder getOrCreateAmount();

        @Override
        public Money.MoneyBuilder getAmount();

        public Money.MoneyBuilder getOrCreateAccruedInterest();

        @Override
        public Money.MoneyBuilder getAccruedInterest();

        @Override
        public PendingPaymentBuilder setId(String var1);

        public PendingPaymentBuilder setPaymentDate(ZonedDateTime var1);

        public PendingPaymentBuilder setAmount(Money var1);

        public PendingPaymentBuilder setAccruedInterest(Money var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("paymentDate"), ZonedDateTime.class, (Object)this.getPaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amount"), processor, Money.MoneyBuilder.class, this.getAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("accruedInterest"), processor, Money.MoneyBuilder.class, this.getAccruedInterest(), new AttributeMeta[0]);
        }

        @Override
        public PendingPaymentBuilder prune();
    }

    public static class PendingPaymentImpl
    extends PaymentBase.PaymentBaseImpl
    implements PendingPayment {
        private final ZonedDateTime paymentDate;
        private final Money amount;
        private final Money accruedInterest;

        protected PendingPaymentImpl(PendingPaymentBuilder builder) {
            super(builder);
            this.paymentDate = builder.getPaymentDate();
            this.amount = Optional.ofNullable(builder.getAmount()).map(f -> f.build()).orElse(null);
            this.accruedInterest = Optional.ofNullable(builder.getAccruedInterest()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="paymentDate")
        @RuneAttribute(value="paymentDate")
        public ZonedDateTime getPaymentDate() {
            return this.paymentDate;
        }

        @Override
        @RosettaAttribute(value="amount")
        @RuneAttribute(value="amount")
        public Money getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="accruedInterest")
        @RuneAttribute(value="accruedInterest")
        public Money getAccruedInterest() {
            return this.accruedInterest;
        }

        @Override
        public PendingPayment build() {
            return this;
        }

        @Override
        public PendingPaymentBuilder toBuilder() {
            PendingPaymentBuilder builder = PendingPayment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PendingPaymentBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPaymentDate()).ifPresent(builder::setPaymentDate);
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getAccruedInterest()).ifPresent(builder::setAccruedInterest);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PendingPayment _that = (PendingPayment)this.getType().cast(o);
            if (!Objects.equals(this.paymentDate, _that.getPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return Objects.equals(this.accruedInterest, _that.getAccruedInterest());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.paymentDate != null ? this.paymentDate.hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.accruedInterest != null ? this.accruedInterest.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "PendingPayment {paymentDate=" + String.valueOf(this.paymentDate) + ", amount=" + String.valueOf(this.amount) + ", accruedInterest=" + String.valueOf(this.accruedInterest) + "} " + super.toString();
        }
    }
}

