/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.ExchangeIdentifierModel;
import fpml.consolidated.asset.ExchangeTradedContractUnderlyer;
import fpml.consolidated.asset.ExchangeTradedOption;
import fpml.consolidated.asset.ExchangeTradedOptionSequence;
import fpml.consolidated.asset.InstrumentType;
import fpml.consolidated.asset.meta.OptionMeta;
import fpml.consolidated.fpmlenum.ExerciseStyleEnum;
import fpml.consolidated.fpmlenum.PutCallEnum;
import fpml.consolidated.fpmlenum.SettlementTypeEnum;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import fpml.consolidated.shared.ClearanceSystem;
import fpml.consolidated.shared.ExchangeId;
import fpml.consolidated.shared.IdentifiedCurrency;
import fpml.consolidated.shared.InstrumentId;
import fpml.consolidated.shared.ProductReference;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@RosettaDataType(value="Option", builder=OptionBuilderImpl.class, version="1.2.2")
@RuneDataType(value="Option", model="fpml", builder=OptionBuilderImpl.class, version="1.2.2")
public interface Option
extends ExchangeTradedOption {
    public static final OptionMeta metaData = new OptionMeta();

    @Override
    public Option build();

    @Override
    public OptionBuilder toBuilder();

    public static OptionBuilder builder() {
        return new OptionBuilderImpl();
    }

    default public RosettaMetaData<? extends Option> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Option> getType() {
        return Option.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.class, this.getInstrumentType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.class, this.getExchangeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.class, this.getClearanceSystem(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("definition"), processor, ProductReference.class, this.getDefinition(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeIdentifierModel"), processor, ExchangeIdentifierModel.class, this.getExchangeIdentifierModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("multiplier"), BigDecimal.class, (Object)this.getMultiplier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("contractReference"), String.class, (Object)this.getContractReference(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("expirationDate"), processor, AdjustableOrRelativeDate.class, this.getExpirationDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeTradedOptionSequence"), processor, ExchangeTradedOptionSequence.class, this.getExchangeTradedOptionSequence(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionType"), PutCallEnum.class, (Object)this.getOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exerciseStyle"), ExerciseStyleEnum.class, (Object)this.getExerciseStyle(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyer"), processor, ExchangeTradedContractUnderlyer.class, this.getUnderlyer(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementType"), SettlementTypeEnum.class, (Object)this.getSettlementType(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class OptionBuilderImpl
    extends ExchangeTradedOption.ExchangeTradedOptionBuilderImpl
    implements OptionBuilder {
        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public OptionBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public OptionBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public OptionBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public OptionBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public OptionBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentType")
        @RuneAttribute(value="instrumentType")
        public OptionBuilder addInstrumentType(InstrumentType _instrumentType) {
            if (_instrumentType != null) {
                this.instrumentType.add(_instrumentType.toBuilder());
            }
            return this;
        }

        @Override
        public OptionBuilder addInstrumentType(InstrumentType _instrumentType, int idx) {
            this.getIndex(this.instrumentType, idx, () -> _instrumentType.toBuilder());
            return this;
        }

        @Override
        public OptionBuilder addInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            if (instrumentTypes != null) {
                for (InstrumentType instrumentType : instrumentTypes) {
                    this.instrumentType.add(instrumentType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentType")
        public OptionBuilder setInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            this.instrumentType = instrumentTypes == null ? new ArrayList() : (List)instrumentTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public OptionBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public OptionBuilder setCurrency(IdentifiedCurrency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeId")
        @RuneAttribute(value="exchangeId")
        public OptionBuilder setExchangeId(ExchangeId _exchangeId) {
            this.exchangeId = _exchangeId == null ? null : _exchangeId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="clearanceSystem")
        @RuneAttribute(value="clearanceSystem")
        public OptionBuilder setClearanceSystem(ClearanceSystem _clearanceSystem) {
            this.clearanceSystem = _clearanceSystem == null ? null : _clearanceSystem.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="definition")
        @RuneAttribute(value="definition")
        public OptionBuilder setDefinition(ProductReference _definition) {
            this.definition = _definition == null ? null : _definition.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeIdentifierModel", isRequired=true)
        @RuneAttribute(value="exchangeIdentifierModel", isRequired=true)
        public OptionBuilder setExchangeIdentifierModel(ExchangeIdentifierModel _exchangeIdentifierModel) {
            this.exchangeIdentifierModel = _exchangeIdentifierModel == null ? null : _exchangeIdentifierModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="multiplier")
        @RuneAttribute(value="multiplier")
        public OptionBuilder setMultiplier(BigDecimal _multiplier) {
            this.multiplier = _multiplier == null ? null : _multiplier;
            return this;
        }

        @Override
        @RosettaAttribute(value="contractReference")
        @RuneAttribute(value="contractReference")
        public OptionBuilder setContractReference(String _contractReference) {
            this.contractReference = _contractReference == null ? null : _contractReference;
            return this;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public OptionBuilder setExpirationDate(AdjustableOrRelativeDate _expirationDate) {
            this.expirationDate = _expirationDate == null ? null : _expirationDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeTradedOptionSequence")
        @RuneAttribute(value="exchangeTradedOptionSequence")
        public OptionBuilder setExchangeTradedOptionSequence(ExchangeTradedOptionSequence _exchangeTradedOptionSequence) {
            this.exchangeTradedOptionSequence = _exchangeTradedOptionSequence == null ? null : _exchangeTradedOptionSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public OptionBuilder setOptionType(PutCallEnum _optionType) {
            this.optionType = _optionType == null ? null : _optionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseStyle")
        @RuneAttribute(value="exerciseStyle")
        public OptionBuilder setExerciseStyle(ExerciseStyleEnum _exerciseStyle) {
            this.exerciseStyle = _exerciseStyle == null ? null : _exerciseStyle;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyer")
        @RuneAttribute(value="underlyer")
        public OptionBuilder setUnderlyer(ExchangeTradedContractUnderlyer _underlyer) {
            this.underlyer = _underlyer == null ? null : _underlyer.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementType")
        @RuneAttribute(value="settlementType")
        public OptionBuilder setSettlementType(SettlementTypeEnum _settlementType) {
            this.settlementType = _settlementType == null ? null : _settlementType;
            return this;
        }

        @Override
        public Option build() {
            return new OptionImpl(this);
        }

        @Override
        public OptionBuilder toBuilder() {
            return this;
        }

        @Override
        public OptionBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            return super.hasData();
        }

        @Override
        public OptionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            OptionBuilder o = (OptionBuilder)other;
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            return _result;
        }

        @Override
        public String toString() {
            return "OptionBuilder {} " + super.toString();
        }
    }

    public static interface OptionBuilder
    extends Option,
    ExchangeTradedOption.ExchangeTradedOptionBuilder {
        @Override
        public OptionBuilder setId(String var1);

        @Override
        public OptionBuilder addInstrumentId(InstrumentId var1);

        @Override
        public OptionBuilder addInstrumentId(InstrumentId var1, int var2);

        @Override
        public OptionBuilder addInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public OptionBuilder setInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public OptionBuilder addInstrumentType(InstrumentType var1);

        @Override
        public OptionBuilder addInstrumentType(InstrumentType var1, int var2);

        @Override
        public OptionBuilder addInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public OptionBuilder setInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public OptionBuilder setDescription(String var1);

        @Override
        public OptionBuilder setCurrency(IdentifiedCurrency var1);

        @Override
        public OptionBuilder setExchangeId(ExchangeId var1);

        @Override
        public OptionBuilder setClearanceSystem(ClearanceSystem var1);

        @Override
        public OptionBuilder setDefinition(ProductReference var1);

        @Override
        public OptionBuilder setExchangeIdentifierModel(ExchangeIdentifierModel var1);

        @Override
        public OptionBuilder setMultiplier(BigDecimal var1);

        @Override
        public OptionBuilder setContractReference(String var1);

        @Override
        public OptionBuilder setExpirationDate(AdjustableOrRelativeDate var1);

        @Override
        public OptionBuilder setExchangeTradedOptionSequence(ExchangeTradedOptionSequence var1);

        @Override
        public OptionBuilder setOptionType(PutCallEnum var1);

        @Override
        public OptionBuilder setExerciseStyle(ExerciseStyleEnum var1);

        @Override
        public OptionBuilder setUnderlyer(ExchangeTradedContractUnderlyer var1);

        @Override
        public OptionBuilder setSettlementType(SettlementTypeEnum var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.InstrumentTypeBuilder.class, this.getInstrumentType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.IdentifiedCurrencyBuilder.class, (RosettaModelObjectBuilder)this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.ExchangeIdBuilder.class, (RosettaModelObjectBuilder)this.getExchangeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.ClearanceSystemBuilder.class, (RosettaModelObjectBuilder)this.getClearanceSystem(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("definition"), processor, ProductReference.ProductReferenceBuilder.class, (RosettaModelObjectBuilder)this.getDefinition(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeIdentifierModel"), processor, ExchangeIdentifierModel.ExchangeIdentifierModelBuilder.class, (RosettaModelObjectBuilder)this.getExchangeIdentifierModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("multiplier"), BigDecimal.class, (Object)this.getMultiplier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("contractReference"), String.class, (Object)this.getContractReference(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("expirationDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getExpirationDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeTradedOptionSequence"), processor, ExchangeTradedOptionSequence.ExchangeTradedOptionSequenceBuilder.class, (RosettaModelObjectBuilder)this.getExchangeTradedOptionSequence(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionType"), PutCallEnum.class, (Object)this.getOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exerciseStyle"), ExerciseStyleEnum.class, (Object)this.getExerciseStyle(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyer"), processor, ExchangeTradedContractUnderlyer.ExchangeTradedContractUnderlyerBuilder.class, (RosettaModelObjectBuilder)this.getUnderlyer(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementType"), SettlementTypeEnum.class, (Object)this.getSettlementType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public OptionBuilder prune();
    }

    public static class OptionImpl
    extends ExchangeTradedOption.ExchangeTradedOptionImpl
    implements Option {
        protected OptionImpl(OptionBuilder builder) {
            super(builder);
        }

        @Override
        public Option build() {
            return this;
        }

        @Override
        public OptionBuilder toBuilder() {
            OptionBuilder builder = Option.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(OptionBuilder builder) {
            super.setBuilderFields(builder);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            return _result;
        }

        @Override
        public String toString() {
            return "Option {} " + super.toString();
        }
    }
}

