/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.InstrumentType;
import fpml.consolidated.asset.UnderlyingAsset;
import fpml.consolidated.asset.meta.MutualFundMeta;
import fpml.consolidated.shared.ClearanceSystem;
import fpml.consolidated.shared.ExchangeId;
import fpml.consolidated.shared.IdentifiedCurrency;
import fpml.consolidated.shared.InstrumentId;
import fpml.consolidated.shared.ProductReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="MutualFund", builder=MutualFundBuilderImpl.class, version="1.2.2")
@RuneDataType(value="MutualFund", model="fpml", builder=MutualFundBuilderImpl.class, version="1.2.2")
public interface MutualFund
extends UnderlyingAsset {
    public static final MutualFundMeta metaData = new MutualFundMeta();

    public Boolean getOpenEndedFund();

    public String getFundManager();

    @Override
    public MutualFund build();

    @Override
    public MutualFundBuilder toBuilder();

    public static MutualFundBuilder builder() {
        return new MutualFundBuilderImpl();
    }

    default public RosettaMetaData<? extends MutualFund> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends MutualFund> getType() {
        return MutualFund.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.class, this.getInstrumentType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.class, this.getExchangeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.class, this.getClearanceSystem(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("definition"), processor, ProductReference.class, this.getDefinition(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("openEndedFund"), Boolean.class, (Object)this.getOpenEndedFund(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fundManager"), String.class, (Object)this.getFundManager(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class MutualFundBuilderImpl
    extends UnderlyingAsset.UnderlyingAssetBuilderImpl
    implements MutualFundBuilder {
        protected Boolean openEndedFund;
        protected String fundManager;

        @Override
        @RosettaAttribute(value="openEndedFund")
        @RuneAttribute(value="openEndedFund")
        public Boolean getOpenEndedFund() {
            return this.openEndedFund;
        }

        @Override
        @RosettaAttribute(value="fundManager")
        @RuneAttribute(value="fundManager")
        public String getFundManager() {
            return this.fundManager;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public MutualFundBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public MutualFundBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public MutualFundBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public MutualFundBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public MutualFundBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentType")
        @RuneAttribute(value="instrumentType")
        public MutualFundBuilder addInstrumentType(InstrumentType _instrumentType) {
            if (_instrumentType != null) {
                this.instrumentType.add(_instrumentType.toBuilder());
            }
            return this;
        }

        @Override
        public MutualFundBuilder addInstrumentType(InstrumentType _instrumentType, int idx) {
            this.getIndex(this.instrumentType, idx, () -> _instrumentType.toBuilder());
            return this;
        }

        @Override
        public MutualFundBuilder addInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            if (instrumentTypes != null) {
                for (InstrumentType instrumentType : instrumentTypes) {
                    this.instrumentType.add(instrumentType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentType")
        public MutualFundBuilder setInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            this.instrumentType = instrumentTypes == null ? new ArrayList() : (List)instrumentTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public MutualFundBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public MutualFundBuilder setCurrency(IdentifiedCurrency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeId")
        @RuneAttribute(value="exchangeId")
        public MutualFundBuilder setExchangeId(ExchangeId _exchangeId) {
            this.exchangeId = _exchangeId == null ? null : _exchangeId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="clearanceSystem")
        @RuneAttribute(value="clearanceSystem")
        public MutualFundBuilder setClearanceSystem(ClearanceSystem _clearanceSystem) {
            this.clearanceSystem = _clearanceSystem == null ? null : _clearanceSystem.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="definition")
        @RuneAttribute(value="definition")
        public MutualFundBuilder setDefinition(ProductReference _definition) {
            this.definition = _definition == null ? null : _definition.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="openEndedFund")
        @RuneAttribute(value="openEndedFund")
        public MutualFundBuilder setOpenEndedFund(Boolean _openEndedFund) {
            this.openEndedFund = _openEndedFund == null ? null : _openEndedFund;
            return this;
        }

        @Override
        @RosettaAttribute(value="fundManager")
        @RuneAttribute(value="fundManager")
        public MutualFundBuilder setFundManager(String _fundManager) {
            this.fundManager = _fundManager == null ? null : _fundManager;
            return this;
        }

        @Override
        public MutualFund build() {
            return new MutualFundImpl(this);
        }

        @Override
        public MutualFundBuilder toBuilder() {
            return this;
        }

        @Override
        public MutualFundBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getOpenEndedFund() != null) {
                return true;
            }
            return this.getFundManager() != null;
        }

        @Override
        public MutualFundBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            MutualFundBuilder o = (MutualFundBuilder)other;
            merger.mergeBasic((Object)this.getOpenEndedFund(), (Object)o.getOpenEndedFund(), this::setOpenEndedFund, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFundManager(), (Object)o.getFundManager(), this::setFundManager, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MutualFund _that = (MutualFund)this.getType().cast(o);
            if (!Objects.equals(this.openEndedFund, _that.getOpenEndedFund())) {
                return false;
            }
            return Objects.equals(this.fundManager, _that.getFundManager());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.openEndedFund != null ? this.openEndedFund.hashCode() : 0);
            _result = 31 * _result + (this.fundManager != null ? this.fundManager.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MutualFundBuilder {openEndedFund=" + this.openEndedFund + ", fundManager=" + this.fundManager + "} " + super.toString();
        }
    }

    public static interface MutualFundBuilder
    extends MutualFund,
    UnderlyingAsset.UnderlyingAssetBuilder {
        @Override
        public MutualFundBuilder setId(String var1);

        @Override
        public MutualFundBuilder addInstrumentId(InstrumentId var1);

        @Override
        public MutualFundBuilder addInstrumentId(InstrumentId var1, int var2);

        @Override
        public MutualFundBuilder addInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public MutualFundBuilder setInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public MutualFundBuilder addInstrumentType(InstrumentType var1);

        @Override
        public MutualFundBuilder addInstrumentType(InstrumentType var1, int var2);

        @Override
        public MutualFundBuilder addInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public MutualFundBuilder setInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public MutualFundBuilder setDescription(String var1);

        @Override
        public MutualFundBuilder setCurrency(IdentifiedCurrency var1);

        @Override
        public MutualFundBuilder setExchangeId(ExchangeId var1);

        @Override
        public MutualFundBuilder setClearanceSystem(ClearanceSystem var1);

        @Override
        public MutualFundBuilder setDefinition(ProductReference var1);

        public MutualFundBuilder setOpenEndedFund(Boolean var1);

        public MutualFundBuilder setFundManager(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.InstrumentTypeBuilder.class, this.getInstrumentType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.IdentifiedCurrencyBuilder.class, (RosettaModelObjectBuilder)this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.ExchangeIdBuilder.class, (RosettaModelObjectBuilder)this.getExchangeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.ClearanceSystemBuilder.class, (RosettaModelObjectBuilder)this.getClearanceSystem(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("definition"), processor, ProductReference.ProductReferenceBuilder.class, (RosettaModelObjectBuilder)this.getDefinition(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("openEndedFund"), Boolean.class, (Object)this.getOpenEndedFund(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fundManager"), String.class, (Object)this.getFundManager(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public MutualFundBuilder prune();
    }

    public static class MutualFundImpl
    extends UnderlyingAsset.UnderlyingAssetImpl
    implements MutualFund {
        private final Boolean openEndedFund;
        private final String fundManager;

        protected MutualFundImpl(MutualFundBuilder builder) {
            super(builder);
            this.openEndedFund = builder.getOpenEndedFund();
            this.fundManager = builder.getFundManager();
        }

        @Override
        @RosettaAttribute(value="openEndedFund")
        @RuneAttribute(value="openEndedFund")
        public Boolean getOpenEndedFund() {
            return this.openEndedFund;
        }

        @Override
        @RosettaAttribute(value="fundManager")
        @RuneAttribute(value="fundManager")
        public String getFundManager() {
            return this.fundManager;
        }

        @Override
        public MutualFund build() {
            return this;
        }

        @Override
        public MutualFundBuilder toBuilder() {
            MutualFundBuilder builder = MutualFund.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MutualFundBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getOpenEndedFund()).ifPresent(builder::setOpenEndedFund);
            Optional.ofNullable(this.getFundManager()).ifPresent(builder::setFundManager);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MutualFund _that = (MutualFund)this.getType().cast(o);
            if (!Objects.equals(this.openEndedFund, _that.getOpenEndedFund())) {
                return false;
            }
            return Objects.equals(this.fundManager, _that.getFundManager());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.openEndedFund != null ? this.openEndedFund.hashCode() : 0);
            _result = 31 * _result + (this.fundManager != null ? this.fundManager.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MutualFund {openEndedFund=" + this.openEndedFund + ", fundManager=" + this.fundManager + "} " + super.toString();
        }
    }
}

