/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.InstrumentType;
import fpml.consolidated.asset.UnderlyingAsset;
import fpml.consolidated.asset.meta.DepositMeta;
import fpml.consolidated.shared.ClearanceSystem;
import fpml.consolidated.shared.DayCountFraction;
import fpml.consolidated.shared.ExchangeId;
import fpml.consolidated.shared.IdentifiedCurrency;
import fpml.consolidated.shared.InstrumentId;
import fpml.consolidated.shared.Period;
import fpml.consolidated.shared.ProductReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Deposit", builder=DepositBuilderImpl.class, version="1.2.2")
@RuneDataType(value="Deposit", model="fpml", builder=DepositBuilderImpl.class, version="1.2.2")
public interface Deposit
extends UnderlyingAsset {
    public static final DepositMeta metaData = new DepositMeta();

    public Period getTerm();

    public Period getPaymentFrequency();

    public DayCountFraction getDayCountFraction();

    @Override
    public Deposit build();

    @Override
    public DepositBuilder toBuilder();

    public static DepositBuilder builder() {
        return new DepositBuilderImpl();
    }

    default public RosettaMetaData<? extends Deposit> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Deposit> getType() {
        return Deposit.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.class, this.getInstrumentType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.class, this.getExchangeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.class, this.getClearanceSystem(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("definition"), processor, ProductReference.class, this.getDefinition(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("term"), processor, Period.class, this.getTerm(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentFrequency"), processor, Period.class, this.getPaymentFrequency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.class, this.getDayCountFraction(), new AttributeMeta[0]);
    }

    public static class DepositBuilderImpl
    extends UnderlyingAsset.UnderlyingAssetBuilderImpl
    implements DepositBuilder {
        protected Period.PeriodBuilder term;
        protected Period.PeriodBuilder paymentFrequency;
        protected DayCountFraction.DayCountFractionBuilder dayCountFraction;

        @Override
        @RosettaAttribute(value="term")
        @RuneAttribute(value="term")
        public Period.PeriodBuilder getTerm() {
            return this.term;
        }

        @Override
        public Period.PeriodBuilder getOrCreateTerm() {
            Period.PeriodBuilder result = this.term != null ? this.term : (this.term = Period.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public Period.PeriodBuilder getPaymentFrequency() {
            return this.paymentFrequency;
        }

        @Override
        public Period.PeriodBuilder getOrCreatePaymentFrequency() {
            Period.PeriodBuilder result = this.paymentFrequency != null ? this.paymentFrequency : (this.paymentFrequency = Period.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public DayCountFraction.DayCountFractionBuilder getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        public DayCountFraction.DayCountFractionBuilder getOrCreateDayCountFraction() {
            DayCountFraction.DayCountFractionBuilder result = this.dayCountFraction != null ? this.dayCountFraction : (this.dayCountFraction = DayCountFraction.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public DepositBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public DepositBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public DepositBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public DepositBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public DepositBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentType")
        @RuneAttribute(value="instrumentType")
        public DepositBuilder addInstrumentType(InstrumentType _instrumentType) {
            if (_instrumentType != null) {
                this.instrumentType.add(_instrumentType.toBuilder());
            }
            return this;
        }

        @Override
        public DepositBuilder addInstrumentType(InstrumentType _instrumentType, int idx) {
            this.getIndex(this.instrumentType, idx, () -> _instrumentType.toBuilder());
            return this;
        }

        @Override
        public DepositBuilder addInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            if (instrumentTypes != null) {
                for (InstrumentType instrumentType : instrumentTypes) {
                    this.instrumentType.add(instrumentType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentType")
        public DepositBuilder setInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            this.instrumentType = instrumentTypes == null ? new ArrayList() : (List)instrumentTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public DepositBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public DepositBuilder setCurrency(IdentifiedCurrency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeId")
        @RuneAttribute(value="exchangeId")
        public DepositBuilder setExchangeId(ExchangeId _exchangeId) {
            this.exchangeId = _exchangeId == null ? null : _exchangeId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="clearanceSystem")
        @RuneAttribute(value="clearanceSystem")
        public DepositBuilder setClearanceSystem(ClearanceSystem _clearanceSystem) {
            this.clearanceSystem = _clearanceSystem == null ? null : _clearanceSystem.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="definition")
        @RuneAttribute(value="definition")
        public DepositBuilder setDefinition(ProductReference _definition) {
            this.definition = _definition == null ? null : _definition.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="term")
        @RuneAttribute(value="term")
        public DepositBuilder setTerm(Period _term) {
            this.term = _term == null ? null : _term.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public DepositBuilder setPaymentFrequency(Period _paymentFrequency) {
            this.paymentFrequency = _paymentFrequency == null ? null : _paymentFrequency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public DepositBuilder setDayCountFraction(DayCountFraction _dayCountFraction) {
            this.dayCountFraction = _dayCountFraction == null ? null : _dayCountFraction.toBuilder();
            return this;
        }

        @Override
        public Deposit build() {
            return new DepositImpl(this);
        }

        @Override
        public DepositBuilder toBuilder() {
            return this;
        }

        @Override
        public DepositBuilder prune() {
            super.prune();
            if (this.term != null && !this.term.prune().hasData()) {
                this.term = null;
            }
            if (this.paymentFrequency != null && !this.paymentFrequency.prune().hasData()) {
                this.paymentFrequency = null;
            }
            if (this.dayCountFraction != null && !this.dayCountFraction.prune().hasData()) {
                this.dayCountFraction = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getTerm() != null && this.getTerm().hasData()) {
                return true;
            }
            if (this.getPaymentFrequency() != null && this.getPaymentFrequency().hasData()) {
                return true;
            }
            return this.getDayCountFraction() != null && this.getDayCountFraction().hasData();
        }

        @Override
        public DepositBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            DepositBuilder o = (DepositBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTerm(), (RosettaModelObjectBuilder)o.getTerm(), this::setTerm);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentFrequency(), (RosettaModelObjectBuilder)o.getPaymentFrequency(), this::setPaymentFrequency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDayCountFraction(), (RosettaModelObjectBuilder)o.getDayCountFraction(), this::setDayCountFraction);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Deposit _that = (Deposit)this.getType().cast(o);
            if (!Objects.equals(this.term, _that.getTerm())) {
                return false;
            }
            if (!Objects.equals(this.paymentFrequency, _that.getPaymentFrequency())) {
                return false;
            }
            return Objects.equals(this.dayCountFraction, _that.getDayCountFraction());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.term != null ? this.term.hashCode() : 0);
            _result = 31 * _result + (this.paymentFrequency != null ? this.paymentFrequency.hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "DepositBuilder {term=" + String.valueOf(this.term) + ", paymentFrequency=" + String.valueOf(this.paymentFrequency) + ", dayCountFraction=" + String.valueOf(this.dayCountFraction) + "} " + super.toString();
        }
    }

    public static interface DepositBuilder
    extends Deposit,
    UnderlyingAsset.UnderlyingAssetBuilder {
        public Period.PeriodBuilder getOrCreateTerm();

        @Override
        public Period.PeriodBuilder getTerm();

        public Period.PeriodBuilder getOrCreatePaymentFrequency();

        @Override
        public Period.PeriodBuilder getPaymentFrequency();

        public DayCountFraction.DayCountFractionBuilder getOrCreateDayCountFraction();

        @Override
        public DayCountFraction.DayCountFractionBuilder getDayCountFraction();

        @Override
        public DepositBuilder setId(String var1);

        @Override
        public DepositBuilder addInstrumentId(InstrumentId var1);

        @Override
        public DepositBuilder addInstrumentId(InstrumentId var1, int var2);

        @Override
        public DepositBuilder addInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public DepositBuilder setInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public DepositBuilder addInstrumentType(InstrumentType var1);

        @Override
        public DepositBuilder addInstrumentType(InstrumentType var1, int var2);

        @Override
        public DepositBuilder addInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public DepositBuilder setInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public DepositBuilder setDescription(String var1);

        @Override
        public DepositBuilder setCurrency(IdentifiedCurrency var1);

        @Override
        public DepositBuilder setExchangeId(ExchangeId var1);

        @Override
        public DepositBuilder setClearanceSystem(ClearanceSystem var1);

        @Override
        public DepositBuilder setDefinition(ProductReference var1);

        public DepositBuilder setTerm(Period var1);

        public DepositBuilder setPaymentFrequency(Period var1);

        public DepositBuilder setDayCountFraction(DayCountFraction var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.InstrumentTypeBuilder.class, this.getInstrumentType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.IdentifiedCurrencyBuilder.class, (RosettaModelObjectBuilder)this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.ExchangeIdBuilder.class, (RosettaModelObjectBuilder)this.getExchangeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.ClearanceSystemBuilder.class, (RosettaModelObjectBuilder)this.getClearanceSystem(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("definition"), processor, ProductReference.ProductReferenceBuilder.class, (RosettaModelObjectBuilder)this.getDefinition(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("term"), processor, Period.PeriodBuilder.class, this.getTerm(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentFrequency"), processor, Period.PeriodBuilder.class, this.getPaymentFrequency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.DayCountFractionBuilder.class, this.getDayCountFraction(), new AttributeMeta[0]);
        }

        @Override
        public DepositBuilder prune();
    }

    public static class DepositImpl
    extends UnderlyingAsset.UnderlyingAssetImpl
    implements Deposit {
        private final Period term;
        private final Period paymentFrequency;
        private final DayCountFraction dayCountFraction;

        protected DepositImpl(DepositBuilder builder) {
            super(builder);
            this.term = Optional.ofNullable(builder.getTerm()).map(f -> f.build()).orElse(null);
            this.paymentFrequency = Optional.ofNullable(builder.getPaymentFrequency()).map(f -> f.build()).orElse(null);
            this.dayCountFraction = Optional.ofNullable(builder.getDayCountFraction()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="term")
        @RuneAttribute(value="term")
        public Period getTerm() {
            return this.term;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public Period getPaymentFrequency() {
            return this.paymentFrequency;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public DayCountFraction getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        public Deposit build() {
            return this;
        }

        @Override
        public DepositBuilder toBuilder() {
            DepositBuilder builder = Deposit.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DepositBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getTerm()).ifPresent(builder::setTerm);
            Optional.ofNullable(this.getPaymentFrequency()).ifPresent(builder::setPaymentFrequency);
            Optional.ofNullable(this.getDayCountFraction()).ifPresent(builder::setDayCountFraction);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Deposit _that = (Deposit)this.getType().cast(o);
            if (!Objects.equals(this.term, _that.getTerm())) {
                return false;
            }
            if (!Objects.equals(this.paymentFrequency, _that.getPaymentFrequency())) {
                return false;
            }
            return Objects.equals(this.dayCountFraction, _that.getDayCountFraction());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.term != null ? this.term.hashCode() : 0);
            _result = 31 * _result + (this.paymentFrequency != null ? this.paymentFrequency.hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Deposit {term=" + String.valueOf(this.term) + ", paymentFrequency=" + String.valueOf(this.paymentFrequency) + ", dayCountFraction=" + String.valueOf(this.dayCountFraction) + "} " + super.toString();
        }
    }
}

