/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.Bond;
import fpml.consolidated.asset.BondCalculationModel;
import fpml.consolidated.asset.EquityAsset;
import fpml.consolidated.asset.FixedIncomeSecurityContentModel;
import fpml.consolidated.asset.InstrumentType;
import fpml.consolidated.asset.meta.ConvertibleBondMeta;
import fpml.consolidated.shared.ClearanceSystem;
import fpml.consolidated.shared.ExchangeId;
import fpml.consolidated.shared.IdentifiedCurrency;
import fpml.consolidated.shared.InstrumentId;
import fpml.consolidated.shared.ProductReference;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ConvertibleBond", builder=ConvertibleBondBuilderImpl.class, version="1.2.2")
@RuneDataType(value="ConvertibleBond", model="fpml", builder=ConvertibleBondBuilderImpl.class, version="1.2.2")
public interface ConvertibleBond
extends Bond {
    public static final ConvertibleBondMeta metaData = new ConvertibleBondMeta();

    public EquityAsset getUnderlyingEquity();

    public ZonedDateTime getRedemptionDate();

    @Override
    public ConvertibleBond build();

    @Override
    public ConvertibleBondBuilder toBuilder();

    public static ConvertibleBondBuilder builder() {
        return new ConvertibleBondBuilderImpl();
    }

    default public RosettaMetaData<? extends ConvertibleBond> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ConvertibleBond> getType() {
        return ConvertibleBond.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.class, this.getInstrumentType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.class, this.getExchangeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.class, this.getClearanceSystem(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("definition"), processor, ProductReference.class, this.getDefinition(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixedIncomeSecurityContentModel"), processor, FixedIncomeSecurityContentModel.class, this.getFixedIncomeSecurityContentModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("parValue"), BigDecimal.class, (Object)this.getParValue(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("faceAmount"), BigDecimal.class, (Object)this.getFaceAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("bondCalculationModel"), processor, BondCalculationModel.class, this.getBondCalculationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyingEquity"), processor, EquityAsset.class, this.getUnderlyingEquity(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("redemptionDate"), ZonedDateTime.class, (Object)this.getRedemptionDate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ConvertibleBondBuilderImpl
    extends Bond.BondBuilderImpl
    implements ConvertibleBondBuilder {
        protected EquityAsset.EquityAssetBuilder underlyingEquity;
        protected ZonedDateTime redemptionDate;

        @Override
        @RosettaAttribute(value="underlyingEquity")
        @RuneAttribute(value="underlyingEquity")
        public EquityAsset.EquityAssetBuilder getUnderlyingEquity() {
            return this.underlyingEquity;
        }

        @Override
        public EquityAsset.EquityAssetBuilder getOrCreateUnderlyingEquity() {
            EquityAsset.EquityAssetBuilder result = this.underlyingEquity != null ? this.underlyingEquity : (this.underlyingEquity = EquityAsset.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="redemptionDate")
        @RuneAttribute(value="redemptionDate")
        public ZonedDateTime getRedemptionDate() {
            return this.redemptionDate;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public ConvertibleBondBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public ConvertibleBondBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public ConvertibleBondBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public ConvertibleBondBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public ConvertibleBondBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentType")
        @RuneAttribute(value="instrumentType")
        public ConvertibleBondBuilder addInstrumentType(InstrumentType _instrumentType) {
            if (_instrumentType != null) {
                this.instrumentType.add(_instrumentType.toBuilder());
            }
            return this;
        }

        @Override
        public ConvertibleBondBuilder addInstrumentType(InstrumentType _instrumentType, int idx) {
            this.getIndex(this.instrumentType, idx, () -> _instrumentType.toBuilder());
            return this;
        }

        @Override
        public ConvertibleBondBuilder addInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            if (instrumentTypes != null) {
                for (InstrumentType instrumentType : instrumentTypes) {
                    this.instrumentType.add(instrumentType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentType")
        public ConvertibleBondBuilder setInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            this.instrumentType = instrumentTypes == null ? new ArrayList() : (List)instrumentTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public ConvertibleBondBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public ConvertibleBondBuilder setCurrency(IdentifiedCurrency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeId")
        @RuneAttribute(value="exchangeId")
        public ConvertibleBondBuilder setExchangeId(ExchangeId _exchangeId) {
            this.exchangeId = _exchangeId == null ? null : _exchangeId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="clearanceSystem")
        @RuneAttribute(value="clearanceSystem")
        public ConvertibleBondBuilder setClearanceSystem(ClearanceSystem _clearanceSystem) {
            this.clearanceSystem = _clearanceSystem == null ? null : _clearanceSystem.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="definition")
        @RuneAttribute(value="definition")
        public ConvertibleBondBuilder setDefinition(ProductReference _definition) {
            this.definition = _definition == null ? null : _definition.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedIncomeSecurityContentModel", isRequired=true)
        @RuneAttribute(value="fixedIncomeSecurityContentModel", isRequired=true)
        public ConvertibleBondBuilder setFixedIncomeSecurityContentModel(FixedIncomeSecurityContentModel _fixedIncomeSecurityContentModel) {
            this.fixedIncomeSecurityContentModel = _fixedIncomeSecurityContentModel == null ? null : _fixedIncomeSecurityContentModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="parValue")
        @RuneAttribute(value="parValue")
        public ConvertibleBondBuilder setParValue(BigDecimal _parValue) {
            this.parValue = _parValue == null ? null : _parValue;
            return this;
        }

        @Override
        @RosettaAttribute(value="faceAmount")
        @RuneAttribute(value="faceAmount")
        public ConvertibleBondBuilder setFaceAmount(BigDecimal _faceAmount) {
            this.faceAmount = _faceAmount == null ? null : _faceAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="bondCalculationModel", isRequired=true)
        @RuneAttribute(value="bondCalculationModel", isRequired=true)
        public ConvertibleBondBuilder setBondCalculationModel(BondCalculationModel _bondCalculationModel) {
            this.bondCalculationModel = _bondCalculationModel == null ? null : _bondCalculationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingEquity")
        @RuneAttribute(value="underlyingEquity")
        public ConvertibleBondBuilder setUnderlyingEquity(EquityAsset _underlyingEquity) {
            this.underlyingEquity = _underlyingEquity == null ? null : _underlyingEquity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="redemptionDate")
        @RuneAttribute(value="redemptionDate")
        public ConvertibleBondBuilder setRedemptionDate(ZonedDateTime _redemptionDate) {
            this.redemptionDate = _redemptionDate == null ? null : _redemptionDate;
            return this;
        }

        @Override
        public ConvertibleBond build() {
            return new ConvertibleBondImpl(this);
        }

        @Override
        public ConvertibleBondBuilder toBuilder() {
            return this;
        }

        @Override
        public ConvertibleBondBuilder prune() {
            super.prune();
            if (this.underlyingEquity != null && !this.underlyingEquity.prune().hasData()) {
                this.underlyingEquity = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getUnderlyingEquity() != null && this.getUnderlyingEquity().hasData()) {
                return true;
            }
            return this.getRedemptionDate() != null;
        }

        @Override
        public ConvertibleBondBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ConvertibleBondBuilder o = (ConvertibleBondBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlyingEquity(), (RosettaModelObjectBuilder)o.getUnderlyingEquity(), this::setUnderlyingEquity);
            merger.mergeBasic((Object)this.getRedemptionDate(), (Object)o.getRedemptionDate(), this::setRedemptionDate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ConvertibleBond _that = (ConvertibleBond)this.getType().cast(o);
            if (!Objects.equals(this.underlyingEquity, _that.getUnderlyingEquity())) {
                return false;
            }
            return Objects.equals(this.redemptionDate, _that.getRedemptionDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.underlyingEquity != null ? this.underlyingEquity.hashCode() : 0);
            _result = 31 * _result + (this.redemptionDate != null ? this.redemptionDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ConvertibleBondBuilder {underlyingEquity=" + String.valueOf(this.underlyingEquity) + ", redemptionDate=" + String.valueOf(this.redemptionDate) + "} " + super.toString();
        }
    }

    public static interface ConvertibleBondBuilder
    extends ConvertibleBond,
    Bond.BondBuilder {
        public EquityAsset.EquityAssetBuilder getOrCreateUnderlyingEquity();

        @Override
        public EquityAsset.EquityAssetBuilder getUnderlyingEquity();

        @Override
        public ConvertibleBondBuilder setId(String var1);

        @Override
        public ConvertibleBondBuilder addInstrumentId(InstrumentId var1);

        @Override
        public ConvertibleBondBuilder addInstrumentId(InstrumentId var1, int var2);

        @Override
        public ConvertibleBondBuilder addInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public ConvertibleBondBuilder setInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public ConvertibleBondBuilder addInstrumentType(InstrumentType var1);

        @Override
        public ConvertibleBondBuilder addInstrumentType(InstrumentType var1, int var2);

        @Override
        public ConvertibleBondBuilder addInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public ConvertibleBondBuilder setInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public ConvertibleBondBuilder setDescription(String var1);

        @Override
        public ConvertibleBondBuilder setCurrency(IdentifiedCurrency var1);

        @Override
        public ConvertibleBondBuilder setExchangeId(ExchangeId var1);

        @Override
        public ConvertibleBondBuilder setClearanceSystem(ClearanceSystem var1);

        @Override
        public ConvertibleBondBuilder setDefinition(ProductReference var1);

        @Override
        public ConvertibleBondBuilder setFixedIncomeSecurityContentModel(FixedIncomeSecurityContentModel var1);

        @Override
        public ConvertibleBondBuilder setParValue(BigDecimal var1);

        @Override
        public ConvertibleBondBuilder setFaceAmount(BigDecimal var1);

        @Override
        public ConvertibleBondBuilder setBondCalculationModel(BondCalculationModel var1);

        public ConvertibleBondBuilder setUnderlyingEquity(EquityAsset var1);

        public ConvertibleBondBuilder setRedemptionDate(ZonedDateTime var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.InstrumentTypeBuilder.class, this.getInstrumentType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.IdentifiedCurrencyBuilder.class, (RosettaModelObjectBuilder)this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.ExchangeIdBuilder.class, (RosettaModelObjectBuilder)this.getExchangeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.ClearanceSystemBuilder.class, (RosettaModelObjectBuilder)this.getClearanceSystem(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("definition"), processor, ProductReference.ProductReferenceBuilder.class, (RosettaModelObjectBuilder)this.getDefinition(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixedIncomeSecurityContentModel"), processor, FixedIncomeSecurityContentModel.FixedIncomeSecurityContentModelBuilder.class, (RosettaModelObjectBuilder)this.getFixedIncomeSecurityContentModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("parValue"), BigDecimal.class, (Object)this.getParValue(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("faceAmount"), BigDecimal.class, (Object)this.getFaceAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("bondCalculationModel"), processor, BondCalculationModel.BondCalculationModelBuilder.class, (RosettaModelObjectBuilder)this.getBondCalculationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyingEquity"), processor, EquityAsset.EquityAssetBuilder.class, this.getUnderlyingEquity(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("redemptionDate"), ZonedDateTime.class, (Object)this.getRedemptionDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public ConvertibleBondBuilder prune();
    }

    public static class ConvertibleBondImpl
    extends Bond.BondImpl
    implements ConvertibleBond {
        private final EquityAsset underlyingEquity;
        private final ZonedDateTime redemptionDate;

        protected ConvertibleBondImpl(ConvertibleBondBuilder builder) {
            super(builder);
            this.underlyingEquity = Optional.ofNullable(builder.getUnderlyingEquity()).map(f -> f.build()).orElse(null);
            this.redemptionDate = builder.getRedemptionDate();
        }

        @Override
        @RosettaAttribute(value="underlyingEquity")
        @RuneAttribute(value="underlyingEquity")
        public EquityAsset getUnderlyingEquity() {
            return this.underlyingEquity;
        }

        @Override
        @RosettaAttribute(value="redemptionDate")
        @RuneAttribute(value="redemptionDate")
        public ZonedDateTime getRedemptionDate() {
            return this.redemptionDate;
        }

        @Override
        public ConvertibleBond build() {
            return this;
        }

        @Override
        public ConvertibleBondBuilder toBuilder() {
            ConvertibleBondBuilder builder = ConvertibleBond.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ConvertibleBondBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getUnderlyingEquity()).ifPresent(builder::setUnderlyingEquity);
            Optional.ofNullable(this.getRedemptionDate()).ifPresent(builder::setRedemptionDate);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ConvertibleBond _that = (ConvertibleBond)this.getType().cast(o);
            if (!Objects.equals(this.underlyingEquity, _that.getUnderlyingEquity())) {
                return false;
            }
            return Objects.equals(this.redemptionDate, _that.getRedemptionDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.underlyingEquity != null ? this.underlyingEquity.hashCode() : 0);
            _result = 31 * _result + (this.redemptionDate != null ? this.redemptionDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ConvertibleBond {underlyingEquity=" + String.valueOf(this.underlyingEquity) + ", redemptionDate=" + String.valueOf(this.redemptionDate) + "} " + super.toString();
        }
    }
}

