/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.TransformTypeChoice;
import fpml.consolidated.meta.TransformTypeMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="TransformType", builder=TransformTypeBuilderImpl.class, version="1.2.2")
@RuneDataType(value="TransformType", model="fpml", builder=TransformTypeBuilderImpl.class, version="1.2.2")
public interface TransformType
extends RosettaModelObject {
    public static final TransformTypeMeta metaData = new TransformTypeMeta();

    public List<? extends TransformTypeChoice> getTransformTypeChoice();

    public String getAlgorithm();

    public TransformType build();

    public TransformTypeBuilder toBuilder();

    public static TransformTypeBuilder builder() {
        return new TransformTypeBuilderImpl();
    }

    default public RosettaMetaData<? extends TransformType> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TransformType> getType() {
        return TransformType.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("transformTypeChoice"), processor, TransformTypeChoice.class, this.getTransformTypeChoice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("algorithm"), String.class, (Object)this.getAlgorithm(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class TransformTypeBuilderImpl
    implements TransformTypeBuilder {
        protected List<TransformTypeChoice.TransformTypeChoiceBuilder> transformTypeChoice = new ArrayList<TransformTypeChoice.TransformTypeChoiceBuilder>();
        protected String algorithm;

        @Override
        @RosettaAttribute(value="transformTypeChoice")
        @RuneAttribute(value="transformTypeChoice")
        public List<? extends TransformTypeChoice.TransformTypeChoiceBuilder> getTransformTypeChoice() {
            return this.transformTypeChoice;
        }

        @Override
        public TransformTypeChoice.TransformTypeChoiceBuilder getOrCreateTransformTypeChoice(int index) {
            if (this.transformTypeChoice == null) {
                this.transformTypeChoice = new ArrayList<TransformTypeChoice.TransformTypeChoiceBuilder>();
            }
            return (TransformTypeChoice.TransformTypeChoiceBuilder)this.getIndex(this.transformTypeChoice, index, () -> {
                TransformTypeChoice.TransformTypeChoiceBuilder newTransformTypeChoice = TransformTypeChoice.builder();
                return newTransformTypeChoice;
            });
        }

        @Override
        @RosettaAttribute(value="algorithm", isRequired=true)
        @RuneAttribute(value="algorithm", isRequired=true)
        public String getAlgorithm() {
            return this.algorithm;
        }

        @Override
        @RosettaAttribute(value="transformTypeChoice")
        @RuneAttribute(value="transformTypeChoice")
        public TransformTypeBuilder addTransformTypeChoice(TransformTypeChoice _transformTypeChoice) {
            if (_transformTypeChoice != null) {
                this.transformTypeChoice.add(_transformTypeChoice.toBuilder());
            }
            return this;
        }

        @Override
        public TransformTypeBuilder addTransformTypeChoice(TransformTypeChoice _transformTypeChoice, int idx) {
            this.getIndex(this.transformTypeChoice, idx, () -> _transformTypeChoice.toBuilder());
            return this;
        }

        @Override
        public TransformTypeBuilder addTransformTypeChoice(List<? extends TransformTypeChoice> transformTypeChoices) {
            if (transformTypeChoices != null) {
                for (TransformTypeChoice transformTypeChoice : transformTypeChoices) {
                    this.transformTypeChoice.add(transformTypeChoice.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="transformTypeChoice")
        public TransformTypeBuilder setTransformTypeChoice(List<? extends TransformTypeChoice> transformTypeChoices) {
            this.transformTypeChoice = transformTypeChoices == null ? new ArrayList<TransformTypeChoice.TransformTypeChoiceBuilder>() : (List)transformTypeChoices.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="algorithm", isRequired=true)
        @RuneAttribute(value="algorithm", isRequired=true)
        public TransformTypeBuilder setAlgorithm(String _algorithm) {
            this.algorithm = _algorithm == null ? null : _algorithm;
            return this;
        }

        @Override
        public TransformType build() {
            return new TransformTypeImpl(this);
        }

        @Override
        public TransformTypeBuilder toBuilder() {
            return this;
        }

        @Override
        public TransformTypeBuilder prune() {
            this.transformTypeChoice = this.transformTypeChoice.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getTransformTypeChoice() != null && this.getTransformTypeChoice().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getAlgorithm() != null;
        }

        public TransformTypeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TransformTypeBuilder o = (TransformTypeBuilder)other;
            merger.mergeRosetta(this.getTransformTypeChoice(), o.getTransformTypeChoice(), this::getOrCreateTransformTypeChoice);
            merger.mergeBasic((Object)this.getAlgorithm(), (Object)o.getAlgorithm(), this::setAlgorithm, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TransformType _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.transformTypeChoice, _that.getTransformTypeChoice())) {
                return false;
            }
            return Objects.equals(this.algorithm, _that.getAlgorithm());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.transformTypeChoice != null ? this.transformTypeChoice.hashCode() : 0);
            _result = 31 * _result + (this.algorithm != null ? this.algorithm.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TransformTypeBuilder {transformTypeChoice=" + String.valueOf(this.transformTypeChoice) + ", algorithm=" + this.algorithm + "}";
        }
    }

    public static interface TransformTypeBuilder
    extends TransformType,
    RosettaModelObjectBuilder {
        public TransformTypeChoice.TransformTypeChoiceBuilder getOrCreateTransformTypeChoice(int var1);

        public List<? extends TransformTypeChoice.TransformTypeChoiceBuilder> getTransformTypeChoice();

        public TransformTypeBuilder addTransformTypeChoice(TransformTypeChoice var1);

        public TransformTypeBuilder addTransformTypeChoice(TransformTypeChoice var1, int var2);

        public TransformTypeBuilder addTransformTypeChoice(List<? extends TransformTypeChoice> var1);

        public TransformTypeBuilder setTransformTypeChoice(List<? extends TransformTypeChoice> var1);

        public TransformTypeBuilder setAlgorithm(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("transformTypeChoice"), processor, TransformTypeChoice.TransformTypeChoiceBuilder.class, this.getTransformTypeChoice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("algorithm"), String.class, (Object)this.getAlgorithm(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public TransformTypeBuilder prune();
    }

    public static class TransformTypeImpl
    implements TransformType {
        private final List<? extends TransformTypeChoice> transformTypeChoice;
        private final String algorithm;

        protected TransformTypeImpl(TransformTypeBuilder builder) {
            this.transformTypeChoice = Optional.ofNullable(builder.getTransformTypeChoice()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.algorithm = builder.getAlgorithm();
        }

        @Override
        @RosettaAttribute(value="transformTypeChoice")
        @RuneAttribute(value="transformTypeChoice")
        public List<? extends TransformTypeChoice> getTransformTypeChoice() {
            return this.transformTypeChoice;
        }

        @Override
        @RosettaAttribute(value="algorithm", isRequired=true)
        @RuneAttribute(value="algorithm", isRequired=true)
        public String getAlgorithm() {
            return this.algorithm;
        }

        @Override
        public TransformType build() {
            return this;
        }

        @Override
        public TransformTypeBuilder toBuilder() {
            TransformTypeBuilder builder = TransformType.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TransformTypeBuilder builder) {
            Optional.ofNullable(this.getTransformTypeChoice()).ifPresent(builder::setTransformTypeChoice);
            Optional.ofNullable(this.getAlgorithm()).ifPresent(builder::setAlgorithm);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TransformType _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.transformTypeChoice, _that.getTransformTypeChoice())) {
                return false;
            }
            return Objects.equals(this.algorithm, _that.getAlgorithm());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.transformTypeChoice != null ? this.transformTypeChoice.hashCode() : 0);
            _result = 31 * _result + (this.algorithm != null ? this.algorithm.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TransformType {transformTypeChoice=" + String.valueOf(this.transformTypeChoice) + ", algorithm=" + this.algorithm + "}";
        }
    }
}

