/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.maven;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.regnosys.rosetta.maven.AbstractRosettaGeneratorMojo;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.xtext.maven.Language;

@Mojo(name="testGenerate", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class RosettaTestGenerateMojo
extends AbstractRosettaGeneratorMojo {
    @Parameter(defaultValue="${project.testClasspathElements}", readonly=true, required=true)
    private List<String> classpathElements;
    @Parameter(defaultValue="${project.testCompileSourceRoots}", required=true)
    private List<String> sourceRoots;

    public Set<String> getClasspathElements() {
        LinkedHashSet classpathElementSet = Sets.newLinkedHashSet();
        classpathElementSet.addAll(this.classpathElements);
        classpathElementSet.remove(this.getProject().getBuild().getTestOutputDirectory());
        return Sets.newLinkedHashSet((Iterable)Iterables.filter((Iterable)classpathElementSet, (Predicate)this.emptyStringFilter()));
    }

    protected void configureMavenOutputs() {
        for (Language language : this.getLanguages()) {
            this.addTestCompileSourceRoots(language);
        }
    }

    protected String tmpDirSuffix() {
        return "-test";
    }

    protected List<String> getSourceRoots() {
        return this.sourceRoots;
    }
}

