/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.maven;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.regnosys.rosetta.generator.RosettaGenerator;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Provider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.builder.standalone.LanguageAccess;
import org.eclipse.xtext.builder.standalone.StandaloneBuilder;
import org.eclipse.xtext.common.types.access.impl.IndexedJvmTypeAccess;
import org.eclipse.xtext.generator.GeneratorContext;
import org.eclipse.xtext.generator.GeneratorDelegate;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.clustering.DisabledClusteringPolicy;
import org.eclipse.xtext.resource.clustering.DynamicResourceClusteringPolicy;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RosettaStandaloneBuilder
extends StandaloneBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(RosettaStandaloneBuilder.class);
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    private IndexedJvmTypeAccess jvmTypeAccess;
    private LanguageAccess rosettaLanguageAccess = null;
    private RosettaGenerator rosettaGenerator = null;
    private boolean needsBeforeAllCall = false;
    private ResourceSet currentResourceSet;
    private JavaIoFileSystemAccess currentFileSystemAccess;

    private LanguageAccess getRosettaLanguageAccess() {
        if (this.rosettaLanguageAccess == null) {
            Map languages;
            try {
                Field f = StandaloneBuilder.class.getDeclaredField("languages");
                f.setAccessible(true);
                languages = (Map)f.get((Object)this);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new RuntimeException(e);
            }
            this.rosettaLanguageAccess = (LanguageAccess)languages.get("rosetta");
        }
        return this.rosettaLanguageAccess;
    }

    private RosettaGenerator getRosettaGenerator() {
        if (this.rosettaGenerator == null) {
            LanguageAccess access = this.getRosettaLanguageAccess();
            GeneratorDelegate delegate = access.getGenerator();
            try {
                Field f = GeneratorDelegate.class.getDeclaredField("generator");
                f.setAccessible(true);
                this.rosettaGenerator = (RosettaGenerator)f.get(delegate);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
        return this.rosettaGenerator;
    }

    public boolean launch() {
        this.needsBeforeAllCall = true;
        boolean needsJava = IterableExtensions.exists(this.getLanguages().values(), l -> l.isLinksAgainstJava());
        if (this.getBaseDir() == null) {
            this.setBaseDir(System.getProperty("user.dir"));
            LOG.warn("Property baseDir not set. Using '" + this.getBaseDir() + "'");
        }
        if (needsJava) {
            LOG.info("Using common types.");
        }
        XtextResourceSet resourceSet = (XtextResourceSet)this.resourceSetProvider.get();
        if (this.getEncoding() != null) {
            this.forceDebugLog("Setting encoding.");
            this.fileEncodingSetup(this.getLanguages().values(), this.getEncoding());
        }
        LOG.info("Collecting source models.");
        long startedAt = System.currentTimeMillis();
        Iterable rootsToTravers = this.getClassPathEntries();
        if (this.getClassPathLookUpFilter() != null) {
            LOG.info("Class path look up filter is active.");
            Pattern cpLookUpFilter = Pattern.compile(this.getClassPathLookUpFilter());
            rootsToTravers = Iterables.filter((Iterable)this.getClassPathEntries(), root -> cpLookUpFilter.matcher((CharSequence)root).matches());
            LOG.info("Investigating " + Iterables.size((Iterable)rootsToTravers) + " of " + Iterables.size((Iterable)this.getClassPathEntries()) + " class path entries.");
        }
        List sourceResourceURIs = this.collectResources(this.getSourceDirs(), (ResourceSet)resourceSet);
        Iterable allResourcesURIs = Iterables.concat((Iterable)this.collectResources(rootsToTravers, (ResourceSet)resourceSet), (Iterable)sourceResourceURIs);
        this.forceDebugLog("Finished collecting source models. Took: " + (System.currentTimeMillis() - startedAt) + " ms.");
        Iterable allClassPathEntries = Iterables.concat((Iterable)this.getSourceDirs(), (Iterable)this.getClassPathEntries());
        if (needsJava) {
            LOG.info("Installing type provider.");
            this.installTypeProvider(allClassPathEntries, resourceSet, null);
        }
        DisabledClusteringPolicy strategy = null;
        if (this.getClusteringConfig() != null) {
            LOG.info("Clustering configured.");
            DynamicResourceClusteringPolicy dynamicResourceClusteringPolicy = new DynamicResourceClusteringPolicy();
            dynamicResourceClusteringPolicy.setMinimumFreeMemory(this.getClusteringConfig().getMinimumFreeMemory() * 1024L * 1024L);
            dynamicResourceClusteringPolicy.setMinimumClusterSize(this.getClusteringConfig().getMinimumClusterSize());
            dynamicResourceClusteringPolicy.setMinimumPercentFreeMemory(this.getClusteringConfig().getMinimumPercentFreeMemory());
            strategy = dynamicResourceClusteringPolicy;
        } else {
            strategy = new DisabledClusteringPolicy();
        }
        ResourceDescriptionsData index = new ResourceDescriptionsData(new ArrayList());
        Iterator allResourceIterator = allResourcesURIs.iterator();
        while (allResourceIterator.hasNext()) {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            int clusterIndex = 0;
            boolean canContinue = true;
            while (allResourceIterator.hasNext() && canContinue) {
                URI uri = (URI)allResourceIterator.next();
                Resource resource = resourceSet.getResource(uri, true);
                resources.add(resource);
                this.fillIndex(uri, resource, index);
                if (strategy.continueProcessing((ResourceSet)resourceSet, null, ++clusterIndex)) continue;
                canContinue = false;
            }
            if (canContinue) continue;
            this.clearResourceSet((ResourceSet)resourceSet);
        }
        this.installIndex(resourceSet, index);
        if (needsJava) {
            String stubsClasses = this.compileStubs(this.generateStubs(index, sourceResourceURIs));
            LOG.info("Installing type provider for stubs.");
            this.installTypeProvider(Iterables.concat((Iterable)allClassPathEntries, (Iterable)Lists.newArrayList((Object[])new String[]{stubsClasses})), resourceSet, this.jvmTypeAccess);
        }
        LOG.info("Validate and generate.");
        Iterator sourceResourceIterator = sourceResourceURIs.iterator();
        boolean hasValidationErrors = false;
        while (sourceResourceIterator.hasNext()) {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            int clusterIndex = 0;
            boolean canContinue = true;
            while (sourceResourceIterator.hasNext() && canContinue) {
                URI uri = (URI)sourceResourceIterator.next();
                Resource resource = resourceSet.getResource(uri, true);
                resources.add(resource);
                resource.getContents();
                EcoreUtil2.resolveLazyCrossReferences((Resource)resource, (CancelIndicator)CancelIndicator.NullImpl);
                boolean bl = hasValidationErrors = !this.validate(resource) || hasValidationErrors;
                if (strategy.continueProcessing((ResourceSet)resourceSet, null, ++clusterIndex)) continue;
                canContinue = false;
            }
            if (this.isFailOnValidationError() && hasValidationErrors) {
                return !hasValidationErrors;
            }
            this.generate(resources);
            if (canContinue) continue;
            this.clearResourceSet((ResourceSet)resourceSet);
        }
        boolean success = !hasValidationErrors;
        LOG.info("Starting after all generation");
        GeneratorContext context = new GeneratorContext();
        context.setCancelIndicator(CancelIndicator.NullImpl);
        this.getRosettaGenerator().afterAllGenerate(this.currentResourceSet, (IFileSystemAccess2)this.currentFileSystemAccess, (IGeneratorContext)context);
        return success;
    }

    protected void generate(List<Resource> sourceResources) {
        if (this.needsBeforeAllCall) {
            LOG.info("Starting before all generation");
            this.currentResourceSet = sourceResources.get(0).getResourceSet();
            LanguageAccess access = this.getRosettaLanguageAccess();
            this.currentFileSystemAccess = this.getFileSystemAccess(access);
            GeneratorContext context = new GeneratorContext();
            context.setCancelIndicator(CancelIndicator.NullImpl);
            this.getRosettaGenerator().beforeAllGenerate(this.currentResourceSet, (IFileSystemAccess2)this.currentFileSystemAccess, (IGeneratorContext)context);
            this.needsBeforeAllCall = false;
        }
        super.generate(sourceResources);
    }

    private JavaIoFileSystemAccess getFileSystemAccess(LanguageAccess language) {
        try {
            Method m = StandaloneBuilder.class.getDeclaredMethod("getFileSystemAccess", LanguageAccess.class);
            m.setAccessible(true);
            return (JavaIoFileSystemAccess)m.invoke((Object)this, language);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

