/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.maven;

import com.google.inject.Injector;
import com.regnosys.rosetta.RosettaStandaloneSetup;
import com.regnosys.rosetta.formatting2.FormattingOptionsAdaptor;
import com.regnosys.rosetta.formatting2.ResourceFormatterService;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.lsp4j.FormattingOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="format")
public class ResourceFormatterMojo
extends AbstractMojo {
    private static Logger LOGGER = LoggerFactory.getLogger(ResourceFormatterMojo.class);
    @Parameter(property="path", required=true)
    private String path;
    @Parameter(property="formattingOptionsPath", required=false)
    private String formattingOptionsPath;
    @Inject
    private FormattingOptionsAdaptor formattingOptionsAdapter;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List resources;
        Path directory = Paths.get(this.path, new String[0]);
        LOGGER.info("Mojo running on path:" + directory.toString());
        FormattingOptions formattingOptions = null;
        try {
            formattingOptions = this.formattingOptionsAdapter.readFormattingOptions(this.formattingOptionsPath);
        }
        catch (IOException e) {
            LOGGER.error("Config file not found.", (Throwable)e);
        }
        Injector inj = new RosettaStandaloneSetup().createInjectorAndDoEMFRegistration();
        ResourceSet resourceSet = (ResourceSet)inj.getInstance(ResourceSet.class);
        ResourceFormatterService formatterService = (ResourceFormatterService)inj.getInstance(ResourceFormatterService.class);
        try {
            resources = Files.walk(directory, new FileVisitOption[0]).filter(path -> path.toString().endsWith(".rosetta")).map(file -> resourceSet.getResource(URI.createFileURI((String)file.toString()), true)).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new MojoFailureException("Error processing files: " + e.getMessage(), (Throwable)e);
        }
        formatterService.formatCollection(resources, this.formattingOptionsAdapter.createPreferences(formattingOptions), (resource, formattedText) -> {
            Path resourcePath = Path.of(resource.getURI().toFileString(), new String[0]);
            try {
                Files.writeString(resourcePath, (CharSequence)formattedText, new OpenOption[0]);
                LOGGER.info("Content written to file: " + resourcePath);
            }
            catch (IOException e) {
                LOGGER.error("Error writing to file.", (Throwable)e);
            }
        });
    }
}

