/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.validation.expression;

import com.regnosys.rosetta.interpreter.RosettaInterpreter;
import com.regnosys.rosetta.interpreter.RosettaValue;
import com.regnosys.rosetta.rosetta.RosettaEnumValue;
import com.regnosys.rosetta.rosetta.expression.ExpressionPackage;
import com.regnosys.rosetta.rosetta.expression.RosettaLiteral;
import com.regnosys.rosetta.rosetta.expression.SwitchCase;
import com.regnosys.rosetta.rosetta.expression.SwitchOperation;
import com.regnosys.rosetta.rosetta.simple.AssignPathRoot;
import com.regnosys.rosetta.rosetta.simple.ChoiceOption;
import com.regnosys.rosetta.types.RChoiceType;
import com.regnosys.rosetta.types.REnumType;
import com.regnosys.rosetta.types.RMetaAnnotatedType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.builtin.RBasicType;
import com.regnosys.rosetta.validation.expression.ExpressionValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class SwitchValidator
extends ExpressionValidator {
    @Inject
    private RosettaInterpreter interpreter;

    @Check
    public void checkSwitch(SwitchOperation op) {
        this.isSingleCheck(op.getArgument(), (EObject)op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT, op);
        RMetaAnnotatedType argumentType = this.typeProvider.getRMetaAnnotatedType(op.getArgument());
        RType rType = this.typeSystem.stripFromTypeAliases(argumentType.getRType());
        if (rType instanceof REnumType) {
            this.checkEnumSwitch((REnumType)rType, op);
        } else if (rType instanceof RBasicType) {
            this.checkBasicTypeSwitch((RBasicType)rType, op);
        } else if (rType instanceof RChoiceType) {
            this.checkChoiceSwitch((RChoiceType)rType, op);
        } else {
            this.unsupportedTypeError(argumentType, op.getOperator(), op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT, "Supported argument types are basic types, enumerations, and choice types");
        }
    }

    private void checkEnumSwitch(REnumType argumentType, SwitchOperation op) {
        HashSet<RosettaEnumValue> seenValues = new HashSet<RosettaEnumValue>();
        for (SwitchCase caseStatement : op.getCases()) {
            RosettaEnumValue guard = caseStatement.getGuard().getEnumGuard();
            if (guard == null) {
                this.error("Case should match an enum value of " + argumentType, caseStatement, (EStructuralFeature)ExpressionPackage.Literals.SWITCH_CASE__GUARD);
                continue;
            }
            if (seenValues.add(guard)) continue;
            this.error("Duplicate case " + guard.getName(), caseStatement, (EStructuralFeature)ExpressionPackage.Literals.SWITCH_CASE__GUARD);
        }
        if (op.getDefault() == null) {
            ArrayList<RosettaEnumValue> missingEnumValues = new ArrayList<RosettaEnumValue>(argumentType.getAllEnumValues());
            missingEnumValues.removeAll(seenValues);
            if (!missingEnumValues.isEmpty()) {
                String missingValuesMsg = missingEnumValues.stream().map(v -> v.getName()).collect(Collectors.joining(", "));
                this.error("Missing the following cases: " + missingValuesMsg + ". Either provide all or add a default.", op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR);
            }
        }
    }

    private void checkBasicTypeSwitch(RBasicType argumentType, SwitchOperation op) {
        HashSet<RosettaValue> seenValues = new HashSet<RosettaValue>();
        RMetaAnnotatedType argumentTypeWithoutMeta = RMetaAnnotatedType.withNoMeta(argumentType);
        for (SwitchCase caseStatement : op.getCases()) {
            RMetaAnnotatedType conditionType;
            RosettaLiteral guard = caseStatement.getGuard().getLiteralGuard();
            if (guard == null) {
                this.error("Case should match a literal of type " + argumentType, caseStatement, (EStructuralFeature)ExpressionPackage.Literals.SWITCH_CASE__GUARD);
                continue;
            }
            if (!seenValues.add(this.interpreter.interpret(guard))) {
                this.error("Duplicate case", caseStatement, (EStructuralFeature)ExpressionPackage.Literals.SWITCH_CASE__GUARD);
            }
            if (this.typeSystem.isComparable(conditionType = this.typeProvider.getRMetaAnnotatedType(guard), argumentTypeWithoutMeta)) continue;
            this.error("Invalid case: " + this.notComparableMessage(conditionType, argumentTypeWithoutMeta), caseStatement, (EStructuralFeature)ExpressionPackage.Literals.SWITCH_CASE__GUARD);
        }
    }

    private void checkChoiceSwitch(RChoiceType argumentType, SwitchOperation op) {
        HashMap<ChoiceOption, RMetaAnnotatedType> includedOptions = new HashMap<ChoiceOption, RMetaAnnotatedType>();
        for (Object caseStatement : op.getCases()) {
            Object guard = caseStatement.getGuard().getChoiceOptionGuard();
            if (guard == null) {
                this.error("Case should match a choice option of type " + argumentType, (EObject)caseStatement, (EStructuralFeature)ExpressionPackage.Literals.SWITCH_CASE__GUARD);
                continue;
            }
            RMetaAnnotatedType alreadyCovered = (RMetaAnnotatedType)includedOptions.get(guard);
            if (alreadyCovered != null) {
                this.error("Case already covered by " + alreadyCovered, (EObject)caseStatement, (EStructuralFeature)ExpressionPackage.Literals.SWITCH_CASE__GUARD);
                continue;
            }
            RMetaAnnotatedType guardType = this.typeProvider.getRTypeOfSymbol((AssignPathRoot)guard);
            includedOptions.put((ChoiceOption)guard, guardType);
            RType valueType = guardType.getRType();
            if (!(valueType instanceof RChoiceType)) continue;
            ((RChoiceType)valueType).getAllOptions().forEach(it -> includedOptions.put(it.getEObject(), guardType));
        }
        if (op.getDefault() == null) {
            ArrayList missingOptions = new ArrayList();
            argumentType.getOwnOptions().forEach(opt -> missingOptions.add(opt.getType()));
            for (Object guard : new LinkedHashSet(includedOptions.values())) {
                for (int i = 0; i < missingOptions.size(); ++i) {
                    RMetaAnnotatedType opt2 = (RMetaAnnotatedType)missingOptions.get(i);
                    RType optValueType = opt2.getRType();
                    if (this.typeSystem.isSubtypeOf(opt2, (RMetaAnnotatedType)guard, false)) {
                        missingOptions.remove(i);
                        --i;
                        continue;
                    }
                    if (!(optValueType instanceof RChoiceType) || !this.typeSystem.isSubtypeOf((RMetaAnnotatedType)guard, opt2, false)) continue;
                    missingOptions.remove(i);
                    --i;
                    ((RChoiceType)optValueType).getOwnOptions().forEach(o -> missingOptions.add(o.getType()));
                }
            }
            if (!missingOptions.isEmpty()) {
                String missingOptsMsg = missingOptions.stream().map(opt -> opt.toString()).collect(Collectors.joining(", "));
                this.error("Missing the following cases: " + missingOptsMsg + ". Either provide all or add a default.", op, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR);
            }
        }
    }
}

