/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.validation.expression;

import com.regnosys.rosetta.rosetta.expression.RosettaBinaryOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaOperation;
import com.regnosys.rosetta.types.CardinalityProvider;
import com.regnosys.rosetta.types.RMetaAnnotatedType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.regnosys.rosetta.types.TypeSystem;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.validation.AbstractDeclarativeRosettaValidator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class AbstractExpressionValidator
extends AbstractDeclarativeRosettaValidator {
    @Inject
    protected RosettaTypeProvider typeProvider;
    @Inject
    protected TypeSystem typeSystem;
    @Inject
    protected RBuiltinTypeService builtins;
    @Inject
    protected CardinalityProvider cardinalityProvider;

    protected String relevantTypeDescription(RMetaAnnotatedType type, RMetaAnnotatedType context) {
        String prepend;
        RType valueType = type.getRType();
        RType valueContext = context.getRType();
        String string = prepend = valueType.getName().equals(valueContext.getName()) ? valueType.getNamespace() + "." : "";
        if (valueType.equals(valueContext)) {
            return prepend + type.toString();
        }
        if (valueType.getName().equals(valueContext.getName())) {
            return prepend + valueType.toString();
        }
        return prepend + valueType.getName();
    }

    protected String notASubtypeMessage(RMetaAnnotatedType expected, RMetaAnnotatedType actual, Function<String, String> suggestion) {
        String actualDescr = this.relevantTypeDescription(actual, expected);
        StringBuilder msg = new StringBuilder().append("Expected type `").append(this.relevantTypeDescription(expected, actual)).append("`, but got `").append(actualDescr).append("` instead");
        if (suggestion != null) {
            msg.append(". ");
            msg.append(suggestion.apply(actualDescr));
        }
        return msg.toString();
    }

    private Function<String, String> defaultSubtypeSuggestion(RosettaOperation op) {
        return actual -> "Cannot use `" + actual + "` with operator `" + op.getOperator() + "`";
    }

    protected boolean subtypeCheck(RMetaAnnotatedType expected, RosettaExpression expr, EObject sourceObject, EStructuralFeature feature, RosettaOperation op) {
        return this.subtypeCheck(expected, this.typeProvider.getRMetaAnnotatedType(expr), sourceObject, feature, -1, this.defaultSubtypeSuggestion(op));
    }

    protected boolean subtypeCheck(RMetaAnnotatedType expected, RosettaExpression expr, EObject sourceObject, EStructuralFeature feature, Function<String, String> suggestion) {
        return this.subtypeCheck(expected, this.typeProvider.getRMetaAnnotatedType(expr), sourceObject, feature, -1, suggestion);
    }

    protected boolean subtypeCheck(RMetaAnnotatedType expected, RosettaExpression expr, EObject sourceObject, EStructuralFeature feature, int featureIndex, Function<String, String> suggestion) {
        return this.subtypeCheck(expected, this.typeProvider.getRMetaAnnotatedType(expr), sourceObject, feature, featureIndex, suggestion);
    }

    protected boolean subtypeCheck(RMetaAnnotatedType expected, RMetaAnnotatedType actual, EObject sourceObject, EStructuralFeature feature, RosettaOperation op) {
        return this.subtypeCheck(expected, actual, sourceObject, feature, -1, this.defaultSubtypeSuggestion(op));
    }

    protected boolean subtypeCheck(RMetaAnnotatedType expected, RMetaAnnotatedType actual, EObject sourceObject, EStructuralFeature feature, Function<String, String> suggestion) {
        return this.subtypeCheck(expected, actual, sourceObject, feature, -1, suggestion);
    }

    protected boolean subtypeCheck(RMetaAnnotatedType expected, RMetaAnnotatedType actual, EObject sourceObject, EStructuralFeature feature, int featureIndex, Function<String, String> suggestion) {
        if (!this.typeSystem.isSubtypeOf(actual, expected)) {
            this.error(this.notASubtypeMessage(expected, actual, suggestion), sourceObject, feature, featureIndex);
            return false;
        }
        return true;
    }

    protected String notComparableMessage(RMetaAnnotatedType left, RMetaAnnotatedType right) {
        return "Types `" + this.relevantTypeDescription(left, right) + "` and `" + this.relevantTypeDescription(right, left) + "` are not comparable";
    }

    protected boolean comparableTypeCheck(RosettaBinaryOperation sourceObject) {
        RMetaAnnotatedType tr;
        RMetaAnnotatedType tl = this.typeProvider.getRMetaAnnotatedType(sourceObject.getLeft());
        if (!this.typeSystem.isComparable(tl, tr = this.typeProvider.getRMetaAnnotatedType(sourceObject.getRight()))) {
            this.error(this.notComparableMessage(tl, tr), sourceObject, null);
            return false;
        }
        return true;
    }

    protected boolean isMultiCheck(RosettaExpression expr, EObject sourceObject, EStructuralFeature feature, RosettaOperation op) {
        String suggestion = "The `" + op.getOperator() + "` operator requires a multi cardinality input";
        return this.isMultiCheck(expr, sourceObject, feature, -1, suggestion);
    }

    protected boolean isMultiCheck(RosettaExpression expr, EObject sourceObject, EStructuralFeature feature, String suggestion) {
        return this.isMultiCheck(expr, sourceObject, feature, -1, suggestion);
    }

    protected boolean isMultiCheck(RosettaExpression expr, EObject sourceObject, EStructuralFeature feature, int featureIndex, String suggestion) {
        if (!this.cardinalityProvider.isMulti(expr)) {
            Object msg = "Expecting multi cardinality";
            if (suggestion != null) {
                msg = (String)msg + ". " + suggestion;
            }
            this.warning((String)msg, sourceObject, feature, featureIndex);
            return false;
        }
        return true;
    }

    protected boolean isSingleCheck(RosettaExpression expr, EObject sourceObject, EStructuralFeature feature, RosettaOperation op) {
        String suggestion = "The `" + op.getOperator() + "` operator requires a single cardinality input";
        return this.isSingleCheck(expr, sourceObject, feature, -1, suggestion);
    }

    protected boolean isSingleCheck(RosettaExpression expr, EObject sourceObject, EStructuralFeature feature, String suggestion) {
        return this.isSingleCheck(expr, sourceObject, feature, -1, suggestion);
    }

    protected boolean isSingleCheck(RosettaExpression expr, EObject sourceObject, EStructuralFeature feature, int featureIndex, String suggestion) {
        if (this.cardinalityProvider.isMulti(expr)) {
            Object msg = "Expecting single cardinality";
            if (suggestion != null) {
                msg = (String)msg + ". " + suggestion;
            }
            this.warning((String)msg, sourceObject, feature, featureIndex);
            return false;
        }
        return true;
    }

    protected boolean commonTypeCheck(RosettaExpression expr1, RosettaExpression expr2, EObject sourceObject, EStructuralFeature feature) {
        if (expr1 == null || expr2 == null) {
            return true;
        }
        return this.commonTypeCheck(List.of(expr1, expr2), sourceObject, feature);
    }

    protected boolean commonTypeCheck(List<RosettaExpression> expressions, EObject sourceObject, EStructuralFeature feature) {
        boolean haveCommonType = true;
        if (!expressions.isEmpty()) {
            LinkedHashSet<RMetaAnnotatedType> types = new LinkedHashSet<RMetaAnnotatedType>();
            RMetaAnnotatedType firstElemType = this.typeProvider.getRMetaAnnotatedType(expressions.get(0));
            types.add(firstElemType);
            RMetaAnnotatedType commonType = firstElemType;
            for (int i = 1; i < expressions.size(); ++i) {
                RMetaAnnotatedType elemType = this.typeProvider.getRMetaAnnotatedType(expressions.get(i));
                RMetaAnnotatedType newCommonType = this.typeSystem.joinMetaAnnotatedTypes(commonType, elemType);
                if (this.typeSystem.isSubtypeOf(this.builtins.ANY_WITH_NO_META, newCommonType)) {
                    this.error("Types " + types.stream().map(t -> "`" + this.relevantTypeDescription((RMetaAnnotatedType)t, elemType) + "`").collect(Collectors.joining(", ")) + " and `" + this.relevantTypeDescription(elemType, newCommonType) + "` do not have a common supertype", sourceObject, feature, feature == null || !feature.isMany() ? -1 : i);
                    haveCommonType = false;
                    continue;
                }
                types.add(elemType);
                commonType = newCommonType;
            }
        }
        return haveCommonType;
    }

    protected void unsupportedTypeError(RMetaAnnotatedType type, RosettaOperation op, EStructuralFeature feature, RType supportedType1, RType supportedType2, RType ... moreSupportedTypes) {
        StringBuilder supportedTypesMsg = new StringBuilder();
        supportedTypesMsg.append("Supported types are ");
        supportedTypesMsg.append(supportedType1);
        if (moreSupportedTypes.length > 0) {
            supportedTypesMsg.append(", ");
            supportedTypesMsg.append(supportedType2);
            for (int i = 0; i < moreSupportedTypes.length - 1; ++i) {
                supportedTypesMsg.append(", ");
                supportedTypesMsg.append(moreSupportedTypes[i]);
            }
            supportedTypesMsg.append(" and ");
            supportedTypesMsg.append(moreSupportedTypes[moreSupportedTypes.length - 1]);
        } else {
            supportedTypesMsg.append(" and ");
            supportedTypesMsg.append(supportedType2);
        }
        this.unsupportedTypeError(type, op.getOperator(), op, feature, supportedTypesMsg.toString());
    }

    protected void unsupportedTypeError(RMetaAnnotatedType type, String operator, EObject sourceObject, EStructuralFeature feature, String supportedTypesMessage) {
        this.error("Operator `" + operator + "` is not supported for type " + type.getRType() + ". " + supportedTypesMessage, sourceObject, feature);
    }
}

