/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.validation;

import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.simple.Choice;
import com.regnosys.rosetta.rosetta.simple.ChoiceOption;
import com.regnosys.rosetta.types.RChoiceOption;
import com.regnosys.rosetta.types.RChoiceType;
import com.regnosys.rosetta.types.RMetaAnnotatedType;
import com.regnosys.rosetta.types.RObjectFactory;
import com.regnosys.rosetta.validation.AbstractDeclarativeRosettaValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class ChoiceValidator
extends AbstractDeclarativeRosettaValidator {
    @Inject
    private RObjectFactory rObjectFactory;

    @Check
    public void checkCyclicOptions(Choice choice) {
        for (ChoiceOption opt : choice.getOptions()) {
            if (!(opt.getTypeCall().getType() instanceof Choice)) continue;
            Choice choiceOpt = (Choice)opt.getTypeCall().getType();
            ArrayList<Choice> path = new ArrayList<Choice>();
            path.add(choice);
            HashSet<Choice> visited = new HashSet<Choice>();
            visited.add(choice);
            if (!this.hasCyclicOption(choiceOpt, path, visited)) continue;
            String pathString = path.stream().map(e -> e.getName()).collect(Collectors.joining(" includes "));
            this.error("Cyclic option: " + pathString, opt, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME);
        }
    }

    private boolean hasCyclicOption(Choice current, List<Choice> path, Set<Choice> visited) {
        path.add(current);
        if (visited.add(current)) {
            for (ChoiceOption opt : current.getOptions()) {
                Choice choiceOpt;
                if (!(opt.getTypeCall().getType() instanceof Choice) || !this.hasCyclicOption(choiceOpt = (Choice)opt.getTypeCall().getType(), path, visited)) continue;
                return true;
            }
        } else if (path.get(0).equals(path.get(path.size() - 1))) {
            return true;
        }
        path.remove(path.size() - 1);
        return false;
    }

    @Check
    public void checkChoiceOptionsDoNotOverlap(Choice choice) {
        RChoiceType t = this.rObjectFactory.buildRChoiceType(choice);
        HashMap<RMetaAnnotatedType, RChoiceOption> includedOptions = new HashMap<RMetaAnnotatedType, RChoiceOption>();
        for (RChoiceOption opt : t.getOwnOptions()) {
            if (!(opt.getType().getRType() instanceof RChoiceType)) continue;
            ((RChoiceType)opt.getType().getRType()).getAllOptions().forEach(o -> includedOptions.put(o.getType(), opt));
        }
        for (RChoiceOption opt : t.getOwnOptions()) {
            RChoiceOption alreadyIncluded = includedOptions.put(opt.getType(), opt);
            if (alreadyIncluded == null) continue;
            String msg = alreadyIncluded.getType().equals(opt.getType()) ? "Duplicate option '" + opt.getType() + "'" : "Option '" + opt.getType() + "' is already included by option '" + alreadyIncluded.getType() + "'";
            this.error(msg, opt.getEObject(), null);
        }
    }
}

