/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.utils;

import com.regnosys.rosetta.utils.Interval;
import com.regnosys.rosetta.utils.OptionalUtil;
import java.util.Optional;

public class IntegerInterval
extends Interval<Integer> {
    public IntegerInterval(Optional<Integer> min, Optional<Integer> max) {
        super(min, max);
    }

    public static IntegerInterval bounded(int min, int max) {
        return new IntegerInterval(Optional.of(min), Optional.of(max));
    }

    public static IntegerInterval boundedLeft(int min) {
        return new IntegerInterval(Optional.of(min), Optional.empty());
    }

    public static IntegerInterval boundedRight(int max) {
        return new IntegerInterval(Optional.empty(), Optional.of(max));
    }

    public static IntegerInterval unbounded() {
        return new IntegerInterval(Optional.empty(), Optional.empty());
    }

    public IntegerInterval minimalCover(IntegerInterval other) {
        return new IntegerInterval(OptionalUtil.zipWith(this.getMin(), other.getMin(), Math::min), OptionalUtil.zipWith(this.getMax(), other.getMax(), Math::max));
    }

    public IntegerInterval add(IntegerInterval other) {
        return new IntegerInterval(OptionalUtil.zipWith(this.getMin(), other.getMin(), (a, b) -> a + b), OptionalUtil.zipWith(this.getMax(), other.getMax(), (a, b) -> a + b));
    }

    public IntegerInterval subtract(IntegerInterval other) {
        return new IntegerInterval(OptionalUtil.zipWith(this.getMin(), other.getMin(), (a, b) -> a - b), OptionalUtil.zipWith(this.getMax(), other.getMax(), (a, b) -> a - b));
    }

    public IntegerInterval multiply(IntegerInterval other) {
        IntegerOrInfinite mina = IntegerInterval.withSignedInfinite(this.getMin(), false);
        IntegerOrInfinite maxa = IntegerInterval.withSignedInfinite(this.getMax(), true);
        IntegerOrInfinite minb = IntegerInterval.withSignedInfinite(other.getMin(), false);
        IntegerOrInfinite maxb = IntegerInterval.withSignedInfinite(other.getMax(), true);
        IntegerOrInfinite mult1 = mina.multiply(minb);
        IntegerOrInfinite mult2 = mina.multiply(maxb);
        IntegerOrInfinite mult3 = maxa.multiply(minb);
        IntegerOrInfinite mult4 = maxa.multiply(maxb);
        IntegerOrInfinite min = mult1.min(mult2).min(mult3).min(mult4);
        IntegerOrInfinite max = mult1.max(mult2).max(mult3).max(mult4);
        return new IntegerInterval(min.finiteValue, max.finiteValue);
    }

    private static IntegerOrInfinite withSignedInfinite(Optional<Integer> finiteValue, boolean defaultSign) {
        return finiteValue.map(v -> IntegerOrInfinite.of(v)).orElseGet(() -> IntegerOrInfinite.infinite(defaultSign));
    }

    private static class IntegerOrInfinite {
        private final Optional<Integer> finiteValue;
        private final boolean sign;

        private IntegerOrInfinite(Optional<Integer> finiteValue, boolean sign) {
            this.finiteValue = finiteValue;
            this.sign = sign;
        }

        public static IntegerOrInfinite of(int finiteValue) {
            return new IntegerOrInfinite(Optional.of(finiteValue), finiteValue >= 0);
        }

        public static IntegerOrInfinite infinite(boolean sign) {
            return new IntegerOrInfinite(Optional.empty(), sign);
        }

        public boolean isFinite() {
            return this.finiteValue.isPresent();
        }

        public IntegerOrInfinite multiply(IntegerOrInfinite other) {
            Optional<Integer> resultFiniteValue = OptionalUtil.zipWith(this.finiteValue, other.finiteValue, (a, b) -> a * b).or(() -> {
                if (this.isZero()) {
                    return this.finiteValue;
                }
                if (other.isZero()) {
                    return other.finiteValue;
                }
                return Optional.empty();
            });
            boolean resultSign = this.sign == other.sign;
            return new IntegerOrInfinite(resultFiniteValue, resultSign);
        }

        public boolean isZero() {
            return this.finiteValue.map(v -> v == 0).orElse(false);
        }

        public IntegerOrInfinite min(IntegerOrInfinite other) {
            Optional<Integer> resultFiniteValue = OptionalUtil.zipWith(this.finiteValue, other.finiteValue, Math::min).or(() -> {
                if (this.isFinite()) {
                    if (other.sign) {
                        return this.finiteValue;
                    }
                    return Optional.empty();
                }
                if (other.isFinite()) {
                    if (this.sign) {
                        return other.finiteValue;
                    }
                    return Optional.empty();
                }
                return Optional.empty();
            });
            boolean resultSign = this.sign && other.sign;
            return new IntegerOrInfinite(resultFiniteValue, resultSign);
        }

        public IntegerOrInfinite max(IntegerOrInfinite other) {
            Optional<Integer> resultFiniteValue = OptionalUtil.zipWith(this.finiteValue, other.finiteValue, Math::max).or(() -> {
                if (this.isFinite()) {
                    if (other.sign) {
                        return Optional.empty();
                    }
                    return this.finiteValue;
                }
                if (other.isFinite()) {
                    if (this.sign) {
                        return Optional.empty();
                    }
                    return other.finiteValue;
                }
                return Optional.empty();
            });
            boolean resultSign = this.sign || other.sign;
            return new IntegerOrInfinite(resultFiniteValue, resultSign);
        }
    }
}

