/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.utils;

import com.regnosys.rosetta.rosetta.expression.OneOfOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaImplicitVariable;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RCardinality;
import com.regnosys.rosetta.types.RChoiceType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DeepFeatureCallUtil {
    public Collection<RAttribute> findDeepFeatures(RDataType type) {
        return this.findDeepFeatureMap(type).values();
    }

    public Map<String, RAttribute> findDeepFeatureMap(RDataType type) {
        if (!this.isEligibleForDeepFeatureCall(type)) {
            return new HashMap<String, RAttribute>();
        }
        HashMap<String, RAttribute> deepIntersection = null;
        HashMap<String, RAttribute> result = new HashMap<String, RAttribute>();
        Collection<RAttribute> allAttributes = type.getAllAttributes();
        for (RAttribute attr : allAttributes) {
            result.put(attr.getName(), attr);
        }
        for (RAttribute attr : allAttributes) {
            HashMap<String, RAttribute> attrDeepFeatureMap;
            RType attrType = attr.getRMetaAnnotatedType().getRType();
            if (attrType instanceof RChoiceType) {
                attrType = ((RChoiceType)attrType).asRDataType();
            }
            if (attrType instanceof RDataType) {
                RDataType attrDataType = (RDataType)attrType;
                attrDeepFeatureMap = this.findDeepFeatureMap(attrDataType);
                for (RAttribute attrFeature : attrDataType.getAllAttributes()) {
                    attrDeepFeatureMap.put(attrFeature.getName(), attrFeature);
                }
            } else {
                attrDeepFeatureMap = new HashMap();
            }
            if (deepIntersection == null) {
                deepIntersection = attrDeepFeatureMap;
            } else {
                this.intersect(deepIntersection, attrDeepFeatureMap);
            }
            this.intersectButRetainAttribute(result, attrDeepFeatureMap, attr);
        }
        if (deepIntersection != null) {
            this.merge(result, deepIntersection);
        }
        return result;
    }

    private void intersect(Map<String, RAttribute> featuresMapToModify, Map<String, RAttribute> otherFeatureMap) {
        this.intersectButRetainAttribute(featuresMapToModify, otherFeatureMap, null);
    }

    private void intersectButRetainAttribute(Map<String, RAttribute> featuresMapToModify, Map<String, RAttribute> otherFeatureMap, RAttribute attributeToRetain) {
        featuresMapToModify.entrySet().removeIf(entry -> {
            String attrName = (String)entry.getKey();
            RAttribute attr = (RAttribute)entry.getValue();
            if (attr.equals(attributeToRetain)) {
                return false;
            }
            RAttribute otherAttr = (RAttribute)otherFeatureMap.get(attrName);
            return otherAttr == null || !this.match(attr, otherAttr);
        });
        for (Map.Entry<String, RAttribute> e : featuresMapToModify.entrySet()) {
            String name = e.getKey();
            RAttribute currFeature = e.getValue();
            RAttribute otherFeature = otherFeatureMap.get(name);
            if (otherFeature == null || !currFeature.getRMetaAnnotatedType().hasMeta() || otherFeature.getRMetaAnnotatedType().hasMeta()) continue;
            e.setValue(otherFeature);
        }
    }

    private void merge(Map<String, RAttribute> featuresMapToModify, Map<String, RAttribute> otherFeatureMap) {
        otherFeatureMap.forEach((name, attr) -> {
            RAttribute candidate = (RAttribute)featuresMapToModify.get(name);
            if (candidate != null) {
                if (!this.match(candidate, (RAttribute)attr)) {
                    featuresMapToModify.remove(name);
                } else if (candidate.getRMetaAnnotatedType().hasMeta() && !attr.getRMetaAnnotatedType().hasMeta()) {
                    featuresMapToModify.put((String)name, (RAttribute)attr);
                }
            } else {
                featuresMapToModify.put((String)name, (RAttribute)attr);
            }
        });
    }

    public boolean match(RAttribute a, RAttribute b) {
        if (!a.getRMetaAnnotatedType().getRType().equals(b.getRMetaAnnotatedType().getRType())) {
            return false;
        }
        return a.isMulti() == b.isMulti();
    }

    public boolean isEligibleForDeepFeatureCall(RDataType type) {
        Collection<RAttribute> allAttributes;
        Data data = type.getEObject();
        return data.getConditions().stream().anyMatch(cond -> this.isOneOfItem(cond.getExpression())) && (allAttributes = type.getAllAttributes()).stream().allMatch(a -> this.isSingularOptional(a.getCardinality())) && !allAttributes.isEmpty();
    }

    private boolean isOneOfItem(RosettaExpression expr) {
        return expr instanceof OneOfOperation && ((OneOfOperation)expr).getArgument() instanceof RosettaImplicitVariable;
    }

    private boolean isSingularOptional(RCardinality card) {
        return card.equals(RCardinality.OPTIONAL);
    }
}

