/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.types.builtin;

import com.regnosys.rosetta.interpreter.RosettaNumberValue;
import com.regnosys.rosetta.interpreter.RosettaValue;
import com.regnosys.rosetta.types.builtin.RBasicType;
import com.regnosys.rosetta.utils.BigDecimalInterval;
import com.regnosys.rosetta.utils.OptionalUtil;
import com.rosetta.model.lib.RosettaNumber;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.Validate;

public class RNumberType
extends RBasicType {
    public static final String DIGITS_PARAM_NAME = "digits";
    public static final String FRACTIONAL_DIGITS_PARAM_NAME = "fractionalDigits";
    public static final String MIN_PARAM_NAME = "min";
    public static final String MAX_PARAM_NAME = "max";
    public static final String SCALE_PARAM_NAME = "scale";
    private final Optional<Integer> digits;
    private final Optional<Integer> fractionalDigits;
    private final BigDecimalInterval interval;
    private final Optional<BigDecimal> scale;

    private static LinkedHashMap<String, RosettaValue> createArgumentMap(Optional<Integer> digits, Optional<Integer> fractionalDigits, BigDecimalInterval interval, Optional<BigDecimal> scale) {
        LinkedHashMap<String, RosettaValue> arguments = new LinkedHashMap<String, RosettaValue>();
        arguments.put(DIGITS_PARAM_NAME, digits.map(d -> RosettaNumberValue.of(RosettaNumber.valueOf((long)d.intValue()))).orElseGet(() -> RosettaValue.empty()));
        arguments.put(FRACTIONAL_DIGITS_PARAM_NAME, fractionalDigits.map(d -> RosettaNumberValue.of(RosettaNumber.valueOf((long)d.intValue()))).orElseGet(() -> RosettaValue.empty()));
        arguments.put(MIN_PARAM_NAME, interval.getMin().map(m -> RosettaNumberValue.of(RosettaNumber.valueOf((BigDecimal)m))).orElseGet(() -> RosettaValue.empty()));
        arguments.put(MAX_PARAM_NAME, interval.getMax().map(m -> RosettaNumberValue.of(RosettaNumber.valueOf((BigDecimal)m))).orElseGet(() -> RosettaValue.empty()));
        arguments.put(SCALE_PARAM_NAME, scale.map(s -> RosettaNumberValue.of(RosettaNumber.valueOf((BigDecimal)s))).orElseGet(() -> RosettaValue.empty()));
        return arguments;
    }

    public RNumberType(Optional<Integer> digits, Optional<Integer> fractionalDigits, BigDecimalInterval interval, Optional<BigDecimal> scale) {
        super("number", RNumberType.createArgumentMap(digits, fractionalDigits, interval, scale), true);
        if (digits.isPresent()) {
            Validate.isTrue((digits.get() > 0 ? 1 : 0) != 0);
        }
        if (fractionalDigits.isPresent()) {
            Validate.isTrue((fractionalDigits.get() >= 0 ? 1 : 0) != 0);
        }
        if (digits.isPresent() && fractionalDigits.isPresent()) {
            Validate.isTrue((fractionalDigits.get() < digits.get() ? 1 : 0) != 0);
        }
        this.digits = digits;
        this.fractionalDigits = fractionalDigits;
        this.interval = interval;
        this.scale = scale;
    }

    public RNumberType(Optional<Integer> digits, Optional<Integer> fractionalDigits, Optional<BigDecimal> min, Optional<BigDecimal> max, Optional<BigDecimal> scale) {
        this(digits, fractionalDigits, new BigDecimalInterval(min, max), scale);
    }

    public static RNumberType from(Map<String, RosettaValue> values) {
        return new RNumberType(values.getOrDefault(DIGITS_PARAM_NAME, RosettaValue.empty()).getSingle(RosettaNumber.class).map(n -> n.intValue()), values.getOrDefault(FRACTIONAL_DIGITS_PARAM_NAME, RosettaValue.empty()).getSingle(RosettaNumber.class).map(n -> n.intValue()), values.getOrDefault(MIN_PARAM_NAME, RosettaValue.empty()).getSingle(RosettaNumber.class).map(RosettaNumber::bigDecimalValue), values.getOrDefault(MAX_PARAM_NAME, RosettaValue.empty()).getSingle(RosettaNumber.class).map(RosettaNumber::bigDecimalValue), values.getOrDefault(SCALE_PARAM_NAME, RosettaValue.empty()).getSingle(RosettaNumber.class).map(RosettaNumber::bigDecimalValue));
    }

    public Optional<Integer> getDigits() {
        return this.digits;
    }

    public Optional<Integer> getFractionalDigits() {
        return this.fractionalDigits;
    }

    public BigDecimalInterval getInterval() {
        return this.interval;
    }

    public Optional<BigDecimal> getScale() {
        return this.scale;
    }

    public boolean isInteger() {
        return this.fractionalDigits.map(f -> f.equals(0)).orElse(false);
    }

    public RNumberType join(RNumberType other) {
        Optional<BigDecimal> joinedScale = this.scale.isPresent() ? (other.scale.isPresent() ? (this.scale.get().compareTo(other.scale.get()) == 0 ? this.scale : Optional.empty()) : this.scale) : other.scale;
        return new RNumberType(OptionalUtil.zipWith(this.digits, other.digits, Math::max), OptionalUtil.zipWith(this.fractionalDigits, other.fractionalDigits, Math::max), this.interval.minimalCover(other.interval), joinedScale);
    }
}

