/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.types;

import com.regnosys.rosetta.RosettaEcoreUtil;
import com.regnosys.rosetta.rosetta.RosettaCardinality;
import com.regnosys.rosetta.rosetta.RosettaDocReference;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaFactory;
import com.regnosys.rosetta.rosetta.RosettaReport;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.TypeCall;
import com.regnosys.rosetta.rosetta.expression.ExpressionFactory;
import com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference;
import com.regnosys.rosetta.rosetta.simple.AnnotationRef;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Choice;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.rosetta.simple.Operation;
import com.regnosys.rosetta.rosetta.simple.RosettaRuleReference;
import com.regnosys.rosetta.rosetta.simple.ShortcutDeclaration;
import com.regnosys.rosetta.rosetta.simple.SimpleFactory;
import com.regnosys.rosetta.types.CardinalityProvider;
import com.regnosys.rosetta.types.RAssignedRoot;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RCardinality;
import com.regnosys.rosetta.types.RChoiceType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.REnumType;
import com.regnosys.rosetta.types.RFunction;
import com.regnosys.rosetta.types.RFunctionOrigin;
import com.regnosys.rosetta.types.RMetaAnnotatedType;
import com.regnosys.rosetta.types.ROperation;
import com.regnosys.rosetta.types.ROperationType;
import com.regnosys.rosetta.types.RShortcut;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.regnosys.rosetta.types.TypeSystem;
import com.regnosys.rosetta.utils.ExternalAnnotationUtil;
import com.regnosys.rosetta.utils.ModelIdProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class RObjectFactory {
    @Inject
    private RosettaTypeProvider typeProvider;
    @Inject
    private CardinalityProvider cardinalityProvider;
    @Inject
    private TypeSystem typeSystem;
    @Inject
    private ModelIdProvider modelIdProvider;
    @Inject
    private ExternalAnnotationUtil externalAnnotationUtil;
    @Inject
    private RosettaEcoreUtil ecoreUtil;

    public RFunction buildRFunction(Function function) {
        return new RFunction(this.modelIdProvider.getSymbolId(function), function.getDefinition(), function.getInputs().stream().map(i -> this.buildRAttribute((Attribute)i)).collect(Collectors.toList()), this.buildRAttribute(function.getOutput()), RFunctionOrigin.FUNCTION, (List<Condition>)function.getConditions(), (List<Condition>)function.getPostConditions(), function.getShortcuts().stream().map(s -> this.buildRShortcut((ShortcutDeclaration)s)).collect(Collectors.toList()), function.getOperations().stream().map(o -> this.buildROperation((Operation)o)).collect(Collectors.toList()), (List<AnnotationRef>)function.getAnnotations());
    }

    private RAttribute createArtificialAttribute(String name, RType type, boolean isMulti) {
        RMetaAnnotatedType rAnnotatedType = RMetaAnnotatedType.withNoMeta(type);
        return new RAttribute(false, name, null, Collections.emptyList(), rAnnotatedType, isMulti ? RCardinality.UNBOUNDED : RCardinality.OPTIONAL, null, null, this);
    }

    public RFunction buildRFunction(RosettaRule rule) {
        RType inputRType = this.typeSystem.typeCallToRType(rule.getInput());
        RType outputRType = this.typeProvider.getRMetaAnnotatedType(rule.getExpression()).getRType();
        boolean outputIsMulti = this.cardinalityProvider.isMulti(rule.getExpression());
        RAttribute outputAttribute = this.createArtificialAttribute("output", outputRType, outputIsMulti);
        return new RFunction(this.modelIdProvider.getSymbolId(rule), rule.getDefinition(), List.of(this.createArtificialAttribute("input", inputRType, false)), outputAttribute, RFunctionOrigin.RULE, List.of(), List.of(), List.of(), List.of(new ROperation(ROperationType.SET, outputAttribute, List.of(), rule.getExpression())), List.of());
    }

    public RFunction buildRFunction(RosettaReport report) {
        String reportDefinition = report.getRegulatoryBody().getBody().getName() + " " + report.getRegulatoryBody().getCorpusList().stream().map(c -> c.getName()).collect(Collectors.joining(" "));
        RDataType outputRtype = this.buildRDataType(report.getReportType());
        RAttribute outputAttribute = this.createArtificialAttribute("output", outputRtype, false);
        Attribute inputAttribute = SimpleFactory.eINSTANCE.createAttribute();
        inputAttribute.setName("input");
        inputAttribute.setTypeCall((TypeCall)EcoreUtil2.copy((EObject)report.getInputType()));
        RosettaCardinality cardinality = RosettaFactory.eINSTANCE.createRosettaCardinality();
        cardinality.setInf(0);
        cardinality.setSup(1);
        inputAttribute.setCard(cardinality);
        Map<RAttribute, RosettaRule> attributeToRuleMap = this.externalAnnotationUtil.getAllReportingRules(report).entrySet().stream().collect(Collectors.toMap(e -> ((ExternalAnnotationUtil.PathAttribute)e.getKey()).getAttr(), e -> (RosettaRule)e.getValue()));
        List<ROperation> operations = this.generateReportOperations(outputRtype, attributeToRuleMap, inputAttribute, List.of(outputAttribute));
        return new RFunction(this.modelIdProvider.getReportId(report), reportDefinition, List.of(this.buildRAttribute(inputAttribute)), outputAttribute, RFunctionOrigin.REPORT, List.of(), List.of(), List.of(), operations, List.of());
    }

    private List<ROperation> generateReportOperations(RDataType reportDataType, Map<RAttribute, RosettaRule> attributeToRuleMap, Attribute inputAttribute, List<RAttribute> assignPath) {
        Collection<RAttribute> attributes = reportDataType.getAllAttributes();
        ArrayList<ROperation> operations = new ArrayList<ROperation>();
        for (RAttribute attribute : attributes) {
            ArrayList<RAttribute> newAssignPath = new ArrayList<RAttribute>(assignPath);
            newAssignPath.add(attribute);
            if (attributeToRuleMap.containsKey(attribute)) {
                operations.add(this.generateOperationForRuleReference(inputAttribute, attributeToRuleMap.get(attribute), newAssignPath));
                continue;
            }
            RType attrType = attribute.getRMetaAnnotatedType().getRType() instanceof RChoiceType ? ((RChoiceType)attribute.getRMetaAnnotatedType().getRType()).asRDataType() : attribute.getRMetaAnnotatedType().getRType();
            if (!(attrType instanceof RDataType)) continue;
            RDataType rData = (RDataType)attrType;
            operations.addAll(this.generateReportOperations(rData, attributeToRuleMap, inputAttribute, newAssignPath));
        }
        return operations;
    }

    private ROperation generateOperationForRuleReference(Attribute inputAttribute, RosettaRule rule, List<RAttribute> assignPath) {
        RAttribute pathHead = assignPath.get(0);
        List<RAttribute> pathTail = assignPath.subList(1, assignPath.size());
        RosettaSymbolReference inputAttributeSymbolRef = ExpressionFactory.eINSTANCE.createRosettaSymbolReference();
        inputAttributeSymbolRef.setSymbol(inputAttribute);
        RosettaSymbolReference symbolRef = ExpressionFactory.eINSTANCE.createRosettaSymbolReference();
        symbolRef.setGenerated(true);
        symbolRef.setSymbol(rule);
        symbolRef.setExplicitArguments(true);
        symbolRef.getArgs().add((Object)inputAttributeSymbolRef);
        return new ROperation(ROperationType.SET, pathHead, pathTail, symbolRef);
    }

    public RAttribute buildRAttribute(Attribute attr) {
        RMetaAnnotatedType rAnnotatedType = this.typeProvider.getRTypeOfFeature(attr, null);
        RCardinality card = this.buildRCardinality(attr.getCard());
        RosettaRuleReference ruleRef = attr.getRuleReference();
        return new RAttribute(attr.isOverride(), attr.getName(), attr.getDefinition(), (List<RosettaDocReference>)attr.getReferences(), rAnnotatedType, card, ruleRef != null ? ruleRef.getReportingRule() : null, attr, this);
    }

    public RAttribute buildRAttributeOfParent(Attribute attr) {
        Attribute parent = this.ecoreUtil.getParentAttribute(attr);
        if (parent == null) {
            return null;
        }
        return this.buildRAttribute(parent);
    }

    public RCardinality buildRCardinality(RosettaCardinality card) {
        if (card.isUnbounded()) {
            if (card.getInf() == 0) {
                return RCardinality.UNBOUNDED;
            }
            return RCardinality.unbounded(card.getInf());
        }
        if (card.getSup() == 1) {
            if (card.getInf() == 1) {
                return RCardinality.SINGLE;
            }
            if (card.getInf() == 0) {
                return RCardinality.OPTIONAL;
            }
        }
        return RCardinality.bounded(card.getInf(), card.getSup());
    }

    public RShortcut buildRShortcut(ShortcutDeclaration shortcut) {
        return new RShortcut(shortcut.getName(), this.cardinalityProvider.isSymbolMulti(shortcut), shortcut.getDefinition(), shortcut.getExpression());
    }

    public ROperation buildROperation(Operation operation) {
        ROperationType operationType = operation.isAdd() ? ROperationType.ADD : ROperationType.SET;
        RAssignedRoot pathHead = operation.getAssignRoot() instanceof Attribute ? this.buildRAttribute((Attribute)operation.getAssignRoot()) : this.buildRShortcut((ShortcutDeclaration)operation.getAssignRoot());
        List<RAttribute> pathTail = operation.pathAsSegmentList().stream().map(s -> this.buildRAttribute(s.getAttribute())).collect(Collectors.toList());
        return new ROperation(operationType, pathHead, pathTail, operation.getExpression());
    }

    public RDataType buildRDataType(Data data) {
        return new RDataType(data, this.modelIdProvider, this, this.typeProvider);
    }

    public RChoiceType buildRChoiceType(Choice choice) {
        return new RChoiceType(choice, this.modelIdProvider, this.typeProvider, this);
    }

    public REnumType buildREnumType(RosettaEnumeration enumeration) {
        return new REnumType(enumeration, this.modelIdProvider, this);
    }
}

