/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.types;

import com.regnosys.rosetta.rosetta.RosettaDocReference;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.types.RAssignedRoot;
import com.regnosys.rosetta.types.RCardinality;
import com.regnosys.rosetta.types.RMetaAnnotatedType;
import com.regnosys.rosetta.types.RObjectFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class RAttribute
implements RAssignedRoot {
    private final boolean isOverride;
    private final String name;
    private final String definition;
    private final List<RosettaDocReference> docReferences;
    private final RMetaAnnotatedType rMetaAnnotatedType;
    private final RCardinality cardinality;
    private final RosettaRule ruleReference;
    private final Attribute origin;
    private final RObjectFactory rObjectFactory;
    private RAttribute parentAttribute = null;

    public RAttribute(boolean isOverride, String name, String definition, List<RosettaDocReference> docReferences, RMetaAnnotatedType rMetaAnnotatedType, RCardinality cardinality, RosettaRule ruleReference, Attribute origin, RObjectFactory rObjectFactory) {
        this.isOverride = isOverride;
        this.name = name;
        this.definition = definition;
        this.docReferences = docReferences;
        this.rMetaAnnotatedType = rMetaAnnotatedType;
        this.cardinality = cardinality;
        this.ruleReference = ruleReference;
        this.origin = origin;
        this.rObjectFactory = rObjectFactory;
    }

    public boolean isOverride() {
        return this.isOverride;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Attribute getEObject() {
        return this.origin;
    }

    public RMetaAnnotatedType getRMetaAnnotatedType() {
        return this.rMetaAnnotatedType;
    }

    @Override
    public boolean isMulti() {
        return this.cardinality.isMulti();
    }

    public RCardinality getCardinality() {
        return this.cardinality;
    }

    public String getDefinition() {
        return this.definition;
    }

    public List<RosettaDocReference> getDocReferences() {
        List<RosettaDocReference> parentDocRefs;
        RAttribute p = this.getParentAttribute();
        if (p == null || (parentDocRefs = p.getDocReferences()).isEmpty()) {
            return this.docReferences;
        }
        ArrayList<RosettaDocReference> docRefs = new ArrayList<RosettaDocReference>(this.docReferences.size() + parentDocRefs.size());
        docRefs.addAll(this.docReferences);
        docRefs.addAll(parentDocRefs);
        return docRefs;
    }

    public RosettaRule getRuleReference() {
        if (this.ruleReference != null) {
            return this.ruleReference;
        }
        RAttribute p = this.getParentAttribute();
        if (p != null) {
            return p.getRuleReference();
        }
        return null;
    }

    public RAttribute getParentAttribute() {
        if (this.parentAttribute == null && this.origin.isOverride()) {
            this.parentAttribute = this.rObjectFactory.buildRAttributeOfParent(this.origin);
        }
        return this.parentAttribute;
    }

    public int hashCode() {
        return Objects.hash(this.definition, this.cardinality, this.name, this.rMetaAnnotatedType, this.origin);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RAttribute other = (RAttribute)obj;
        return Objects.equals(this.definition, other.definition) && Objects.equals(this.cardinality, other.cardinality) && Objects.equals(this.name, other.name) && Objects.equals(this.rMetaAnnotatedType, other.rMetaAnnotatedType) && Objects.equals(this.origin, other.origin);
    }

    public String toString() {
        return String.format("RAttribute[name=%s, type=%s, cardinality=%s]", this.name, this.rMetaAnnotatedType, this.cardinality);
    }
}

